/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDataTypeUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDate;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDateTime;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDuration;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XTime;
import java.math.BigDecimal;

public class XDayTimeDuration
extends XDuration {
    public XDayTimeDuration(int days2, int hours2, int minutes2, double seconds2) {
        this.calculateValue(days2, hours2, minutes2, seconds2);
    }

    public XDayTimeDuration(BigDecimal cValue) {
        this.setValue(cValue);
    }

    public final void calculateValue(int days2, int hours2, int minutes2, double seconds2) {
        this.m_CValue = XDataTypeUtils.dayTimeDurationToSeconds(days2, hours2, minutes2, seconds2);
        if (this.m_CValue.doubleValue() == 0.0) {
            return;
        }
        this.m_days = this.m_CValue.divide(new BigDecimal(86400), 1).intValue();
        BigDecimal left = this.m_CValue.subtract(new BigDecimal(86400.0 * (double)this.m_days));
        this.m_hours = (int)left.doubleValue() / 3600;
        left = left.subtract(new BigDecimal(this.m_hours * 3600));
        this.m_minutes = (int)left.doubleValue() / 60;
        this.m_seconds = left.subtract(new BigDecimal(this.m_minutes * 60)).doubleValue();
    }

    public final void setValue(BigDecimal cValue) {
        this.m_CValue = cValue;
        if (cValue.doubleValue() == 0.0) {
            return;
        }
        this.m_days = (int)cValue.divide(new BigDecimal(86400), 1).longValue();
        BigDecimal rem = cValue.subtract(new BigDecimal(this.m_days).multiply(new BigDecimal(86400)));
        this.m_hours = (int)rem.doubleValue() / 3600;
        rem = rem.subtract(new BigDecimal(this.m_hours * 3600));
        this.m_minutes = (int)rem.doubleValue() / 60;
        this.m_seconds = rem.subtract(new BigDecimal(this.m_minutes * 60)).doubleValue();
    }

    @Override
    public BigDecimal getCValue() {
        return this.m_CValue;
    }

    public XDayTimeDuration add(XDayTimeDuration other2) {
        return new XDayTimeDuration(this.m_days + other2.getDays(), this.m_hours + other2.getHours(), this.m_minutes + other2.getMinutes(), this.m_seconds + other2.getSeconds());
    }

    public XDate add(XDate other2) {
        return other2.add(this);
    }

    public XTime add(XTime other2) {
        return other2.add(this);
    }

    public XDateTime add(XDateTime other2) {
        return other2.add(this);
    }

    public XDayTimeDuration subtract(XDayTimeDuration other2) {
        return new XDayTimeDuration(this.m_CValue.add(other2.getCValue().negate()));
    }

    public XDayTimeDuration multiply(double factor) {
        this.checkDoubleValue(factor, false);
        return new XDayTimeDuration(this.m_CValue.multiply(new BigDecimal(factor)));
    }

    public XDayTimeDuration divide(double arg2) {
        this.checkDoubleValue(arg2, true);
        if (Double.isInfinite(arg2)) {
            return new XDayTimeDuration(new BigDecimal(0));
        }
        return new XDayTimeDuration(this.m_CValue.divide(new BigDecimal(arg2), 18, 4));
    }

    public BigDecimal divide(XDayTimeDuration other2) {
        return this.m_CValue.divide(other2.getCValue(), 18, 4);
    }
}

