/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.DateTimeBase;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XItemBase;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.v2.BasisLibrary2;
import java.math.BigDecimal;

public class XDuration
extends XItemBase {
    protected int m_years = 0;
    protected int m_months = 0;
    protected int m_days = 0;
    protected int m_hours = 0;
    protected int m_minutes = 0;
    protected double m_seconds = 0.0;
    protected BigDecimal m_CValue = null;

    protected XDuration() {
    }

    protected XDuration(DateTimeBase value2) {
        this.m_years = value2.getYear();
        this.m_months = value2.getMonth();
        this.m_days = value2.getDay();
        this.m_hours = value2.getHours();
        this.m_minutes = value2.getMinutes();
        this.m_seconds = (double)value2.getSeconds() + value2.getFraction();
    }

    public XDuration(int year2, int month2, int day2, int hour, int minute, double second) {
        this.m_years = year2;
        this.m_months = month2;
        this.m_days = day2;
        this.m_hours = hour;
        this.m_minutes = minute;
        this.m_seconds = second;
    }

    public BigDecimal getCValue() {
        return this.m_CValue;
    }

    public int getYears() {
        return this.m_years;
    }

    public int getMonths() {
        return this.m_months;
    }

    public int getDays() {
        return this.m_days;
    }

    public int getHours() {
        return this.m_hours;
    }

    public int getMinutes() {
        return this.m_minutes;
    }

    public double getSeconds() {
        return this.m_seconds;
    }

    protected void checkDoubleValue(double value2, boolean forDivision) {
        if (forDivision) {
            if (Double.isNaN(value2)) {
                BasisLibrary2.runTimeError("ERR_NAN_FOR_DURATION_OPERATION");
            } else if (Double.compare(value2, 0.0) == 0 || Double.compare(value2, -0.0) == 0) {
                BasisLibrary2.runTimeError("ERR_DURATION_OPERATION_OVERFLOW");
            }
        } else if (Double.isNaN(value2)) {
            BasisLibrary2.runTimeError("ERR_NAN_FOR_DURATION_OPERATION");
        } else if (Double.isInfinite(value2)) {
            BasisLibrary2.runTimeError("ERR_DURATION_OPERATION_OVERFLOW");
        }
    }
}

