/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.DateTimeBase;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDataTypeUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDateTime;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDayTimeDuration;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XItemBase;

public class XTime
extends XItemBase {
    private int m_hour;
    private int m_minute;
    private double m_second;
    private XDayTimeDuration m_timezone = null;

    protected XTime(DateTimeBase value2) {
        this.m_hour = value2.getHours();
        this.m_minute = value2.getMinutes();
        this.m_second = (double)value2.getSeconds() + value2.getFraction();
    }

    public XTime(int hour, int minute, double second) {
        this(hour, minute, second, null);
    }

    public XTime(int hour, int minute, double second, int tz_hour, int tz_minute) {
        this(hour, minute, second, new XDayTimeDuration(0, tz_hour, tz_minute, 0.0));
    }

    public XTime(int hour, int minute, double second, XDayTimeDuration timezone2) {
        this.m_hour = hour;
        this.m_minute = minute;
        this.m_second = second;
        this.m_timezone = timezone2;
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public double getSecond() {
        return this.m_second;
    }

    public XDayTimeDuration getTimeZone() {
        return this.m_timezone;
    }

    public int getTimeZoneHour() {
        return this.m_timezone != null ? this.m_timezone.getHours() : Integer.MAX_VALUE;
    }

    public int getTimeZoneMinute() {
        return this.m_timezone != null ? this.m_timezone.getMinutes() : Integer.MAX_VALUE;
    }

    public XTime add(XDayTimeDuration dtd) {
        double stmp = this.m_second + dtd.getSeconds();
        int carry = XDataTypeUtils.fQuotient(stmp, 60.0);
        double sDateTime = XDataTypeUtils.modulo(stmp, 60.0, carry);
        int tmp = this.m_minute + dtd.getMinutes() + carry;
        carry = XDataTypeUtils.fQuotient(tmp, 60.0);
        int mnDateTime = (int)XDataTypeUtils.modulo((double)tmp, 60.0, carry);
        tmp = this.m_hour + dtd.getHours() + carry;
        carry = XDataTypeUtils.fQuotient(tmp, 24.0);
        int hDateTime = (int)XDataTypeUtils.modulo((double)tmp, 24.0, carry);
        return new XTime(hDateTime, mnDateTime, sDateTime, this.m_timezone);
    }

    public XDayTimeDuration subtract(XTime other2) {
        XDateTime dt1 = new XDateTime(1970, 6, 20, this.getHour(), this.getMinute(), this.getSecond(), this.getTimeZoneHour(), this.getTimeZoneMinute()).normalize();
        XDateTime dt2 = new XDateTime(1970, 6, 20, other2.getHour(), other2.getMinute(), other2.getSecond(), other2.getTimeZoneHour(), other2.getTimeZoneMinute()).normalize();
        return dt1.subtract(dt2);
    }

    public XTime subtract(XDayTimeDuration dtd) {
        return this.add(XDataTypeUtils.negate(dtd));
    }
}

