/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.CallTemplate;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Literal;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ValueOf;
import com.ibm.xltxe.rnm1.xtq.runtime.AbstractStarlet;
import com.ibm.xltxe.rnm1.xtq.xquery.drivers.InterpretedQuerylet;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.InterpretedTranslet;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.ModuleDeclImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TraceEventImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TraceUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMsg;
import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xapi.XSequenceType;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.ErrorHandler;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.SourceLocation;
import com.ibm.xml.xci.exec.StaticContext;
import com.ibm.xml.xci.exec.trace.InstructionEvent;
import com.ibm.xml.xci.type.SequenceType;
import com.ibm.xml.xci.type.SequenceTypeFactory;
import com.ibm.xml.xci.type.TypeRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;

public class InstructionEventImpl
extends TraceEventImpl
implements InstructionEvent {
    public static final String s_traceEvalNamespace = "http://www.ibm.com/xmlns/prod/xltxe-j/trace-eval";
    public static final String s_traceEvalFeature = "http://www.ibm.com/xmlns/prod/xltxe-j/trace-eval/feature";
    public static final String s_currentGroupVariable = "__currentgroup__";
    public static final String s_currentGroupingKeyVariable = "__currentgroupingkey__";
    public static final String s_regexGroupVariable = "__regexgroup__";
    private static final QName s_currentGroupQName = new QName("http://www.ibm.com/xmlns/prod/xltxe-j/trace-eval", "__currentgroup__");
    private static final QName s_currentGroupingKeyQName = new QName("http://www.ibm.com/xmlns/prod/xltxe-j/trace-eval", "__currentgroupingkey__");
    private static final QName s_regexGroupQName = new QName("http://www.ibm.com/xmlns/prod/xltxe-j/trace-eval", "__regexgroup__");
    private static final SequenceType s_itemStarType = SequenceTypeFactory.item(XSequenceType.OccurrenceIndicator.ZERO_OR_MORE);
    private int m_instructionType;
    private SourceLocation m_location;
    private AbstractStarlet m_starlet;
    private Object m_otherContextInfo;
    private boolean m_compatibilityMode;

    public InstructionEventImpl(int eventType, int instructionType, SourceLocation location, AbstractStarlet starlet, Object otherContextInfo, boolean compatibilityMode) {
        super(eventType);
        this.m_instructionType = instructionType;
        this.m_location = location;
        this.m_starlet = starlet;
        this.m_otherContextInfo = otherContextInfo;
        this.m_compatibilityMode = compatibilityMode;
    }

    @Override
    public String getInstructionName() {
        return s_elementNames[this.m_instructionType];
    }

    @Override
    public int getInstructionType() {
        return this.m_instructionType;
    }

    @Override
    public SourceLocation getInstructionSourceLocation() {
        return this.m_location;
    }

    public static int mapInstructionType(Expr node2) {
        switch (node2.getId()) {
            case 193: {
                return 0;
            }
            case 194: {
                return 1;
            }
            case 195: {
                return 2;
            }
            case 159: {
                return 3;
            }
            case 105: {
                if (node2 instanceof CallTemplate) {
                    return 4;
                }
                return 68;
            }
            case 197: {
                return 5;
            }
            case 134: 
            case 161: {
                return 6;
            }
            case 198: {
                return 7;
            }
            case 199: {
                return 8;
            }
            case 156: {
                return 9;
            }
            case 108: 
            case 157: {
                return 10;
            }
            case 200: {
                return 11;
            }
            case 201: {
                return 12;
            }
            case 202: {
                return 13;
            }
            case 56: {
                return 14;
            }
            case 203: {
                return 15;
            }
            case 226: {
                return 16;
            }
            case 234: {
                return 17;
            }
            case 205: {
                return 18;
            }
            case 204: {
                return 19;
            }
            case 206: {
                return 20;
            }
            case 207: {
                return 21;
            }
            case 209: {
                return 22;
            }
            case 162: {
                return 23;
            }
            case 235: {
                return 24;
            }
            case 210: {
                return 25;
            }
            case 233: {
                return 26;
            }
            case 211: {
                return 27;
            }
            case 160: 
            case 228: {
                return 28;
            }
            case 214: {
                return 29;
            }
            case 29: 
            case 34: {
                return 30;
            }
            case 215: {
                return 31;
            }
            case 217: {
                return 32;
            }
            case 5: {
                return 33;
            }
            case 97: {
                return 34;
            }
            case 46: {
                return 35;
            }
            case 47: {
                return 36;
            }
            case 53: {
                return 37;
            }
            case 54: {
                return 38;
            }
            case 55: {
                return 39;
            }
            case 57: {
                return 40;
            }
            case 58: {
                return 41;
            }
            case 59: {
                return 42;
            }
            case 60: {
                return 43;
            }
            case 61: {
                return 44;
            }
            case 62: {
                return 45;
            }
            case 63: {
                return 46;
            }
            case 64: {
                return 47;
            }
            case 65: {
                return 48;
            }
            case 66: {
                return 49;
            }
            case 67: {
                return 50;
            }
            case 68: {
                return 51;
            }
            case 69: {
                return 52;
            }
            case 72: {
                return 53;
            }
            case 74: {
                return 54;
            }
            case 82: {
                return 55;
            }
            case 96: {
                return 56;
            }
            case 98: {
                return 57;
            }
            case 99: {
                return 58;
            }
            case 101: {
                return 59;
            }
            case 102: {
                return 60;
            }
            case 103: {
                return 61;
            }
            case 104: {
                return 62;
            }
            case 106: {
                return 63;
            }
            case 107: {
                return 64;
            }
            case 158: {
                return 65;
            }
            case 185: {
                return 66;
            }
            case 100: {
                return 67;
            }
            case 42: {
                return 76;
            }
        }
        return -1;
    }

    public static int mapXQueryInstructionType(Expr node2) {
        switch (node2.getId()) {
            case 159: {
                return 3;
            }
            case 134: 
            case 161: {
                return 6;
            }
            case 156: {
                return 9;
            }
            case 108: 
            case 157: {
                return 10;
            }
            case 141: 
            case 162: {
                return 23;
            }
            case 228: {
                return 28;
            }
            case 160: {
                Expr expr;
                if (node2 instanceof ValueOf && (expr = ((ValueOf)node2).getExpression()) instanceof Literal && ((Literal)expr).getValue().length() == 0) {
                    return -1;
                }
                return 28;
            }
            case 29: {
                return 30;
            }
            case 56: {
                return 14;
            }
            case 43: {
                return 69;
            }
            case 45: {
                return 70;
            }
            case 46: {
                return 35;
            }
            case 47: {
                return 36;
            }
            case 53: {
                return 37;
            }
            case 54: {
                return 38;
            }
            case 55: {
                return 39;
            }
            case 72: {
                return 53;
            }
            case 74: {
                return 54;
            }
            case 103: {
                return 61;
            }
            case 104: {
                return 62;
            }
            case 106: {
                return 63;
            }
            case 107: {
                return 64;
            }
            case 42: {
                return 76;
            }
        }
        return -1;
    }

    public static int mapXSLTInstructionType(Expr node2) {
        switch (node2.getId()) {
            case 193: {
                return 0;
            }
            case 194: {
                return 1;
            }
            case 195: {
                return 2;
            }
            case 159: {
                return 3;
            }
            case 105: {
                if (node2 instanceof CallTemplate) {
                    return 4;
                }
                return -1;
            }
            case 197: {
                return 5;
            }
            case 134: 
            case 161: {
                return 6;
            }
            case 198: {
                return 7;
            }
            case 199: {
                return 8;
            }
            case 156: {
                return 9;
            }
            case 108: 
            case 157: {
                return 10;
            }
            case 200: {
                return 11;
            }
            case 201: {
                return 12;
            }
            case 202: {
                return 13;
            }
            case 56: {
                return 14;
            }
            case 203: {
                return 15;
            }
            case 226: {
                return 16;
            }
            case 234: {
                return 17;
            }
            case 205: {
                return 18;
            }
            case 204: {
                return 19;
            }
            case 206: {
                return 20;
            }
            case 207: {
                return 21;
            }
            case 209: {
                return 22;
            }
            case 162: {
                return 23;
            }
            case 235: {
                return 24;
            }
            case 210: {
                return 25;
            }
            case 233: {
                return 26;
            }
            case 211: {
                return 27;
            }
            case 160: 
            case 228: {
                return 28;
            }
            case 214: {
                return 29;
            }
            case 29: 
            case 34: {
                return 30;
            }
            case 215: {
                return 31;
            }
            case 217: {
                return 32;
            }
        }
        return -1;
    }

    @Override
    public Cursor evaluateExpression(String expression2, ErrorHandler errorHandler) {
        int starletType = (Integer)this.m_starlet.getProperty(AbstractStarlet.STARLET_TYPE);
        switch (starletType) {
            case 3: {
                return this.evaluateXSLTExpression(expression2, errorHandler);
            }
            case 2: {
                return this.evaluateXQueryExpression(expression2, errorHandler);
            }
        }
        String msg = new RuntimeMsg("ERR_SYSTEM", "Starlet type not supported for expression evaluation: " + starletType).getFormattedMessage();
        errorHandler.report(-1, XMessageHandler.MsgType.FATAL_ERROR, msg, null, true);
        return null;
    }

    public Cursor evaluateXSLTExpression(String expression2, ErrorHandler errorHandler) {
        SessionContext session = new SessionContext(this.m_starlet.getTypeRegistry(0));
        StaticContext sc = this.getStaticContext(this.m_starlet.getTypeRegistry(0), errorHandler);
        DynamicContext dc = this.getDynamicContext(errorHandler);
        if (dc == null) {
            return null;
        }
        sc.setLanguageTypeAndVersion(4);
        sc.setCompatibilityMode(this.m_compatibilityMode);
        sc.setFeature("http://www.ibm.com/xmlns/prod/xltxe-j/xslt_functions", true);
        sc.setFeature(s_traceEvalFeature, true);
        this.declareVariables(sc, dc);
        this.declareXSLTSpecialVariables(dc);
        this.declareXSLTFunctions(sc, dc);
        Preparer preparer = session.getPreparer(RequestInfo.XPath2);
        Executable exec = preparer.prepare(expression2, sc, -1);
        if (exec == null) {
            String msg = new RuntimeMsg("DBG_TRACE_EXPR_EVALUATION_FAILED", expression2).getFormattedMessage();
            errorHandler.report(-1, XMessageHandler.MsgType.FATAL_ERROR, msg, null, true);
            return null;
        }
        Cursor contextItem = this.m_starlet.getContextItem();
        if (contextItem != null) {
            contextItem = contextItem.fork(false);
        }
        return exec.execute(contextItem, dc, Cursor.Profile.RANDOM_ACCESS, null);
    }

    public Cursor evaluateXQueryExpression(String expression2, ErrorHandler errorHandler) {
        ModuleDeclImpl moduleDecl = this.m_starlet.getModuleDecl(this.m_starlet.getModuleId());
        TypeRegistry typeRegistry = this.m_starlet.getTypeRegistry(moduleDecl.getSchemaSetKey());
        SessionContext session = new SessionContext(typeRegistry);
        StaticContext sc = this.getStaticContext(typeRegistry, errorHandler);
        DynamicContext dc = this.getDynamicContext(errorHandler);
        if (dc == null) {
            return null;
        }
        sc.setLanguageTypeAndVersion(1);
        sc.setBaseURI(moduleDecl.getBaseURI());
        sc.setBoundarySpacePolicy(moduleDecl.getBoundarySpacePolicy());
        sc.setConstructionMode(moduleDecl.getConstructionMode());
        sc.setCopyNamespacesModeInherit(moduleDecl.getCopyNamespaceModeInherit());
        sc.setCopyNamespacesModePreserve(moduleDecl.getCopyNamespaceModePreserve());
        sc.setDefaultOrderForEmptySequences(moduleDecl.getDefaultOrderForEmptySequences());
        sc.setDefaultCollation(moduleDecl.getDefaultCollation());
        sc.setDefaultElementTypeNamespace(moduleDecl.getDefaultElementTypeNamespace());
        sc.setDefaultFunctionNamespace(moduleDecl.getDefaultFunctionNamespace());
        this.declareModuleVariables(sc, dc, moduleDecl);
        this.declareXQueryFunctions(sc, dc, moduleDecl);
        Preparer preparer = session.getPreparer(RequestInfo.XQuery);
        Executable exec = preparer.prepare(expression2, sc, -1);
        if (exec == null) {
            String msg = new RuntimeMsg("DBG_TRACE_EXPR_EVALUATION_FAILED", expression2).getFormattedMessage();
            errorHandler.report(-1, XMessageHandler.MsgType.FATAL_ERROR, msg, null, true);
            return null;
        }
        Cursor contextItem = this.m_starlet.getContextItem();
        if (contextItem != null) {
            contextItem = contextItem.fork(false);
        }
        return exec.execute(contextItem, dc, Cursor.Profile.RANDOM_ACCESS, null);
    }

    private StaticContext getStaticContext(TypeRegistry typeRegistry, ErrorHandler errorHandler) {
        BasicStaticContext sc = new BasicStaticContext(typeRegistry);
        sc.setErrorHandler(errorHandler);
        if (this.m_starlet.getArbitraryPrecision()) {
            sc.setIntegerMathMode(2);
        } else if (this.m_starlet.getOverflowDetection()) {
            sc.setIntegerMathMode(3);
        } else {
            sc.setIntegerMathMode(1);
        }
        this.declareNamespaces(sc);
        return sc;
    }

    private DynamicContext getDynamicContext(ErrorHandler errorHandler) {
        DynamicContext dc = (DynamicContext)this.m_starlet.getProperty("com.ibm.xml.xci.exec.DynamicContext");
        try {
            dc = (DynamicContext)dc.clone();
        }
        catch (CloneNotSupportedException e) {
            String msg = new RuntimeMsg("ERR_SYSTEM", "DynamicContext is not cloneable: " + dc.getClass().getName()).getFormattedMessage();
            errorHandler.report(-1, XMessageHandler.MsgType.FATAL_ERROR, msg, null, true);
            return null;
        }
        dc.setErrorHandler(errorHandler);
        return dc;
    }

    private void declareNamespaces(StaticContext sc) {
        HashMap<String, String> namespaceMap = this.m_starlet.getNamespaceMap();
        for (String prefix2 : namespaceMap.keySet()) {
            String namespace2 = namespaceMap.get(prefix2);
            if (namespace2.equals("http://www.w3.org/1999/XSL/Transform") || namespace2.equals("http://www.w3.org/XML/1998/namespace")) continue;
            sc.declareNamespace(prefix2, namespaceMap.get(prefix2));
        }
    }

    private void declareVariables(StaticContext sc, DynamicContext dc) {
        this.declareVariables(sc, dc, this.m_starlet.getVariableValues());
    }

    private void declareModuleVariables(StaticContext sc, DynamicContext dc, ModuleDeclImpl moduleDecl) {
        this.declareVariables(sc, dc, this.m_starlet.getVariableValues());
        Collection<Integer> imports = moduleDecl.getImports();
        Iterator<Integer> it = imports.iterator();
        while (it.hasNext()) {
            moduleDecl = this.m_starlet.getModuleDecl(it.next());
            this.declareVariables(sc, dc, moduleDecl.getGlobalVariables());
        }
    }

    private void declareVariables(StaticContext sc, DynamicContext dc, HashMap<String, Cursor> variableValues) {
        for (String key2 : variableValues.keySet()) {
            Cursor value2 = variableValues.get(key2);
            QName qname2 = QName.valueOf(key2);
            sc.addVariableBinding(qname2, s_itemStarType, false);
            dc.bindVariable(qname2, value2);
        }
    }

    private void declareXSLTFunctions(StaticContext sc, DynamicContext dc) {
        QName qname2;
        String name2;
        int index2;
        SequenceType[] paramTypes;
        SequenceType type2;
        HashMap functionParams;
        Executable executable = this.m_starlet.getExecutable();
        Map<String, Object> properties = executable.getProperties();
        HashMap functionMap = (HashMap)properties.get("http://www.ibm.com/xmlns/prod/xltxe/execution-trace-ud-functions");
        if (functionMap != null && functionMap.size() > 0) {
            functionParams = (HashMap)properties.get("http://www.ibm.com/xmlns/prod/xltxe/execution-trace-ud-function-params");
            for (String function2 : functionMap.keySet()) {
                type2 = (SequenceType)functionMap.get(function2);
                paramTypes = (SequenceType[])functionParams.get(function2);
                index2 = function2.lastIndexOf(":");
                name2 = function2.substring(0, index2);
                qname2 = QName.valueOf(name2);
                sc.addFunction(qname2, type2, paramTypes);
                Executable udExecutable = TraceUtils.getXSLTUDFunctionExecutable((InterpretedTranslet)this.m_starlet, this.m_otherContextInfo, name2, paramTypes.length);
                dc.bindFunction(qname2, paramTypes.length, udExecutable);
            }
        }
        if ((functionMap = (HashMap)properties.get("http://www.ibm.com/xmlns/prod/xltxe/execution-trace-extension-functions")) != null && functionMap.size() > 0) {
            functionParams = (HashMap)properties.get("http://www.ibm.com/xmlns/prod/xltxe/execution-trace-extension-function-params");
            for (String function2 : functionMap.keySet()) {
                type2 = (SequenceType)functionMap.get(function2);
                paramTypes = (SequenceType[])functionParams.get(function2);
                index2 = function2.lastIndexOf(":");
                name2 = function2.substring(0, index2);
                qname2 = QName.valueOf(name2);
                sc.addFunction(qname2, type2, paramTypes);
            }
        }
    }

    private void declareXQueryFunctions(StaticContext sc, DynamicContext dc, ModuleDeclImpl moduleDecl) {
        this.declareModuleFunctions(sc, dc, moduleDecl);
        Collection<Integer> imports = moduleDecl.getImports();
        Iterator<Integer> it = imports.iterator();
        while (it.hasNext()) {
            moduleDecl = this.m_starlet.getModuleDecl(it.next());
            this.declareModuleFunctions(sc, dc, moduleDecl);
        }
    }

    private void declareModuleFunctions(StaticContext sc, DynamicContext dc, ModuleDeclImpl moduleDecl) {
        QName qname2;
        String name2;
        int index2;
        SequenceType[] paramTypes;
        SequenceType type2;
        HashMap<String, SequenceType> functionMap = moduleDecl.getUDFunctions();
        HashMap<String, SequenceType[]> paramMap = moduleDecl.getUDParams();
        for (String function2 : functionMap.keySet()) {
            type2 = functionMap.get(function2);
            paramTypes = paramMap.get(function2);
            index2 = function2.lastIndexOf(":");
            name2 = function2.substring(0, index2);
            qname2 = QName.valueOf(name2);
            sc.addFunction(qname2, type2, paramTypes);
            Executable udExecutable = TraceUtils.getXQueryUDFunctionExecutable((InterpretedQuerylet)this.m_starlet, moduleDecl.getModuleName(), this.m_otherContextInfo, name2, paramTypes.length);
            dc.bindFunction(qname2, paramTypes.length, udExecutable);
        }
        functionMap = moduleDecl.getEXTFunctions();
        paramMap = moduleDecl.getEXTParams();
        for (String function2 : functionMap.keySet()) {
            type2 = functionMap.get(function2);
            paramTypes = paramMap.get(function2);
            index2 = function2.lastIndexOf(":");
            name2 = function2.substring(0, index2);
            qname2 = QName.valueOf(name2);
            if (sc.functionAvailable(qname2, paramTypes.length)) continue;
            sc.addFunction(qname2, type2, paramTypes);
        }
    }

    private void declareXSLTSpecialVariables(DynamicContext dc) {
        Cursor group2 = this.m_starlet.getCurrentGroup();
        dc.bindVariable(s_currentGroupQName, group2 == null ? null : group2.fork(false));
        Cursor groupingKey = this.m_starlet.getCurrentGroupingKey();
        dc.bindVariable(s_currentGroupingKeyQName, groupingKey == null ? null : groupingKey.fork(false));
        Cursor regexGroup = this.m_starlet.getRegexGroup();
        dc.bindVariable(s_regexGroupQName, regexGroup == null ? null : regexGroup.fork(false));
    }
}

