/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug;

import com.ibm.xltxe.rnm1.xtq.common.utils.InputSource2CharBuffer;
import com.ibm.xml.xci.exec.trace.SourceProvider;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.InputSource;

public class SourceProviderImpl
implements SourceProvider {
    private Map<String, String> m_documents;
    private Map<String, String> m_encodings;
    private Set<String> m_generated;

    public SourceProviderImpl(Map<String, String> documents, Map<String, String> encodings) {
        this.m_documents = documents;
        this.m_encodings = encodings;
        this.m_generated = new HashSet<String>(documents.keySet());
    }

    @Override
    public synchronized String getSourceAsString(String uri2) {
        String result2;
        String string2 = result2 = this.m_documents != null ? this.m_documents.get(uri2) : null;
        if (result2 == null && this.loadSource(uri2)) {
            result2 = this.m_documents.get(uri2);
        }
        return result2;
    }

    @Override
    public synchronized byte[] getSourceAsBytes(String uri2) {
        try {
            String sourceAsString = this.getSourceAsString(uri2);
            byte[] result2 = null;
            if (sourceAsString != null) {
                result2 = sourceAsString.getBytes(this.m_encodings.get(uri2));
            }
            return result2;
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    @Override
    public boolean isSourceGenerated(String uri2) {
        return this.m_generated.contains(uri2);
    }

    private synchronized boolean loadSource(String uri2) {
        try {
            InputSource2CharBuffer is2cb = new InputSource2CharBuffer(new InputSource(uri2));
            if (this.m_documents == null) {
                this.m_documents = new HashMap<String, String>();
                this.m_encodings = new HashMap<String, String>();
            }
            this.m_documents.put(uri2, is2cb.getCharBuffer().toString());
            this.m_encodings.put(uri2, is2cb.getEncoding());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

