/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.ObjectFactory;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.exec.trace.TraceEvent;
import com.ibm.xml.xci.exec.trace.TraceListener;
import com.ibm.xml.xci.exec.trace.TraceManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TraceManagerImpl
extends TraceManager
implements TraceListener {
    private static final Logger s_logger = LoggerUtil.getLogger(TraceManagerImpl.class);
    private static final String s_className = TraceManagerImpl.class.getName();
    private List<TraceListener> m_listeners = new ArrayList<TraceListener>();
    private TraceInterceptListener m_interceptor;

    public TraceManagerImpl(int langType) {
        Iterator<String> listeners = TraceManagerImpl.getRegisteredListeners(langType);
        while (listeners.hasNext()) {
            String listener = listeners.next();
            try {
                Object obj = ObjectFactory.newInstance(listener, ObjectFactory.findClassLoader(), true);
                if (!(obj instanceof TraceListener)) continue;
                TraceListener instance2 = (TraceListener)obj;
                this.m_listeners.add(instance2);
            }
            catch (ObjectFactory.ConfigurationError err) {
                if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINE)) continue;
                s_logger.logp(Level.FINE, s_className, "<init>", err.getMessage());
            }
        }
    }

    @Override
    public void trace(TraceEvent event) {
        if (this.m_interceptor == null || this.m_interceptor.allow(event)) {
            for (int i = 0; i < this.m_listeners.size(); ++i) {
                this.m_listeners.get(i).trace(event);
            }
        }
    }

    public void setTraceInterceptListener(TraceInterceptListener interceptor) {
        this.m_interceptor = interceptor;
    }

    public static interface TraceInterceptListener {
        public boolean allow(TraceEvent var1);
    }
}

