/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.extensions;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.extensions.ExsltBase;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class ExsltDatetime
extends ExsltBase {
    static final DateTimeFormatString dt = new DateTimeFormatString("yyyy-MM-dd'T'HH:mm:ss", true, true);
    static final DateTimeFormatString d = new DateTimeFormatString("yyyy-MM-dd", false, true);
    static final DateTimeFormatString gym = new DateTimeFormatString("yyyy-MM", false, true);
    static final DateTimeFormatString gy = new DateTimeFormatString("yyyy", false, true);
    static final DateTimeFormatString gmd = new DateTimeFormatString("--MM-dd", false, true);
    static final DateTimeFormatString gm = new DateTimeFormatString("--MM--", false, true);
    static final DateTimeFormatString gd = new DateTimeFormatString("---dd", false, true);
    static final DateTimeFormatString t = new DateTimeFormatString("HH:mm:ss", true, true);
    static final DateTimeFormatString EEEE = new DateTimeFormatString("EEEE", false, false, Locale.ENGLISH);
    static final DateTimeFormatString EEE = new DateTimeFormatString("EEE", false, false, Locale.ENGLISH);
    static final DateTimeFormatString MMMM = new DateTimeFormatString("MMMM", false, false, Locale.ENGLISH);
    static final DateTimeFormatString MMM = new DateTimeFormatString("MMM", false, false, Locale.ENGLISH);
    static final String EMPTY_STR = "";
    private static final Double nan = new Double(Double.NaN);

    public static String dateTime() {
        Calendar cal = Calendar.getInstance();
        Date datetime2 = cal.getTime();
        StringBuffer buff = new StringBuffer(dt.format(datetime2));
        int offset = cal.get(15) + cal.get(16);
        if (offset == 0) {
            buff.append("Z");
        } else {
            int hrs = offset / 3600000;
            int min2 = offset / 60000 % 60;
            char posneg = hrs < 0 ? (char)'-' : '+';
            buff.append(posneg + ExsltDatetime.formatDigits(hrs) + ':' + ExsltDatetime.formatDigits(min2));
        }
        return buff.toString();
    }

    private static String formatDigits(int q) {
        String dd = String.valueOf(Math.abs(q));
        return dd.length() == 1 ? '0' + dd : dd;
    }

    public static String date(String datetimeIn) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
            String leader = edz[0];
            String datetime2 = edz[1];
            String zone = edz[2];
            if (datetime2 == null || zone == null) {
                return EMPTY_STR;
            }
            DateTimeFormatString[] formatsIn = new DateTimeFormatString[]{dt, d};
            DateTimeFormatString formatOut = d;
            Date date2 = ExsltDatetime.testFormats(datetime2, formatsIn);
            if (date2 == null) {
                return EMPTY_STR;
            }
            String dateOut = formatOut.format(date2);
            if (dateOut.length() == 0) {
                return EMPTY_STR;
            }
            return leader + dateOut + zone;
        }
        catch (ParseException e) {
            return EMPTY_STR;
        }
    }

    public static String date() {
        String datetime2 = ExsltDatetime.dateTime().toString();
        String date2 = datetime2.substring(0, datetime2.indexOf("T"));
        String zone = datetime2.substring(ExsltDatetime.getZoneStart(datetime2));
        return date2 + zone;
    }

    public static String time(String timeIn) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(timeIn);
            String time2 = edz[1];
            String zone = edz[2];
            if (time2 == null || zone == null) {
                return EMPTY_STR;
            }
            DateTimeFormatString[] formatsIn = new DateTimeFormatString[]{dt, d, t};
            DateTimeFormatString formatOut = t;
            Date date2 = ExsltDatetime.testFormats(time2, formatsIn);
            if (date2 == null) {
                return EMPTY_STR;
            }
            String out = formatOut.format(date2);
            return out + zone;
        }
        catch (ParseException e) {
            return EMPTY_STR;
        }
    }

    public static String time() {
        String datetime2 = ExsltDatetime.dateTime().toString();
        String time2 = datetime2.substring(datetime2.indexOf("T") + 1);
        return time2;
    }

    public static double year(String datetimeIn) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
            boolean ad = edz[0].length() == 0;
            String datetime2 = edz[1];
            if (datetime2 == null) {
                return Double.NaN;
            }
            DateTimeFormatString[] formats = new DateTimeFormatString[]{dt, d, gym, gy};
            double yr = ExsltDatetime.getNumber(datetime2, formats, 1, true);
            if (ad || Double.isNaN(yr)) {
                return yr;
            }
            return -yr;
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double year() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    public static double monthInYear(String datetimeIn) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
            String datetime2 = edz[1];
            if (datetime2 == null) {
                return Double.NaN;
            }
            DateTimeFormatString[] formats = new DateTimeFormatString[]{dt, d, gym, gm, gmd};
            return ExsltDatetime.getNumber(datetime2, formats, 2, true) + 1.0;
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double monthInYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(2) + 1;
    }

    public static double weekInYear(String datetimeIn) {
        return ExsltDatetime.weekInYear(datetimeIn, false);
    }

    public static double weekInYearCorrectedWeekStart(String datetimeIn) {
        return ExsltDatetime.weekInYear(datetimeIn, true);
    }

    private static double weekInYear(String datetimeIn, boolean correctedWeekStart) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
            String datetime2 = edz[1];
            if (datetime2 == null) {
                return Double.NaN;
            }
            DateTimeFormatString[] formats = new DateTimeFormatString[]{dt, d};
            return ExsltDatetime.getNumber(datetime2, formats, 3, correctedWeekStart);
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double weekInYear() {
        return ExsltDatetime.weekInYear(false);
    }

    public static double weekInYearCorrectedWeekStart() {
        return ExsltDatetime.weekInYear(true);
    }

    private static double weekInYear(boolean correctedWeekStart) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        if (correctedWeekStart) {
            cal.setFirstDayOfWeek(2);
            cal.setMinimalDaysInFirstWeek(4);
        }
        return cal.get(3);
    }

    public static double dayInYear(String datetimeIn) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
            String datetime2 = edz[1];
            if (datetime2 == null) {
                return Double.NaN;
            }
            DateTimeFormatString[] formats = new DateTimeFormatString[]{dt, d};
            return ExsltDatetime.getNumber(datetime2, formats, 6, true);
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double dayInYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(6);
    }

    public static double dayInMonth(String datetimeIn) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
            String datetime2 = edz[1];
            DateTimeFormatString[] formats = new DateTimeFormatString[]{dt, d, gmd, gd};
            double day2 = ExsltDatetime.getNumber(datetime2, formats, 5, true);
            return day2;
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double dayInMonth() {
        Calendar cal = Calendar.getInstance();
        return cal.get(5);
    }

    public static double dayOfWeekInMonth(String datetimeIn) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
            String datetime2 = edz[1];
            if (datetime2 == null) {
                return Double.NaN;
            }
            DateTimeFormatString[] formats = new DateTimeFormatString[]{dt, d};
            return ExsltDatetime.getNumber(datetime2, formats, 8, true);
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double dayOfWeekInMonth() {
        Calendar cal = Calendar.getInstance();
        return cal.get(8);
    }

    public static double dayInWeek(String datetimeIn) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
            String datetime2 = edz[1];
            if (datetime2 == null) {
                return Double.NaN;
            }
            DateTimeFormatString[] formats = new DateTimeFormatString[]{dt, d};
            return ExsltDatetime.getNumber(datetime2, formats, 7, true);
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double dayInWeek() {
        Calendar cal = Calendar.getInstance();
        return cal.get(7);
    }

    public static double hourInDay(String datetimeIn) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
            String datetime2 = edz[1];
            if (datetime2 == null) {
                return Double.NaN;
            }
            DateTimeFormatString[] formats = new DateTimeFormatString[]{dt, t};
            return ExsltDatetime.getNumber(datetime2, formats, 11, true);
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double hourInDay() {
        Calendar cal = Calendar.getInstance();
        return cal.get(11);
    }

    public static double minuteInHour(String datetimeIn) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
            String datetime2 = edz[1];
            if (datetime2 == null) {
                return Double.NaN;
            }
            DateTimeFormatString[] formats = new DateTimeFormatString[]{dt, t};
            return ExsltDatetime.getNumber(datetime2, formats, 12, true);
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double minuteInHour() {
        Calendar cal = Calendar.getInstance();
        return cal.get(12);
    }

    public static double secondInMinute(String datetimeIn) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
            String datetime2 = edz[1];
            if (datetime2 == null) {
                return Double.NaN;
            }
            DateTimeFormatString[] formats = new DateTimeFormatString[]{dt, t};
            return ExsltDatetime.getNumber(datetime2, formats, 13, true);
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double secondInMinute() {
        Calendar cal = Calendar.getInstance();
        return cal.get(13);
    }

    public static Object leapYear(String datetimeIn) {
        try {
            String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
            String datetime2 = edz[1];
            if (datetime2 == null) {
                return nan;
            }
            DateTimeFormatString[] formats = new DateTimeFormatString[]{dt, d, gym, gy};
            double dbl = ExsltDatetime.getNumber(datetime2, formats, 1, true);
            if (Double.isNaN(dbl)) {
                return nan;
            }
            int yr = (int)dbl;
            if (yr % 400 == 0 || yr % 100 != 0 && yr % 4 == 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (ParseException e) {
            return nan;
        }
    }

    public static boolean leapYear() {
        Calendar cal = Calendar.getInstance();
        int yr = cal.get(1);
        return yr % 400 == 0 || yr % 100 != 0 && yr % 4 == 0;
    }

    public static String monthName(String datetimeIn) {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime2 = edz[1];
        if (datetime2 == null) {
            return EMPTY_STR;
        }
        DateTimeFormatString[] formatsIn = new DateTimeFormatString[]{dt, d, gym, gm};
        return ExsltDatetime.getNameOrAbbrev(datetimeIn, formatsIn, MMMM);
    }

    public static String monthName() {
        return ExsltDatetime.getNameOrAbbrev(MMMM);
    }

    public static String monthAbbreviation(String datetimeIn) {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime2 = edz[1];
        if (datetime2 == null) {
            return EMPTY_STR;
        }
        DateTimeFormatString[] formatsIn = new DateTimeFormatString[]{dt, d, gym, gm};
        return ExsltDatetime.getNameOrAbbrev(datetimeIn, formatsIn, MMM);
    }

    public static String monthAbbreviation() {
        return ExsltDatetime.getNameOrAbbrev(MMM);
    }

    public static String dayName(String datetimeIn) {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime2 = edz[1];
        if (datetime2 == null) {
            return EMPTY_STR;
        }
        DateTimeFormatString[] formatsIn = new DateTimeFormatString[]{dt, d};
        return ExsltDatetime.getNameOrAbbrev(datetimeIn, formatsIn, EEEE);
    }

    public static String dayName() {
        return ExsltDatetime.getNameOrAbbrev(EEEE);
    }

    public static String dayAbbreviation(String datetimeIn) {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime2 = edz[1];
        if (datetime2 == null) {
            return EMPTY_STR;
        }
        DateTimeFormatString[] formatsIn = new DateTimeFormatString[]{dt, d};
        return ExsltDatetime.getNameOrAbbrev(datetimeIn, formatsIn, EEE);
    }

    public static String dayAbbreviation() {
        return ExsltDatetime.getNameOrAbbrev(EEE);
    }

    private static String[] getEraDatetimeZone(String in2) {
        int z;
        String leader = EMPTY_STR;
        String datetime2 = in2;
        String zone = EMPTY_STR;
        if (in2.charAt(0) == '-' && !in2.startsWith("--")) {
            leader = "-";
            datetime2 = in2.substring(1);
        }
        if ((z = ExsltDatetime.getZoneStart(datetime2)) > 0) {
            zone = datetime2.substring(z);
            datetime2 = datetime2.substring(0, z);
        } else if (z == -2) {
            zone = null;
        }
        return new String[]{leader, datetime2, zone};
    }

    private static int getZoneStart(String datetime2) {
        if (datetime2.indexOf("Z") == datetime2.length() - 1) {
            return datetime2.length() - 1;
        }
        if (datetime2.length() >= 6 && datetime2.charAt(datetime2.length() - 3) == ':' && (datetime2.charAt(datetime2.length() - 6) == '+' || datetime2.charAt(datetime2.length() - 6) == '-')) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
                dateFormat.setLenient(false);
                Date d = dateFormat.parse(datetime2.substring(datetime2.length() - 5));
                return datetime2.length() - 6;
            }
            catch (ParseException pe) {
                return -2;
            }
        }
        return -1;
    }

    private static Date testFormats(String in2, DateTimeFormatString[] formats) throws ParseException {
        for (int i = 0; i < formats.length; ++i) {
            Date d = formats[i].parse(in2);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    private static double getNumber(String in2, DateTimeFormatString[] formats, int calField, boolean correctedWeekStart) throws ParseException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        if (correctedWeekStart) {
            cal.setFirstDayOfWeek(2);
            cal.setMinimalDaysInFirstWeek(4);
        }
        cal.setLenient(false);
        Date date2 = ExsltDatetime.testFormats(in2, formats);
        if (date2 == null) {
            return Double.NaN;
        }
        cal.setTime(date2);
        return cal.get(calField);
    }

    private static String getNameOrAbbrev(String in2, DateTimeFormatString[] formatsIn, DateTimeFormatString formatOut) {
        for (int i = 0; i < formatsIn.length; ++i) {
            Date dt = formatsIn[i].parse(in2);
            if (dt == null) continue;
            return formatOut.format(dt);
        }
        return EMPTY_STR;
    }

    private static String getNameOrAbbrev(DateTimeFormatString format2) {
        Calendar cal = Calendar.getInstance();
        return format2.format(cal.getTime());
    }

    public static String formatDate(String dateTime3, String pattern2) {
        String zone;
        TimeZone timeZone;
        String yearSymbols = "Gy";
        String monthSymbols = "M";
        String daySymbols = "dDEFwW";
        if (dateTime3.endsWith("Z") || dateTime3.endsWith("z")) {
            timeZone = TimeZone.getTimeZone("GMT");
            zone = "z";
        } else if (dateTime3.length() >= 6 && dateTime3.charAt(dateTime3.length() - 3) == ':' && (dateTime3.charAt(dateTime3.length() - 6) == '+' || dateTime3.charAt(dateTime3.length() - 6) == '-')) {
            String offset = dateTime3.substring(dateTime3.length() - 6);
            timeZone = "+00:00".equals(offset) || "-00:00".equals(offset) ? TimeZone.getTimeZone("GMT") : TimeZone.getTimeZone("GMT" + offset);
            zone = "z";
        } else {
            timeZone = TimeZone.getDefault();
            zone = EMPTY_STR;
        }
        DateTimeFormatString[] formats = new DateTimeFormatString[]{dt, d, gym, gy};
        Date d = t.parse(dateTime3, timeZone);
        if (d != null) {
            SimpleDateFormat outFormat = new SimpleDateFormat(ExsltDatetime.strip("GyMdDEFwW", pattern2));
            outFormat.setTimeZone(timeZone);
            return outFormat.format(d);
        }
        for (int i = 0; i < formats.length; ++i) {
            d = formats[i].parse(dateTime3, timeZone);
            if (d == null) continue;
            SimpleDateFormat outFormat = new SimpleDateFormat(pattern2);
            outFormat.setTimeZone(timeZone);
            return outFormat.format(d);
        }
        d = gmd.parse(dateTime3);
        if (d != null) {
            SimpleDateFormat outFormat = new SimpleDateFormat(ExsltDatetime.strip("Gy", pattern2));
            outFormat.setTimeZone(timeZone);
            return outFormat.format(d);
        }
        d = gm.parse(dateTime3);
        if (d != null) {
            SimpleDateFormat outFormat = new SimpleDateFormat(ExsltDatetime.strip("Gy", pattern2));
            outFormat.setTimeZone(timeZone);
            return outFormat.format(d);
        }
        d = gd.parse(dateTime3);
        if (d != null) {
            SimpleDateFormat outFormat = new SimpleDateFormat(ExsltDatetime.strip("GyM", pattern2));
            outFormat.setTimeZone(timeZone);
            return outFormat.format(d);
        }
        return EMPTY_STR;
    }

    private static String strip(String symbols, String pattern2) {
        int i = 0;
        StringBuffer result2 = new StringBuffer(pattern2.length());
        while (i < pattern2.length()) {
            char ch = pattern2.charAt(i);
            if (ch == '\'') {
                int endQuote = pattern2.indexOf(39, i + 1);
                if (endQuote == -1) {
                    endQuote = pattern2.length();
                }
                result2.append(pattern2.substring(i, endQuote));
                i = endQuote++;
                continue;
            }
            if (symbols.indexOf(ch) > -1) {
                ++i;
                continue;
            }
            result2.append(ch);
            ++i;
        }
        return result2.toString();
    }

    private static class DateTimeFormatString {
        private String fFormat;
        private boolean fAllowsFractionalSeconds;
        private boolean fAllowsTimeZone;
        private Locale fLocale;

        public DateTimeFormatString(String basicFormat, boolean allowsFractionalSeconds, boolean allowsTimeZone) {
            this.fFormat = basicFormat;
            this.fAllowsFractionalSeconds = allowsFractionalSeconds;
            this.fAllowsTimeZone = allowsTimeZone;
        }

        public DateTimeFormatString(String basicFormat, boolean allowsFractionalSeconds, boolean allowsTimeZone, Locale loc) {
            this.fFormat = basicFormat;
            this.fAllowsFractionalSeconds = allowsFractionalSeconds;
            this.fAllowsTimeZone = allowsTimeZone;
            this.fLocale = loc;
        }

        public String format(Date value2) {
            SimpleDateFormat dateFormat = this.fLocale == null ? new SimpleDateFormat(this.fFormat) : new SimpleDateFormat(this.fFormat, this.fLocale);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setGregorianChange(new Date(Long.MIN_VALUE));
            dateFormat.setCalendar(cal);
            dateFormat.setLenient(false);
            return dateFormat.format(value2);
        }

        public Date parse(String value2) {
            return this.parse(value2, null);
        }

        public Date parse(String value2, TimeZone tz) {
            SimpleDateFormat dateFormat;
            SimpleDateFormat simpleDateFormat = dateFormat = this.fLocale == null ? new SimpleDateFormat(this.fFormat) : new SimpleDateFormat(this.fFormat, this.fLocale);
            if (tz != null) {
                dateFormat.setTimeZone(tz);
            }
            ParsePosition pos = new ParsePosition(0);
            dateFormat.setLenient(false);
            Date d = dateFormat.parse(value2, pos);
            int parsePos = pos.getIndex();
            if (d != null && parsePos < value2.length() && this.fAllowsFractionalSeconds && value2.charAt(parsePos) == '.') {
                ++parsePos;
                boolean hasFractionalSeconds = false;
                while (parsePos < value2.length() && DateTimeFormatString.isASCIIDigit(value2.charAt(parsePos))) {
                    hasFractionalSeconds = true;
                    ++parsePos;
                }
                if (!hasFractionalSeconds) {
                    d = null;
                }
            }
            if (d != null && parsePos < value2.length() && this.fAllowsTimeZone) {
                switch (value2.length() - parsePos) {
                    case 1: {
                        if (value2.charAt(parsePos) != 'Z') break;
                        ++parsePos;
                        break;
                    }
                    case 6: {
                        char s = value2.charAt(parsePos);
                        char h1 = value2.charAt(parsePos + 1);
                        char h2 = value2.charAt(parsePos + 2);
                        char c = value2.charAt(parsePos + 3);
                        char m1 = value2.charAt(parsePos + 4);
                        char m2 = value2.charAt(parsePos + 5);
                        if (s != '+' && s != '-' || !DateTimeFormatString.isASCIIDigit(h1) || !DateTimeFormatString.isASCIIDigit(h2) || c != ':' || !DateTimeFormatString.isASCIIDigit(m1) || !DateTimeFormatString.isASCIIDigit(m2)) break;
                        parsePos += 6;
                        break;
                    }
                }
            }
            if (parsePos < value2.length()) {
                d = null;
            }
            return d;
        }

        private static boolean isASCIIDigit(char c) {
            return c >= '0' && c <= '9';
        }
    }
}

