/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.extensions;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.extensions.ExsltBase;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.xci.Cursor;

public class ExsltMath
extends ExsltBase {
    private static final String PI = "3.1415926535897932384626433832795028841971693993751";
    private static final String E = "2.71828182845904523536028747135266249775724709369996";
    private static final String SQRRT2 = "1.41421356237309504880168872420969807856967187537694";
    private static final String LN2 = "0.69314718055994530941723212145817656807550013436025";
    private static final String LN10 = "2.302585092994046";
    private static final String LOG2E = "1.4426950408889633";
    private static final String SQRT1_2 = "0.7071067811865476";

    public static double max(Cursor c) {
        if (c == null) {
            return Double.NaN;
        }
        double m = -1.7976931348623157E308;
        Cursor scan = c.fork(false);
        do {
            double d;
            if (Double.isNaN(d = ExsltMath.toNumber(scan))) {
                return Double.NaN;
            }
            if (!(d > m)) continue;
            m = d;
        } while (scan.toNext());
        scan.release();
        return m;
    }

    public static double min(Cursor c) {
        if (c == null) {
            return Double.NaN;
        }
        double m = Double.MAX_VALUE;
        Cursor scan = c.fork(false);
        do {
            double d;
            if (Double.isNaN(d = ExsltMath.toNumber(scan))) {
                return Double.NaN;
            }
            if (!(d < m)) continue;
            m = d;
        } while (scan.toNext());
        scan.release();
        return m;
    }

    public static Cursor highest(Cursor c) {
        double maxValue = ExsltMath.max(c);
        Cursor highNodes = null;
        if (Double.isNaN(maxValue)) {
            return highNodes;
        }
        Cursor c_fork = c.fork(false);
        do {
            double d;
            if ((d = ExsltMath.toNumber(c_fork)) != maxValue) continue;
            Cursor newNode = c_fork.fork(true);
            newNode.toSelf();
            highNodes = highNodes == null ? newNode : highNodes.sequenceConcat(newNode, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_FOR_PROTOTYPE, false, false, true, true);
        } while (c_fork.toNext());
        c_fork.release();
        return highNodes;
    }

    public static Cursor lowest(Cursor c) {
        double minValue = ExsltMath.min(c == null ? null : c.fork(false));
        Cursor lowNodes = null;
        if (Double.isNaN(minValue)) {
            return lowNodes;
        }
        Cursor c_fork = c.fork(false);
        do {
            double d;
            if ((d = ExsltMath.toNumber(c_fork)) != minValue) continue;
            Cursor newNode = c_fork.fork(true);
            newNode.toSelf();
            lowNodes = lowNodes == null ? newNode : lowNodes.sequenceConcat(newNode, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_FOR_PROTOTYPE, false, false, true, true);
        } while (c_fork.toNext());
        c_fork.release();
        return lowNodes;
    }

    public static double abs(double num) {
        return Math.abs(num);
    }

    public static double acos(double num) {
        return Math.acos(num);
    }

    public static double asin(double num) {
        return Math.asin(num);
    }

    public static double atan(double num) {
        return Math.atan(num);
    }

    public static double atan2(double num1, double num2) {
        return Math.atan2(num1, num2);
    }

    public static double cos(double num) {
        return Math.cos(num);
    }

    public static double exp(double num) {
        return Math.exp(num);
    }

    public static double log(double num) {
        return Math.log(num);
    }

    public static double power(double num1, double num2) {
        return Math.pow(num1, num2);
    }

    public static double random() {
        return Math.random();
    }

    public static double sin(double num) {
        return Math.sin(num);
    }

    public static double sqrt(double num) {
        return Math.sqrt(num);
    }

    public static double tan(double num) {
        return Math.tan(num);
    }

    public static double constant(String name2, double precision) {
        String value2 = null;
        if (name2.equals("PI")) {
            value2 = PI;
        } else if (name2.equals("E")) {
            value2 = E;
        } else if (name2.equals("SQRRT2")) {
            value2 = SQRRT2;
        } else if (name2.equals("LN2")) {
            value2 = LN2;
        } else if (name2.equals("LN10")) {
            value2 = LN10;
        } else if (name2.equals("LOG2E")) {
            value2 = LOG2E;
        } else if (name2.equals("SQRT1_2")) {
            value2 = SQRT1_2;
        }
        if (value2 != null) {
            int bits = new Double(precision).intValue();
            if (bits <= value2.length()) {
                value2 = value2.substring(0, bits);
            }
            return new Double(value2);
        }
        return Double.NaN;
    }
}

