/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.extensions;

import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.JavaMethodResolver;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.extensions.MultiHashtable;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.extensions.ObjectFactory;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.v2.BasisLibrary2;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class JavaExtensionUtils {
    private static final MultiHashtable _internal2Java = new MultiHashtable();
    private static HashMap<XSTypeDefinition, Class> _schemaType2Class = new HashMap();
    private static HashMap<Class, Class> _class2Primitive = new HashMap();
    private static String EMPTYSTRING = "";
    private static final Class stringClass = String.class;
    private static final Class xciCursorClass = Cursor.class;
    private static final double lowerBounds = 0.001;
    private static final double upperBounds = 1.0E7;
    private static final DecimalFormat defaultFormatter;
    private static final String defaultPattern = "";
    private static FieldPosition _fieldPosition;

    public static final Cursor callJavaConstructor(String className, Cursor[] args) {
        Class clazz;
        if (className == null || className.length() == 0) {
            throw new RuntimeException(JavaExtensionUtils.getMessageString("CLASS_NOT_FOUND_ERR", className));
        }
        try {
            clazz = ObjectFactory.findProviderClass(className, ObjectFactory.findClassLoader(), true);
        }
        catch (ClassNotFoundException e) {
            throw new WrappedRuntimeException(JavaExtensionUtils.getMessageString("CLASS_NOT_FOUND_ERR", className), e);
        }
        List constructors = JavaMethodResolver.findConstructors(clazz, args.length);
        if (constructors == null || constructors.isEmpty()) {
            throw new RuntimeException(JavaExtensionUtils.getMessageString("CONSTRUCTOR_NOT_FOUND", className));
        }
        int nConstructors = constructors.size();
        Class[] argTypes = JavaExtensionUtils.getArgumentTypes(args);
        int bestConstrDistance = Integer.MAX_VALUE;
        Constructor chosenConstructor = null;
        for (int i = 0; i < nConstructors; ++i) {
            int j;
            Constructor constructor = (Constructor)constructors.get(i);
            Class<?>[] paramTypes = constructor.getParameterTypes();
            int currConstrDistance = 0;
            for (j = 0; j < args.length; ++j) {
                Class intType = argTypes[j];
                Class<?> extType = paramTypes[j];
                Object match = _internal2Java.maps(intType, extType);
                if (match != null) {
                    currConstrDistance += ((TargetType)match).distance;
                    continue;
                }
                if (intType == extType) continue;
                if (extType.isAssignableFrom(intType)) {
                    ++currConstrDistance;
                    continue;
                }
                currConstrDistance = Integer.MAX_VALUE;
                break;
            }
            if (j != args.length || currConstrDistance >= bestConstrDistance) continue;
            chosenConstructor = constructor;
            bestConstrDistance = currConstrDistance;
        }
        if (chosenConstructor != null) {
            Object[] values2 = JavaExtensionUtils.convertArgumentValues(args, chosenConstructor.getParameterTypes());
            try {
                Object ret = chosenConstructor.newInstance(values2);
                return JavaExtensionUtils.createCursor(ret, chosenConstructor.getDeclaringClass());
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(JavaExtensionUtils.getMessageString("ERR_EXT_CONSTRUCTOR_CALL_FAILED", className), e);
            }
        }
        throw new RuntimeException(JavaExtensionUtils.getMessageString("CONSTRUCTOR_NOT_FOUND", className));
    }

    public static final Cursor callJavaMethod(String methodName, String className, Cursor[] args, HashMap defaultObjectTable) {
        List methods;
        Class[] argTypes = JavaExtensionUtils.getArgumentTypes(args);
        Class clazz = null;
        boolean hasInstanceArg = false;
        if (className != null && className.length() > 0) {
            try {
                Class firstArgClass;
                clazz = ObjectFactory.findProviderClass(className, ObjectFactory.findClassLoader(), true);
                if (argTypes.length > 0 && clazz.isAssignableFrom(firstArgClass = argTypes[0])) {
                    hasInstanceArg = true;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz == null) {
            if (argTypes.length > 0 && !argTypes[0].isPrimitive()) {
                hasInstanceArg = true;
                clazz = argTypes[0];
            } else {
                throw new RuntimeException(JavaExtensionUtils.getMessageString("CLASS_NOT_FOUND_ERR", className));
            }
        }
        int argCount = args.length;
        if (hasInstanceArg) {
            --argCount;
        }
        if ((methods = JavaMethodResolver.findMethods(clazz, methodName, argCount)) == null || methods.isEmpty()) {
            throw new RuntimeException(JavaExtensionUtils.getMessageString("FUNCTION_RESOLVE_ERR", methodName));
        }
        int bestMethodDistance = Integer.MAX_VALUE;
        Method chosenMethod = null;
        int nMethods = methods.size();
        int argStart = hasInstanceArg ? 1 : 0;
        for (int i = 0; i < nMethods; ++i) {
            int j;
            Method method = (Method)methods.get(i);
            Class<?>[] paramTypes = method.getParameterTypes();
            int currMethodDistance = 0;
            for (j = 0; j < argCount; ++j) {
                Class intType = argTypes[j + argStart];
                Class<?> extType = paramTypes[j];
                Object match = _internal2Java.maps(intType, extType);
                if (match != null) {
                    currMethodDistance += ((TargetType)match).distance;
                    continue;
                }
                if (intType == extType) continue;
                if (extType.isAssignableFrom(intType)) {
                    ++currMethodDistance;
                    continue;
                }
                currMethodDistance = Integer.MAX_VALUE;
                break;
            }
            if (j != argCount || currMethodDistance >= bestMethodDistance) continue;
            chosenMethod = method;
            bestMethodDistance = currMethodDistance;
        }
        if (chosenMethod != null) {
            Object instanceArg = null;
            int modifiers = chosenMethod.getModifiers();
            if ((modifiers & 8) != 0) {
                if (hasInstanceArg) {
                    throw new RuntimeException(JavaExtensionUtils.getMessageString("FUNCTION_RESOLVE_ERR", methodName));
                }
            } else if (hasInstanceArg) {
                instanceArg = args[0].itemTypedValue().getObject(1);
            } else {
                instanceArg = defaultObjectTable.get(className);
                if (instanceArg == null) {
                    try {
                        instanceArg = clazz.newInstance();
                        defaultObjectTable.put(className, instanceArg);
                    }
                    catch (Exception e) {
                        throw new WrappedRuntimeException(JavaExtensionUtils.getMessageString("ERR_EXT_DEFAULT_OBJECT_FAILED", className), e);
                    }
                }
            }
            Object[] values2 = JavaExtensionUtils.convertArgumentValues(args, argStart, chosenMethod.getParameterTypes());
            try {
                Object ret = chosenMethod.invoke(instanceArg, values2);
                return JavaExtensionUtils.createCursor(ret, chosenMethod.getReturnType());
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(JavaExtensionUtils.getMessageString("ERR_EXT_METHOD_CALL_FAILED", new Object[]{methodName, className}), e);
            }
        }
        throw new RuntimeException(JavaExtensionUtils.getMessageString("FUNCTION_RESOLVE_ERR", methodName));
    }

    private static final Class[] getArgumentTypes(Cursor[] args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = JavaExtensionUtils.getArgumentType(args[i]);
        }
        return argTypes;
    }

    private static final Class getArgumentType(Cursor arg2) {
        if (arg2 == null) {
            return xciCursorClass;
        }
        XSTypeDefinition type2 = arg2.itemXSType();
        if (!arg2.itemIsAtomic()) {
            return xciCursorClass;
        }
        if (type2 == TypeRegistry.FOREIGNOBJECT) {
            VolatileCData vcd = arg2.itemTypedValue();
            Class argClass = vcd.getObject(1).getClass();
            Class argPrimitive = _class2Primitive.get(argClass);
            return argPrimitive == null ? argClass : argPrimitive;
        }
        return _schemaType2Class.get(type2);
    }

    private static final Object[] convertArgumentValues(Cursor[] args, Class[] types2) {
        return JavaExtensionUtils.convertArgumentValues(args, 0, types2);
    }

    private static final Object[] convertArgumentValues(Cursor[] args, int offset, Class[] types2) {
        Object[] values2 = new Object[args.length - offset];
        int i = offset;
        int j = 0;
        while (i < args.length) {
            values2[j] = JavaExtensionUtils.convertArgumentValue(args[i], types2[j]);
            ++i;
            ++j;
        }
        return values2;
    }

    private static final Object convertArgumentValue(Cursor arg2, Class type2) {
        if (arg2 != null) {
            VolatileCData cdata = arg2.itemTypedValue();
            XSTypeDefinition argType = arg2.itemXSType();
            if (argType == TypeRegistry.FOREIGNOBJECT) {
                return cdata.getObject(1);
            }
            if (type2 == Boolean.TYPE || type2 == Boolean.class) {
                return JavaExtensionUtils.cursorToBoolean(arg2);
            }
            if (type2 == Character.TYPE || type2 == Character.class) {
                if (argType == TypeRegistry.XSSTRING) {
                    return Character.valueOf(JavaExtensionUtils.cursorToChar(arg2));
                }
                return new Character((char)JavaExtensionUtils.cursorToDouble(arg2));
            }
            if (type2 == Double.TYPE || type2 == Double.class) {
                return JavaExtensionUtils.cursorToDouble(arg2);
            }
            if (type2 == Float.TYPE || type2 == Float.class) {
                return Float.valueOf((float)JavaExtensionUtils.cursorToDouble(arg2));
            }
            if (type2 == Long.TYPE || type2 == Long.class) {
                return (long)JavaExtensionUtils.cursorToDouble(arg2);
            }
            if (type2 == Integer.TYPE || type2 == Integer.class) {
                return (int)JavaExtensionUtils.cursorToDouble(arg2);
            }
            if (type2 == Short.TYPE || type2 == Short.class) {
                return (short)JavaExtensionUtils.cursorToDouble(arg2);
            }
            if (type2 == Byte.TYPE || type2 == Byte.class) {
                return (byte)JavaExtensionUtils.cursorToDouble(arg2);
            }
            if (type2 == String.class) {
                return JavaExtensionUtils.cursorToString(arg2);
            }
            if (type2 == NodeIterator.class) {
                if (arg2.itemIsAtomic()) {
                    throw new RuntimeException(JavaExtensionUtils.getMessageString("DATA_CONVERSION_ERR", new Object[]{argType.getName(), "node-set"}));
                }
                return BasisLibrary2.getNodeIterator(arg2);
            }
            if (type2 == NodeList.class) {
                if (arg2.itemIsAtomic()) {
                    throw new RuntimeException(JavaExtensionUtils.getMessageString("DATA_CONVERSION_ERR", new Object[]{argType.getName(), "node-set"}));
                }
                return BasisLibrary2.getNodeList(arg2);
            }
            if (type2 == Node.class) {
                if (arg2.itemIsAtomic()) {
                    throw new RuntimeException(JavaExtensionUtils.getMessageString("DATA_CONVERSION_ERR", new Object[]{argType.getName(), "node-set"}));
                }
                return BasisLibrary2.getNode(arg2);
            }
            if (type2 == Number.class) {
                return JavaExtensionUtils.cursorToDouble(arg2);
            }
            if (type2 == Object.class) {
                Class objClass = _schemaType2Class.get(argType);
                if (objClass == Boolean.TYPE) {
                    return JavaExtensionUtils.cursorToBoolean(arg2);
                }
                if (objClass == Double.TYPE) {
                    return JavaExtensionUtils.cursorToDouble(arg2);
                }
                if (objClass == stringClass) {
                    return JavaExtensionUtils.cursorToString(arg2);
                }
                if (!arg2.itemIsAtomic()) {
                    return BasisLibrary2.getNodeIterator(arg2);
                }
                return JavaExtensionUtils.cursorToString(arg2);
            }
        } else {
            if (type2 == Boolean.TYPE || type2 == Boolean.class) {
                return false;
            }
            if (type2 == Character.TYPE || type2 == Character.class) {
                return new Character(EMPTYSTRING.charAt(0));
            }
            if (type2 == Double.TYPE || type2 == Double.class) {
                return Double.NaN;
            }
            if (type2 == Float.TYPE || type2 == Float.class) {
                return Float.valueOf(Float.NaN);
            }
            if (type2 == String.class) {
                return EMPTYSTRING;
            }
            if (type2 == NodeIterator.class) {
                return arg2;
            }
            if (type2 == NodeList.class) {
                return arg2;
            }
            if (type2 == Node.class) {
                return arg2;
            }
            if (type2 == Number.class) {
                return Double.NaN;
            }
            if (type2 == Object.class) {
                return arg2;
            }
            if (type2 == Long.TYPE || type2 == Long.class || type2 == Integer.TYPE || type2 == Integer.class || type2 == Short.TYPE || type2 == Short.class || type2 == Byte.TYPE || type2 == Byte.class) {
                throw new RuntimeException(JavaExtensionUtils.getMessageString("DATA_CONVERSION_ERR", new Object[]{"node-set", arg2.itemXSType().getName()}));
            }
        }
        return null;
    }

    private static final Cursor createCursor(Object result2, Class type2) {
        if (result2 == null) {
            return null;
        }
        CursorFactory cursorFactory = SessionContext.getStaticSimpleDataFactory();
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            return cursorFactory.sequence((Boolean)result2, TypeRegistry.XSBOOLEAN, false);
        }
        if (type2 == Character.TYPE) {
            return cursorFactory.sequence(new char[]{((Character)result2).charValue()}, TypeRegistry.XSSTRING, false);
        }
        if (type2 == stringClass) {
            return cursorFactory.sequence((CharSequence)((String)result2), TypeRegistry.XSSTRING, false);
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            return cursorFactory.sequence((Double)result2, TypeRegistry.XSDOUBLE, false);
        }
        if (type2 == Float.TYPE || type2 == Float.class) {
            return cursorFactory.sequence(((Float)result2).doubleValue(), TypeRegistry.XSDOUBLE, false);
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            return cursorFactory.sequence(((Long)result2).doubleValue(), TypeRegistry.XSDOUBLE, false);
        }
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            return cursorFactory.sequence(((Integer)result2).doubleValue(), TypeRegistry.XSDOUBLE, false);
        }
        if (type2 == Short.TYPE || type2 == Short.class) {
            return cursorFactory.sequence(((Short)result2).doubleValue(), TypeRegistry.XSDOUBLE, false);
        }
        if (type2 == Byte.TYPE || type2 == Byte.class) {
            return cursorFactory.sequence(((Byte)result2).doubleValue(), TypeRegistry.XSDOUBLE, false);
        }
        if (type2 == Object.class) {
            return cursorFactory.sequence(result2);
        }
        if (type2.isAssignableFrom(xciCursorClass)) {
            return (Cursor)result2;
        }
        if (type2.isAssignableFrom(NodeList.class)) {
            return RuntimeLibrary.getCursor((NodeList)result2);
        }
        if (type2.isAssignableFrom(NodeIterator.class)) {
            return RuntimeLibrary.getCursor((NodeIterator)result2);
        }
        if (type2.isAssignableFrom(Node.class)) {
            return RuntimeLibrary.getCursor((Node)result2);
        }
        if (type2.isAssignableFrom(DocumentFragment.class)) {
            return RuntimeLibrary.getCursor((DocumentFragment)result2);
        }
        return cursorFactory.sequence(result2);
    }

    public static String getMessageString(String code, Object arg2) {
        return JavaExtensionUtils.getMessageString(code, new Object[]{arg2});
    }

    public static String getMessageString(String code, Object[] args) {
        RuntimeMsg msg = new RuntimeMsg(code, args);
        return msg.getFormattedMessage();
    }

    private static boolean cursorToBoolean(Cursor obj) {
        Class objClass = _schemaType2Class.get(obj.itemXSType());
        VolatileCData cdObj = obj.itemTypedValue();
        if (objClass == Double.TYPE) {
            double temp = cdObj.getDouble(1);
            return temp != 0.0 && !Double.isNaN(temp);
        }
        if (objClass == Boolean.TYPE) {
            return cdObj.getBoolean(1);
        }
        if (objClass == stringClass) {
            return !cdObj.getString(1).equals(EMPTYSTRING);
        }
        if (!obj.itemIsAtomic()) {
            return Boolean.TRUE;
        }
        return !cdObj.getString(1).equals(EMPTYSTRING);
    }

    private static char cursorToChar(Cursor obj) {
        Class objClass = _schemaType2Class.get(obj.itemXSType());
        VolatileCData cdObj = obj.itemTypedValue();
        if (objClass == Double.TYPE) {
            return (char)cdObj.getDouble(1);
        }
        if (objClass == Boolean.TYPE) {
            boolean ch = cdObj.getBoolean(1);
            return (char)(ch ? 1 : 0);
        }
        if (objClass == stringClass) {
            return cdObj.getString(1).charAt(0);
        }
        if (!obj.itemIsAtomic()) {
            return obj.itemStringValue().getString(1).charAt(0);
        }
        return cdObj.getString(1).charAt(0);
    }

    private static double cursorToDouble(Cursor obj) {
        Class objClass = _schemaType2Class.get(obj.itemXSType());
        VolatileCData cdObj = obj.itemTypedValue();
        if (objClass == Double.TYPE) {
            return cdObj.getDouble(1);
        }
        if (objClass == Boolean.TYPE) {
            return cdObj.getBoolean(1) ? 1.0 : 0.0;
        }
        if (objClass == stringClass) {
            return JavaExtensionUtils.stringToReal(cdObj.getString(1));
        }
        if (!obj.itemIsAtomic()) {
            return JavaExtensionUtils.stringToReal(obj.itemStringValue().getString(1));
        }
        return JavaExtensionUtils.stringToReal(cdObj.getString(1));
    }

    private static double stringToReal(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    private static String cursorToString(Cursor obj) {
        Class objClass = _schemaType2Class.get(obj.itemXSType());
        VolatileCData cdObj = obj.itemTypedValue();
        if (objClass == Double.TYPE) {
            return JavaExtensionUtils.realToString(cdObj.getDouble(1));
        }
        if (objClass == Boolean.TYPE) {
            return cdObj.getBoolean(1) ? "true" : "false";
        }
        if (objClass == stringClass) {
            return cdObj.getString(1);
        }
        if (!obj.itemIsAtomic()) {
            return obj.itemStringValue().getString(1);
        }
        return cdObj.getString(1);
    }

    private static String realToString(double d) {
        double m = Math.abs(d);
        if (m >= 0.001 && m < 1.0E7) {
            int length2;
            String result2 = Double.toString(d);
            if (result2.charAt((length2 = result2.length()) - 2) == '.' && result2.charAt(length2 - 1) == '0') {
                return result2.substring(0, length2 - 2);
            }
            if (result2.indexOf(46) != 0 && result2.indexOf(69) < 0 && result2.charAt(length2 - 1) == '0') {
                return result2.substring(0, length2 - 1);
            }
            return result2;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return Double.toString(d);
        }
        if (d == 0.0) {
            return "0";
        }
        return JavaExtensionUtils.formatNumber(d, defaultPattern, defaultFormatter);
    }

    public static String formatNumber(double number2, String pattern2, DecimalFormat formatter) {
        if (formatter == null) {
            formatter = defaultFormatter;
        }
        try {
            StringBuffer result2 = new StringBuffer();
            String localizedPattern = formatter.toPattern();
            int index2 = localizedPattern.indexOf(46);
            if (index2 >= 1 && localizedPattern.charAt(index2 - 1) == '#') {
                StringBuffer newpattern = new StringBuffer();
                newpattern.append(localizedPattern.substring(0, index2 - 1));
                newpattern.append("0");
                newpattern.append(localizedPattern.substring(index2));
                formatter.applyLocalizedPattern(newpattern.toString());
            } else if (index2 == 0) {
                StringBuffer newpattern = new StringBuffer();
                newpattern.append("0");
                newpattern.append(localizedPattern);
                formatter.applyLocalizedPattern(newpattern.toString());
            }
            formatter.format(number2, result2, _fieldPosition);
            return result2.toString();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(JavaExtensionUtils.getMessageString("FORMAT_NUMBER_ERR", new Object[]{Double.toString(number2), pattern2}));
        }
    }

    static {
        Class<Object> objectClass = Object.class;
        Class<Node> nodeClass = Node.class;
        Class<NodeList> nodeListClass = NodeList.class;
        Class<NodeIterator> nodeIteratorClass = NodeIterator.class;
        _internal2Java.put(Boolean.TYPE, new TargetType(Boolean.TYPE, 0));
        _internal2Java.put(Boolean.TYPE, new TargetType(Boolean.class, 1));
        _internal2Java.put(Boolean.TYPE, new TargetType(objectClass, 2));
        _internal2Java.put(Boolean.TYPE, new TargetType(stringClass, 3));
        _internal2Java.put(Double.TYPE, new TargetType(Double.TYPE, 0));
        _internal2Java.put(Double.TYPE, new TargetType(Double.class, 1));
        _internal2Java.put(Double.TYPE, new TargetType(Number.class, 2));
        _internal2Java.put(Double.TYPE, new TargetType(Float.TYPE, 3));
        _internal2Java.put(Double.TYPE, new TargetType(Long.TYPE, 4));
        _internal2Java.put(Double.TYPE, new TargetType(Integer.TYPE, 5));
        _internal2Java.put(Double.TYPE, new TargetType(Short.TYPE, 6));
        _internal2Java.put(Double.TYPE, new TargetType(Character.TYPE, 7));
        _internal2Java.put(Double.TYPE, new TargetType(Byte.TYPE, 8));
        _internal2Java.put(Double.TYPE, new TargetType(Boolean.TYPE, 9));
        _internal2Java.put(Double.TYPE, new TargetType(stringClass, 10));
        _internal2Java.put(Double.TYPE, new TargetType(objectClass, 11));
        _internal2Java.put(Integer.TYPE, new TargetType(Integer.TYPE, 0));
        _internal2Java.put(Integer.TYPE, new TargetType(Double.class, 1));
        _internal2Java.put(Integer.TYPE, new TargetType(Number.class, 2));
        _internal2Java.put(Integer.TYPE, new TargetType(Long.TYPE, 3));
        _internal2Java.put(Integer.TYPE, new TargetType(Double.TYPE, 4));
        _internal2Java.put(Integer.TYPE, new TargetType(Float.TYPE, 5));
        _internal2Java.put(Integer.TYPE, new TargetType(Short.TYPE, 6));
        _internal2Java.put(Integer.TYPE, new TargetType(Character.TYPE, 7));
        _internal2Java.put(Integer.TYPE, new TargetType(Byte.TYPE, 8));
        _internal2Java.put(Integer.TYPE, new TargetType(Boolean.TYPE, 9));
        _internal2Java.put(Integer.TYPE, new TargetType(stringClass, 10));
        _internal2Java.put(Integer.TYPE, new TargetType(objectClass, 11));
        _internal2Java.put(stringClass, new TargetType(stringClass, 0));
        _internal2Java.put(stringClass, new TargetType(objectClass, 1));
        _internal2Java.put(stringClass, new TargetType(Character.TYPE, 2));
        _internal2Java.put(stringClass, new TargetType(Double.TYPE, 3));
        _internal2Java.put(stringClass, new TargetType(Float.TYPE, 3));
        _internal2Java.put(stringClass, new TargetType(Long.TYPE, 3));
        _internal2Java.put(stringClass, new TargetType(Integer.TYPE, 3));
        _internal2Java.put(stringClass, new TargetType(Short.TYPE, 3));
        _internal2Java.put(stringClass, new TargetType(Byte.TYPE, 3));
        _internal2Java.put(stringClass, new TargetType(Boolean.TYPE, 4));
        _internal2Java.put(xciCursorClass, new TargetType(nodeIteratorClass, 0));
        _internal2Java.put(xciCursorClass, new TargetType(nodeListClass, 1));
        _internal2Java.put(xciCursorClass, new TargetType(nodeClass, 2));
        _internal2Java.put(xciCursorClass, new TargetType(stringClass, 3));
        _internal2Java.put(xciCursorClass, new TargetType(objectClass, 5));
        _internal2Java.put(xciCursorClass, new TargetType(Character.TYPE, 6));
        _internal2Java.put(xciCursorClass, new TargetType(Double.TYPE, 7));
        _internal2Java.put(xciCursorClass, new TargetType(Float.TYPE, 7));
        _internal2Java.put(xciCursorClass, new TargetType(Long.TYPE, 7));
        _internal2Java.put(xciCursorClass, new TargetType(Integer.TYPE, 7));
        _internal2Java.put(xciCursorClass, new TargetType(Short.TYPE, 7));
        _internal2Java.put(xciCursorClass, new TargetType(Byte.TYPE, 7));
        _internal2Java.put(xciCursorClass, new TargetType(Boolean.TYPE, 8));
        _schemaType2Class.put(TypeRegistry.XSDOUBLE, Double.TYPE);
        _schemaType2Class.put(TypeRegistry.XSDECIMAL, Double.TYPE);
        _schemaType2Class.put(TypeRegistry.XSFLOAT, Double.TYPE);
        _schemaType2Class.put(TypeRegistry.XSINTEGER, Double.TYPE);
        _schemaType2Class.put(TypeRegistry.XSINT, Double.TYPE);
        _schemaType2Class.put(TypeRegistry.XSLONG, Double.TYPE);
        _schemaType2Class.put(TypeRegistry.XSSHORT, Double.TYPE);
        _schemaType2Class.put(TypeRegistry.XSBYTE, Double.TYPE);
        _schemaType2Class.put(TypeRegistry.XSBOOLEAN, Boolean.TYPE);
        _schemaType2Class.put(TypeRegistry.XSSTRING, stringClass);
        _schemaType2Class.put(TypeRegistry.XSUNTYPED, xciCursorClass);
        _schemaType2Class.put(TypeRegistry.XSUNTYPEDATOMIC, xciCursorClass);
        _class2Primitive.put(Double.class, Double.TYPE);
        _class2Primitive.put(Number.class, Double.TYPE);
        _class2Primitive.put(Integer.class, Double.TYPE);
        _class2Primitive.put(Float.class, Double.TYPE);
        _class2Primitive.put(Long.class, Double.TYPE);
        _class2Primitive.put(Short.class, Double.TYPE);
        _class2Primitive.put(Byte.class, Double.TYPE);
        _class2Primitive.put(Boolean.class, Boolean.TYPE);
        NumberFormat f2 = NumberFormat.getInstance(Locale.getDefault());
        f2.setMaximumFractionDigits(1000);
        defaultFormatter = f2 instanceof DecimalFormat ? (DecimalFormat)f2 : new DecimalFormat();
        defaultFormatter.setGroupingUsed(false);
        _fieldPosition = new FieldPosition(0);
    }

    static class TargetType {
        public Class type;
        public int distance;

        public TargetType(Class type2, int distance) {
            this.type = type2;
            this.distance = distance;
        }

        public boolean equals(Object query) {
            return query.equals(this.type);
        }
    }
}

