/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.input;

import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class DOM2SAX
implements XMLReader,
Locator {
    private static final String EMPTYSTRING = "";
    private static final String XMLNS_PREFIX = "xmlns";
    private Node _dom = null;
    private ContentHandler _sax = null;
    private LexicalHandler _lex = null;
    private ContentHandler _saxImpl = null;
    private Hashtable _nsPrefixes = new Hashtable();
    private final String _systemId;

    public DOM2SAX(Node root2) {
        this(root2, null);
    }

    public DOM2SAX(Node root2, String systemId) {
        this._dom = root2;
        this._systemId = systemId;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this._sax;
    }

    @Override
    public void setContentHandler(ContentHandler handler) throws NullPointerException {
        this._sax = handler;
        if (handler instanceof LexicalHandler) {
            this._lex = (LexicalHandler)((Object)handler);
        }
        this._saxImpl = handler;
    }

    private boolean startPrefixMapping(String prefix2, String uri2) throws SAXException {
        boolean pushed = true;
        Stack<String> uriStack = (Stack<String>)this._nsPrefixes.get(prefix2);
        if (uriStack != null) {
            if (uriStack.isEmpty()) {
                this._sax.startPrefixMapping(prefix2, uri2);
                uriStack.push(uri2);
            } else {
                String lastUri = (String)uriStack.peek();
                if (!lastUri.equals(uri2)) {
                    this._sax.startPrefixMapping(prefix2, uri2);
                    uriStack.push(uri2);
                } else {
                    pushed = false;
                }
            }
        } else {
            this._sax.startPrefixMapping(prefix2, uri2);
            uriStack = new Stack<String>();
            this._nsPrefixes.put(prefix2, uriStack);
            uriStack.push(uri2);
        }
        return pushed;
    }

    private void endPrefixMapping(String prefix2) throws SAXException {
        Stack uriStack = (Stack)this._nsPrefixes.get(prefix2);
        if (uriStack != null) {
            this._sax.endPrefixMapping(prefix2);
            uriStack.pop();
        }
    }

    private static String getLocalName(Node node2) {
        String localName2 = node2.getLocalName();
        if (localName2 == null) {
            String qname2 = node2.getNodeName();
            int col = qname2.lastIndexOf(58);
            return col > 0 ? qname2.substring(col + 1) : qname2;
        }
        return localName2;
    }

    @Override
    public void parse(InputSource unused) throws IOException, SAXException {
        this.parse();
    }

    public void parse() throws IOException, SAXException {
        if (this._dom != null) {
            boolean isIncomplete;
            boolean bl = isIncomplete = this._dom.getNodeType() != 9;
            if (isIncomplete) {
                this._sax.startDocument();
                this.parse(this._dom);
                this._sax.endDocument();
            } else {
                this.parse(this._dom);
            }
        }
    }

    private void parse(Node node2) throws IOException, SAXException {
        Object first = null;
        if (node2 == null) {
            return;
        }
        switch (node2.getNodeType()) {
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                String cdata = node2.getNodeValue();
                if (this._lex != null) {
                    this._lex.startCDATA();
                    this._sax.characters(cdata.toCharArray(), 0, cdata.length());
                    this._lex.endCDATA();
                    break;
                }
                this._sax.characters(cdata.toCharArray(), 0, cdata.length());
                break;
            }
            case 8: {
                if (this._lex == null) break;
                String value2 = node2.getNodeValue();
                this._lex.comment(value2.toCharArray(), 0, value2.length());
                break;
            }
            case 9: {
                this._sax.setDocumentLocator(this);
                this._sax.startDocument();
                for (Node next = node2.getFirstChild(); next != null; next = next.getNextSibling()) {
                    this.parse(next);
                }
                this._sax.endDocument();
                break;
            }
            case 1: {
                String prefix2;
                String uriAttr;
                String qnameAttr;
                Node attr2;
                int i;
                Vector<String> pushedPrefixes = new Vector<String>();
                AttributesImpl attrs = new AttributesImpl();
                NamedNodeMap map2 = node2.getAttributes();
                int length2 = map2.getLength();
                for (i = 0; i < length2; ++i) {
                    attr2 = map2.item(i);
                    qnameAttr = attr2.getNodeName();
                    if (!qnameAttr.startsWith(XMLNS_PREFIX)) continue;
                    uriAttr = attr2.getNodeValue();
                    int colon = qnameAttr.lastIndexOf(58);
                    String string2 = prefix2 = colon > 0 ? qnameAttr.substring(colon + 1) : EMPTYSTRING;
                    if (!this.startPrefixMapping(prefix2, uriAttr)) continue;
                    pushedPrefixes.addElement(prefix2);
                }
                for (i = 0; i < length2; ++i) {
                    attr2 = map2.item(i);
                    qnameAttr = attr2.getNodeName();
                    if (qnameAttr.startsWith(XMLNS_PREFIX)) continue;
                    uriAttr = attr2.getNamespaceURI();
                    String localNameAttr = DOM2SAX.getLocalName(attr2);
                    if (uriAttr != null) {
                        int colon = qnameAttr.lastIndexOf(58);
                        String string3 = prefix2 = colon > 0 ? qnameAttr.substring(0, colon) : EMPTYSTRING;
                        if (this.startPrefixMapping(prefix2, uriAttr)) {
                            pushedPrefixes.addElement(prefix2);
                        }
                    }
                    attrs.addAttribute(uriAttr != null ? uriAttr : EMPTYSTRING, localNameAttr, qnameAttr, "CDATA", attr2.getNodeValue());
                }
                String qname2 = node2.getNodeName();
                String uri2 = node2.getNamespaceURI();
                String localName2 = DOM2SAX.getLocalName(node2);
                if (uri2 != null) {
                    int colon = qname2.lastIndexOf(58);
                    String string4 = prefix2 = colon > 0 ? qname2.substring(0, colon) : EMPTYSTRING;
                    if (this.startPrefixMapping(prefix2, uri2)) {
                        pushedPrefixes.addElement(prefix2);
                    }
                } else {
                    uri2 = EMPTYSTRING;
                }
                if (this._saxImpl != null) {
                    this._saxImpl.startElement(uri2, localName2, qname2, attrs);
                } else {
                    this._sax.startElement(uri2, localName2, qname2, attrs);
                }
                for (Node next = node2.getFirstChild(); next != null; next = next.getNextSibling()) {
                    this.parse(next);
                }
                this._sax.endElement(uri2, localName2, qname2);
                int nPushedPrefixes = pushedPrefixes.size();
                for (int i2 = 0; i2 < nPushedPrefixes; ++i2) {
                    this.endPrefixMapping((String)pushedPrefixes.elementAt(i2));
                }
                break;
            }
            case 7: {
                this._sax.processingInstruction(node2.getNodeName(), node2.getNodeValue());
                break;
            }
            case 3: {
                String data2 = node2.getNodeValue();
                this._sax.characters(data2.toCharArray(), 0, data2.length());
            }
        }
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public boolean getFeature(String name2) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name2, boolean value2) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void parse(String sysId) throws IOException, SAXException {
        throw new IOException(XMLMessages.createXMLMessage("ERR_SYSTEM", "This method is not yet implemented."));
    }

    @Override
    public void setDTDHandler(DTDHandler handler) throws NullPointerException {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver2) throws NullPointerException {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) throws NullPointerException {
    }

    @Override
    public void setProperty(String name2, Object value2) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name2) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public int getColumnNumber() {
        return 0;
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return this._systemId;
    }

    private String getNodeTypeFromCode(short code) {
        String retval = null;
        switch (code) {
            case 2: {
                retval = "ATTRIBUTE_NODE";
                break;
            }
            case 4: {
                retval = "CDATA_SECTION_NODE";
                break;
            }
            case 8: {
                retval = "COMMENT_NODE";
                break;
            }
            case 11: {
                retval = "DOCUMENT_FRAGMENT_NODE";
                break;
            }
            case 9: {
                retval = "DOCUMENT_NODE";
                break;
            }
            case 10: {
                retval = "DOCUMENT_TYPE_NODE";
                break;
            }
            case 1: {
                retval = "ELEMENT_NODE";
                break;
            }
            case 6: {
                retval = "ENTITY_NODE";
                break;
            }
            case 5: {
                retval = "ENTITY_REFERENCE_NODE";
                break;
            }
            case 12: {
                retval = "NOTATION_NODE";
                break;
            }
            case 7: {
                retval = "PROCESSING_INSTRUCTION_NODE";
                break;
            }
            case 3: {
                retval = "TEXT_NODE";
            }
        }
        return retval;
    }
}

