/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.input;

import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.common.utils.STAXEvent2SAX;
import com.ibm.xltxe.rnm1.xtq.common.utils.STAXStream2SAX;
import com.ibm.xltxe.rnm1.xtq.common.utils.StAX2SAX;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.input.DOM2SAX;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class Util {
    public static InputSource getInputSource(XSLTParser parser, Source source) {
        InputSource input = null;
        String systemId = source.getSystemId();
        if (systemId == null) {
            systemId = "";
        }
        try {
            if (source instanceof SAXSource) {
                SAXSource sax = (SAXSource)source;
                input = sax.getInputSource();
                parser.setXMLReader(sax.getXMLReader());
            } else if (source instanceof DOMSource) {
                DOMSource domsrc = (DOMSource)source;
                Node dom = domsrc.getNode();
                DOM2SAX dom2sax = new DOM2SAX(dom, domsrc.getSystemId());
                parser.setXMLReader(dom2sax);
                input = SAXSource.sourceToInputSource(source);
                if (input == null) {
                    input = new InputSource(domsrc.getSystemId());
                }
            } else if (source instanceof StreamSource) {
                StreamSource stream2 = (StreamSource)source;
                InputStream istream = stream2.getInputStream();
                Reader reader = stream2.getReader();
                parser.setXMLReader(null);
                input = istream != null ? new InputSource(istream) : (reader != null ? new InputSource(reader) : new InputSource(systemId));
                input.setPublicId(stream2.getPublicId());
            } else if (source instanceof StAXSource) {
                StAXSource stax = (StAXSource)source;
                XMLStreamReader xmlSreader = stax.getXMLStreamReader();
                StAX2SAX reader = null;
                if (xmlSreader != null) {
                    reader = new STAXStream2SAX(xmlSreader);
                } else {
                    XMLEventReader xmlEreader = stax.getXMLEventReader();
                    if (xmlEreader != null) {
                        reader = new STAXEvent2SAX(xmlEreader);
                    }
                }
                parser.setXMLReader(reader);
                input = new InputSource(stax.getSystemId());
            } else {
                ErrorMsg err = new ErrorMsg("JAXP_UNKNOWN_SOURCE_ERR");
                parser.reportError(2, err);
                return null;
            }
            input.setSystemId(source.getSystemId());
        }
        catch (NullPointerException e) {
            ErrorMsg err = new ErrorMsg("JAXP_NO_SOURCE_ERR");
            parser.reportError(2, err);
        }
        catch (SecurityException e) {
            ErrorMsg err = new ErrorMsg("FILE_ACCESS_ERR", systemId);
            parser.reportError(2, err);
        }
        return input;
    }
}

