/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.output;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XResultResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public class ResultDocumentResolver {
    private static final Logger s_logger = LoggerUtil.getLogger(ResultDocumentResolver.class);
    private static final String s_className = ResultDocumentResolver.class.getName();
    private XResultResolver m_delegate = null;
    private static final String _eol = System.getProperty("line.separator");
    private static final int _eol_len = _eol.length();

    public XResultResolver getWrappedResolver() {
        return this.m_delegate;
    }

    public void setDelegateResolver(XResultResolver r) {
        this.m_delegate = r;
    }

    public Result getResultDocument(String baseURI, String href, boolean append) {
        String absoluteURI = ResultDocumentResolver.getAbsoluteURI(baseURI, href);
        StreamResult result2 = null;
        try {
            URI uri2 = new URI(absoluteURI);
            if (uri2.getScheme().equals("file")) {
                String path2 = uri2.getPath();
                int ignore = path2.length() - href.length();
                ResultDocumentResolver.makeDirectories(path2, ignore);
            }
            result2 = new StreamResult();
            result2.setSystemId(absoluteURI);
            OutputStream os = this.makeOutputStream(uri2, append);
            result2.setOutputStream(os);
        }
        catch (URISyntaxException e) {
            result2 = new StreamResult(absoluteURI);
        }
        return result2;
    }

    public Result getResultDocument(String baseURI, String href) {
        Result r = null;
        if (this.m_delegate != null) {
            r = this.m_delegate.getResult(href, baseURI);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "getResultDocument", "User-supplied XResultResolver " + this.m_delegate + " used to resolve (" + href + ", " + baseURI + ") returned Result " + r + (r != null ? " with systemId '" + r.getSystemId() + "'" : ""));
            }
        } else if (href.equals("")) {
            return null;
        }
        if (r == null) {
            r = this.getResultDocument(baseURI, href, false);
        }
        return r;
    }

    private OutputStream makeOutputStream(URI uri2, boolean append) {
        OutputStream os;
        if (uri2.getScheme().equals("file")) {
            try {
                String fname = uri2.getPath();
                os = new FileOutputStream(fname, append);
            }
            catch (FileNotFoundException e) {
                os = null;
            }
        } else {
            try {
                URLConnection con = uri2.toURL().openConnection();
                os = con.getOutputStream();
            }
            catch (MalformedURLException e) {
                os = null;
            }
            catch (IOException e) {
                os = null;
            }
        }
        return os;
    }

    public static String turnIntoAbsoluteURI(String uri2) {
        char charAfterColon;
        int colon;
        String outURI = ResultDocumentResolver.isCommonURL(uri2) ? uri2 : (_eol_len == 2 ? (1 == (colon = uri2.indexOf(58)) ? (3 <= (uri2 = ResultDocumentResolver.replace(uri2, '\\', '/')).length() ? ((charAfterColon = (uri2 = ResultDocumentResolver.replace(uri2, '\\', '/')).charAt(2)) != '/' ? "file:///" + uri2.substring(0, 2) + '/' + uri2.substring(2) : "file:///" + uri2) : "file://" + uri2) : "file://" + uri2) : "file://" + uri2);
        outURI = ResultDocumentResolver.removeSlashDirSlashDotDot(outURI);
        outURI = ResultDocumentResolver.removeSlashDotSlash(outURI);
        return outURI;
    }

    private static String getBasePath(String uri2) {
        int last2 = uri2.lastIndexOf(47);
        if (last2 != uri2.length() - 1) {
            uri2 = 7 < last2 ? uri2.substring(0, last2 + 1) : uri2 + '/';
        }
        return uri2;
    }

    public static boolean isCommonURL(String s) {
        if (null == s) {
            return false;
        }
        return s.startsWith("file:") || s.startsWith("http:") || s.startsWith("ftp:") || s.startsWith("gopher:") || s.startsWith("mailto:") || s.startsWith("news:") || s.startsWith("telnet:");
    }

    public static String getAbsoluteURI(String primaryURL, String href) {
        String absURI;
        String base2 = primaryURL;
        String relative = href;
        if (base2 == null) {
            base2 = "";
        }
        if (relative == null) {
            relative = "";
        }
        char inputSep = File.separatorChar;
        char sep2 = '/';
        base2 = ResultDocumentResolver.replace(base2, inputSep, sep2);
        relative = ResultDocumentResolver.replace(relative, inputSep, sep2);
        base2 = ResultDocumentResolver.removeSlashDirSlashDotDot(base2);
        relative = ResultDocumentResolver.removeSlashDirSlashDotDot(relative);
        if (base2.length() == 0 || ResultDocumentResolver.isCommonURL(relative) || new File(relative).isAbsolute()) {
            base2 = relative;
            relative = "";
        }
        if (!ResultDocumentResolver.isCommonURL(base2)) {
            base2 = ResultDocumentResolver.turnIntoAbsoluteURI(base2);
        }
        if (relative.length() == 0) {
            if (ResultDocumentResolver.isCommonURL(base2)) {
                return base2;
            }
            if (base2.startsWith("file:")) {
                base2 = ResultDocumentResolver.canonicalizeFileURI(base2);
            }
            return ResultDocumentResolver.removeSlashDirSlashDotDot(base2);
        }
        if (relative.length() > 0) {
            base2 = ResultDocumentResolver.getBasePath(base2);
            absURI = base2 + relative;
        } else {
            absURI = base2;
        }
        int ignore = base2.length();
        return ResultDocumentResolver.removeSlashDirSlashDotDot(absURI);
    }

    private static String removeSlashDirSlashDotDot(String uri2) {
        int idxDotDot = uri2.indexOf("../");
        if (0 <= idxDotDot) {
            int idx1 = -1;
            int idx2 = -1;
            for (int i = 0; i < idxDotDot; ++i) {
                if (uri2.charAt(i) != '/') continue;
                idx1 = idx2;
                idx2 = i;
            }
            if (0 <= idx1 && idx1 < idx2 && idx2 < idxDotDot) {
                uri2 = uri2.substring(0, idx1) + uri2.substring(idxDotDot + 2);
                uri2 = ResultDocumentResolver.removeSlashDirSlashDotDot(uri2);
            }
        }
        return uri2;
    }

    private static String removeSlashDotSlash(String uri2) {
        int idx;
        while (0 <= (idx = uri2.indexOf("/./"))) {
            uri2 = uri2.substring(0, idx) + uri2.substring(idx + 2);
        }
        return uri2;
    }

    private static String canonicalizeFileURI(String uri2) {
        return uri2;
    }

    public static String canonicalURI(String uri2) {
        if (uri2 == null) {
            uri2 = "";
        }
        uri2 = ResultDocumentResolver.replace(uri2, '\\', '/');
        uri2 = ResultDocumentResolver.removeSlashDirSlashDotDot(uri2);
        uri2 = ResultDocumentResolver.removeSlashDotSlash(uri2);
        return uri2;
    }

    private static String replace(String s, char oldChar, char newChar) {
        boolean changed = false;
        if (oldChar != newChar) {
            char[] arr = s.toCharArray();
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] != oldChar) continue;
                arr[i] = newChar;
                changed = true;
            }
            if (changed) {
                s = String.valueOf(arr);
            }
        }
        return s;
    }

    private static void makeDirectories(String filename, int ignore) {
        int max2 = filename.length();
        if (ignore < 0) {
            ignore = 0;
        }
        for (int idx = ignore + 1; idx < max2; ++idx) {
            String directoryName;
            File f2;
            char c = filename.charAt(idx);
            if (c != '/' || (f2 = new File(directoryName = filename.substring(0, idx))).isDirectory()) continue;
            f2.mkdir();
        }
    }
}

