/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.res;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.res.BaseMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import java.util.Locale;
import java.util.ResourceBundle;

public class RuntimeMsg
extends BaseMsg {
    private static ResourceBundle m_bundle = ResourceBundle.getBundle("com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", Locale.getDefault());
    public static final String RUNTIME_RESOURCE_BUNDLE = "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages";
    private SourceLocation m_location = null;

    public RuntimeMsg(String codeOrMessage, Expr node2, boolean isCode) {
        super(codeOrMessage, isCode);
        this.m_location = this.createSourceLocation(node2);
    }

    public RuntimeMsg(String message, int line) {
        super(message);
        this.m_location = this.createSourceLocation(line, 0);
    }

    public RuntimeMsg(String code, int line, Object param) {
        super(code, new Object[]{param});
        this.m_location = this.createSourceLocation(line, 0);
    }

    public RuntimeMsg(String code, Object param) {
        super(code, new Object[]{param});
    }

    public RuntimeMsg(String code, Object[] params) {
        super(code, params);
    }

    public RuntimeMsg(String code, Object param, Expr node2) {
        super(code, new Object[]{param});
        this.m_location = this.createSourceLocation(node2);
    }

    public RuntimeMsg(String code, Object param1, Object param2) {
        super(code, new Object[]{param1, param2});
    }

    public RuntimeMsg(String code, Object param1, Object param2, Expr node2) {
        super(code, new Object[]{param1, param2});
        this.m_location = this.createSourceLocation(node2);
    }

    public RuntimeMsg(Throwable e) {
        super(e.getMessage(), null);
    }

    public RuntimeMsg(String code) {
        super(code, true);
    }

    public SourceLocation getSourceLocation() {
        return this.m_location;
    }

    @Override
    protected ResourceBundle getBundle() {
        return m_bundle;
    }

    private SourceLocation createSourceLocation(Expr node2) {
        if (node2 == null) {
            return null;
        }
        return new SourceLocation(node2.getSystemId(), node2.getPublicId(), node2.getStartLineNumber(), node2.getStartColumnNumber(), node2.getEndLineNumber(), node2.getEndColumnNumber());
    }

    private SourceLocation createSourceLocation(int line, int column) {
        return new SourceLocation(null, null, line, column, -1, -1);
    }

    @Override
    protected String formatLocation() {
        String result2 = "";
        String url = null;
        if (this.m_location != null) {
            url = this.m_location.getSystemId();
            if (url == null) {
                url = this.m_location.getPublicId();
            }
            if (url == null) {
                url = new ErrorMsg("UNKNOWN_MSG").getFormattedMessage();
            }
            int line = this.m_location.getLineNumber();
            String lineStr = String.valueOf(line);
            if (line <= 0) {
                lineStr = new ErrorMsg("UNKNOWN_MSG").getFormattedMessage();
            }
            int col = this.m_location.getColumnNumber();
            String colStr = String.valueOf(col);
            if (col <= 0) {
                colStr = new ErrorMsg("UNKNOWN_MSG").getFormattedMessage();
            }
            result2 = new ErrorMsg("SOURCE_LOCATION_MSG", new Object[]{url, lineStr, colStr}).getFormattedMessage();
        }
        return result2;
    }
}

