/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.v2;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.LazyBaseCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.serializer.XOutputWriter;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;

public final class EncodedCData
extends LazyBaseCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final byte[] encodedBytes;
    private final int encodedBytesLen;
    private final String encoding;
    private final short entityEncodings;

    public static CData make(VolatileCData typedValue, String encoding, short entityEncodings) {
        assert (typedValue instanceof Cursor);
        if (typedValue.isOptimizedFor(encoding, entityEncodings)) {
            return typedValue.constant(true);
        }
        return new EncodedCData(typedValue, encoding, entityEncodings);
    }

    public static CData make(VolatileCData typedValue, boolean escape2) {
        assert (typedValue instanceof Cursor);
        return new EncodedCData(typedValue, Chars.UTF8.name(), escape2 ? (short)33 : 0);
    }

    private EncodedCData(VolatileCData typedValue, String encoding, short entityEncodings) {
        super(typedValue.constant(true));
        try {
            this.encoding = encoding;
            this.entityEncodings = entityEncodings;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            typedValue.writeEncodedBytesTo(bos, encoding, entityEncodings, false);
            this.encodedBytes = bos.toByteArray();
            this.encodedBytesLen = this.encodedBytes.length;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final CData constant(boolean discard2) {
        CData cdata = this.typedValue.constant(discard2);
        if (cdata == this.typedValue) {
            return this;
        }
        if (discard2) {
            this.typedValue = cdata;
            return this;
        }
        return this.makeNew(cdata, this.encoding, this.entityEncodings);
    }

    @Override
    public boolean isOptimizedFor(String encoding, short entityEncodings) {
        return this.encoding == encoding && this.entityEncodings == entityEncodings && this.isConstant();
    }

    @Override
    public final CData itemAt(int position2) {
        CData cdata = this.typedValue.itemAt(position2);
        if (cdata == this.typedValue) {
            return this;
        }
        return this.makeNew(cdata, this.encoding, this.entityEncodings);
    }

    protected Cursor smartWrapCursor(Cursor cursor2) {
        if (cursor2 == this) {
            return cursor2;
        }
        XSSimpleTypeDefinition myTypeXSType = this.getXSTypeDefinition();
        if (cursor2 instanceof VolatileCData) {
            VolatileCData vcdataFromCursor = (VolatileCData)((Object)cursor2);
            return (Cursor)((Object)this.makeNew(vcdataFromCursor.constant(true), this.encoding, this.entityEncodings));
        }
        return cursor2;
    }

    protected CData makeNew(VolatileCData typedValue, String encoding, short entityEncodings) {
        assert (typedValue instanceof Cursor);
        return new EncodedCData(typedValue, encoding, entityEncodings);
    }

    protected CData makeNew(VolatileCData typedValue) {
        assert (typedValue instanceof Cursor);
        boolean escape2 = false;
        return new EncodedCData(typedValue, Chars.UTF8.name(), escape2 ? (short)33 : 0);
    }

    @Override
    public int writeTo(Writer writer, boolean discard2) throws IOException {
        return this.typedValue.writeTo(writer, discard2);
    }

    @Override
    public int writeEncodedBytesTo(int from2, byte[] bytes2, int offset, String encoding, short entityEncodings, boolean discard2) {
        if (this.encoding == encoding && this.entityEncodings == entityEncodings) {
            int length2 = Math.min(this.encodedBytes.length - from2, bytes2.length - offset);
            System.arraycopy(this.encodedBytes, from2, bytes2, offset, length2);
            return length2;
        }
        return this.typedValue.writeEncodedBytesTo(from2, bytes2, offset, encoding, entityEncodings, discard2);
    }

    @Override
    public void writeEncodedBytesTo(OutputStream out, Charset charset, boolean discard2) throws IOException {
        if (this.encoding.equals(charset.name())) {
            out.write(this.encodedBytes);
        } else {
            this.typedValue.writeEncodedBytesTo(out, charset, discard2);
        }
    }

    @Override
    public void writeEncodedBytesTo(OutputStream out, String encoding, short entityEncodings, boolean discard2) throws IOException {
        if (this.encoding == encoding && this.entityEncodings == entityEncodings) {
            out.write(this.encodedBytes);
        } else {
            this.typedValue.writeEncodedBytesTo(out, encoding, entityEncodings, discard2);
        }
    }

    @Override
    public boolean equals(Object other2) {
        if (!(other2 instanceof VolatileCData)) {
            return false;
        }
        if (other2 instanceof EncodedCData && (!this.encoding.equals(((EncodedCData)other2).encoding) || this.entityEncodings != ((EncodedCData)other2).entityEncodings)) {
            return false;
        }
        return this.typedValue.equals(other2);
    }

    @Override
    public void write(XOutputWriter out, EncodeContext encodeContext, boolean discard2) throws IOException {
        out.writeDirectUTF8(this.encodedBytes, 0, this.encodedBytesLen);
    }

    @Override
    public void write(XOutputWriter out, int start, int end, EncodeContext encodeContext, boolean discard2) throws IOException {
        out.writeDirectUTF8(this.encodedBytes, start, end);
    }

    @Override
    public XSSimpleTypeDefinition getXSTypeDefinition() {
        return this.typedValue.getXSTypeDefinition();
    }

    @Override
    protected CData parse() {
        return this.typedValue;
    }
}

