/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.v2;

import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import com.ibm.xml.xci.dp.serialize.SerializedCData;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import java.util.Map;

public class XPathStep {
    private int fForksTaken = 0;
    private long fContextSize = -1L;
    private final Executable fStepExec;
    private final DynamicContext fDC;
    private boolean fKnownNotSingleton = false;
    private static Cursor.Profile STACK_NAVIGATION_PLUS_SIZE = Cursor.Profile.MINIMAL_STACK_NAVIGATION.union(Cursor.Profile.SIZE);
    private static String CONSOLIDATE_FORK_THRESHOLD_OPTION = "StepCursorForkThreshold";
    private static int CONSOLIDATE_FORK_THRESHOLD = HiddenOptions.wasSpecified(CONSOLIDATE_FORK_THRESHOLD_OPTION) ? HiddenOptions.getIntegerValue(CONSOLIDATE_FORK_THRESHOLD_OPTION) : Integer.MAX_VALUE;

    private XPathStep(Executable stepExec, DynamicContext dc) {
        this.fStepExec = stepExec;
        this.fDC = dc;
    }

    public static Cursor instantiate(Cursor source, DynamicContext dc, Executable stepExec, boolean isOrderedUnique) {
        Cursor stepCursor;
        if (STACK_NAVIGATION_PLUS_SIZE.containedIn(source.profile()) && source.contextIsSingleton()) {
            stepCursor = stepExec.execute(source, dc, Cursor.Profile.RANDOM_ACCESS, null);
        } else {
            Cursor firstStepResult;
            Cursor forkedSource = source.fork(false, Cursor.Profile.STREAMING_READ, Cursor.Profile.STREAMING_READ);
            while ((firstStepResult = stepExec.execute(forkedSource, dc, Cursor.Profile.RANDOM_ACCESS, null)) == null && forkedSource.toNext()) {
            }
            if (firstStepResult != null) {
                XPathStep xPathStep = new XPathStep(stepExec, dc);
                xPathStep.getClass();
                stepCursor = xPathStep.new XPathStepCursor(forkedSource, firstStepResult, isOrderedUnique);
            } else {
                stepCursor = null;
                forkedSource.release();
            }
        }
        return stepCursor;
    }

    private void incrementForkCount() {
        ++this.fForksTaken;
    }

    private int getForkCount() {
        return this.fForksTaken;
    }

    private void setContextSize(long size) {
        this.fContextSize = size;
    }

    private long getContextSize() {
        return this.fContextSize;
    }

    private Executable getStepExec() {
        return this.fStepExec;
    }

    private DynamicContext getDynamicContext() {
        return this.fDC;
    }

    private boolean isKnownNotSingleton() {
        return this.fKnownNotSingleton;
    }

    private void markKnownNotSingleton() {
        this.fKnownNotSingleton = true;
    }

    private class XPathStepCursor
    extends AbstractDelegatingCursor {
        private Cursor fSource;
        private Cursor fCurrentStep;
        private boolean fNavigated;
        private long fPosition = 1L;
        private boolean fIsOrderedUnique;

        private XPathStepCursor(Cursor source, Cursor currentStep, boolean isOrderedUnique) {
            this.fSource = source;
            this.fCurrentStep = currentStep;
            this.fIsOrderedUnique = isOrderedUnique;
        }

        private XPathStepCursor(XPathStepCursor orig, Cursor.Profile neededProfile, Cursor.Profile futureProfile) {
            this(orig.getSource().fork(false, neededProfile, futureProfile), orig.getDelegate().fork(false, neededProfile, futureProfile), orig.fIsOrderedUnique);
            this.fPosition = orig.fPosition;
        }

        @Override
        public Cursor getDelegate() {
            return this.fCurrentStep;
        }

        protected Cursor getSource() {
            return this.fSource;
        }

        @Override
        public long contextPosition() {
            return this.fNavigated ? super.contextPosition() : this.fPosition;
        }

        @Override
        public long contextSize() {
            long contextSize;
            if (this.fNavigated) {
                return super.contextSize();
            }
            if (XPathStep.this.getContextSize() >= 0L) {
                return XPathStep.this.getContextSize();
            }
            if (Cursor.Profile.TO_PREVIOUS.containedIn(this.profile())) {
                long startingPosition = this.fPosition;
                while (this.toNext()) {
                }
                contextSize = this.fPosition;
                XPathStep.this.setContextSize(contextSize);
                for (long numToRewind = contextSize - startingPosition; numToRewind > 0L; --numToRewind) {
                    this.toPrevious();
                }
            } else {
                Cursor forkedCursor = this.fork(false, Cursor.Profile.STREAMING_READ, Cursor.Profile.STREAMING_READ);
                while (forkedCursor.toNext()) {
                }
                contextSize = forkedCursor.contextPosition();
                XPathStep.this.setContextSize(contextSize);
                forkedCursor.release();
            }
            return contextSize;
        }

        @Override
        public boolean contextIsSingleton() {
            boolean isSingleton;
            if (this.fNavigated) {
                isSingleton = super.contextIsSingleton();
            } else if (XPathStep.this.isKnownNotSingleton()) {
                isSingleton = false;
            } else if (XPathStep.this.getContextSize() >= 1L) {
                isSingleton = XPathStep.this.getContextSize() == 1L;
            } else if (this.fPosition > 1L) {
                isSingleton = false;
            } else {
                boolean hasNext;
                if (Cursor.Profile.TO_PREVIOUS.containedIn(this.profile())) {
                    hasNext = this.toNext();
                    if (hasNext) {
                        this.toPrevious();
                    }
                } else {
                    Cursor forkedCursor = this.fork(false, Cursor.Profile.STREAMING_READ, Cursor.Profile.STREAMING_READ);
                    hasNext = forkedCursor.toNext();
                    forkedCursor.release();
                }
                boolean bl = isSingleton = !hasNext;
                if (isSingleton) {
                    XPathStep.this.setContextSize(1L);
                } else {
                    XPathStep.this.markKnownNotSingleton();
                }
            }
            return isSingleton;
        }

        @Override
        public boolean contextIsNodesOnly() {
            return true;
        }

        @Override
        public boolean contextIsAtomsOnly() {
            return false;
        }

        @Override
        protected void navigate() {
            this.fNavigated = true;
            this.fIsOrderedUnique = false;
            this.clearSource(true);
        }

        @Override
        public boolean requiresRelease() {
            return this.getDelegate().requiresRelease() || !this.fNavigated && this.getSource().requiresRelease();
        }

        @Override
        public void release() {
            this.clearDelegate(true);
            this.clearSource(true);
            this.fPosition = -1L;
            this.fCurrentStep = null;
        }

        protected void setDelegate(Cursor newDelegate, boolean releaseOldDelegate) {
            Cursor oldDelegate;
            if (releaseOldDelegate && (oldDelegate = this.getDelegate()) != null) {
                oldDelegate.release();
            }
            this.fCurrentStep = newDelegate;
        }

        protected void clearDelegate(boolean releaseOldDelegate) {
            this.setDelegate(null, releaseOldDelegate);
        }

        protected void setSource(Cursor newSource, boolean releaseSource) {
            Cursor oldSource;
            if (releaseSource && (oldSource = this.getSource()) != null) {
                oldSource.release();
            }
            this.fSource = newSource;
        }

        protected void clearSource(boolean releaseSource) {
            this.setSource(null, releaseSource);
        }

        @Override
        public boolean toNext() {
            boolean foundNext;
            if (this.fNavigated) {
                return super.toNext();
            }
            if (XPathStep.this.getContextSize() == this.fPosition) {
                return false;
            }
            Cursor stepCursor = this.getDelegate();
            if (!stepCursor.toNext()) {
                boolean forkedSource;
                Cursor srcToMove = this.getSource();
                long origSourcePos = 0L;
                boolean movedSource = false;
                if (Cursor.Profile.TO_POSITION.containedIn(srcToMove.profile())) {
                    origSourcePos = srcToMove.contextPosition();
                    forkedSource = false;
                } else {
                    srcToMove = srcToMove.fork(false);
                    forkedSource = true;
                }
                Cursor nextStep = null;
                while (nextStep == null && srcToMove.toNext()) {
                    movedSource = true;
                    nextStep = XPathStep.this.getStepExec().execute(srcToMove, XPathStep.this.getDynamicContext(), Cursor.Profile.RANDOM_ACCESS, null);
                }
                boolean bl = foundNext = nextStep != null;
                if (foundNext) {
                    this.setDelegate(nextStep, true);
                    if (forkedSource) {
                        this.setSource(srcToMove, true);
                    }
                } else if (forkedSource) {
                    srcToMove.release();
                } else if (movedSource) {
                    srcToMove.toPosition(origSourcePos);
                }
            } else {
                foundNext = true;
            }
            if (foundNext) {
                if (this.fPosition == 1L) {
                    XPathStep.this.markKnownNotSingleton();
                }
                ++this.fPosition;
            } else {
                XPathStep.this.setContextSize(this.fPosition);
            }
            return foundNext;
        }

        @Override
        public boolean toPrevious() {
            boolean foundPrevious;
            if (this.fNavigated) {
                return super.toPrevious();
            }
            if (this.fPosition == 1L) {
                return false;
            }
            Cursor stepCursor = this.getDelegate();
            if (!stepCursor.toPrevious()) {
                boolean forkedSource;
                Cursor srcToMove = this.getSource();
                long origSourcePos = 0L;
                boolean movedSource = false;
                if (Cursor.Profile.TO_POSITION.containedIn(srcToMove.profile())) {
                    origSourcePos = srcToMove.contextPosition();
                    forkedSource = false;
                } else {
                    srcToMove = srcToMove.fork(false);
                    forkedSource = true;
                }
                Cursor nextStep = null;
                while (nextStep == null && srcToMove.toPrevious()) {
                    nextStep = XPathStep.this.getStepExec().execute(srcToMove, XPathStep.this.getDynamicContext(), Cursor.Profile.RANDOM_ACCESS, null);
                    movedSource = true;
                }
                boolean bl = foundPrevious = nextStep != null;
                if (foundPrevious) {
                    if (Cursor.Profile.MINIMAL_STACK_NAVIGATION.containedIn(nextStep.profile())) {
                        nextStep.toLast();
                    } else {
                        while (nextStep.toNext()) {
                        }
                    }
                    this.setDelegate(nextStep, true);
                    if (forkedSource) {
                        this.setSource(srcToMove, true);
                    }
                } else if (forkedSource) {
                    srcToMove.release();
                } else if (movedSource) {
                    srcToMove.toPosition(origSourcePos);
                }
            } else {
                foundPrevious = true;
            }
            if (foundPrevious) {
                --this.fPosition;
            }
            return foundPrevious;
        }

        @Override
        public boolean toPosition(long position2) {
            boolean succeeded;
            long i;
            if (this.fNavigated) {
                return super.toPosition(position2);
            }
            if (position2 <= 0L) {
                return false;
            }
            boolean knownToSucceed = position2 <= this.fPosition || position2 <= XPathStep.this.getContextSize();
            Cursor savedSourceState = this.getSource();
            Cursor savedDelegateState = this.getDelegate();
            long savedPosition = this.fPosition;
            if (!knownToSucceed) {
                this.setSource(savedSourceState.fork(false), false);
                this.setDelegate(savedDelegateState.fork(false), false);
            }
            if (this.fPosition < position2) {
                for (i = this.fPosition; i < position2 && this.toNext(); ++i) {
                }
            } else {
                for (i = this.fPosition; i > position2 && this.toPrevious(); --i) {
                }
            }
            boolean bl = succeeded = this.fPosition == position2;
            if (!knownToSucceed) {
                if (succeeded) {
                    savedSourceState.release();
                    savedDelegateState.release();
                } else {
                    this.setSource(savedSourceState, true);
                    this.setDelegate(savedDelegateState, true);
                    this.fPosition = savedPosition;
                }
            }
            return succeeded;
        }

        @Override
        public void toLast() {
            if (this.fNavigated) {
                super.toLast();
            } else {
                while (this.toNext()) {
                }
            }
        }

        @Override
        public VolatileCData serialize(Map<String, Object> parameters) {
            return new SerializedCData(this, parameters);
        }

        @Override
        public Cursor fork(boolean mustNavigate, Cursor.Profile neededProfile, Cursor.Profile futureProfile) {
            Cursor forkedResult;
            if (!mustNavigate && this.fPosition == 1L && CONSOLIDATE_FORK_THRESHOLD != Integer.MAX_VALUE && XPathStep.this.getForkCount() > CONSOLIDATE_FORK_THRESHOLD) {
                this.consolidateNodes();
            }
            if (this.fNavigated || mustNavigate) {
                forkedResult = this.getDelegate().fork(mustNavigate, neededProfile, futureProfile);
            } else {
                if (CONSOLIDATE_FORK_THRESHOLD != Integer.MAX_VALUE) {
                    XPathStep.this.incrementForkCount();
                }
                forkedResult = new XPathStepCursor(this, neededProfile, futureProfile);
            }
            return forkedResult;
        }

        @Override
        public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile futureProfile, boolean releaseThis) {
            Cursor orderedResult;
            if (this.fIsOrderedUnique) {
                orderedResult = releaseThis ? this : this.fork(false, profile, futureProfile);
            } else {
                if (!this.fNavigated) {
                    this.consolidateNodes();
                }
                Cursor unorderedResult = this.getDelegate();
                if (releaseThis) {
                    this.release();
                }
                orderedResult = unorderedResult.documentOrder(profile, futureProfile, releaseThis);
            }
            return orderedResult;
        }

        @Override
        public Cursor sequenceConcat(Cursor that, Cursor.Profile neededProfile, Cursor.Profile futureProfile, boolean releaseThis, boolean releaseThat) {
            this.consolidateNodes();
            Cursor nodes2 = this.getDelegate().sequenceConcat(that, neededProfile, futureProfile, releaseThis, releaseThat);
            return nodes2;
        }

        @Override
        public Class<?> exportAsClass(String name2) {
            this.consolidateNodes();
            return this.getDelegate().exportAsClass(name2);
        }

        @Override
        public Object exportAs(String name2, boolean release2) {
            this.consolidateNodes();
            return this.getDelegate().exportAs(name2, release2);
        }

        private void consolidateNodes() {
            if (this.fNavigated) {
                return;
            }
            Cursor concat = this.getDelegate();
            Cursor source = this.getSource();
            Executable exec = XPathStep.this.getStepExec();
            DynamicContext dc = XPathStep.this.getDynamicContext();
            boolean didConcat = false;
            while (source.toNext()) {
                Cursor localResult = exec.execute(source, dc, Cursor.Profile.STREAMING_READ, null);
                if (localResult == null) continue;
                concat = concat.sequenceConcat(localResult, Cursor.Profile.SEQUENCE, Cursor.Profile.RANDOM_ACCESS, false, false, true, true);
                didConcat = true;
            }
            if (didConcat) {
                this.setDelegate(concat, false);
            }
            this.navigate();
        }
    }
}

