/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator;

import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;
import com.ibm.xltxe.rnm1.xtq.utils.LineInfo;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import java.util.HashMap;
import java.util.Map;

public class LineNumberHelper {
    private static Type s_lineTableType = JavaObjectType.s_javaHashMapType;
    private static String s_lineInfoSeparator = ":";
    private LineInfo m_lineState = null;
    private boolean m_lineStateChanged = false;
    private HashMap<Integer, LineInfo> m_lineTable = new HashMap();
    private int m_index = 0;
    private HashMap<String, Integer> m_uriTable = new HashMap();
    private int m_uriIndex = 0;

    public HashMap<Integer, LineInfo> getLineTable() {
        return this.m_lineTable;
    }

    public HashMap<String, Integer> getURITable() {
        return this.m_uriTable;
    }

    public int getLineTableIndex() {
        if (this.m_lineState != null) {
            if (this.m_lineStateChanged) {
                ++this.m_index;
                this.m_lineTable.put(this.m_index, this.m_lineState);
                this.addURI(this.m_lineState.getSystemID());
                this.m_lineStateChanged = false;
            }
            return this.m_index;
        }
        return -1;
    }

    private void addURI(String uri2) {
        if (uri2 != null && uri2.length() > 0 && !this.m_uriTable.containsKey(uri2)) {
            ++this.m_uriIndex;
            this.m_uriTable.put(uri2, this.m_uriIndex);
        }
    }

    public void setLineState(LineInfo lineInfo) {
        this.m_lineState = lineInfo;
        this.m_lineStateChanged = true;
    }

    public LineInfo getLineState() {
        return this.m_lineState;
    }

    public Type getLineTableType() {
        return s_lineTableType;
    }

    public String getLineTableValue(LineInfo li) {
        StringBuilder stringBuilder = new StringBuilder();
        if (li.getSystemID() != null) {
            Integer index2 = this.m_uriTable.get(li.getSystemID());
            stringBuilder.append(index2.toString());
        } else {
            stringBuilder.append("X");
        }
        stringBuilder.append(s_lineInfoSeparator);
        stringBuilder.append(li.getStartLine());
        stringBuilder.append(s_lineInfoSeparator);
        stringBuilder.append(li.getStartColumn());
        return stringBuilder.toString();
    }

    public static SourceLocation lineTableEntryToSourceLocation(String entry, Map<String, String> uriTable) {
        int uriEnd = entry.indexOf(s_lineInfoSeparator);
        String uriKey = entry.substring(0, uriEnd);
        String systemId = uriTable.get(uriKey);
        if (systemId != null && systemId.length() == 0) {
            systemId = null;
        }
        int lineEnd = entry.indexOf(s_lineInfoSeparator, uriEnd + 1);
        int line = Integer.valueOf(entry.substring(uriEnd + 1, lineEnd));
        int column = Integer.valueOf(entry.substring(lineEnd + 1));
        return new SourceLocation(systemId, null, line, column, -1, -1);
    }

    public Map<String, String> getRuntimeLineTable() {
        HashMap<String, String> lineTable = new HashMap<String, String>(this.m_lineTable.size());
        for (Integer line : this.m_lineTable.keySet()) {
            LineInfo lineInfo = this.m_lineTable.get(line);
            String lineEntry = this.getLineTableValue(lineInfo);
            lineTable.put(line.toString(), lineEntry);
        }
        return lineTable;
    }

    public Map<String, String> getRuntimeURITable() {
        HashMap<String, String> uriTable = new HashMap<String, String>(this.m_uriTable.size());
        for (String uri2 : this.m_uriTable.keySet()) {
            Integer index2 = this.m_uriTable.get(uri2);
            uriTable.put(index2.toString(), uri2);
        }
        return uriTable;
    }
}

