/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator;

import com.ibm.xltxe.rnm1.xtq.Constants;
import com.ibm.xltxe.rnm1.xtq.ast.XPath20Exception;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionCall;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.IdOrKeyFunctionCallPattern;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.KindTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.NameTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OperatorExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.StepExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Template;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.TestSeq;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.TranslatorBase;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XSLTC2Helper;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.TypeCheckError;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2.XPath2TypeChecker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.namespace.QName;

public final class Mode
implements Constants,
XPathTreeConstants {
    public static final String APPLY_TEMPLATES = "applyTemplates";
    private final QName _name;
    private final XTQProgram _stylesheet;
    private final String _methodName;
    private List<Template> _templates;
    private List _childNodeGroup = null;
    private TestSeq _childNodeTestSeq = null;
    private List _attribNodeGroup = null;
    private List _idxGroup = null;
    private TestSeq _idxTestSeq = null;
    private List[] _patternGroups;
    private TestSeq[] _testSeq;
    private Hashtable<Template, Mode> _neededTemplates = new Hashtable();
    private Hashtable<Template, Mode> _namedTemplates = new Hashtable();
    private ArrayList<Expr> _rootPatterns = null;
    private Hashtable _importLevels = null;
    private Hashtable _keys = null;
    private TranslatorBase _translator;
    private int _modeNumber;
    XPath2TypeChecker _xpath2TypeChecker;

    public Mode(QName name2, TranslatorBase translator, XTQProgram stylesheet, String suffix2) {
        this._name = name2;
        if (this._name == null) {
            // empty if block
        }
        this._translator = translator;
        this._stylesheet = stylesheet;
        this._methodName = APPLY_TEMPLATES + suffix2;
        this._templates = new ArrayList<Template>();
        this._patternGroups = new ArrayList[32];
        int n2 = this._modeNumber = suffix2.equals("") ? 0 : Integer.valueOf(suffix2);
        if (this._translator != null) {
            this._xpath2TypeChecker = new XPath2TypeChecker(this._translator._compiler);
        }
    }

    public void setTranslator(TranslatorBase translator) {
        this._translator = translator;
        if (this._translator != null) {
            this._xpath2TypeChecker = new XPath2TypeChecker(this._translator._compiler);
        }
    }

    public TranslatorBase getTranslator() {
        return this._translator;
    }

    public String functionName() {
        return this._methodName;
    }

    public String functionName(int min2, int max2) {
        if (this._importLevels == null) {
            this._importLevels = new Hashtable();
        }
        this._importLevels.put(new Integer(max2), new Integer(min2));
        return this._methodName + '_' + max2;
    }

    public XTQProgram getStylesheet() {
        return this._stylesheet;
    }

    public void addTemplate(Template template) {
        this._templates.add(template);
    }

    public void processPatterns(Hashtable keys2, int version) {
        this._keys = keys2;
        for (Template template : this._templates) {
            Expr pattern2;
            if (template.isNamedTemplate() && !template.isDisabled()) {
                this._namedTemplates.put(template, this);
            }
            if ((pattern2 = template.getPattern()) == null) continue;
            this.flattenAlternative(pattern2, template, keys2, version, null);
            if (null == this._xpath2TypeChecker) continue;
            try {
                this._xpath2TypeChecker.visitExpression(pattern2);
            }
            catch (TypeCheckError e) {
                throw new RuntimeException(e);
            }
        }
        this.prepareTestSequences();
    }

    private void flattenAlternative(Expr pattern2, Template template, Hashtable keys2, int version, ArrayList<ArrayList<Expr>> unionPatternSets) {
        if (pattern2 instanceof IdOrKeyFunctionCallPattern) {
            ASTDecorator.setPatternPriority(pattern2, XSLTC2Helper.getPatternPriority(pattern2));
            if (((IdOrKeyFunctionCallPattern)pattern2).getFunctionQName().getLocalPart().equals("id")) {
                if (this._idxGroup == null) {
                    this._idxGroup = new ArrayList();
                }
                this._idxGroup.add(pattern2);
            } else {
                this.addPatternToGroup(pattern2);
            }
        } else if (XSLTCHelper.isUnionPattern(pattern2)) {
            Iterator<ArrayList<Expr>> templateRules;
            OperatorExpr unionPattern = (OperatorExpr)pattern2;
            Expr left = unionPattern.getOperand(0);
            Expr right = unionPattern.getOperand(1);
            ArrayList<ArrayList<Expr>> ups = unionPatternSets == null ? new ArrayList<ArrayList<Expr>>() : unionPatternSets;
            this.flattenAlternative(left, template, keys2, version, ups);
            this.flattenAlternative(right, template, keys2, version, ups);
            if (unionPatternSets == null && (templateRules = ups.iterator()).hasNext()) {
                templateRules.next();
                while (templateRules.hasNext()) {
                    ArrayList<Expr> rule2 = templateRules.next();
                    Iterator<Expr> patterns = rule2.iterator();
                    int templRuleNumber = this._translator.getParser().getTemplateIndex();
                    while (patterns.hasNext()) {
                        ASTDecorator.setPatternTemplateRule(patterns.next(), templRuleNumber);
                    }
                }
            }
        } else if (pattern2.getId() == 187 || pattern2.getId() == 188 || pattern2.getId() == 84 || pattern2.getId() == 105 && ((FunctionCall)pattern2).getQName().getLocalPart().equals("root")) {
            if (version == 1) {
                ASTDecorator.setPatternPriority(pattern2, new BigDecimal(XSLTC2Helper.getPatternPriority(pattern2).doubleValue() + ""));
            } else {
                ASTDecorator.setPatternPriority(pattern2, XSLTC2Helper.getPatternPriority(pattern2));
            }
            if (pattern2 instanceof StepExpr) {
                short id2;
                StepExpr stepPattern = (StepExpr)pattern2;
                Expr child2 = (Expr)stepPattern.jjtGetChild(0);
                if (child2 instanceof KindTest) {
                    XSLTParser parser = this._translator.getParser();
                    id2 = ((KindTest)child2).getKindTestType();
                    if (id2 == 0) {
                        XSLTCHelper.processingInstructionTestRewrite(stepPattern, parser);
                    } else if (id2 == 4 && ((KindTest)child2).getElementTest() != null) {
                        XSLTC2Helper.documentTestRewrite(parser, stepPattern, parser);
                    }
                } else if (child2 instanceof NameTest) {
                    NameTest aNameTest = (NameTest)child2;
                    id2 = aNameTest.getNameTestType();
                    XSLTParser parser = this._translator.getParser();
                    if (id2 == 1) {
                        if (version == 1) {
                            XSLTCHelper.nameTestRewrite(stepPattern, parser, true);
                        } else {
                            XSLTC2Helper.nameTestRewrite(stepPattern, parser);
                        }
                    } else if (id2 == 2) {
                        XSLTC2Helper.nameTestRewrite(stepPattern, parser);
                    }
                }
            }
            if (unionPatternSets != null) {
                ArrayList<Expr> set2 = null;
                int numSets = unionPatternSets.size();
                for (int i = 0; i < numSets; ++i) {
                    ArrayList<Expr> group2 = unionPatternSets.get(i);
                    Expr groupRepresentative = group2.get(0);
                    int compareResult = ASTDecorator.getPatternPriority(pattern2).compareTo(ASTDecorator.getPatternPriority(groupRepresentative));
                    if (compareResult > 0) {
                        set2 = new ArrayList();
                        unionPatternSets.add(i, set2);
                        break;
                    }
                    if (compareResult != 0) continue;
                    set2 = group2;
                    break;
                }
                if (set2 == null) {
                    set2 = new ArrayList<Expr>();
                    unionPatternSets.add(set2);
                }
                set2.add(pattern2);
            }
            this.addPatternToGroup(pattern2);
        }
    }

    private void addPatternToGroup(Expr lpp) {
        if (lpp instanceof IdOrKeyFunctionCallPattern) {
            this.addPattern(-1, lpp);
        } else {
            StepExpr kernel = XSLTCHelper.getKernelPattern(lpp);
            if (kernel != null) {
                int nodeType = kernel.getStepNodeType();
                int axisType = -1;
                try {
                    axisType = kernel.getAxisType();
                }
                catch (XPath20Exception e) {
                    // empty catch block
                }
                if (axisType == 1 && nodeType == 2) {
                    return;
                }
                if (axisType == 4 && nodeType < 14) {
                    nodeType = 2;
                }
                this.addPattern(nodeType, lpp);
            } else {
                if (this._rootPatterns == null) {
                    this._rootPatterns = new ArrayList();
                    this._rootPatterns.add(lpp);
                } else {
                    int position2;
                    int size = this._rootPatterns.size();
                    for (position2 = 0; position2 < size && !XSLTCHelper.noSmallerThan(lpp, this._rootPatterns.get(position2)); ++position2) {
                    }
                    this._rootPatterns.add(position2, lpp);
                }
                this.addPattern(9, lpp);
            }
        }
    }

    private void addPattern(int kernelType, Expr pattern2) {
        ArrayList<Expr> patterns;
        int oldLength = this._patternGroups.length;
        if (kernelType >= oldLength) {
            ArrayList[] newGroups = new ArrayList[kernelType * 2];
            System.arraycopy(this._patternGroups, 0, newGroups, 0, oldLength);
            this._patternGroups = newGroups;
        }
        if (kernelType == -1) {
            patterns = XSLTCHelper.getAxisForPattern(pattern2) == 4 ? (this._attribNodeGroup == null ? (this._attribNodeGroup = new ArrayList<Expr>(2)) : this._attribNodeGroup) : (this._childNodeGroup == null ? (this._childNodeGroup = new ArrayList(2)) : this._childNodeGroup);
        } else {
            ArrayList<Object> arrayList = patterns = this._patternGroups[kernelType] == null ? new ArrayList(2) : this._patternGroups[kernelType];
        }
        if (patterns.size() == 0) {
            patterns.add(pattern2);
        } else {
            boolean inserted = false;
            for (int i = 0; i < patterns.size(); ++i) {
                Expr lppToCompare = (Expr)patterns.get(i);
                if (!XSLTCHelper.noSmallerThan(pattern2, lppToCompare)) continue;
                inserted = true;
                patterns.add(i, pattern2);
                break;
            }
            if (!inserted) {
                patterns.add(pattern2);
            }
        }
    }

    private void completeTestSequences(int nodeType, List patterns) {
        if (patterns != null) {
            if (this._patternGroups[nodeType] == null) {
                this._patternGroups[nodeType] = patterns;
            } else {
                int m = patterns.size();
                for (int j = 0; j < m; ++j) {
                    this.addPattern(nodeType, (Expr)patterns.get(j));
                }
            }
        }
    }

    private void prepareTestSequences() {
        int i;
        int n2;
        List starGroup = this._patternGroups[1];
        List atStarGroup = this._patternGroups[2];
        this.completeTestSequences(3, this._childNodeGroup);
        this.completeTestSequences(1, this._childNodeGroup);
        this.completeTestSequences(1, this._idxGroup);
        this.completeTestSequences(7, this._childNodeGroup);
        this.completeTestSequences(8, this._childNodeGroup);
        this.completeTestSequences(2, this._attribNodeGroup);
        List<String> names = this._translator.getCompiler().getNamesIndex();
        if (starGroup != null || atStarGroup != null || this._childNodeGroup != null || this._attribNodeGroup != null || this._idxGroup != null) {
            n2 = this._patternGroups.length;
            for (i = 14; i < n2; ++i) {
                if (this._patternGroups[i] == null) continue;
                String name2 = names.get(i - 14);
                if (Mode.isAttributeName(name2)) {
                    this.completeTestSequences(i, atStarGroup);
                    this.completeTestSequences(i, this._attribNodeGroup);
                    continue;
                }
                this.completeTestSequences(i, starGroup);
                this.completeTestSequences(i, this._childNodeGroup);
                this.completeTestSequences(i, this._idxGroup);
            }
        }
        this._testSeq = new TestSeq[14 + names.size()];
        n2 = this._patternGroups.length;
        for (i = 0; i < n2; ++i) {
            List patterns = this._patternGroups[i];
            if (patterns == null) continue;
            TestSeq testSeq = new TestSeq(patterns, i, this);
            testSeq.reduce();
            this._testSeq[i] = testSeq;
            testSeq.findTemplates(this._neededTemplates);
        }
        if (this._childNodeGroup != null && this._childNodeGroup.size() > 0) {
            this._childNodeTestSeq = new TestSeq(this._childNodeGroup, -1, this);
            this._childNodeTestSeq.reduce();
            this._childNodeTestSeq.findTemplates(this._neededTemplates);
        }
        if (this._idxGroup != null && this._idxGroup.size() > 0) {
            this._idxTestSeq = new TestSeq(this._idxGroup, this);
            this._idxTestSeq.reduce();
            this._idxTestSeq.findTemplates(this._neededTemplates);
        }
        if (this._rootPatterns != null) {
            this._neededTemplates.put(XSLTCHelper.getTemplateForPattern(this.getRootPattern()), this);
        }
    }

    private static boolean isAttributeName(String qname2) {
        int col = qname2.lastIndexOf(58) + 1;
        return qname2.charAt(col) == '@';
    }

    public final TestSeq[] getTestSeq() {
        return this._testSeq;
    }

    public final List<Template> getTemplates() {
        return this._templates;
    }

    public final Expr getRootPattern() {
        return this._rootPatterns != null ? this._rootPatterns.get(0) : null;
    }

    public final ArrayList<Expr> getRootPatterns() {
        return this._rootPatterns;
    }

    public final TestSeq getChildNodeTestSeq() {
        this._childNodeTestSeq = null;
        return null;
    }

    private void compileTemplates() {
        LinkedHashSet<Template> templates = new LinkedHashSet<Template>();
        templates.addAll(this._namedTemplates.keySet());
        templates.addAll(this._neededTemplates.keySet());
        for (Template template : templates) {
            this._translator.compileTemplate(template);
        }
    }

    public void compileApplyTemplates() {
        this.compileTemplates();
    }

    public Hashtable getKeys() {
        return this._keys;
    }

    public int getModeNumber() {
        return this._modeNumber;
    }

    public QName getModeName() {
        return this._name;
    }
}

