/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.FILTypeConstants;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.BeginInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.JavaMethodInvocationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NewJavaObjectInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.OnceInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NamespaceHelper {
    private static final String s_getStaticNamespaceTablesFunction = "get-static-namespace-tables";
    private static final String s_namespace_id_key = "com.ibm.xltxe.rnm1.xtq.xslt.translator.namespacehelper.namespaceid";
    public static final String s_getNSPrefixCounterFunction = "get-ns-prefix-counter";
    private static Type s_namespaceTablesType = new StreamType(JavaObjectType.s_javaHashtableType);
    private List m_namespaceNodes = new ArrayList();

    public Instruction getNamespaceId(Expr node2) {
        int idValue;
        Expr lastNSNode = this.lastNamespaceNode(node2);
        Integer id2 = (Integer)lastNSNode.getProperty(s_namespace_id_key);
        if (id2 == null) {
            idValue = this.m_namespaceNodes.size();
            lastNSNode.addProperty(s_namespace_id_key, new Integer(idValue));
            this.m_namespaceNodes.add(lastNSNode);
        } else {
            idValue = id2;
        }
        return LiteralInstruction.integerLiteral(idValue);
    }

    public Function generateGetStaticNamespaceTablesFunction() {
        LetChainBuilder lcb = new LetChainBuilder();
        Instruction[] namespaceTables = new Instruction[this.m_namespaceNodes.size()];
        ArrayList<StreamInstruction> instructions = new ArrayList<StreamInstruction>();
        for (int i = 0; i < this.m_namespaceNodes.size(); ++i) {
            Expr node2 = (Expr)this.m_namespaceNodes.get(i);
            Instruction hash = lcb.bind(new OnceInstruction(new NewJavaObjectInstruction(new Instruction[0], (Type)JavaObjectType.s_javaHashtableType)));
            this.fillInHashtable(hash, node2, instructions, lcb);
            namespaceTables[i] = hash;
        }
        instructions.add(new StreamInstruction((Type)JavaObjectType.s_javaHashtableType, namespaceTables));
        Instruction body = lcb.packageUp(new BeginInstruction(instructions));
        Function function2 = new Function(s_getStaticNamespaceTablesFunction, new Binding[0], body);
        function2.setMemoizeResult(true);
        return function2;
    }

    public final Instruction callGetStaticNamespaceTablesFunction() {
        return new FunctionCallInstruction(s_getStaticNamespaceTablesFunction, new Instruction[0]);
    }

    public final Instruction getNamespaceTable(Expr node2) {
        Instruction namespaceTables = this.callGetStaticNamespaceTablesFunction();
        Instruction namespaceId = this.getNamespaceId(node2);
        StreamElementInstruction namespaceTable = new StreamElementInstruction(namespaceTables, namespaceId);
        return namespaceTable;
    }

    private Expr lastNamespaceNode(Expr node2) {
        Node parent2;
        HashMap<String, String> prefixMapping;
        Expr currentNode = node2;
        while (currentNode != null && ((prefixMapping = currentNode.getPrefixMapping()) == null || prefixMapping.size() <= 0) && (parent2 = currentNode.jjtGetParent()) instanceof Expr) {
            currentNode = (Expr)parent2;
        }
        return currentNode;
    }

    private void fillInHashtable(Instruction hash, Expr node2, List instructions, LetChainBuilder lcb) {
        HashMap<String, String> prefixMapping;
        Node parent2 = node2.jjtGetParent();
        if (parent2 != null && parent2 instanceof Expr) {
            this.fillInHashtable(hash, (Expr)parent2, instructions, lcb);
        }
        if ((prefixMapping = node2.getPrefixMapping()) != null) {
            for (Map.Entry<String, String> entry : prefixMapping.entrySet()) {
                Instruction key2 = lcb.bind(StreamInstruction.charStreamLiteral(entry.getKey()));
                Instruction value2 = lcb.bind(StreamInstruction.charStreamLiteral(entry.getValue()));
                Instruction[] params = new Instruction[]{lcb.bind(new CharStreamToJavaStringInstruction(key2)), lcb.bind(new JavaMethodInvocationInstruction("intern", lcb.bind(new CharStreamToJavaStringInstruction(value2)), new Instruction[0], (Type)JavaObjectType.s_javaStringType))};
                instructions.add(new JavaMethodInvocationInstruction("put", hash.cloneWithoutTypeInformation(), params, (Type)JavaObjectType.s_javaObjectType));
            }
        }
    }

    public Function generateGetNSPrefixCountFunction(int count2) {
        NewJavaObjectInstruction body = new NewJavaObjectInstruction(new Instruction[]{LiteralInstruction.integerLiteral(count2)}, (Type)FILTypeConstants.COUNTER);
        Function function2 = new Function(s_getNSPrefixCounterFunction, new Binding[0], body);
        function2.setMemoizeResult(true);
        return function2;
    }

    public Instruction callGetNSPrefixCountFunction() {
        return new FunctionCallInstruction(s_getNSPrefixCounterFunction, new Instruction[0]);
    }

    public Type getNamespaceTablesType() {
        return s_namespaceTablesType;
    }
}

