/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator;

import com.ibm.xltxe.rnm1.xtq.xml.types.ChoiceType;
import com.ibm.xltxe.rnm1.xtq.xml.types.NodeType;
import com.ibm.xltxe.rnm1.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.FunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.SimpleFunctionDeclaration;
import java.util.ArrayList;

public class PolymorphicFunctionDeclaration
extends FunctionDeclaration {
    private String m_functionName;
    private ArrayList m_declarationEntries = new ArrayList();
    private Type m_returnType = null;
    private String m_signature = null;
    private boolean[] m_polyArguments = null;
    private Boolean m_polyReturnType = null;

    public PolymorphicFunctionDeclaration(String functionName, int arity) {
        this.m_functionName = functionName;
        this.m_arity = arity;
    }

    public PolymorphicFunctionDeclaration(String functionName, int arity, SimpleFunctionDeclaration entry) {
        this.m_functionName = functionName;
        this.m_arity = arity;
        this.m_declarationEntries.add(entry);
    }

    public void addDeclarationEntry(SimpleFunctionDeclaration entry) {
        this.m_declarationEntries.add(entry);
    }

    @Override
    public String getFunctionName() {
        return this.m_functionName;
    }

    public int getNumberOfDeclarations() {
        return this.m_declarationEntries.size();
    }

    public SimpleFunctionDeclaration getDeclarationEntry(int index2) {
        if (index2 >= 0 && index2 < this.m_declarationEntries.size()) {
            return (SimpleFunctionDeclaration)this.m_declarationEntries.get(index2);
        }
        return null;
    }

    public boolean isPolymorphicArgument(int index2) {
        if (this.m_polyArguments == null) {
            this.m_polyArguments = new boolean[this.m_arity];
            if (this.m_declarationEntries.size() >= 2) {
                SimpleFunctionDeclaration declaration1 = this.getDeclarationEntry(0);
                SimpleFunctionDeclaration declaration2 = this.getDeclarationEntry(1);
                for (int i = 0; i < this.m_arity; ++i) {
                    this.m_polyArguments[i] = declaration1.getArgumentType(i) != declaration2.getArgumentType(i);
                }
            }
        }
        if (index2 >= 0 && index2 < this.m_arity) {
            return this.m_polyArguments[index2];
        }
        return false;
    }

    public boolean isPolymorphicReturnType() {
        if (this.m_polyReturnType == null) {
            XSequenceType rt2;
            XSequenceType rt1;
            this.m_polyReturnType = this.m_declarationEntries.size() >= 2 ? ((rt1 = this.getDeclarationEntry(0).getReturnType()).equals(rt2 = this.getDeclarationEntry(1).getReturnType()) ? Boolean.FALSE : Boolean.TRUE) : Boolean.FALSE;
        }
        return this.m_polyReturnType;
    }

    public Type getReturnType() {
        if (this.m_returnType == null) {
            int size = this.m_declarationEntries.size();
            ChoiceType resultType = new ChoiceType();
            for (int i = 0; i < size; ++i) {
                SimpleFunctionDeclaration entry = (SimpleFunctionDeclaration)this.m_declarationEntries.get(i);
                resultType.addType(entry.getReturnType());
            }
            this.m_returnType = resultType;
        }
        return this.m_returnType;
    }

    @Override
    public String getRuntimeReturnType() {
        if (this.isPolymorphicReturnType()) {
            XSequenceType firstReturnType = this.getDeclarationEntry(0).getReturnType();
            OccurrenceIndicator firstIndicator = firstReturnType.getQuantifier();
            if (firstIndicator == OccurrenceIndicator.ONE || firstIndicator == OccurrenceIndicator.ZERO_OR_ONE) {
                return "com.ibm.xltxe.rnm1.xtq.xml.datamodel.XItem";
            }
            return "com.ibm.xltxe.rnm1.xtq.xml.datamodel.XSequence";
        }
        return this.getDeclarationEntry(0).getRuntimeReturnType();
    }

    @Override
    public String getRuntimeArgumentType(int index2) {
        if (this.isPolymorphicArgument(index2)) {
            return "com.ibm.xltxe.rnm1.xtq.xml.datamodel.XSequence";
        }
        return this.getDeclarationEntry(0).getRuntimeArgumentType(index2);
    }

    @Override
    public XSequenceType getArgumentType(int index2) {
        if (this.isPolymorphicArgument(index2)) {
            return null;
        }
        return this.getDeclarationEntry(0).getArgumentType(index2);
    }

    public boolean hasNodeArguments() {
        SimpleFunctionDeclaration firstEntry = this.getDeclarationEntry(0);
        if (firstEntry != null) {
            XSequenceType argType = firstEntry.getArgumentType(0);
            return argType.getBaseType() instanceof NodeType;
        }
        return false;
    }
}

