/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator;

import com.ibm.xltxe.rnm1.xtq.Constants;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ApplyTemplates;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CallTemplate;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Choose;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CompAttrConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CompElemConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Copy;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CopyOf;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirAttributeConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirCommentConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirPIConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ForEach;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.If;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Number;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OperatorExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Otherwise;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Param;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Template;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Text;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.UseAttributeSets;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ValueOf;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableRef;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.When;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.WithParam;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.TypeConstants;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator2;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.XSLTCHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;

public class TranslatorHelper
implements Constants {
    public static boolean isTopLevelRTFNode(Expr node2) {
        Expr parent2 = (Expr)node2.jjtGetParent();
        if (parent2 == null) {
            return false;
        }
        int parentId = parent2.getId();
        return parentId == 217 || parentId == 34 || parentId == 29;
    }

    private static boolean isSimpleRTF(Expr node2) {
        int n2 = node2.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            Expr item2 = (Expr)node2.jjtGetChild(i);
            if (TranslatorHelper.isTextElement(item2, false)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAdaptiveRTF(Expr node2) {
        int n2 = node2.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            Expr item2 = (Expr)node2.jjtGetChild(i);
            if (TranslatorHelper.isTextElement(item2, true)) continue;
            return false;
        }
        return true;
    }

    private static boolean isTextElement(Expr node2, boolean doExtendedCheck) {
        if (node2 instanceof ValueOf || node2 instanceof Number || node2 instanceof Text) {
            return true;
        }
        if (node2 instanceof If) {
            return doExtendedCheck ? TranslatorHelper.isAdaptiveRTF(node2) : TranslatorHelper.isSimpleRTF(node2);
        }
        if (node2 instanceof Choose) {
            int n2 = node2.jjtGetNumChildren();
            for (int i = 0; i < n2; ++i) {
                Expr item2 = (Expr)node2.jjtGetChild(i);
                if (item2 instanceof Text || (item2 instanceof When || item2 instanceof Otherwise) && (doExtendedCheck && TranslatorHelper.isAdaptiveRTF(item2) || !doExtendedCheck && TranslatorHelper.isSimpleRTF(item2))) continue;
                return false;
            }
            return true;
        }
        return doExtendedCheck && (node2 instanceof CallTemplate || node2 instanceof ApplyTemplates);
    }

    public static String getSignature(Class clazz) {
        if (clazz.isArray()) {
            StringBuffer sb = new StringBuffer();
            Class<?> cl = clazz;
            while (cl.isArray()) {
                sb.append("[");
                cl = cl.getComponentType();
            }
            sb.append(TranslatorHelper.getSignature(cl));
            return sb.toString();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            String name2 = clazz.toString();
            ErrorMsg err = new ErrorMsg("UNKNOWN_SIG_TYPE_ERR", name2);
            throw new Error(err.toString());
        }
        return "L" + clazz.getName().replace('.', '/') + ';';
    }

    public static String getSignature(Method meth) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        Class<?>[] params = meth.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(TranslatorHelper.getSignature(params[j]));
        }
        return sb.append(')').append(TranslatorHelper.getSignature(meth.getReturnType())).toString();
    }

    public static String getSignature(Constructor cons) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        Class<?>[] params = cons.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(TranslatorHelper.getSignature(params[j]));
        }
        return sb.append(")V").toString();
    }

    public static boolean canLoadAsArrayOffsetLength(Text text2) {
        return text2.getSimpleStringValue().length() <= 21845;
    }

    public static Template getCalleeTemplate(CallTemplate node2) {
        XTQProgram stylesheet = node2.getXTQProgram();
        stylesheet = stylesheet.getTopLevelXTQProgram();
        List templates = stylesheet.getAllValidTemplates();
        int size = templates.size();
        for (int i = 0; i < size; ++i) {
            Template t = (Template)templates.get(i);
            if (t.getQName() != node2.getQName() || !t.isSimpleNamedTemplate()) continue;
            return t;
        }
        return null;
    }

    protected static boolean buildParameterList(CallTemplate callTemplate, Object[] parameters) {
        int count2 = callTemplate.jjtGetNumChildren();
        int numParams = parameters.length;
        block0: for (int i = 0; i < count2; ++i) {
            WithParam withParam;
            Node node2 = callTemplate.jjtGetChild(i);
            if (!(node2 instanceof WithParam) || (withParam = (WithParam)node2).isTunnel()) continue;
            QName name2 = withParam.getQName();
            for (int k = 0; k < numParams; ++k) {
                Object object2 = parameters[k];
                if (object2 instanceof Param && ((Param)object2).getQName() == name2) {
                    parameters[k] = withParam;
                    continue block0;
                }
                if (!(object2 instanceof WithParam) || ((WithParam)object2).getQName() != name2) continue;
                parameters[k] = withParam;
                continue block0;
            }
        }
        boolean createTempVar = false;
        for (int i = 0; i < numParams; ++i) {
            if (!(parameters[i] instanceof Param)) continue;
            Param param = (Param)parameters[i];
            Expr expr = param.getExpression();
            if (param.jjtGetNumChildren() <= 0 && (expr == null || !XSLTCHelper.hasVariableReferences(expr))) continue;
            createTempVar = true;
            break;
        }
        return createTempVar;
    }

    protected static boolean checkAttributesUnique(DirElemConstructor lre) {
        boolean hasHiddenXslAttribute = TranslatorHelper.canProduceAttributeNodes(lre, true);
        if (hasHiddenXslAttribute) {
            return false;
        }
        List attributeElements = lre.getAttributeElements();
        if (attributeElements != null) {
            int numAttrs = attributeElements.size();
            Hashtable<Object, DirAttributeConstructor> attrsTable = null;
            for (int i = 0; i < numAttrs; ++i) {
                CompAttrConstructor xslAttr;
                Expr attrName;
                Expr node2 = (Expr)attributeElements.get(i);
                if (node2 instanceof UseAttributeSets) {
                    return false;
                }
                if (!(node2 instanceof CompAttrConstructor)) continue;
                if (attrsTable == null) {
                    attrsTable = new Hashtable<Object, DirAttributeConstructor>();
                    for (int k = 0; k < i; ++k) {
                        Expr n2 = (Expr)attributeElements.get(k);
                        if (!(n2 instanceof DirAttributeConstructor)) continue;
                        DirAttributeConstructor literalAttr = (DirAttributeConstructor)n2;
                        attrsTable.put(literalAttr.getQName(), literalAttr);
                    }
                }
                if ((attrName = (xslAttr = (CompAttrConstructor)node2).getNameExpr()) instanceof Text) {
                    Text simpleAttr = (Text)attrName;
                    String name2 = simpleAttr.toString();
                    if (name2 != null && attrsTable.get(name2) != null) {
                        return false;
                    }
                    if (name2 == null) continue;
                    attrsTable.put(name2, xslAttr);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private static boolean canProduceAttributeNodes(Expr node2, boolean ignoreXslAttribute) {
        int size = node2.jjtGetNumChildren();
        for (int i = 0; i < size; ++i) {
            Expr child2 = (Expr)node2.jjtGetChild(i);
            if (child2 instanceof Text) {
                Text text2 = (Text)child2;
                if (text2.isIgnore()) continue;
                return false;
            }
            if (child2 instanceof DirElemConstructor || child2 instanceof ValueOf || child2 instanceof CompElemConstructor || child2 instanceof DirCommentConstructor || child2 instanceof Number || child2 instanceof DirPIConstructor) {
                return false;
            }
            if (child2 instanceof CompAttrConstructor) {
                if (ignoreXslAttribute) continue;
                return true;
            }
            if (child2 instanceof CallTemplate || child2 instanceof ApplyTemplates || child2 instanceof Copy || child2 instanceof CopyOf) {
                return true;
            }
            if ((child2 instanceof If || child2 instanceof ForEach) && TranslatorHelper.canProduceAttributeNodes(child2, false)) {
                return true;
            }
            if (!(child2 instanceof Choose)) continue;
            int num = child2.jjtGetNumChildren();
            for (int k = 0; k < num; ++k) {
                Expr chooseChild = (Expr)child2.jjtGetChild(k);
                if (!(chooseChild instanceof When) && !(chooseChild instanceof Otherwise) || !TranslatorHelper.canProduceAttributeNodes(chooseChild, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasBadChars(String value2) {
        for (char ch : value2.toCharArray()) {
            if (ch >= ' ' && '~' >= ch && ch != '<' && ch != '>' && ch != '&' && ch != '\"') continue;
            return true;
        }
        return false;
    }

    public static Type getRealType(Expr expr) {
        Type castType = ASTDecorator2.getExpressionCastType(expr);
        if (castType != null) {
            return castType;
        }
        return ASTDecorator2.getType(expr);
    }

    public static boolean isNodeValueTest(Expr predicate2) {
        if (!ASTDecorator.getCanOptimize(predicate2)) {
            return false;
        }
        return XSLTCHelper.getStepForPredicate(predicate2) != null && TranslatorHelper.getCompareValue(predicate2) != null;
    }

    public static Expr getCompareValue(Expr predicate2) {
        Expr value2 = ASTDecorator.getCompareValue(predicate2);
        if (value2 != null) {
            return value2;
        }
        if (predicate2 == null) {
            return null;
        }
        if (predicate2.getId() == 59) {
            OperatorExpr op2 = (OperatorExpr)predicate2;
            if (op2.getOperatorType() != 13 && op2.getOperatorType() != 14) {
                return null;
            }
            Expr left = op2.getOperand(0);
            Expr right = op2.getOperand(1);
            Type tleft = TranslatorHelper.getRealType(left);
            Type tright = TranslatorHelper.getRealType(right);
            if (tleft == TypeConstants.STRING && !XSLTCHelper.isSimpleStep(left)) {
                value2 = left;
            } else if (left instanceof VariableRef) {
                value2 = left;
            }
            if (value2 != null) {
                ASTDecorator.setCompareValue(predicate2, value2);
                return value2;
            }
            if (tright == TypeConstants.STRING && !XSLTCHelper.isSimpleStep(right)) {
                value2 = right;
            } else if (right instanceof VariableRef) {
                value2 = right;
            }
            if (value2 != null) {
                ASTDecorator.setCompareValue(predicate2, value2);
                return value2;
            }
        }
        return null;
    }
}

