/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator;

import com.ibm.xltxe.rnm1.xtq.Constants;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Whitespace;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class WhitespaceHelper
implements Constants {
    public static final int RULE_NONE = 0;
    public static final int RULE_ELEMENT = 1;
    public static final int RULE_NAMESPACE = 2;
    public static final int RULE_ALL = 3;

    public static List getRules(Whitespace node2) {
        ArrayList<WhitespaceRule> rules = new ArrayList<WhitespaceRule>();
        StringTokenizer list = Util.whitespaceTokenize(node2.getElementList());
        while (list.hasMoreElements()) {
            rules.add(new WhitespaceRule(node2.getAction(), list.nextToken(), node2.getImportPrecedence().getPrecedence()));
        }
        return rules;
    }

    public static final class WhitespaceRule {
        private final int _action;
        private String _namespace;
        private String _element;
        private int _type;
        private int _priority;

        public WhitespaceRule(int action, String namespace2, String element2, int type2, int priority) {
            this._action = action;
            this._namespace = namespace2;
            this._element = element2;
            this._type = type2;
            this._priority = priority;
        }

        public String getGeneratedConstructor() {
            StringBuffer ans = new StringBuffer();
            ans.append("new com.ibm.xltxe.rnm1.xtq.xslt.translator.WhitespaceHelper.WhitespaceRule(");
            ans.append(this.getAction());
            ans.append(", \"");
            ans.append(this.getNamespace());
            ans.append("\", \"");
            ans.append(this.getElement());
            ans.append("\", ");
            ans.append(this.getStrength());
            ans.append(", ");
            ans.append(this.getPriority());
            ans.append(")");
            return ans.toString();
        }

        public WhitespaceRule(int action, String element2, int precedence) {
            this._action = action;
            int colon = element2.lastIndexOf(58);
            if (colon >= 0) {
                this._namespace = element2.substring(0, colon);
                this._element = element2.substring(colon + 1, element2.length());
            } else {
                this._namespace = "";
                this._element = element2;
            }
            this._priority = precedence << 2;
            if (this._element.equals("*")) {
                if (this._namespace == "") {
                    this._type = 3;
                } else {
                    this._type = 2;
                    ++this._priority;
                }
            } else {
                this._type = 1;
                this._priority += 2;
            }
        }

        public boolean matches(String namespace2, String localName2) {
            if (this._type == 3) {
                return true;
            }
            if (this._type == 2) {
                return this._namespace.equals(namespace2);
            }
            if (this._type == 1) {
                if (this._namespace.equals("*")) {
                    return this._element.equals(localName2);
                }
                return this._namespace.equals(namespace2) && this._element.equals(localName2);
            }
            return false;
        }

        public int compareTo(WhitespaceRule other2) {
            return this._priority < other2._priority ? -1 : (this._priority > other2._priority ? 1 : 0);
        }

        public int getAction() {
            return this._action;
        }

        public int getStrength() {
            return this._type;
        }

        public int getPriority() {
            return this._priority;
        }

        public String getElement() {
            return this._element;
        }

        public String getNamespace() {
            return this._namespace;
        }
    }
}

