/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator;

import com.ibm.xltxe.rnm1.xtq.ast.XPath20Exception;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ContextItemExprImpl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionCall;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.KindTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.NameTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.NodeTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Number;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OperatorExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.PathExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Sort;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.StepExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Template;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VarDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableBase;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableRef;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.factories.ExpressionFactoryImpl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.xml.types.NodeType;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.TypeConstants;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ObjectFactory;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2.Function2TypeChecker;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;

public class XSLTCHelper
implements XPathTreeConstants {
    public static final int STEP_PATTERN_NO_CONTEXT = 0;
    public static final int STEP_PATTERN_SIMPLE_CONTEXT = 1;
    public static final int STEP_PATTERN_GENERAL_CONTEXT = 2;
    private static final String TRANSLET_URI = "http://xml.apache.org/xalan/xsltc";
    private static final short AXIS_MISMATCH = -1;
    private static final char DASH = '-';
    private static final HashMap<XSTypeDefinition, Type> xsTypesToxtqTypes = new HashMap();
    private static final HashMap<Type, XSTypeDefinition> xtqTypesToxsTypes;

    public static String getNormalizedFunctionName(String name2) {
        if (name2.indexOf(45) > 0) {
            StringBuffer buff = new StringBuffer("");
            for (int i = 0; i < name2.length(); ++i) {
                if (i > 0 && name2.charAt(i - 1) == '-') {
                    buff.append(Character.toUpperCase(name2.charAt(i)));
                    continue;
                }
                if (name2.charAt(i) == '-') continue;
                buff.append(name2.charAt(i));
            }
            return buff.toString();
        }
        return name2;
    }

    public static ArrayList findMethods(Class clazz, String methodName, int numArgs) {
        return XSLTCHelper.findMethods(clazz, methodName, numArgs, null);
    }

    public static ArrayList findMethods(Class clazz, String methodName, int numArgs, Boolean getStatic) {
        ArrayList<Method> result2 = null;
        if (clazz != null) {
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                int mods = methods[i].getModifiers();
                if (!Modifier.isPublic(mods) || !methods[i].getName().equals(methodName) || methods[i].getParameterTypes().length != numArgs || getStatic != null && getStatic != Modifier.isStatic(mods)) continue;
                if (result2 == null) {
                    result2 = new ArrayList<Method>();
                }
                result2.add(methods[i]);
            }
        }
        return result2;
    }

    public static ArrayList findConstructors(Class clazz, int numArgs) {
        ArrayList result2 = null;
        Constructor<?>[] constructors = clazz.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            int mods = constructors[i].getModifiers();
            if (!Modifier.isPublic(mods) || constructors[i].getParameterTypes().length != numArgs) continue;
            if (result2 == null) {
                result2 = new ArrayList();
            }
            result2.add(constructors[i]);
        }
        return result2;
    }

    public static XTQProgram getStylesheet(SimpleNode node2) {
        for (Node parent2 = node2; parent2 != null; parent2 = parent2.jjtGetParent()) {
            if (!(parent2 instanceof XTQProgram)) continue;
            return (XTQProgram)parent2;
        }
        return null;
    }

    public static VariableBase findAncestorVariable(Expr node2) {
        Node parent2 = node2.jjtGetParent();
        return XSLTCHelper.findAncestorVariable(parent2);
    }

    private static VariableBase findAncestorVariable(Node node2) {
        Node varNode = null;
        while (node2 != null) {
            if (node2 instanceof VariableBase) {
                varNode = node2;
            }
            node2 = node2.jjtGetParent();
        }
        if (varNode != null) {
            return (VariableBase)varNode;
        }
        return null;
    }

    public static boolean isPredicate(Expr expr) {
        Node parent2 = expr.jjtGetParent();
        return parent2 instanceof StepExpr && parent2.jjtGetChild(0) != expr;
    }

    public static boolean isClosure(Node node2) {
        return node2 instanceof Number || node2 instanceof Sort || node2 instanceof Expr && XSLTCHelper.isPredicate((Expr)node2);
    }

    public static void addVariableToClosure(SimpleNode closure, VariableRef variableRef) {
        if (closure instanceof Number) {
            Number number2 = (Number)closure;
            ArrayList<VariableRef> closureVars = ASTDecorator.getClosureVars(number2);
            if (closureVars == null) {
                closureVars = new ArrayList<VariableRef>();
                ASTDecorator.setClosureVars(number2, closureVars);
            }
            if (!closureVars.contains(variableRef)) {
                closureVars.add(variableRef);
            }
        } else if (closure instanceof Sort) {
            Sort sort2 = (Sort)closure;
            ArrayList<VariableRef> closureVars = ASTDecorator.getClosureVars(sort2);
            if (closureVars == null) {
                closureVars = new ArrayList<VariableRef>();
                ASTDecorator.setClosureVars(sort2, closureVars);
            }
            if (!closureVars.contains(variableRef)) {
                closureVars.add(variableRef);
                sort2.setSortRecordFactoryNeeded(true);
            }
        } else if (closure instanceof Expr && XSLTCHelper.isPredicate((Expr)closure)) {
            Expr predicate2 = (Expr)closure;
            ArrayList<VariableRef> closureVars = ASTDecorator.getClosureVars(predicate2);
            if (closureVars == null) {
                closureVars = new ArrayList<VariableRef>();
                ASTDecorator.setClosureVars(predicate2, closureVars);
            }
            if (!closureVars.contains(variableRef)) {
                closureVars.add(variableRef);
                SimpleNode parentClosure = XSLTCHelper.getParentClosure(closure);
                if (parentClosure != null) {
                    XSLTCHelper.addVariableToClosure(parentClosure, variableRef);
                }
            }
        }
    }

    public static String getClosureInnerClassName(SimpleNode closure) {
        if (closure instanceof Number) {
            return ASTDecorator.getInnerClassName((Number)closure);
        }
        if (closure instanceof Sort) {
            return ASTDecorator.getInnerClassName((Sort)closure);
        }
        if (closure instanceof Expr) {
            return ASTDecorator.getInnerClassName((Expr)closure);
        }
        return null;
    }

    public static SimpleNode getParentClosure(SimpleNode closure) {
        if (closure instanceof Expr && XSLTCHelper.isPredicate((Expr)closure)) {
            Node node2 = closure.jjtGetParent();
            do {
                if (XSLTCHelper.isClosure(node2)) {
                    return (SimpleNode)node2;
                }
                if (!(node2 instanceof TopLevelDecl)) continue;
                return null;
            } while ((node2 = node2.jjtGetParent()) != null);
            return null;
        }
        return null;
    }

    public static Boolean evaluateElementAvailableAtCompileTime(FunctionCall function2, XPathCompiler compiler) {
        String qname2 = function2.getOperand(0).getSimpleStringValue();
        int index2 = qname2.indexOf(58);
        String localName2 = index2 > 0 ? qname2.substring(index2 + 1) : qname2;
        String prefix2 = index2 > 0 ? qname2.substring(0, index2) : "";
        XSLTParser parser = compiler.getParser();
        XStaticContext context2 = parser.getStaticContext();
        context2.setCurrentNode(function2);
        String namespace2 = context2.getNamespaceURI(prefix2);
        return parser.elementSupported(namespace2, localName2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean isExternalMethods(String namespace2, String localName2, int arity, HashMap extTable) {
        String className = XSLTCHelper.getClassNameFromUri(namespace2, extTable);
        String methodName = null;
        int lastDotIndex = localName2.lastIndexOf(46);
        if (lastDotIndex > 0) {
            methodName = localName2.substring(lastDotIndex + 1);
            className = className != null && className.length() > 0 ? className + "." + localName2.substring(0, lastDotIndex) : localName2.substring(0, lastDotIndex);
        } else {
            methodName = localName2;
        }
        if (className == null || methodName == null) {
            return false;
        }
        if (methodName.indexOf(45) > 0) {
            methodName = XSLTCHelper.getNormalizedFunctionName(methodName);
        }
        try {
            Class clazz = ObjectFactory.findProviderClass(className, ObjectFactory.findClassLoader(), true);
            if (clazz == null) {
                return false;
            }
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                int mods = methods[i].getModifiers();
                if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !methods[i].getName().equals(methodName)) continue;
                int argNum = methods[i].getParameterTypes().length;
                if (arity == -1) {
                    return true;
                }
                if (argNum != arity) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return false;
    }

    public static Axis astAxis2XCIAxis(int xpathAxis) {
        switch (xpathAxis) {
            case 7: {
                return Axis.ANCESTOR;
            }
            case 13: {
                return Axis.ANCESTORORSELF;
            }
            case 4: {
                return Axis.ATTRIBUTE;
            }
            case 1: {
                return Axis.CHILD;
            }
            case 2: {
                return Axis.DESCENDANT;
            }
            case 6: {
                return Axis.DESCENDANTORSELF;
            }
            case 10: {
                return Axis.FOLLOWING;
            }
            case 8: {
                return Axis.FOLLOWINGSIBLING;
            }
            case 12: {
                return Axis.NAMESPACE;
            }
            case 3: {
                return Axis.PARENT;
            }
            case 11: {
                return Axis.PRECEDING;
            }
            case 9: {
                return Axis.PRECEDINGSIBLING;
            }
            case 5: {
                return Axis.SELF;
            }
        }
        assert (false) : "UNKNOWN AXIS!!!";
        return Axis.EMPTYSET;
    }

    public static int xpathOpType2XSLTCOpType(int xpathOpType) {
        switch (xpathOpType) {
            case 13: {
                return 0;
            }
            case 14: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 18: {
                return 4;
            }
            case 15: {
                return 3;
            }
            case 16: {
                return 5;
            }
        }
        throw new StaticError("ERR_SYSTEM", "Invalid xpath operator type: " + String.valueOf(xpathOpType));
    }

    public static StepExpr getStepForPredicate(Expr predicate2) {
        if (predicate2 == null) {
            return null;
        }
        if (predicate2.getId() == 59) {
            PathExpr pathExpr;
            OperatorExpr op2 = (OperatorExpr)predicate2;
            if (op2.getOperatorType() != 13 && op2.getOperatorType() != 14) {
                return null;
            }
            Expr left = op2.getOperand(0);
            Expr right = op2.getOperand(1);
            if (left.getId() == 85) {
                return (StepExpr)left;
            }
            if (left.getId() == 82 && (pathExpr = (PathExpr)left).getOperandCount() == 1 && pathExpr.getOperand(0) instanceof StepExpr) {
                return (StepExpr)pathExpr.getOperand(0);
            }
            if (right.getId() == 85) {
                return (StepExpr)right;
            }
            if (right.getId() == 82 && (pathExpr = (PathExpr)right).getOperandCount() == 1 && pathExpr.getOperand(0) instanceof StepExpr) {
                return (StepExpr)pathExpr.getOperand(0);
            }
        }
        return null;
    }

    protected static boolean isLastCall(Expr predicate2) {
        if (predicate2 instanceof FunctionCall) {
            FunctionCall func = (FunctionCall)predicate2;
            QName qname2 = func.getFunctionQName();
            return qname2.getNamespaceURI().equals(func.getBuiltInNamespaceFunc()) && qname2.getLocalPart().equals("last");
        }
        return false;
    }

    public static boolean isKeyCall(Expr expr) {
        if (expr instanceof FunctionCall) {
            FunctionCall func = (FunctionCall)expr;
            QName qname2 = func.getFunctionQName();
            return qname2.getNamespaceURI().equals(func.getBuiltInNamespaceFunc()) && qname2.getLocalPart().equals("key");
        }
        return false;
    }

    public static boolean isPattern(Expr expr) {
        int id2 = expr.getId();
        return id2 == 186 || id2 == 187 || id2 == 188;
    }

    public static boolean isProcessingInstructionPattern(StepExpr stepPattern) {
        try {
            NodeTest nodetest = stepPattern.getNodeTest();
            return nodetest.isKindTest() && ((KindTest)nodetest).getPITarget() != null;
        }
        catch (XPath20Exception e) {
            return false;
        }
    }

    public static boolean hasArgumentPattern(StepExpr stepPattern) {
        try {
            NodeTest nodetest = stepPattern.getNodeTest();
            if (nodetest.isKindTest()) {
                KindTest aKindTest = (KindTest)nodetest;
                return aKindTest.getNodeName() != null || aKindTest.getElementTest() != null || aKindTest.getTypeName() != null;
            }
            return false;
        }
        catch (XPath20Exception e) {
            return false;
        }
    }

    public static boolean isFilterStep(Expr expr) {
        return expr instanceof StepExpr && ((StepExpr)expr).isFilterStep();
    }

    public static void dontOptimize(Expr predicate2) {
        ASTDecorator.setCanOptimize(predicate2, false);
    }

    public static boolean hasPositionCall(Expr expr) {
        switch (expr.getId()) {
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                OperatorExpr op2 = (OperatorExpr)expr;
                return XSLTCHelper.hasPositionCall(op2.getOperand(0)) || XSLTCHelper.hasPositionCall(op2.getOperand(1));
            }
            case 69: {
                OperatorExpr tmp = (OperatorExpr)expr;
                return XSLTCHelper.hasPositionCall(tmp.getOperand(0));
            }
            case 105: {
                FunctionCall func = (FunctionCall)expr;
                QName qname2 = func.getFunctionQName();
                String ns = qname2.getNamespaceURI();
                String localName2 = qname2.getLocalPart();
                if (ns != null && ns.equals(func.getBuiltInNamespaceFunc())) {
                    return localName2.equals("last") || localName2.equals("position");
                }
                return true;
            }
        }
        return false;
    }

    public static boolean hasLastCall(Expr expr) {
        switch (expr.getId()) {
            case 59: 
            case 61: 
            case 62: {
                OperatorExpr op2 = (OperatorExpr)expr;
                return XSLTCHelper.hasLastCall(op2.getOperand(0)) || XSLTCHelper.hasLastCall(op2.getOperand(1));
            }
            case 105: {
                return XSLTCHelper.isLastCall(expr);
            }
        }
        return false;
    }

    public static boolean hasParentPattern(Expr expr) {
        Node parent2 = expr.jjtGetParent();
        if (parent2 instanceof PathExpr) {
            int startIndex;
            PathExpr pathExpr = (PathExpr)parent2;
            int n2 = startIndex = pathExpr.isAbsolute() ? 1 : 0;
            if (pathExpr.getOperandCount() - startIndex > 1) {
                return true;
            }
        } else if (parent2 instanceof OperatorExpr && ((OperatorExpr)parent2).getOperatorType() == 1) {
            return true;
        }
        return false;
    }

    public static boolean isWildcardNodeTest(StepExpr step2) {
        try {
            NameTest nameTest;
            NodeTest nodetest = step2.getNodeTest();
            if (nodetest instanceof NameTest && (nameTest = (NameTest)nodetest).getNameTestType() == 0 && nameTest.getQName() == null) {
                return true;
            }
        }
        catch (XPath20Exception e) {
            return false;
        }
        return false;
    }

    public static boolean isAbbreviatedDot(StepExpr step2) {
        try {
            if (step2.isFilterStep()) {
                return step2.getPrimaryExpr() instanceof ContextItemExprImpl;
            }
            return step2.getAxisType() == 5 && step2.getStepNodeType() == -1;
        }
        catch (XPath20Exception e) {
            return false;
        }
    }

    public static boolean isNamedFunction(FunctionCall function2, String namespace2, String localName2) {
        QName qname2 = function2.getFunctionQName();
        String ns = qname2.getNamespaceURI();
        String lname = qname2.getLocalPart();
        if (namespace2 != null) {
            return namespace2.equals(ns) && lname.equals(localName2);
        }
        return (ns == null || ns.length() == 0) && lname.equals(localName2);
    }

    public static boolean isWildcardPattern(Expr pattern2) {
        if (pattern2.getId() == 188) {
            StepExpr stepPattern = (StepExpr)pattern2;
            if (XSLTCHelper.isProcessingInstructionPattern(stepPattern)) {
                return false;
            }
            if (XSLTCHelper.hasArgumentPattern(stepPattern)) {
                return false;
            }
            return ASTDecorator.isPatternReduced(pattern2) && stepPattern.getPredicateCount() == 0;
        }
        if (pattern2.getId() == 187) {
            PathExpr pathExpr = (PathExpr)pattern2;
            return pathExpr.isAbsolute() && pathExpr.getOperandCount() == 0;
        }
        return false;
    }

    public static boolean isSimpleStep(Expr expr) {
        Expr firstChild;
        PathExpr pathExpr;
        StepExpr step2 = null;
        if (expr instanceof StepExpr) {
            step2 = (StepExpr)expr;
        } else if (expr instanceof PathExpr && !(pathExpr = (PathExpr)expr).isAbsolute() && pathExpr.getOperandCount() == 1 && (firstChild = pathExpr.getOperand(0)) instanceof StepExpr) {
            step2 = (StepExpr)firstChild;
        }
        return step2 != null ? !step2.isFilterStep() || XSLTCHelper.isAbbreviatedDot(step2) : false;
    }

    protected static String getNextFieldNameForStepPattern(XPathCompiler compiler) {
        return "__step_pattern_iter_" + compiler.nextStepPatternSerial();
    }

    public static int analyzeContextCasesForStepPattern(StepExpr stepPattern) {
        boolean noContext = true;
        int n2 = stepPattern.getPredicateCount();
        for (int i = 0; i < n2 && noContext; ++i) {
            Expr pred = stepPattern.getPredicateAt(i);
            if (!XSLTCHelper.hasPositionCall(pred) && !ASTDecorator.isNthPositionFilter(pred)) continue;
            noContext = false;
        }
        if (noContext) {
            return 0;
        }
        if (n2 == 1) {
            return 1;
        }
        return 2;
    }

    public static boolean isUnionPattern(Expr expr) {
        return expr.getId() == 186 && expr instanceof OperatorExpr && ((OperatorExpr)expr).getOperatorType() == 1;
    }

    public static StepExpr getKernelPattern(Expr pattern2) {
        Expr lastChild;
        OperatorExpr pathPattern;
        int n2;
        int id2 = pattern2.getId();
        if (id2 == 188) {
            StepExpr stepPattern = (StepExpr)pattern2;
            return stepPattern;
        }
        if (id2 == 187) {
            PathExpr pathPattern2 = (PathExpr)pattern2;
            int n3 = pathPattern2.getOperandCount();
            if (n3 > 0) {
                Expr lastChild2 = pathPattern2.getOperand(n3 - 1);
                if (lastChild2.getId() == 188) {
                    return (StepExpr)lastChild2;
                }
                return XSLTCHelper.getKernelPattern(lastChild2);
            }
        } else if (id2 == 84 && (n2 = (pathPattern = (OperatorExpr)pattern2).getOperandCount()) > 0 && (lastChild = pathPattern.getOperand(n2 - 1)).getId() == 188) {
            return (StepExpr)lastChild;
        }
        return null;
    }

    public static int getAxisForPattern(Expr pattern2) {
        StepExpr kernelPattern = XSLTCHelper.getKernelPattern(pattern2);
        try {
            if (kernelPattern != null) {
                return kernelPattern.getAxisType();
            }
            return 1;
        }
        catch (XPath20Exception e) {
            return 1;
        }
    }

    public static Template getTemplateForPattern(Expr pattern2) {
        for (Node parent2 = pattern2.jjtGetParent(); parent2 != null; parent2 = parent2.jjtGetParent()) {
            if (!(parent2 instanceof Template)) continue;
            return (Template)parent2;
        }
        return null;
    }

    public static boolean noSmallerThan(Expr leftPattern, Expr rightPattern) {
        Expr.ImportPrecedence rightImportPrecedence;
        Template lt2 = XSLTCHelper.getTemplateForPattern(leftPattern);
        Template rt = XSLTCHelper.getTemplateForPattern(rightPattern);
        Expr.ImportPrecedence leftImportPrecedence = lt2.getImportPrecedence();
        if (leftImportPrecedence.hasHigherPrecedenceThan(rightImportPrecedence = rt.getImportPrecedence())) {
            return true;
        }
        if (leftImportPrecedence.hasSamePrecedenceAs(rightImportPrecedence)) {
            BigDecimal rightPriority;
            BigDecimal leftPriority = ASTDecorator.getPatternPriority(leftPattern);
            if (leftPriority.compareTo(rightPriority = ASTDecorator.getPatternPriority(rightPattern)) == 1) {
                return true;
            }
            if (leftPriority.compareTo(rightPriority) == 0 && lt2.getPosition() > rt.getPosition()) {
                return true;
            }
        }
        return false;
    }

    public static void reduceKernelPattern(Expr pattern2) {
        PathExpr pathPattern;
        int n2;
        if (pattern2.getId() == 188) {
            ASTDecorator.setPatternReduced(pattern2, true);
        } else if (pattern2.getId() == 187 && (n2 = (pathPattern = (PathExpr)pattern2).getOperandCount()) > 0) {
            Expr lastChild = pathPattern.getOperand(n2 - 1);
            ASTDecorator.setPatternReduced(lastChild, true);
        }
    }

    public static int findNodeTypeForStep(StepExpr step2, XPathCompiler compiler) {
        NodeTest nodetest = null;
        short axis = 0;
        try {
            nodetest = step2.getNodeTest();
            axis = step2.getAxisType();
        }
        catch (XPath20Exception e) {
            // empty catch block
        }
        XSLTParser parser = compiler.getParser();
        XStaticContext context2 = parser.getStaticContext();
        if (nodetest.isNameTest()) {
            NameTest nameTest = (NameTest)nodetest;
            QName qname2 = nameTest.getQName();
            String namespace2 = null;
            String localName2 = null;
            String prefix2 = null;
            if (qname2 != null) {
                localName2 = qname2.getLocalPart();
                prefix2 = qname2.getPrefix();
                namespace2 = qname2.getNamespaceURI();
            } else {
                short type2 = nameTest.getNameTestType();
                if (type2 == 0) {
                    if (axis == 12) {
                        return -1;
                    }
                    if (axis == 4) {
                        return 2;
                    }
                    return 1;
                }
                if (type2 == 1) {
                    prefix2 = nameTest.getNCName();
                    namespace2 = context2.getNamespaceURI(prefix2);
                    localName2 = "*";
                    if (axis != 12) {
                        int id2 = step2.getId();
                        if (id2 == 188 && step2.getPredicateCount() == 0) {
                            ASTDecorator.setPatternPriority(step2, new BigDecimal("-0.25"));
                        } else if (id2 == 85) {
                            XSLTCHelper.nameTestRewrite(step2, compiler.getParser(), false);
                            if (axis == 4) {
                                return 2;
                            }
                            return 1;
                        }
                    }
                } else if (type2 == 2) {
                    localName2 = nameTest.getNCName();
                }
            }
            if (axis == 12) {
                if (qname2 != null) {
                    QName newName = new QName("", localName2, "xmlns");
                    return compiler.registerNamespaceDecl(newName);
                }
                return -1;
            }
            QName newName = parser.getQName(namespace2, prefix2, localName2);
            if (axis == 4) {
                return compiler.registerAttribute(newName);
            }
            return compiler.registerElement(newName);
        }
        KindTest kindTest = (KindTest)nodetest;
        short type3 = kindTest.getKindTestType();
        switch (type3) {
            case 0: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return -1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 9;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
        }
        return -1;
    }

    public static boolean hasVariableReferences(Expr expr) {
        if (expr instanceof VariableRef) {
            return true;
        }
        if (expr instanceof OperatorExpr) {
            return XSLTCHelper.hasVariableReferencesForOperator((OperatorExpr)expr);
        }
        if (expr instanceof StepExpr) {
            return XSLTCHelper.hasVariableReferencesForStep((StepExpr)expr);
        }
        return false;
    }

    private static boolean hasVariableReferencesForStep(StepExpr step2) {
        if (step2.isFilterStep()) {
            Expr primary = null;
            try {
                primary = step2.getPrimaryExpr();
            }
            catch (XPath20Exception e) {
                return false;
            }
            if (XSLTCHelper.hasVariableReferences(primary)) {
                return true;
            }
        }
        int numPredicates = step2.getPredicateCount();
        for (int i = 0; i < numPredicates; ++i) {
            Expr pred = step2.getPredicateAt(i);
            if (!XSLTCHelper.hasVariableReferences(pred)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasVariableReferencesForOperator(OperatorExpr op2) {
        int numOps = op2.getOperandCount();
        for (int i = 0; i < numOps; ++i) {
            Expr arg2 = op2.getOperand(i);
            if (!XSLTCHelper.hasVariableReferences(arg2)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkOrderNodes(PathExpr pathExpr) {
        int startIndex;
        int n2 = pathExpr.getOperandCount();
        int n3 = startIndex = pathExpr.isAbsolute() ? 1 : 0;
        if (n2 > startIndex + 1) {
            return XSLTCHelper.getCombinedAxis(pathExpr) == -1;
        }
        return false;
    }

    public static short getCombinedAxis(Expr expr) {
        if (expr instanceof StepExpr) {
            return XSLTCHelper.getAxisForStep((StepExpr)expr);
        }
        if (expr instanceof ContextItemExprImpl) {
            return 5;
        }
        if (expr instanceof VariableRef) {
            return XSLTCHelper.getAxisForVariable((VariableRef)expr);
        }
        if (expr instanceof FunctionCall) {
            return XSLTCHelper.getAxisForFunction((FunctionCall)expr);
        }
        if (expr instanceof PathExpr) {
            int startIndex;
            PathExpr pathExpr = (PathExpr)expr;
            int elementCount = pathExpr.getOperandCount();
            int n2 = startIndex = pathExpr.isAbsolute() ? 1 : 0;
            if (elementCount == startIndex) {
                return 5;
            }
            if (elementCount == startIndex + 1) {
                return XSLTCHelper.getCombinedAxis(pathExpr.getOperand(startIndex));
            }
            short leftAxis = XSLTCHelper.getCombinedAxis(pathExpr.getOperand(startIndex));
            short rightAxis = XSLTCHelper.getCombinedAxis(pathExpr.getOperand(startIndex + 1));
            short combinedAxis = XSLTCHelper.getCombinedAxis(leftAxis, rightAxis);
            for (int i = startIndex + 2; i < elementCount; ++i) {
                if (combinedAxis == -1) {
                    return -1;
                }
                rightAxis = XSLTCHelper.getCombinedAxis(pathExpr.getOperand(i));
                combinedAxis = XSLTCHelper.getCombinedAxis(combinedAxis, rightAxis);
            }
            return combinedAxis;
        }
        return -1;
    }

    public static short getAxisForVariable(VariableRef varRef) {
        VariableBase var = ASTDecorator.getVariable(varRef);
        if (var instanceof VarDecl) {
            Expr select2 = var.getExpression();
            if (select2 != null) {
                return XSLTCHelper.getCombinedAxis(select2);
            }
            return -1;
        }
        return -1;
    }

    public static short getAxisForFunction(FunctionCall function2) {
        QName qname2 = function2.getFunctionQName();
        String localName2 = qname2.getLocalPart();
        String namespace2 = qname2.getNamespaceURI();
        if (namespace2 != null && namespace2.equals(function2.getBuiltInNamespaceFunc()) && (localName2.equals("document") || localName2.equals("current"))) {
            return 5;
        }
        return -1;
    }

    public static short getAxisForStep(StepExpr step2) {
        try {
            if (step2.isFilterStep()) {
                Expr primary = step2.getPrimaryExpr();
                if (primary instanceof VariableRef) {
                    return XSLTCHelper.getAxisForVariable((VariableRef)primary);
                }
                if (primary instanceof FunctionCall) {
                    return XSLTCHelper.getAxisForFunction((FunctionCall)primary);
                }
                if (primary instanceof ContextItemExprImpl) {
                    return 5;
                }
                return -1;
            }
            return step2.getAxisType();
        }
        catch (XPath20Exception e) {
            return -1;
        }
    }

    public static short getCombinedAxis(short leftAxis, short rightAxis) {
        if (leftAxis == -1 || rightAxis == -1) {
            return -1;
        }
        if (rightAxis == 4 || rightAxis == 12) {
            return rightAxis;
        }
        if (rightAxis == 5) {
            return leftAxis;
        }
        if (leftAxis == 8 || leftAxis == 9) {
            if (rightAxis == 1) {
                return leftAxis;
            }
            if (rightAxis == 2 || rightAxis == 6) {
                return rightAxis;
            }
            return -1;
        }
        if (leftAxis == 5 || leftAxis == 3) {
            return rightAxis;
        }
        if (leftAxis == 1) {
            if (rightAxis == 1 || rightAxis == 2 || rightAxis == 6) {
                return rightAxis;
            }
            return -1;
        }
        return -1;
    }

    public static void flattenUnionExpression(OperatorExpr unionExpr, List components) {
        for (int i = 0; i < 2; ++i) {
            Expr child2 = unionExpr.getOperand(i);
            if (child2.getId() == 63) {
                XSLTCHelper.flattenUnionExpression((OperatorExpr)child2, components);
                continue;
            }
            components.add(child2);
        }
    }

    public static FunctionDecl getStylesheetFunctionCall(FunctionCall function2, XSLTParser parser) {
        QName funcName = XSLTCHelper.getFunctionQName(function2, parser);
        int arity = function2.getOperandCount();
        return parser.getStaticContext().lookupStylesheetFunction(funcName, arity);
    }

    public static boolean isStylesheetFunctionCall(FunctionCall function2, XSLTParser parser) {
        FunctionDecl func = XSLTCHelper.getStylesheetFunctionCall(function2, parser);
        return func != null && !func.isExternal();
    }

    public static boolean isExternalFunctionCall(FunctionCall function2, XSLTParser parser) {
        FunctionDecl func = XSLTCHelper.getStylesheetFunctionCall(function2, parser);
        return func != null && func.isExternal();
    }

    public static boolean isStylesheetFunctionCallWithoutArity(String localName2, String namespace2, String prefix2, XPathCompiler compiler) {
        XSLTParser parser = compiler.getParser();
        QName funcName = parser.getQName(namespace2, prefix2, localName2);
        return parser.getExpressionFactory().getStaticContext().stylesheetFunctionAvailable(funcName);
    }

    public static boolean isExtFunction(FunctionDecl function2, XPathCompiler compiler, HashMap extTable) {
        QName qname2 = function2.getQName();
        String namespace2 = qname2.getNamespaceURI();
        if (namespace2 != null && namespace2.length() > 0 && !namespace2.equals(TRANSLET_URI)) {
            int nArgs;
            ArrayList methods;
            String localName2 = qname2.getLocalPart();
            String className = XSLTCHelper.getClassNameFromUri(namespace2, extTable);
            Class clazz = null;
            int pos = localName2.lastIndexOf(46);
            if (pos > 0) {
                className = className != null && className.length() > 0 ? className + "." + localName2.substring(0, pos) : localName2.substring(0, pos);
                localName2 = localName2.substring(pos + 1);
            } else {
                if (className != null && className.length() > 0) {
                    try {
                        clazz = ObjectFactory.findProviderClass(className, ObjectFactory.findClassLoader(), true);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (localName2.indexOf(45) > 0) {
                    localName2 = XSLTCHelper.getNormalizedFunctionName(localName2);
                }
                if (Function2TypeChecker.isBuiltInExtensionNamespace(function2.getQName()) && compiler.getFunctionDeclarationFromSignature(function2.getQName(), function2.getArity()) != null) {
                    return true;
                }
            }
            if (clazz == null) {
                try {
                    clazz = ObjectFactory.findProviderClass(className, ObjectFactory.findClassLoader(), true);
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
            return (methods = XSLTCHelper.findMethods(clazz, localName2, nArgs = function2.getArity())) != null;
        }
        return false;
    }

    public static FunctionDecl getModuleFunctionCall(FunctionCall function2, XSLTParser parser, boolean external) {
        QName funcName = XSLTCHelper.getFunctionQName(function2, parser);
        int arity = function2.getOperandCount();
        return parser.getStaticContext().lookupModuleFunction(funcName, arity, external);
    }

    public static boolean isModuleFunctionCall(FunctionCall function2, XSLTParser parser) {
        FunctionDecl func = XSLTCHelper.getModuleFunctionCall(function2, parser, false);
        return func != null;
    }

    public static boolean isModuleExternalFunctionCall(FunctionCall function2, XSLTParser parser) {
        FunctionDecl func = XSLTCHelper.getModuleFunctionCall(function2, parser, true);
        return func != null;
    }

    private static final QName getFunctionQName(FunctionCall function2, XSLTParser parser) {
        String localName2 = function2.getFunctionQName().getLocalPart();
        String namespace2 = function2.getFunctionQName().getNamespaceURI();
        String prefix2 = function2.getFunctionQName().getPrefix();
        QName funcName = parser.getQName(namespace2, prefix2, localName2);
        return funcName;
    }

    public static String getClassNameFromUri(String uri2, HashMap extensionNamespaceTable) {
        String className = (String)extensionNamespaceTable.get(uri2);
        if (className != null) {
            return className;
        }
        if (uri2.startsWith("http://www.ibm.com/xmlns/prod/xltxe-j/java")) {
            int length2 = "http://www.ibm.com/xmlns/prod/xltxe-j/java".length() + 1;
            return uri2.length() > length2 ? uri2.substring(length2) : "";
        }
        if (uri2.startsWith("http://xml.apache.org/xalan/xsltc/java")) {
            int length3 = "http://xml.apache.org/xalan/xsltc/java".length() + 1;
            return uri2.length() > length3 ? uri2.substring(length3) : "";
        }
        if (uri2.startsWith("http://xml.apache.org/xalan/java")) {
            int length4 = "http://xml.apache.org/xalan/java".length() + 1;
            return uri2.length() > length4 ? uri2.substring(length4) : "";
        }
        if (uri2.startsWith("http://xml.apache.org/xslt/java")) {
            int length5 = "http://xml.apache.org/xslt/java".length() + 1;
            return uri2.length() > length5 ? uri2.substring(length5) : "";
        }
        int index2 = uri2.lastIndexOf(47);
        return index2 > 0 ? uri2.substring(index2 + 1) : uri2;
    }

    public static void processingInstructionTestRewrite(StepExpr step2, XSLTParser parser) {
        try {
            KindTest kindTest = (KindTest)step2.getNodeTest();
            String target = kindTest.getPITarget();
            if (target != null && target.length() > 0) {
                ExpressionFactoryImpl exprFactory = parser.getExpressionFactory();
                Expr pred = exprFactory.createExpr(parser, "name(.)='" + target + "'");
                step2.jjtInsertChild(pred, 1);
            }
        }
        catch (XPath20Exception xPath20Exception) {
            // empty catch block
        }
    }

    protected static void nameTestRewrite(StepExpr step2, XSLTParser parser, boolean isPattern) {
        try {
            NameTest arg2 = (NameTest)step2.jjtGetChild(0);
            NameTest newNameTest = new NameTest(91);
            newNameTest.setNameTestType((short)0);
            step2.jjtReplaceChild(newNameTest, 0);
            ExpressionFactoryImpl exprFactory = parser.getExpressionFactory();
            XStaticContext staticCtx = parser.getStaticContext();
            String namespaceURI = staticCtx.getNamespaceURI(arg2.getNCName());
            OperatorExpr opExpr = (OperatorExpr)exprFactory.createExpr(parser, "namespace-uri() = '" + namespaceURI + "'");
            step2.jjtInsertChild(opExpr, 1);
            if (isPattern) {
                step2.setPatternStepRewrittenToPredicate(true);
            }
            step2.setStepNodeType(1);
        }
        catch (XPath20Exception xPath20Exception) {
            // empty catch block
        }
    }

    public static Type convertXSTypeToXtqType(XSTypeDefinition type2) {
        return xsTypesToxtqTypes.get(type2);
    }

    public static XSTypeDefinition convertXtqTypeToXSType(Type type2) {
        XSTypeDefinition xstype = xtqTypesToxsTypes.get(type2);
        if (xstype == null && type2 instanceof XSequenceType && ((XSequenceType)type2).getBaseType() instanceof NodeType) {
            xstype = TypeRegistry.XSUNTYPED;
        }
        return xstype;
    }

    public static boolean hasConstructors(String className, int arity) {
        try {
            Class clazz = ObjectFactory.findProviderClass(className, ObjectFactory.findClassLoader(), true);
            return XSLTCHelper.findConstructors(clazz, arity).size() > 0;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static {
        xsTypesToxtqTypes.put(TypeRegistry.XSANYATOMICTYPE, TypeConstants.ANYATOMICTYPE);
        xsTypesToxtqTypes.put(TypeRegistry.XSANYSIMPLETYPE, TypeConstants.ANYSIMPLETYPE);
        xsTypesToxtqTypes.put(TypeRegistry.XSANYTYPE, TypeConstants.ANYTYPE);
        xsTypesToxtqTypes.put(TypeRegistry.XSANYURI, TypeConstants.ANYURI);
        xsTypesToxtqTypes.put(TypeRegistry.XSBASE64BINARY, TypeConstants.BASE64BINARY);
        xsTypesToxtqTypes.put(TypeRegistry.XSBOOLEAN, TypeConstants.BOOLEAN);
        xsTypesToxtqTypes.put(TypeRegistry.XSBYTE, TypeConstants.BYTE);
        xsTypesToxtqTypes.put(TypeRegistry.XSDATE, TypeConstants.DATE);
        xsTypesToxtqTypes.put(TypeRegistry.XSDATETIME, TypeConstants.DATETIME);
        xsTypesToxtqTypes.put(TypeRegistry.XSDAYTIMEDURATION, TypeConstants.DAYTIMEDURATION);
        xsTypesToxtqTypes.put(TypeRegistry.XSDECIMAL, TypeConstants.DECIMAL);
        xsTypesToxtqTypes.put(TypeRegistry.XSDOUBLE, TypeConstants.DOUBLE);
        xsTypesToxtqTypes.put(TypeRegistry.XSDURATION, TypeConstants.DURATION);
        xsTypesToxtqTypes.put(TypeRegistry.XSENTITIES, TypeConstants.ENTITIES);
        xsTypesToxtqTypes.put(TypeRegistry.XSENTITY, TypeConstants.ENTITY);
        xsTypesToxtqTypes.put(TypeRegistry.XSFLOAT, TypeConstants.FLOAT);
        xsTypesToxtqTypes.put(TypeRegistry.XSGDAY, TypeConstants.GDAY);
        xsTypesToxtqTypes.put(TypeRegistry.XSGMONTH, TypeConstants.GMONTH);
        xsTypesToxtqTypes.put(TypeRegistry.XSGMONTHDAY, TypeConstants.GMONTHDAY);
        xsTypesToxtqTypes.put(TypeRegistry.XSGYEAR, TypeConstants.GYEAR);
        xsTypesToxtqTypes.put(TypeRegistry.XSGYEARMONTH, TypeConstants.GYEARMONTH);
        xsTypesToxtqTypes.put(TypeRegistry.XSHEXBINARY, TypeConstants.HEXBINARY);
        xsTypesToxtqTypes.put(TypeRegistry.XSID, TypeConstants.ID);
        xsTypesToxtqTypes.put(TypeRegistry.XSIDREF, TypeConstants.IDREF);
        xsTypesToxtqTypes.put(TypeRegistry.XSIDREFS, TypeConstants.IDREFS);
        xsTypesToxtqTypes.put(TypeRegistry.XSINT, TypeConstants.INT);
        xsTypesToxtqTypes.put(TypeRegistry.XSINTEGER, TypeConstants.INTEGER);
        xsTypesToxtqTypes.put(TypeRegistry.XSLANGUAGE, TypeConstants.LANGUAGE);
        xsTypesToxtqTypes.put(TypeRegistry.XSLONG, TypeConstants.LONG);
        xsTypesToxtqTypes.put(TypeRegistry.XSNAME, TypeConstants.NAME);
        xsTypesToxtqTypes.put(TypeRegistry.XSNCNAME, TypeConstants.NCNAME);
        xsTypesToxtqTypes.put(TypeRegistry.XSNEGATIVEINTEGER, TypeConstants.NEGATIVEINTEGER);
        xsTypesToxtqTypes.put(TypeRegistry.XSNMTOKEN, TypeConstants.NMTOKEN);
        xsTypesToxtqTypes.put(TypeRegistry.XSNMTOKENS, TypeConstants.NMTOKENS);
        xsTypesToxtqTypes.put(TypeRegistry.XSNONNEGATIVEINTEGER, TypeConstants.NONNEGATIVEINTEGER);
        xsTypesToxtqTypes.put(TypeRegistry.XSNONPOSITIVEINTEGER, TypeConstants.NONPOSITIVEINTEGER);
        xsTypesToxtqTypes.put(TypeRegistry.XSNORMALIZEDSTRING, TypeConstants.NORMALIZEDSTRING);
        xsTypesToxtqTypes.put(TypeRegistry.XSNOTATION, TypeConstants.NOTATION);
        xsTypesToxtqTypes.put(TypeRegistry.XSPOSITIVEINTEGER, TypeConstants.POSITIVEINTEGER);
        xsTypesToxtqTypes.put(TypeRegistry.XSQNAME, TypeConstants.QNAME);
        xsTypesToxtqTypes.put(TypeRegistry.XSSHORT, TypeConstants.SHORT);
        xsTypesToxtqTypes.put(TypeRegistry.XSSTRING, TypeConstants.STRING);
        xsTypesToxtqTypes.put(TypeRegistry.XSTIME, TypeConstants.TIME);
        xsTypesToxtqTypes.put(TypeRegistry.XSTOKEN, TypeConstants.TOKEN);
        xsTypesToxtqTypes.put(TypeRegistry.XSUNSIGNEDBYTE, TypeConstants.UNSIGNEDBYTE);
        xsTypesToxtqTypes.put(TypeRegistry.XSUNSIGNEDINT, TypeConstants.UNSIGNEDINT);
        xsTypesToxtqTypes.put(TypeRegistry.XSUNSIGNEDLONG, TypeConstants.UNSIGNEDLONG);
        xsTypesToxtqTypes.put(TypeRegistry.XSUNSIGNEDSHORT, TypeConstants.UNSIGNEDSHORT);
        xsTypesToxtqTypes.put(TypeRegistry.XSUNTYPEDATOMIC, TypeConstants.UNTYPEDATOMIC);
        xsTypesToxtqTypes.put(TypeRegistry.XSYEARMONTHDURATION, TypeConstants.YEARMONTHDURATION);
        xsTypesToxtqTypes.put(TypeRegistry.XSUNTYPED, TypeConstants.NODE);
        xsTypesToxtqTypes.put(TypeRegistry.XSUNTYPEDATOMIC, TypeConstants.UNTYPEDATOMIC);
        xtqTypesToxsTypes = new HashMap();
        xtqTypesToxsTypes.put(TypeConstants.ANYATOMICTYPE, TypeRegistry.XSANYATOMICTYPE);
        xtqTypesToxsTypes.put(TypeConstants.ANYSIMPLETYPE, TypeRegistry.XSANYSIMPLETYPE);
        xtqTypesToxsTypes.put(TypeConstants.ANYTYPE, TypeRegistry.XSANYTYPE);
        xtqTypesToxsTypes.put(TypeConstants.ANYURI, TypeRegistry.XSANYURI);
        xtqTypesToxsTypes.put(TypeConstants.BASE64BINARY, TypeRegistry.XSBASE64BINARY);
        xtqTypesToxsTypes.put(TypeConstants.BOOLEAN, TypeRegistry.XSBOOLEAN);
        xtqTypesToxsTypes.put(TypeConstants.BYTE, TypeRegistry.XSBYTE);
        xtqTypesToxsTypes.put(TypeConstants.DATE, TypeRegistry.XSDATE);
        xtqTypesToxsTypes.put(TypeConstants.DATETIME, TypeRegistry.XSDATETIME);
        xtqTypesToxsTypes.put(TypeConstants.DAYTIMEDURATION, TypeRegistry.XSDAYTIMEDURATION);
        xtqTypesToxsTypes.put(TypeConstants.DECIMAL, TypeRegistry.XSDECIMAL);
        xtqTypesToxsTypes.put(TypeConstants.DOUBLE, TypeRegistry.XSDOUBLE);
        xtqTypesToxsTypes.put(TypeConstants.DURATION, TypeRegistry.XSDURATION);
        xtqTypesToxsTypes.put(TypeConstants.ENTITIES, TypeRegistry.XSENTITIES);
        xtqTypesToxsTypes.put(TypeConstants.ENTITY, TypeRegistry.XSENTITY);
        xtqTypesToxsTypes.put(TypeConstants.FLOAT, TypeRegistry.XSFLOAT);
        xtqTypesToxsTypes.put(TypeConstants.GDAY, TypeRegistry.XSGDAY);
        xtqTypesToxsTypes.put(TypeConstants.GMONTH, TypeRegistry.XSGMONTH);
        xtqTypesToxsTypes.put(TypeConstants.GMONTHDAY, TypeRegistry.XSGMONTHDAY);
        xtqTypesToxsTypes.put(TypeConstants.GYEAR, TypeRegistry.XSGYEAR);
        xtqTypesToxsTypes.put(TypeConstants.GYEARMONTH, TypeRegistry.XSGYEARMONTH);
        xtqTypesToxsTypes.put(TypeConstants.HEXBINARY, TypeRegistry.XSHEXBINARY);
        xtqTypesToxsTypes.put(TypeConstants.ID, TypeRegistry.XSID);
        xtqTypesToxsTypes.put(TypeConstants.IDREF, TypeRegistry.XSIDREF);
        xtqTypesToxsTypes.put(TypeConstants.IDREFS, TypeRegistry.XSIDREFS);
        xtqTypesToxsTypes.put(TypeConstants.INT, TypeRegistry.XSINT);
        xtqTypesToxsTypes.put(TypeConstants.INTEGER, TypeRegistry.XSINTEGER);
        xtqTypesToxsTypes.put(TypeConstants.LANGUAGE, TypeRegistry.XSLANGUAGE);
        xtqTypesToxsTypes.put(TypeConstants.LONG, TypeRegistry.XSLONG);
        xtqTypesToxsTypes.put(TypeConstants.NAME, TypeRegistry.XSNAME);
        xtqTypesToxsTypes.put(TypeConstants.NCNAME, TypeRegistry.XSNCNAME);
        xtqTypesToxsTypes.put(TypeConstants.NEGATIVEINTEGER, TypeRegistry.XSNEGATIVEINTEGER);
        xtqTypesToxsTypes.put(TypeConstants.NMTOKEN, TypeRegistry.XSNMTOKEN);
        xtqTypesToxsTypes.put(TypeConstants.NMTOKENS, TypeRegistry.XSNMTOKENS);
        xtqTypesToxsTypes.put(TypeConstants.NONNEGATIVEINTEGER, TypeRegistry.XSNONNEGATIVEINTEGER);
        xtqTypesToxsTypes.put(TypeConstants.NONPOSITIVEINTEGER, TypeRegistry.XSNONPOSITIVEINTEGER);
        xtqTypesToxsTypes.put(TypeConstants.NORMALIZEDSTRING, TypeRegistry.XSNORMALIZEDSTRING);
        xtqTypesToxsTypes.put(TypeConstants.NOTATION, TypeRegistry.XSNOTATION);
        xtqTypesToxsTypes.put(TypeConstants.POSITIVEINTEGER, TypeRegistry.XSPOSITIVEINTEGER);
        xtqTypesToxsTypes.put(TypeConstants.QNAME, TypeRegistry.XSQNAME);
        xtqTypesToxsTypes.put(TypeConstants.SHORT, TypeRegistry.XSSHORT);
        xtqTypesToxsTypes.put(TypeConstants.STRING, TypeRegistry.XSSTRING);
        xtqTypesToxsTypes.put(TypeConstants.TIME, TypeRegistry.XSTIME);
        xtqTypesToxsTypes.put(TypeConstants.TOKEN, TypeRegistry.XSTOKEN);
        xtqTypesToxsTypes.put(TypeConstants.UNSIGNEDBYTE, TypeRegistry.XSUNSIGNEDBYTE);
        xtqTypesToxsTypes.put(TypeConstants.UNSIGNEDINT, TypeRegistry.XSUNSIGNEDINT);
        xtqTypesToxsTypes.put(TypeConstants.UNSIGNEDLONG, TypeRegistry.XSUNSIGNEDLONG);
        xtqTypesToxsTypes.put(TypeConstants.UNSIGNEDSHORT, TypeRegistry.XSUNSIGNEDSHORT);
        xtqTypesToxsTypes.put(TypeConstants.UNTYPEDATOMIC, TypeRegistry.XSUNTYPEDATOMIC);
        xtqTypesToxsTypes.put(TypeConstants.YEARMONTHDURATION, TypeRegistry.XSYEARMONTHDURATION);
        xtqTypesToxsTypes.put(TypeConstants.NODE, TypeRegistry.XSUNTYPED);
        xtqTypesToxsTypes.put(TypeConstants.UNTYPEDATOMIC, TypeRegistry.XSUNTYPEDATOMIC);
    }
}

