/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator;

import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.AutoFunctorizingXSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.input.Util;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.codegen.bcel.ClassCollector;
import com.ibm.xltxe.rnm1.xylem.codegen.bcel.Resource;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xltxe.rnm1.xylem.instructions.DebugInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.InterpreterUtilities;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import org.xml.sax.InputSource;

public class XylemXSLTC {
    private static final Logger s_logger = LoggerUtil.getLogger(XylemXSLTC.class);
    private static final String s_className = XylemXSLTC.class.getName();
    protected static SourceLoader s_sourceLoader = null;
    protected static boolean s_topResolve = false;
    protected static ArrayList s_classes;
    protected static ArrayList s_resources;
    private static boolean s_isInputXylem;

    public static void createSourceLoader(final URIResolver uriResolver) {
        s_sourceLoader = new SourceLoader(){

            @Override
            public InputSource loadSource(String href, String context2, XSLTParser parser) {
                try {
                    Source source = uriResolver.resolve(href, context2);
                    if (source != null) {
                        return Util.getInputSource(parser, source);
                    }
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
    }

    protected static void outputToJar(File outputDir, String jarFileName) throws IOException {
        Attributes attr2;
        Manifest manifest = new Manifest();
        Attributes atrs = manifest.getMainAttributes();
        atrs.put(Attributes.Name.MANIFEST_VERSION, "1.2");
        Map<String, Attributes> map2 = manifest.getEntries();
        Iterator classes = s_classes.iterator();
        String now = new Date().toString();
        Attributes.Name dateAttr = new Attributes.Name("Date");
        while (classes.hasNext()) {
            JavaClass clazz = (JavaClass)classes.next();
            String className = clazz.getClassName().replace('.', '/');
            attr2 = new Attributes();
            attr2.put(dateAttr, now);
            map2.put(className + ".class", attr2);
        }
        for (Resource res : s_resources) {
            attr2 = new Attributes();
            attr2.put(dateAttr, now);
            map2.put(res.getName(), attr2);
        }
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(new File(outputDir, jarFileName)), manifest);
        for (JavaClass clazz : s_classes) {
            String className = clazz.getClassName().replace('.', '/');
            jos.putNextEntry(new JarEntry(className + ".class"));
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            clazz.dump(out);
            out.writeTo(jos);
        }
        for (Resource res : s_resources) {
            jos.putNextEntry(new JarEntry(res.getName()));
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            res.dump(out);
            out.writeTo(jos);
        }
        jos.close();
    }

    public static void main(String[] args) {
        XylemXSLTCommandLineParser clp = new XylemXSLTCommandLineParser();
        s_classes = new ArrayList();
        s_resources = new ArrayList();
        if (!clp.parseCommandLine(args)) {
            System.exit(-1);
        }
        SessionContext session = new SessionContext();
        URL[] files = new URL[clp.m_files.size()];
        clp.m_files.toArray(files);
        if (clp.m_functor != null) {
            if (clp.m_interface == null) {
                s_logger.logp(Level.SEVERE, s_className, "main", "you must specify an interface file with -functor");
                System.exit(-1);
            }
            try {
                AutoFunctorizingXSLTLinker.compileFunctorAppliedStylesheets(clp.m_functor.toURL(), files, clp.m_interface.toURL(), clp.m_compilerSettings, s_sourceLoader, s_topResolve, session);
            }
            catch (MalformedURLException e) {
                s_logger.logp(Level.SEVERE, s_className, "main", "malformed interface or functor filename", e);
                System.exit(-1);
            }
        } else if (clp.m_files.size() > 1) {
            if (!clp.m_linkerSettings.isOverlapDetection()) {
                s_logger.logp(Level.SEVERE, s_className, "main", "multiple XSLT input files only supported with -functor");
                System.exit(-1);
            } else if (AutoFunctorizingXSLTLinker.compileStylesheetDetectOverlap(files, clp.m_classNames, clp.m_compilerSettings, clp.m_linkerSettings, s_sourceLoader, s_topResolve, session) == null) {
                System.exit(-1);
            }
        } else if (s_isInputXylem) {
            if (clp.m_compilerSettings.isStylesheetSpecificSAX()) {
                if (XSLTLinker.s_linker.compileXylemFile(clp.m_inputFile, clp.m_linkerSettings, session) == null) {
                    System.exit(-1);
                }
            } else if (XSLTLinker.s_linker.compileXylemFile(clp.m_inputFile, session) == null) {
                System.exit(-1);
            }
        } else if (clp.m_compilerSettings.isStylesheetSpecificSAX()) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "isInputXylem=" + s_isInputXylem);
            }
            if (XSLTLinker.s_linker.compileStylesheet_StylesheetSpecificSAX(clp.m_inputFile, clp.m_classNames.size() > 0 ? (String)clp.m_classNames.get(0) : null, clp.m_compilerSettings, clp.m_linkerSettings, s_sourceLoader, s_topResolve, session) == null) {
                System.exit(-1);
            }
        } else {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "isInputXylem=" + s_isInputXylem);
            }
            clp.m_linkerSettings.setDumpXylem(true);
            if (XSLTLinker.s_linker.compileStylesheet(clp.m_inputFile, clp.m_classNames.size() > 0 ? (String)clp.m_classNames.get(0) : null, clp.m_compilerSettings, clp.m_linkerSettings, s_sourceLoader, s_topResolve, session) == null) {
                System.exit(-1);
            }
        }
        if (clp.m_jarFileName != null) {
            try {
                XylemXSLTC.outputToJar(clp.m_linkerSettings.getOutputDir(), clp.m_jarFileName);
            }
            catch (IOException e) {
                s_logger.logp(Level.SEVERE, s_className, "main", "IOException outputting jar file", e);
                System.exit(-1);
            }
        }
    }

    static {
        s_isInputXylem = false;
    }

    private static class CachingClassCollector
    extends ChainedClassCollector {
        public CachingClassCollector(ClassCollector next) {
            super(next);
        }

        @Override
        public void handleGeneratedClass(JavaClass jc) {
            s_classes.add(jc);
        }

        @Override
        public void handleGeneratedResource(Resource resource) {
            s_resources.add(resource);
        }
    }

    private static abstract class ChainedClassCollector
    extends ClassCollector {
        private ClassCollector m_nextCollector;

        public ChainedClassCollector(ClassCollector next) {
            this.m_nextCollector = next;
        }

        public abstract void handleGeneratedClass(JavaClass var1);

        public abstract void handleGeneratedResource(Resource var1);

        @Override
        public final void acceptGeneratedClass(JavaClass jc) {
            this.handleGeneratedClass(jc);
            if (this.m_nextCollector != null) {
                this.m_nextCollector.acceptGeneratedClass(jc);
            }
        }

        @Override
        public final void acceptGeneratedResource(Resource resource) {
            this.handleGeneratedResource(resource);
            if (this.m_nextCollector != null) {
                this.m_nextCollector.acceptGeneratedResource(resource);
            }
        }
    }

    public static class XylemXSLTCommandLineParser
    extends CommandLineParserSingleInputFile {
        public File m_functor = null;
        public File m_interface = null;
        public ArrayList m_files = new ArrayList();
        public ArrayList m_classNames = new ArrayList();
        public XSLTCompilerSettings m_compilerSettings = new XSLTCompilerSettings();
        public XSLTLinkerSettings m_linkerSettings = new XSLTLinkerSettings(this.m_compilerSettings);
        public String m_jarFileName = null;
        public InterpreterUtilities m_utility = new InterpreterUtilities();

        @Override
        protected int parseOption(String[] args, int i) {
            if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("-h")) {
                System.out.println("Usage: XylemXSLTC [-command commandfile]\n                  [-language java|cpp]\n                  [-xslt-version 1.0|2.0]\n                  [-version]\n                  [-showversion]\n                  [-split limit]\n                  [-newsplit limit]\n                  [-outputdir dir]\n                  [-jarfile file]\n                  [-uriresolver fully.qualified.ClassName]\n                  [-topresolve]\n                  [-enabletracing]\n                  [-enabledebug]\n                  [-nodesetspecialization]\n                  [-disablenvcursors]\n                  [-traceserialization]\n                  [-combinepartitions]\n                  [-dumpxylem]\n                  [-dumpintermediatexylem]\n                  [-maxfunctionsperpartition n]\n                  [-functor input0.xsl -interface input0.xylemi]\n                  [-detectoverlap]\n                  [-classloaderproxy]\n                  [-disablejavac]\n                  [-assertions]\n                  [-symbols]\n                  [-streamresultonly]\n                  [-defaultmethod method]\n                  [-forceencoding encoding]\n                  [-nometa]\n                  [-standardserializer]\n                  [-suppressComments]\n                  [-generateBCEL]\n                  [-generateCXO]\n                  [-generateFCG]\n                  [-stylesheetSpecificSAX]\n                  [-saxstreaming]\n                  [-inputXylem input.xylem]\n                  [-xhtmlCompatability]\n                  [-disablesetparameter]\n                  [-minoptimizations]\n                  [-nsd]\n                  input1.xsl input2.xsl ...");
                return -1;
            }
            if ("-command".equals(args[i])) {
                if (i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-command missing parameter");
                    return -1;
                }
                if (!this.handleCommandOption(args[++i])) {
                    return -1;
                }
                return i;
            }
            if (args[i].equals("-split")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-split missing parameter");
                    return -1;
                }
                try {
                    this.m_compilerSettings.setPrereductionSplitLimit(Integer.parseInt(args[i]));
                }
                catch (NumberFormatException nfe) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid split limit: " + args[i]);
                    return -1;
                }
                return i;
            }
            if (args[i].equals("-xslt-version")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-xslt-version missing parameter");
                    return -1;
                }
                this.m_compilerSettings.setVersion(args[i]);
                if (!args[i].equals("1.0") && !args[i].equals("2.0")) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid version: " + args[i]);
                    return -1;
                }
                return i;
            }
            if (args[i].equals("-version")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return -1;
            }
            if (args[i].equals("-showversion")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return i;
            }
            if (args[i].equals("-symbols")) {
                this.m_linkerSettings.getCodeGenerationSettings().getJavaCSettings().setGenerateSymbols(true);
                return i;
            }
            if (args[i].equals("-enabletracing")) {
                this.m_linkerSettings.getCodeGenerationSettings().setFunctionCallTracing(true);
                this.m_utility.setDebuggerflag(true);
                return i;
            }
            if (args[i].equals("-nodesetspecialization")) {
                this.m_linkerSettings.setNodesetSpecialization(true);
                return i;
            }
            if (args[i].equals("-minoptimizations")) {
                this.m_linkerSettings.setMinOptimization(true);
                return i;
            }
            if (args[i].equals("-nsd")) {
                this.m_linkerSettings.setEnableNodeSetDeforester(true);
                return i;
            }
            if (args[i].equals("-disablecnlfoptimizer")) {
                this.m_linkerSettings.setDisableCNLFOptimizer(true);
                return i;
            }
            if (args[i].equals("-disablenvcursors")) {
                this.m_linkerSettings.setDisableNVCursor(true);
                return i;
            }
            if (args[i].equals("-detectoverlap")) {
                this.m_linkerSettings.setOverlapDetection(true);
                return i;
            }
            if (args[i].equals("-dumpxylem")) {
                this.m_linkerSettings.setDumpXylem(true);
                return i;
            }
            if (args[i].equals("-dumpintermediatexylem")) {
                this.m_linkerSettings.setDumpIntermediateXylem(true);
                return i;
            }
            if (args[i].equals("-inputXylem")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-inputXylem missing parameter");
                    return -1;
                }
                this.m_inputFile = this.validateInputFilename(args[i], s_topResolve);
                s_isInputXylem = true;
                return i;
            }
            if (args[i].equals("-maxfunctionsperpartition")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-maxfunctionsperpartition missing parameter");
                    return -1;
                }
                this.m_linkerSettings.getCodeGenerationSettings().setMaxFunctionsPerPartition(Integer.parseInt(args[i]));
                return i;
            }
            if (args[i].equals("-functor")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-functor missing parameter");
                    return -1;
                }
                if (this.m_linkerSettings.isOverlapDetection()) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-detectoverlap and functor mode are mutually exclusive");
                    return -1;
                }
                this.m_functor = new File(args[i]);
                if (!this.m_functor.exists()) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "specified functor input file does not exist: " + this.m_functor);
                    return -1;
                }
                return i;
            }
            if (args[i].equals("-interface")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-interface missing parameter");
                    return -1;
                }
                if (this.m_linkerSettings.isOverlapDetection()) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-detectoverlap and functor mode are mutually exclusive");
                    return -1;
                }
                this.m_interface = new File(args[i]);
                if (!this.m_interface.exists()) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "specified interface input file does not exist: " + this.m_interface);
                    return -1;
                }
                return i;
            }
            if (args[i].equals("-classname")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-classname missing parameter");
                    return -1;
                }
                this.m_classNames.add(args[i]);
                return i;
            }
            if (args[i].equals("-outputdir")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-outputdir missing parameter");
                    return -1;
                }
                File file = new File(args[i]);
                this.m_linkerSettings.setOutputDir(file);
                if (!file.exists() || !file.isDirectory()) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "specified output directory does not exist or is not a directory: " + file);
                    return -1;
                }
                return i;
            }
            if (args[i].equals("-jarfile")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-jarfile missing parameter");
                    return -1;
                }
                String jarFileName = args[i];
                String JAR_EXT = ".jar";
                this.m_jarFileName = jarFileName.endsWith(".jar") ? jarFileName : jarFileName + ".jar";
                this.m_linkerSettings.getCodeGenerationSettings().setBCELClassCollector(new CachingClassCollector(null));
                return i;
            }
            if (args[i].equals("-uriresolver")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-uriresolver missing parameter");
                    return -1;
                }
                try {
                    URIResolver uriResolver = (URIResolver)ObjectFactory.newInstance(args[i], ObjectFactory.findClassLoader(), true);
                    XylemXSLTC.createSourceLoader(uriResolver);
                }
                catch (Exception ee) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-uriresolver invalid class");
                    return -1;
                }
                return i;
            }
            if (args[i].equals("-topresolve")) {
                s_topResolve = true;
                return i;
            }
            if (args[i].equals("-streamresultonly")) {
                this.m_compilerSettings.setStreamResultOnly(true);
                return i;
            }
            if (args[i].equals("-defaultmethod")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-defaultmethod missing parameter");
                    return -1;
                }
                this.m_compilerSettings.setStreamResultDefaultOutputMethod(args[i].toLowerCase());
                return i;
            }
            if (args[i].equals("-forceencoding")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-forceencoding missing parameter");
                    return -1;
                }
                this.m_compilerSettings.setForcedOutputEncoding(args[i]);
                return i;
            }
            if (args[i].equals("-nometa")) {
                this.m_compilerSettings.setStreamResultNoMeta(true);
                return i;
            }
            if (args[i].equals("-standardserializer")) {
                this.m_compilerSettings.setStreamResultOnly(false);
                return i;
            }
            if (args[i].equals("-enabledebug")) {
                DebugInstruction.enable(args[++i]);
                return i;
            }
            if (args[i].equals("-traceserialization")) {
                this.m_compilerSettings.setSerializationTraceEnabled(true);
                return i;
            }
            if (args[i].equals("-classloaderproxy")) {
                this.m_linkerSettings.setGenerateClassLoadingProxy(true);
                return i;
            }
            if (args[i].equals("-stylesheetSpecificSAX")) {
                this.m_compilerSettings.setStylesheetSpecificSAX(true);
                this.m_linkerSettings.setStylesheetSpecificSAX(true);
                return i;
            }
            if (args[i].equals("-saxstreaming")) {
                this.m_compilerSettings.setStreaming(true);
                this.m_compilerSettings.setStylesheetSpecificSAX(true);
                this.m_linkerSettings.setStylesheetSpecificSAX(true);
                return i;
            }
            if (args[i].equals("-assertions")) {
                return i;
            }
            if (args[i].equals("-xhtmlCompatability")) {
                this.m_compilerSettings.setXHTMLCompatability(true);
                return i;
            }
            if (args[i].equals("-interpret")) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-interpret no longer supported; use XSLTInterpreter instead");
                return i;
            }
            if ("-DISABLESETPARAMETER".equalsIgnoreCase(args[i])) {
                this.m_compilerSettings.setDisableSetParameter(true);
                return i;
            }
            if (args[i].equals("-interpretOverlap")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-interpretOverlap missing functorindex");
                    return -1;
                }
                if (!this.m_linkerSettings.isOverlapDetection()) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "Set -interpretOverlap after -detectoverlap");
                    return -1;
                }
                int functorindex = -1;
                try {
                    functorindex = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException nfe) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid functor index: " + args[i]);
                    return -1;
                }
                this.m_linkerSettings.setInterpretIndex(functorindex);
                return i;
            }
            int j = this.m_linkerSettings.getCodeGenerationSettings().parseOption(args, i);
            if (j == -1) {
                return -1;
            }
            if (j != -2) {
                return j;
            }
            this.m_inputFile = this.validateInputFilename(args[i], s_topResolve);
            if (this.m_inputFile == null) {
                return -1;
            }
            this.m_files.add(this.m_inputFile);
            return i;
        }

        @Override
        public boolean parseCommandLine(String[] args) {
            boolean b = super.parseCommandLine(args);
            if (this.m_linkerSettings.isOverlapDetection() && this.m_files.size() <= 1) {
                this.m_linkerSettings.setOverlapDetection(false);
            }
            return b;
        }
    }
}

