/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator.v2;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Number;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.TranslatorUtilities;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XSLT2Translator;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.ComparisonInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.EqualityInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.ExpandedTypeIDInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.XPathDataTypeLiteralInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ConstructXDMItemAtomInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ItemKind;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.builders.DynamicVariableBuilder;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.OrInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StaticMethodInvocationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;

public class Number2Translator {
    final LetChainBuilder lcb;
    final DynamicVariableBuilder dvb;
    final XSLT2Translator xslt2Translator;

    public Number2Translator(LetChainBuilder l, DynamicVariableBuilder d, XSLT2Translator x) {
        this.lcb = l;
        this.dvb = d;
        this.xslt2Translator = x;
    }

    public Instruction compileNumber(Number number2) {
        Instruction numInstruction = null;
        boolean isBCMode = number2.isBackwardsCompatibilityMode(this.xslt2Translator.getStaticContext().getLanguage());
        Instruction formatInst = this.makeStringInstruction(number2.getFormat(), "1", isBCMode);
        Instruction langInst = this.makeStringInstruction(number2.getLang(), "en", isBCMode);
        Object letterValueInst = this.lcb.bindToVar(this.makeStringInstruction(number2.getLetterValue(), "alphabetic", isBCMode));
        Instruction equalsAlphaInst = this.lcb.bind(new DeepEqualityInstruction(new IdentifierInstruction(letterValueInst), this.lcb.bind(StreamInstruction.charStreamLiteral("alphabetic"))));
        Instruction equalsTradInst = this.lcb.bind(new DeepEqualityInstruction(new IdentifierInstruction(letterValueInst), this.lcb.bind(StreamInstruction.charStreamLiteral("traditional"))));
        Instruction orInst = this.lcb.bind(new OrInstruction(equalsAlphaInst, equalsTradInst));
        LetChainBuilder otherwiseLCB = this.lcb.newInstanceParented();
        Instruction[] substitutionTexts = new Instruction[]{new IdentifierInstruction(letterValueInst), otherwiseLCB.bind(StreamInstruction.charStreamLiteral("letter-value"))};
        Instruction terminateBadLetterValue = TranslatorUtilities.genReportErrorCharStreamType((XStarCompiler)this.xslt2Translator.getCompiler(), otherwiseLCB, "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_AVT_NOT_PERMITTED", substitutionTexts);
        Instruction chooseLetterValueInst = this.lcb.bind(new ChooseInstruction(orInst, (Instruction)new IdentifierInstruction(letterValueInst), otherwiseLCB.packageUp(terminateBadLetterValue)));
        otherwiseLCB = null;
        Instruction ordinalInst = this.makeStringInstruction(number2.getOrdinal(), "no", isBCMode);
        Object groupingSeparatorInst = this.lcb.bindToVar(this.makeStringInstruction(number2.getGroupingSeparator(), "", isBCMode));
        Instruction groupingSeparatorLengthInst = this.lcb.bind(new StaticMethodInvocationInstruction("com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeLibrary", "codePointCount", new Instruction[]{new IdentifierInstruction(groupingSeparatorInst)}, IntType.s_intType));
        Instruction lengthGreaterThanInst = this.lcb.bind(new ComparisonInstruction(15, groupingSeparatorLengthInst, new LiteralInstruction(IntType.s_intType, 2)));
        otherwiseLCB = this.lcb.newInstanceParented();
        substitutionTexts = new Instruction[]{new IdentifierInstruction(groupingSeparatorInst), otherwiseLCB.bind(StreamInstruction.charStreamLiteral("grouping-separator"))};
        Instruction terminateBadGroupingSeparatorLength = TranslatorUtilities.genReportErrorCharStreamType((XStarCompiler)this.xslt2Translator.getCompiler(), otherwiseLCB, "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_AVT_NOT_PERMITTED", substitutionTexts);
        Instruction chooseGroupingSeparatorInst = this.lcb.bind(new ChooseInstruction(lengthGreaterThanInst, (Instruction)new IdentifierInstruction(groupingSeparatorInst), otherwiseLCB.packageUp(terminateBadGroupingSeparatorLength)));
        otherwiseLCB = null;
        Object groupingSizeInst = this.lcb.bindToVar(this.makeStringInstruction(number2.getGroupingSize(), "0", isBCMode));
        Instruction groupingSizeTypeCheckOneItemInst = this.lcb.bind(new ConstructXDMItemAtomInstruction(ItemKind.String, new Instruction[]{new IdentifierInstruction(groupingSizeInst), this.lcb.bind(new XPathDataTypeLiteralInstruction(this.lcb.bind(StreamInstruction.charStreamLiteral(ItemKind.String.getXType().toString()))))}));
        LetChainBuilder whenLCB = this.lcb.newInstanceParented();
        substitutionTexts = new Instruction[]{new IdentifierInstruction(groupingSizeInst), whenLCB.bind(StreamInstruction.charStreamLiteral("grouping-size"))};
        Instruction errorInstr = TranslatorUtilities.genReportErrorCharStreamType((XStarCompiler)this.xslt2Translator.getCompiler(), whenLCB, "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_AVT_NOT_PERMITTED", substitutionTexts);
        Instruction groupingSizeNumberInst = this.lcb.bind(TranslatorUtilities.makeModuleFunctionCall((XStarCompiler)this.xslt2Translator.getCompiler(), "xslt2", "fn:number-singleton", new Instruction[]{groupingSizeTypeCheckOneItemInst}));
        Instruction groupingSizeIsNaNInst = this.lcb.bind(new StaticMethodInvocationInstruction("java.lang.Double", "isNaN", new Instruction[]{groupingSizeNumberInst}, BooleanType.s_booleanType));
        Instruction chooseGroupingSizeInst = this.lcb.bind(new ChooseInstruction(groupingSizeIsNaNInst, whenLCB.packageUp(errorInstr), new IdentifierInstruction(groupingSizeInst)));
        if (number2.hasValue()) {
            Expr valueExpr = number2.getValueExpr();
            Instruction valueInst = this.xslt2Translator.compileNode(this.dvb, this.lcb, valueExpr);
            numInstruction = this.xslt2Translator.converter.makeRuntimeLibraryFunctionCall(this.dvb, this.lcb, "xsl-number-value", new Instruction[]{valueInst, formatInst, chooseGroupingSizeInst, chooseGroupingSeparatorInst, chooseLetterValueInst, langInst, ordinalInst, LiteralInstruction.booleanLiteral(isBCMode)}, "");
        } else {
            Instruction startNode = this.makeStartNodeInstruction(number2);
            if (number2.getFrom() == null && number2.getCount() == null) {
                if (number2.getLevel() == 0) {
                    numInstruction = this.xslt2Translator.converter.makeRuntimeLibraryFunctionCall(this.dvb, this.lcb, "xsl-number-default-single", new Instruction[]{startNode, formatInst, chooseGroupingSizeInst, chooseGroupingSeparatorInst, chooseLetterValueInst, langInst, ordinalInst}, "");
                } else if (number2.getLevel() == 2) {
                    numInstruction = this.xslt2Translator.converter.makeRuntimeLibraryFunctionCall(this.dvb, this.lcb, "xsl-number-default-any", new Instruction[]{startNode, formatInst, chooseGroupingSizeInst, chooseGroupingSeparatorInst, chooseLetterValueInst, langInst, ordinalInst}, "");
                }
            }
            if (numInstruction == null) {
                String numberingFunction;
                int level = number2.getLevel();
                switch (level) {
                    case 2: {
                        numberingFunction = "xsl-number-any";
                        break;
                    }
                    case 1: {
                        numberingFunction = "xsl-number-multiple";
                        break;
                    }
                    default: {
                        numberingFunction = "xsl-number-single";
                    }
                }
                Expr count2 = number2.getCount();
                Instruction countlambda = this.makeCountLambda(count2);
                Expr from2 = number2.getFrom();
                Instruction fromlambda = this.makeFromLambda(from2);
                numInstruction = this.xslt2Translator.converter.makeRuntimeLibraryFunctionCall(this.dvb, this.lcb, numberingFunction, new Instruction[]{startNode, countlambda, fromlambda, formatInst, chooseGroupingSizeInst, chooseGroupingSeparatorInst, chooseLetterValueInst, langInst, ordinalInst}, "");
            }
        }
        return numInstruction;
    }

    private Instruction makeFromLambda(Expr from2) {
        Integer var = ReductionHelper.generateIntermediateIdentifier2();
        Object oldVar = this.dvb.bind("__current__", var);
        LetChainBuilder lcbForLambda = new LetChainBuilder();
        LambdaInstruction fromlambda = from2 != null ? new LambdaInstruction(lcbForLambda.packageUp(lcbForLambda.bind(this.xslt2Translator.compileNode(this.dvb, lcbForLambda, from2))), new Binding[]{new Binding((Object)var, XDMItemType.s_itemType)}, true) : new LambdaInstruction(lcbForLambda.packageUp(LiteralInstruction.booleanFalseLiteral()), new Binding[]{new Binding((Object)var, XDMItemType.s_itemType)}, true);
        this.dvb.bind("__current__", oldVar);
        Instruction fromlambda2 = this.lcb.bind(fromlambda);
        return fromlambda2;
    }

    private Instruction makeCountLambda(Expr count2) {
        LambdaInstruction countlambda;
        Integer current2 = ReductionHelper.generateIntermediateIdentifier2();
        Object originalCurrent = this.dvb.bind("__current__", current2);
        LetChainBuilder lcbForLambda = new LetChainBuilder();
        if (count2 != null) {
            countlambda = new LambdaInstruction(lcbForLambda.packageUp(lcbForLambda.bind(this.xslt2Translator.compileNode(this.dvb, lcbForLambda, count2))), new Binding[]{new Binding((Object)current2, XDMItemType.s_itemType)}, true);
        } else {
            ExpandedTypeIDInstruction oldVarInst = new ExpandedTypeIDInstruction(this.xslt2Translator.makeStreamToCursorCall(this.dvb, lcbForLambda, lcbForLambda.bind(new IdentifierInstruction(originalCurrent))));
            ExpandedTypeIDInstruction varInst = new ExpandedTypeIDInstruction(this.xslt2Translator.makeStreamToCursorCall(this.dvb, lcbForLambda, lcbForLambda.bind(new IdentifierInstruction(current2))));
            countlambda = new LambdaInstruction(lcbForLambda.packageUp(new EqualityInstruction(lcbForLambda.bind(oldVarInst), lcbForLambda.bind(varInst), false)), new Binding[]{new Binding((Object)current2, XDMItemType.s_itemType)}, true);
        }
        this.dvb.bind("__current__", originalCurrent);
        Instruction countlambda2 = this.lcb.bind(countlambda);
        return countlambda2;
    }

    private Instruction makeStartNodeInstruction(Number number2) {
        Instruction startNode;
        if (number2.hasSelect()) {
            Expr selectExpr = number2.getSelect();
            Instruction x = this.xslt2Translator.compileNode(this.dvb, this.lcb, selectExpr);
            Instruction[] startNodeListOfOne = new Instruction[]{x};
            startNode = this.xslt2Translator.converter.makeRuntimeLibraryFunctionCall(this.dvb, this.lcb, "extract-singleton", startNodeListOfOne, "");
        } else {
            startNode = new IdentifierInstruction(this.dvb.lookup("__current__"));
        }
        return startNode;
    }

    private Instruction makeStringInstruction(Expr expr, String defaultValue, boolean isBCMode) {
        Instruction instruction2 = expr == null ? this.lcb.bind(StreamInstruction.charStreamLiteral(defaultValue)) : this.xslt2Translator.AVT2String(this.dvb, this.lcb, expr, isBCMode);
        return instruction2;
    }
}

