/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator.v2;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionCall;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Param;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.PathExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.StepExpr;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarCompiler;
import com.ibm.xltxe.rnm1.xtq.xml.types.ItemType;
import com.ibm.xltxe.rnm1.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.TypeConstants;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator2;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.FunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.PolymorphicFunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.SimpleFunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.TranslatorUtilities;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XPath2Translator;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ContextItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.XDMSequenceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSeqBaseType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.builders.DynamicVariableBuilder;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetBaseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StaticMethodInvocationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xml.xci.Cursor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class ParamTranslator {
    final XPath2Translator translator;

    public ParamTranslator(XPath2Translator translator) {
        this.translator = translator;
    }

    Instruction translateTypeAware(DynamicVariableBuilder dvb, LetChainBuilder lcb, Expr expression2, Instruction param, com.ibm.xltxe.rnm1.xylem.Type fArgType) {
        Instruction goodInstruction;
        com.ibm.xltxe.rnm1.xylem.Type preType = this.tryToResolveToType(lcb, param);
        if (preType != null && preType instanceof XDMItemType && fArgType != null && fArgType instanceof XDMItemType || preType != null && preType instanceof XDMSequenceType && fArgType != null && fArgType instanceof XDMSequenceType) {
            goodInstruction = param;
        } else if (this.typesAreLooslyEqual(preType, fArgType)) {
            goodInstruction = param;
        } else if (preType != null && preType instanceof XDMItemType && fArgType != null && fArgType instanceof XDMSequenceType) {
            param = this.ensureSafeForReduced(lcb, param);
            goodInstruction = lcb.bind(new XDMSequenceInstruction(param));
        } else if (preType != null && preType instanceof XDMSequenceType && fArgType != null && fArgType instanceof XDMItemType) {
            goodInstruction = lcb.bind(new ContextItemInstruction(param));
        } else if (preType == null && fArgType != null && fArgType instanceof XDMItemType) {
            if (expression2 != null) {
                OccurrenceIndicator occInd;
                Type astType = expression2.getTypeInference();
                OccurrenceIndicator occurrenceIndicator = occInd = astType != null ? astType.getQuantifier() : OccurrenceIndicator.ZERO_OR_MORE;
                goodInstruction = occInd == OccurrenceIndicator.ONE || occInd == OccurrenceIndicator.ZERO_OR_ONE ? (expression2.getId() == 102 ? param : lcb.bind(new ContextItemInstruction(param))) : (expression2.getId() == 82 ? param : this.wrapToSafeType(dvb, lcb, expression2, param, fArgType));
            } else {
                goodInstruction = param;
            }
        } else {
            goodInstruction = this.wrapWithSequenceCheck(dvb, lcb, expression2, param, fArgType, null);
        }
        return goodInstruction;
    }

    com.ibm.xltxe.rnm1.xylem.Type inferFILTypeFromParam(Param param) {
        XSequenceType asType = ASTDecorator2.getAsType(param);
        com.ibm.xltxe.rnm1.xylem.Type filArgType = asType != null ? this.inferFILTypeFromASTXDMSequenceType(asType) : XDMSequenceType.s_sequenceType;
        return filArgType;
    }

    private com.ibm.xltxe.rnm1.xylem.Type inferFILTypeFromASTXDMSequenceType(XSequenceType asType) {
        OccurrenceIndicator occuranceIndicator = asType.getQuantifier();
        XDMSeqBaseType filArgType = occuranceIndicator != null ? (occuranceIndicator == OccurrenceIndicator.ONE || occuranceIndicator == OccurrenceIndicator.ZERO_OR_ONE ? XDMItemType.s_itemType : XDMSequenceType.s_sequenceType) : XDMSequenceType.s_sequenceType;
        return filArgType;
    }

    private Instruction translateTypeAwareArg(DynamicVariableBuilder dvb, LetChainBuilder lcb, Expr expression2) {
        Instruction goodInstruction;
        com.ibm.xltxe.rnm1.xylem.Type fArgType = this.queryFILFunctionParamType(expression2);
        if (fArgType != null && fArgType instanceof XDMItemType) {
            com.ibm.xltxe.rnm1.xylem.Type preType;
            Type astType = expression2.getTypeInference();
            OccurrenceIndicator occInd = astType != null ? astType.getQuantifier() : OccurrenceIndicator.ZERO_OR_MORE;
            Instruction param = this.translator.translateExpression(dvb, lcb, expression2);
            goodInstruction = occInd == OccurrenceIndicator.ONE || occInd == OccurrenceIndicator.ZERO_OR_ONE ? (expression2.getId() == 102 ? param : this.wrapToSafeType(dvb, lcb, expression2, param, fArgType)) : (expression2.getId() == 82 ? param : ((preType = this.tryToResolveToType(lcb, param)) != null && preType instanceof XDMItemType ? param : this.wrapToSafeType(dvb, lcb, expression2, param, fArgType)));
        } else {
            goodInstruction = this.translator.translateExpression(dvb, lcb, expression2);
            com.ibm.xltxe.rnm1.xylem.Type fArgType2 = this.tryToResolveToType(lcb, goodInstruction);
            if (!this.typesAreLooslyEqual(fArgType2, fArgType) && (fArgType2 == null || fArgType2 instanceof XDMItemType) && fArgType instanceof XDMSequenceType) {
                goodInstruction = this.ensureSafeForReduced(lcb, goodInstruction);
                goodInstruction = lcb.bind(new XDMSequenceInstruction(goodInstruction));
            }
        }
        return goodInstruction;
    }

    Instruction translateTypeAwareArg(DynamicVariableBuilder dvb, LetChainBuilder lcb, Expr expression2, String filFunctionName, int paraIndex, int paraCount) {
        Instruction param = this.translator.translateExpression(dvb, lcb, expression2);
        Instruction goodInstruction = this.translateTypeAwareArg(dvb, lcb, expression2, filFunctionName, paraIndex, paraCount, param);
        return goodInstruction;
    }

    Instruction translateTypeAwareArg(DynamicVariableBuilder dvb, LetChainBuilder lcb, Expr expression2, String filFunctionName, int paraIndex, int paraCount, Instruction param) {
        Instruction goodInstruction;
        com.ibm.xltxe.rnm1.xylem.Type fArgType = this.queryFILFunctionParamType(filFunctionName, paraIndex, paraCount);
        if (fArgType != null && fArgType instanceof XDMItemType) {
            goodInstruction = this.translateTypeAware(dvb, lcb, expression2, param, fArgType);
        } else {
            goodInstruction = param;
            com.ibm.xltxe.rnm1.xylem.Type fArgType2 = this.tryToResolveToType(lcb, goodInstruction);
            if (!this.typesAreLooslyEqual(fArgType2, fArgType) && (fArgType2 == null || fArgType2 instanceof XDMItemType) && fArgType instanceof XDMSequenceType) {
                goodInstruction = this.ensureSafeForReduced(lcb, goodInstruction);
                goodInstruction = lcb.bind(new XDMSequenceInstruction(goodInstruction));
            }
        }
        return goodInstruction;
    }

    private Instruction ensureSafeForReduced(LetChainBuilder lcb, Instruction goodInstruction) {
        if (!(goodInstruction instanceof IdentifierInstruction) && !(goodInstruction instanceof LiteralInstruction)) {
            goodInstruction = lcb.bind(goodInstruction);
        }
        return goodInstruction;
    }

    Instruction wrapStep(DynamicVariableBuilder dvb, LetChainBuilder lcb, Instruction x) {
        return x;
    }

    public Instruction wrapToSafeType(DynamicVariableBuilder dvb, LetChainBuilder lcb, Expr expression2, Instruction param, com.ibm.xltxe.rnm1.xylem.Type fArgType) {
        com.ibm.xltxe.rnm1.xylem.Type preType = this.tryToResolveToType(lcb, param);
        return this.wrapToSafeType(dvb, lcb, param, fArgType, preType, SequenceToItemCheckType.NONE, null);
    }

    private Instruction wrapToSafeType(DynamicVariableBuilder dvb, LetChainBuilder lcb, Instruction param, com.ibm.xltxe.rnm1.xylem.Type fArgType, com.ibm.xltxe.rnm1.xylem.Type preType, SequenceToItemCheckType sequenceToItemCheckType, String opOrFuncStringForErrorReporting) {
        Instruction goodInstruction;
        if (this.typesAreLooslyEqual(preType, fArgType)) {
            goodInstruction = param;
        } else if (preType != null && preType instanceof XDMItemType && fArgType != null && fArgType instanceof XDMSequenceType) {
            param = this.ensureSafeForReduced(lcb, param);
            goodInstruction = lcb.bind(new XDMSequenceInstruction(param));
        } else if (preType != null && preType instanceof XDMSequenceType && fArgType != null && fArgType instanceof XDMItemType) {
            param = this.ensureSafeForReduced(lcb, param);
            switch (sequenceToItemCheckType) {
                case NONE: {
                    goodInstruction = lcb.bind(new ContextItemInstruction(param));
                    break;
                }
                case OPERATOR: {
                    Instruction opStringInstruction = lcb.bind(StreamInstruction.charStreamLiteral(opOrFuncStringForErrorReporting));
                    goodInstruction = lcb.bind(TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, "checkSequenceToOneItemOrEmptyForOperator", new Instruction[]{param, opStringInstruction}));
                    break;
                }
                case FO_FUNCTION: {
                    goodInstruction = lcb.bind(TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, "checkSequenceToOneItemOrEmpty", new Instruction[]{param}));
                    break;
                }
                default: {
                    goodInstruction = lcb.bind(new ContextItemInstruction(param));
                    break;
                }
            }
        } else if (preType == null && fArgType instanceof XDMSequenceType) {
            param = this.ensureSafeForReduced(lcb, param);
            goodInstruction = lcb.bind(new XDMSequenceInstruction(param));
        } else {
            goodInstruction = preType == null && fArgType instanceof XDMItemType ? this.wrapWithSequenceCheck(dvb, lcb, null, param, fArgType, null) : param;
        }
        return goodInstruction;
    }

    Instruction wrapToSafeType(DynamicVariableBuilder dvb, LetChainBuilder lcb, Instruction param, com.ibm.xltxe.rnm1.xylem.Type fArgType) {
        return this.wrapToSafeType(dvb, lcb, null, param, fArgType);
    }

    public Instruction wrapWithSequenceCheck(DynamicVariableBuilder dvb, LetChainBuilder lcb, Expr expr, Instruction n2, com.ibm.xltxe.rnm1.xylem.Type fArgType, Expr parentFunc) {
        Instruction result2;
        boolean isBCMode;
        String resultCheck;
        boolean mayNeedSorting = false;
        boolean isSimplePathExpr = false;
        Expr lastChildren = null;
        if (expr instanceof PathExpr) {
            PathExpr pathExpr = (PathExpr)expr;
            if (pathExpr.jjtGetNumChildren() > 1) {
                mayNeedSorting = true;
            }
            if ((lastChildren = pathExpr.getOperand(pathExpr.getOperandCount() - 1)) instanceof StepExpr && !((StepExpr)lastChildren).isFilterStep()) {
                isSimplePathExpr = true;
            }
        }
        String resultCheckParam = null;
        if (isSimplePathExpr) {
            if (fArgType instanceof XDMItemType) {
                resultCheck = XPath2Translator.CHECK_ALL_NODES_TO_ITEM;
                if (parentFunc != null) {
                    QName funcName = this.queryFunctionName(parentFunc);
                    String ns = funcName.getNamespaceURI();
                    resultCheckParam = ns != null ? "{" + ns + "}:" + funcName.getLocalPart() : funcName.getLocalPart();
                }
                resultCheckParam = "";
            } else {
                resultCheck = XPath2Translator.CHECK_ALL_NODES;
            }
        } else {
            resultCheck = fArgType instanceof XDMItemType ? XPath2Translator.CHECK_HOMOGENEOUS_NODES_OR_ATOMICS_TO_ITEM : XPath2Translator.CHECK_HOMOGENEOUS_NODES_OR_ATOMICS;
        }
        boolean bl = isBCMode = expr != null ? this.translator.isBCMode(expr) : this.translator.isBCMode();
        if (isBCMode && fArgType instanceof XDMItemType) {
            com.ibm.xltxe.rnm1.xylem.Type preType = this.tryToResolveToType(lcb, n2);
            if (!(preType instanceof XDMItemType)) {
                if (!mayNeedSorting) {
                    result2 = lcb.bind(new ContextItemInstruction(n2));
                } else {
                    result2 = lcb.bind(TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, "collate-sequence", new Instruction[]{n2}));
                    result2 = lcb.bind(new ContextItemInstruction(result2));
                }
            } else {
                result2 = n2;
            }
        } else {
            com.ibm.xltxe.rnm1.xylem.Type type2 = this.tryToResolveToType(lcb, n2);
            if (!(type2 instanceof XDMSequenceType)) {
                n2 = this.ensureSafeForReduced(lcb, n2);
                n2 = lcb.bind(new XDMSequenceInstruction(n2));
            }
            if (fArgType instanceof XDMItemType) {
                Instruction[] params = resultCheckParam != null ? new Instruction[]{n2, lcb.bind(StreamInstruction.charStreamLiteral(resultCheckParam))} : new Instruction[]{n2};
                result2 = lcb.bind(TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, resultCheck, params));
            } else {
                result2 = lcb.bind(TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, resultCheck, new Instruction[]{n2}));
            }
        }
        Instruction wrapper = this.wrapStep(dvb, lcb, result2);
        return wrapper;
    }

    QName queryFunctionName(Expr expr) {
        QName qname2 = null;
        Node parent2 = expr.jjtGetParent();
        if (parent2 != null && parent2 instanceof FunctionCall) {
            FunctionCall fci = (FunctionCall)parent2;
            qname2 = fci.getFunctionQName();
            assert (qname2 != null);
        }
        return qname2;
    }

    com.ibm.xltxe.rnm1.xylem.Type queryFILFunctionParamType(Expr expr) {
        com.ibm.xltxe.rnm1.xylem.Type argType = null;
        Node parent2 = expr.jjtGetParent();
        if (parent2 != null && parent2 instanceof FunctionCall) {
            FunctionCall fci = (FunctionCall)parent2;
            QName qname2 = fci.getFunctionQName();
            assert (qname2 != null);
            int arity = fci.getOperandCount();
            String filFunctionName = this.constructLibraryMethodName(qname2, arity);
            int argIndex = -1;
            for (int i = 0; i < arity; ++i) {
                if (expr != fci.getOperand(i)) continue;
                argIndex = i;
                break;
            }
            argType = this.queryFILFunctionParamType(filFunctionName, argIndex, arity);
        }
        return argType;
    }

    private com.ibm.xltxe.rnm1.xylem.Type queryFILFunctionParamType(String formName, int argIndex, int count2) {
        com.ibm.xltxe.rnm1.xylem.Type[] paramTypes;
        com.ibm.xltxe.rnm1.xylem.Type filArgType = null;
        FunctionSignature sig = this.getFunctionSignature(formName);
        if (sig != null && argIndex >= 0 && (paramTypes = sig.getParameterTypes()) != null) {
            filArgType = paramTypes[argIndex];
        }
        return filArgType;
    }

    private FunctionSignature getFunctionSignature(String formName) {
        ModuleSignature msig = this.getModuleSignature();
        FunctionSignature sig = msig.getFunctionSignature(formName);
        return sig;
    }

    private ModuleSignature getModuleSignature() {
        XPathCompiler compiler = this.getCompiler();
        assert (compiler != null);
        ModuleSignature msig = compiler.getRuntimeLibrary() == null ? compiler.getRuntimeLibrarySignature() : compiler.getRuntimeLibrary().m_signature;
        assert (msig != null);
        return msig;
    }

    private com.ibm.xltxe.rnm1.xylem.Type queryFILFunctionReturnType(String formName) {
        com.ibm.xltxe.rnm1.xylem.Type filArgType = null;
        FunctionSignature sig = this.getFunctionSignature(formName);
        if (sig != null) {
            filArgType = sig.getReturnType();
        }
        return filArgType;
    }

    private void parasAddItemAware(DynamicVariableBuilder dvb, LetChainBuilder lcb, ArrayList<Instruction> paras, Expr expression2) {
        Instruction goodInstruction = this.translateTypeAwareArg(dvb, lcb, expression2);
        paras.add(goodInstruction);
    }

    private void parasAddItemAware(DynamicVariableBuilder dvb, LetChainBuilder lcb, int paraIndex, int paraCount, ArrayList<Instruction> paras, Expr expression2, String filFunctionName) {
        Instruction goodInstruction = this.translateTypeAwareArg(dvb, lcb, expression2, filFunctionName, paraIndex, paraCount);
        paras.add(goodInstruction);
    }

    com.ibm.xltxe.rnm1.xylem.Type tryToResolveToType(LetChainBuilder lcb, Instruction param) {
        com.ibm.xltxe.rnm1.xylem.Type preType = param.getPreTypecheckType(this.getModuleSignature());
        if (preType == null) {
            if (param instanceof IdentifierInstruction || param instanceof LetBaseInstruction) {
                Instruction resolvedMaybe = lcb.tryToResolve(param);
                if (resolvedMaybe != null) {
                    preType = this.tryToResolveToType(lcb, resolvedMaybe);
                }
            } else if (param instanceof ChooseInstruction) {
                Instruction resolvedMaybe = ((ChooseInstruction)param).getDefaultHandler();
                if (resolvedMaybe == null) {
                    resolvedMaybe = ((ChooseInstruction)param).getChildInstruction(0);
                }
                if (resolvedMaybe != null) {
                    preType = this.tryToResolveToType(lcb, resolvedMaybe);
                }
            } else if (param instanceof ModuleFunctionCallInstruction) {
                ModuleFunctionCallInstruction mfci = (ModuleFunctionCallInstruction)param;
                String formName = mfci.getFunction();
                preType = this.queryFILFunctionReturnType(formName);
            }
        }
        return preType;
    }

    com.ibm.xltxe.rnm1.xylem.Type tryToResolveToType(LetChainBuilder lcb, Instruction instr, Expr expr) {
        return this.tryToResolveToType(lcb, instr);
    }

    public Instruction makeRuntimeLibraryFunctionCall(DynamicVariableBuilder dvb, LetChainBuilder lcb, String formName, Instruction[] parameters, String opOrFuncStringForErrorReporting) {
        boolean mightUseXDMItemVariant = false;
        com.ibm.xltxe.rnm1.xylem.Type[] argTypesMaybe = new com.ibm.xltxe.rnm1.xylem.Type[parameters.length];
        boolean foundSequence = false;
        for (int i = 0; i < parameters.length; ++i) {
            Instruction arg2 = parameters[i];
            com.ibm.xltxe.rnm1.xylem.Type argTypeMaybe = this.tryToResolveToType(lcb, arg2);
            if (!foundSequence) {
                if (argTypeMaybe instanceof XDMItemType) {
                    mightUseXDMItemVariant = true;
                } else if (argTypeMaybe instanceof XDMSequenceType) {
                    mightUseXDMItemVariant = false;
                    foundSequence = true;
                }
            }
            argTypesMaybe[i] = argTypeMaybe;
        }
        com.ibm.xltxe.rnm1.xylem.Type[] paramTypes = null;
        if (mightUseXDMItemVariant) {
            String itemVariantFormName = formName.concat("-item");
            FunctionSignature sig = this.getFunctionSignature(itemVariantFormName);
            if (sig != null) {
                paramTypes = sig.getParameterTypes();
                assert (paramTypes.length == argTypesMaybe.length);
                for (int i = 0; i < paramTypes.length; ++i) {
                    com.ibm.xltxe.rnm1.xylem.Type param = paramTypes[i];
                    if (this.typesAreLooslyEqual(param, argTypesMaybe[i])) continue;
                    mightUseXDMItemVariant = false;
                }
            } else {
                mightUseXDMItemVariant = false;
            }
            if (mightUseXDMItemVariant) {
                formName = itemVariantFormName;
            }
        }
        if (!mightUseXDMItemVariant) {
            FunctionSignature sig = this.getFunctionSignature(formName);
            assert (sig != null) : "Programmer Error!  Function Signature Not Found: " + formName;
            paramTypes = sig.getParameterTypes();
        }
        assert (paramTypes != null);
        assert (paramTypes.length == argTypesMaybe.length);
        SequenceToItemCheckType itemCheckType = this.inferSequenceToItemCheck(formName);
        for (int i = 0; i < paramTypes.length; ++i) {
            com.ibm.xltxe.rnm1.xylem.Type paramType = paramTypes[i];
            if (this.typesAreLooslyEqual(paramType, argTypesMaybe[i])) continue;
            parameters[i] = this.wrapToSafeType(dvb, lcb, parameters[i], paramType, argTypesMaybe[i], itemCheckType, opOrFuncStringForErrorReporting);
        }
        ModuleFunctionCallInstruction modFunCall = TranslatorUtilities.makeModuleFunctionCall((XStarCompiler)this.translator.getCompiler(), "xslt2", formName, parameters);
        return lcb.bind(modFunCall);
    }

    protected boolean typesAreLooslyEqual(com.ibm.xltxe.rnm1.xylem.Type param, com.ibm.xltxe.rnm1.xylem.Type argTypeMaybe) {
        if (param == null || argTypeMaybe == null) {
            return false;
        }
        return param.equals(argTypeMaybe);
    }

    public Instruction makeRuntimeLibraryFunctionCall(DynamicVariableBuilder dvb, LetChainBuilder lcb, String formName, List<Instruction> parameters, String opOrFuncStringForErrorReporting) {
        boolean mightUseXDMItemVariant = false;
        int paramSize = parameters.size();
        com.ibm.xltxe.rnm1.xylem.Type[] argTypesMaybe = new com.ibm.xltxe.rnm1.xylem.Type[paramSize];
        boolean foundSequence = false;
        for (int i = 0; i < paramSize; ++i) {
            Instruction arg2 = parameters.get(i);
            com.ibm.xltxe.rnm1.xylem.Type argTypeMaybe = this.tryToResolveToType(lcb, arg2);
            if (!foundSequence) {
                if (argTypeMaybe instanceof XDMItemType) {
                    mightUseXDMItemVariant = true;
                } else if (argTypeMaybe instanceof XDMSequenceType) {
                    mightUseXDMItemVariant = false;
                    foundSequence = true;
                }
            }
            argTypesMaybe[i] = argTypeMaybe;
        }
        com.ibm.xltxe.rnm1.xylem.Type[] paramTypes = null;
        if (mightUseXDMItemVariant) {
            String itemVariantFormName = formName.concat("-item");
            FunctionSignature sig = this.getFunctionSignature(itemVariantFormName);
            if (sig != null) {
                paramTypes = sig.getParameterTypes();
                assert (paramTypes.length == argTypesMaybe.length);
                for (int i = 0; i < paramTypes.length; ++i) {
                    com.ibm.xltxe.rnm1.xylem.Type param = paramTypes[i];
                    if (this.typesAreLooslyEqual(param, argTypesMaybe[i])) continue;
                    mightUseXDMItemVariant = false;
                }
            } else {
                mightUseXDMItemVariant = false;
            }
            if (mightUseXDMItemVariant) {
                formName = itemVariantFormName;
            }
        }
        if (!mightUseXDMItemVariant) {
            FunctionSignature sig = this.getFunctionSignature(formName);
            assert (sig != null) : "Programmer Error!  Function Signature Not Found: " + formName;
            paramTypes = sig.getParameterTypes();
        }
        assert (paramTypes != null);
        assert (paramTypes.length == argTypesMaybe.length);
        SequenceToItemCheckType itemCheckType = this.inferSequenceToItemCheck(formName);
        for (int i = 0; i < paramTypes.length; ++i) {
            com.ibm.xltxe.rnm1.xylem.Type paramType = paramTypes[i];
            if (this.typesAreLooslyEqual(paramType, argTypesMaybe[i])) continue;
            Instruction arg3 = parameters.get(i);
            Instruction argWrapped = this.wrapToSafeType(dvb, lcb, arg3, paramType, argTypesMaybe[i], itemCheckType, opOrFuncStringForErrorReporting);
            parameters.set(i, argWrapped);
        }
        ModuleFunctionCallInstruction modFunCall = TranslatorUtilities.makeModuleFunctionCall((XStarCompiler)this.translator.getCompiler(), "xslt2", formName, parameters);
        return lcb.bind(modFunCall);
    }

    private SequenceToItemCheckType inferSequenceToItemCheck(String formName) {
        SequenceToItemCheckType itemCheckType = formName.startsWith("fn:") ? SequenceToItemCheckType.FO_FUNCTION : (formName.startsWith("op:") ? SequenceToItemCheckType.OPERATOR : SequenceToItemCheckType.NONE);
        return itemCheckType;
    }

    Instruction generateFNDataFunctionCall(DynamicVariableBuilder dvb, LetChainBuilder lcb, Instruction n2) {
        return this.makeRuntimeLibraryFunctionCall(dvb, lcb, "fn:data", new Instruction[]{n2}, "");
    }

    Instruction generateFNStringFunctionCall(DynamicVariableBuilder dvb, LetChainBuilder lcb, Instruction n2) {
        return this.makeRuntimeLibraryFunctionCall(dvb, lcb, "fn:string-2", new Instruction[]{n2, new IdentifierInstruction("__contextposition__"), new IdentifierInstruction("__dom__")}, "");
    }

    Instruction generateProperFNStringFunctionCall(DynamicVariableBuilder dvb, LetChainBuilder lcb, Instruction n2, Module p) {
        return this.makeRuntimeLibraryFunctionCall(dvb, lcb, "fn:string-2", new Instruction[]{n2, new IdentifierInstruction("__contextposition__")}, "");
    }

    Instruction generateFNBooleanFunctionCall(DynamicVariableBuilder dvb, LetChainBuilder lcb, Instruction n2) {
        return this.makeRuntimeLibraryFunctionCall(dvb, lcb, "fn:boolean-1", new Instruction[]{n2, new IdentifierInstruction("__dom__")}, "");
    }

    Instruction generateEffectiveBooleanValueFunctionCall(DynamicVariableBuilder dvb, LetChainBuilder lcb, Instruction n2) {
        return this.makeRuntimeLibraryFunctionCall(dvb, lcb, "effective-boolean-value", new Instruction[]{n2}, "");
    }

    Instruction generateValueOfFunctionCall(DynamicVariableBuilder dvb, LetChainBuilder lcb, Instruction n2, Instruction separator, boolean createIfEmpty) {
        return this.makeRuntimeLibraryFunctionCall(dvb, lcb, "value-of", new Instruction[]{n2, separator, LiteralInstruction.booleanLiteral(createIfEmpty)}, "");
    }

    public Instruction generateCreateStringFunctionCall(DynamicVariableBuilder dvb, LetChainBuilder lcb, Instruction n2, Instruction separator) {
        return this.makeRuntimeLibraryFunctionCall(dvb, lcb, "create-string", new Instruction[]{n2, separator}, "");
    }

    public Instruction generateToStringFunctionCall(DynamicVariableBuilder dvb, LetChainBuilder lcb, Instruction n2) {
        return this.makeRuntimeLibraryFunctionCall(dvb, lcb, "to-string", new Instruction[]{n2}, "");
    }

    Instruction convertArgForBackwardCompatibility(DynamicVariableBuilder dvb, LetChainBuilder lcb, Instruction instr, XSequenceType expectedType, com.ibm.xltxe.rnm1.xylem.Type fArgType) {
        OccurrenceIndicator quantifier = expectedType.getQuantifier();
        if (quantifier == OccurrenceIndicator.ONE || quantifier == OccurrenceIndicator.ZERO_OR_ONE) {
            ArrayList<Instruction> params = new ArrayList<Instruction>();
            ItemType baseType = expectedType.getBaseType();
            if (fArgType instanceof XDMItemType) {
                String typeString = "";
                com.ibm.xltxe.rnm1.xylem.Type certainValueType = this.tryToResolveToType(lcb, instr);
                if (certainValueType != null && certainValueType instanceof XDMItemType) {
                    params.add(instr);
                    if (baseType == TypeConstants.STRING) {
                        instr = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, "applyStringBackwardCompatibilityRuleFromItemToItem", params);
                    } else if (baseType == TypeConstants.DOUBLE) {
                        instr = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, "applyDoubleBackwardCompatibilityRuleFromItemToItem", params);
                    } else if (typeString == "") {
                        // empty if block
                    }
                } else if (baseType == TypeConstants.STRING) {
                    instr = this.ensureSafeForReduced(lcb, instr);
                    params.add(lcb.bind(new XDMSequenceInstruction(instr)));
                    instr = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, "applyStringBackwardCompatibilityRuleToItem", params);
                } else if (baseType == TypeConstants.DOUBLE) {
                    instr = this.ensureSafeForReduced(lcb, instr);
                    params.add(lcb.bind(new XDMSequenceInstruction(instr)));
                    instr = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, "applyDoubleBackwardCompatibilityRuleToItem", params);
                } else if (typeString == "") {
                    instr = this.ensureSafeForReduced(lcb, instr);
                    params.add(lcb.bind(new XDMSequenceInstruction(instr)));
                    instr = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, "applyBackwardCompatibilityRuleToItem", params);
                }
            } else {
                params.add(instr);
                String typeString = "";
                if (baseType == TypeConstants.STRING) {
                    instr = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, "applyStringBackwardCompatibilityRule", params);
                } else if (baseType == TypeConstants.DOUBLE) {
                    instr = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, "applyDoubleBackwardCompatibilityRule", params);
                } else if (typeString == "") {
                    instr = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, "applyBackwardCompatibilityRule", params);
                }
            }
        }
        return instr;
    }

    Instruction[] convertArgsToJava(FunctionCall function2, Class<?>[] paramTypes, ArrayList<Type> argsType, int argOffset, DynamicVariableBuilder dvb, LetChainBuilder lcb) {
        int numArgs = function2.getOperandCount();
        Instruction[] parameters = new Instruction[paramTypes.length];
        int i = argOffset;
        int j = 0;
        while (i < numArgs) {
            Expr operand2 = function2.getOperand(i);
            Class<?> paramType = paramTypes[j];
            Instruction instruction2 = this.translator.translateExpression(dvb, lcb, operand2);
            Type argType = argsType != null ? argsType.get(j) : null;
            instruction2 = this.convertToJava(instruction2, paramType, argType, lcb);
            parameters[j] = lcb.bind(instruction2);
            ++i;
            ++j;
        }
        return parameters;
    }

    Instruction convertArgsToXSLTObjectStream(FunctionCall function2, DynamicVariableBuilder dvb, LetChainBuilder lcb) {
        int numArgs = function2.getOperandCount();
        Instruction[] parameters = new Instruction[numArgs];
        int i = 0;
        int j = 0;
        while (i < numArgs) {
            Expr operand2 = function2.getOperand(i);
            parameters[j] = lcb.bind(new XDMSequenceInstruction(this.translator.translateExpression(dvb, lcb, operand2)));
            ++i;
            ++j;
        }
        StreamInstruction stream2 = new StreamInstruction((com.ibm.xltxe.rnm1.xylem.Type)XDMSequenceType.s_sequenceType, parameters);
        return lcb.bind(stream2);
    }

    void convertArgumentsForBackwardCompatibility(DynamicVariableBuilder dvb, LetChainBuilder lcb, FunctionCall fci, ArrayList<Instruction> paras) {
        QName qname2 = fci.getFunctionQName();
        int arity = fci.getOperandCount();
        String filFunctionName = this.constructLibraryMethodName(qname2, arity);
        this.convertArgumentsForBackwardCompatibility(dvb, lcb, fci, paras, qname2, arity, filFunctionName);
    }

    private void convertArgumentsForBackwardCompatibility(DynamicVariableBuilder dvb, LetChainBuilder lcb, FunctionCall fci, ArrayList<Instruction> paras, QName qname2, int arity, String filFunctionName) {
        FunctionDeclaration functionObject = this.getCompiler().getFunctionDeclarationFromSignature(qname2, arity);
        if (functionObject instanceof SimpleFunctionDeclaration) {
            for (int i = 0; i < arity; ++i) {
                Expr expression2 = fci.getOperand(i);
                Instruction param = this.translator.translateExpression(dvb, lcb, expression2);
                Instruction instr = this.translateTypeAwareArg(dvb, lcb, expression2, filFunctionName, i, arity, param);
                com.ibm.xltxe.rnm1.xylem.Type fArgType = this.queryFILFunctionParamType(expression2);
                XSequenceType expectedType = functionObject.getArgumentType(i);
                paras.add(this.convertArgForBackwardCompatibility(dvb, lcb, instr, expectedType, fArgType));
            }
        } else if (functionObject instanceof PolymorphicFunctionDeclaration) {
            for (int i = 0; i < arity; ++i) {
                Expr expression3 = fci.getOperand(i);
                Instruction instr = this.translator.translateExpression(dvb, lcb, expression3);
                instr = this.translateTypeAwareArg(dvb, lcb, expression3, filFunctionName, i, arity, instr);
                SimpleFunctionDeclaration[] temp = new SimpleFunctionDeclaration[((PolymorphicFunctionDeclaration)functionObject).getNumberOfDeclarations()];
                for (int j = 0; j < temp.length; ++j) {
                    SimpleFunctionDeclaration decl = ((PolymorphicFunctionDeclaration)functionObject).getDeclarationEntry(j);
                    XSequenceType expectedType = decl.getArgumentType(0);
                    if (!expectedType.getBaseType().getQName().getLocalPart().equalsIgnoreCase("double")) continue;
                    com.ibm.xltxe.rnm1.xylem.Type fArgType = this.queryFILFunctionParamType(expression3);
                    paras.add(this.convertArgForBackwardCompatibility(dvb, lcb, instr, expectedType, fArgType));
                }
            }
        } else {
            for (int i = 0; i < arity; ++i) {
                Expr expression4 = fci.getOperand(i);
                paras.add(this.translateTypeAwareArg(dvb, lcb, expression4));
            }
        }
    }

    private Instruction convertToJava(Instruction instruction2, Class<?> javaType, Type argType, LetChainBuilder lcb) {
        instruction2 = this.convertToXylem(instruction2, javaType, argType, lcb);
        if (javaType.isAssignableFrom(Cursor.class)) {
            return instruction2;
        }
        com.ibm.xltxe.rnm1.xylem.Type type2 = XPath2Translator.convertJavaTypeToXylemType(javaType);
        instruction2 = lcb.bind(new CoerceInstruction(instruction2, type2));
        return instruction2;
    }

    private Instruction convertToXylem(Instruction instruction2, Class<?> javaType, Type argType, LetChainBuilder lcb) {
        if (NodeIterator.class.isAssignableFrom(javaType) || NodeList.class.isAssignableFrom(javaType) || org.w3c.dom.Node.class.isAssignableFrom(javaType)) {
            return lcb.bind(new CoerceInstruction(instruction2, XDMItemType.s_itemType));
        }
        if (String.class.isAssignableFrom(javaType)) {
            return lcb.bind(new CoerceInstruction(instruction2, CharType.s_charType.getStreamType()));
        }
        if (Boolean.class.isAssignableFrom(javaType) || javaType == Boolean.TYPE) {
            if (argType == TypeConstants.BOOLEAN) {
                return lcb.bind(TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this.getCompiler(), lcb, "stream-to-boolean", new Instruction[]{lcb.bind(new XDMSequenceInstruction(instruction2))}));
            }
            return lcb.bind(new CoerceInstruction(instruction2, BooleanType.s_booleanType));
        }
        if (Character.class.isAssignableFrom(javaType) || javaType == Character.TYPE) {
            return lcb.bind(new StaticMethodInvocationInstruction("com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeLibrary", "cursorToChar", new Instruction[]{instruction2}, CharType.s_charType));
        }
        if (Number.class.isAssignableFrom(javaType) || javaType.isPrimitive()) {
            return lcb.bind(new CoerceInstruction(instruction2, DoubleType.s_doubleType));
        }
        if (DocumentFragment.class.isAssignableFrom(javaType)) {
            return lcb.bind(new CoerceInstruction(instruction2, XDMItemType.s_itemType));
        }
        if (Cursor.class.isAssignableFrom(javaType)) {
            return lcb.bind(new CoerceInstruction(instruction2, XDMSequenceType.s_sequenceType));
        }
        return instruction2;
    }

    private String constructLibraryMethodName(QName qname2, int arity) {
        String filFunctionName;
        String uri2 = qname2.getNamespaceURI();
        String prefix2 = qname2.getPrefix();
        if (prefix2 == null || prefix2.length() == 0) {
            if (uri2 != null && uri2.length() > 0) {
                if (uri2.equals("http://www.w3.org/2005/xpath-functions")) {
                    filFunctionName = "fn:" + qname2.getLocalPart();
                } else if (uri2.equals("http://xtqhp")) {
                    filFunctionName = qname2.getLocalPart();
                } else {
                    assert (false) : "no prefix or known uri";
                    filFunctionName = qname2.getLocalPart();
                }
            } else {
                filFunctionName = qname2.getPrefix() + ":" + qname2.getLocalPart();
            }
        } else {
            filFunctionName = qname2.getPrefix() + ":" + qname2.getLocalPart();
        }
        int functionRealArity = filFunctionName.equals("fn:lang") ? arity + 1 : arity;
        filFunctionName = filFunctionName + "-" + functionRealArity;
        return filFunctionName;
    }

    private XPathCompiler getCompiler() {
        return this.translator.getCompiler();
    }

    static enum SequenceToItemCheckType {
        NONE,
        OPERATOR,
        FO_FUNCTION;

    }
}

