/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator.v2;

import com.ibm.xltxe.rnm1.xtq.Constants;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CollationElement;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DecimalFormatting;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Key;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Output;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableBase;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Whitespace;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.Mode;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.WhitespaceHelper;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XSLT2Translator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import javax.xml.namespace.QName;

public class Stylesheet2Helper
implements Constants {
    public static void processModes(XTQProgram stylesheet, XSLT2Translator translator) {
        Mode defaultMode = ASTDecorator.getStylesheetDefaultMode(stylesheet);
        if (defaultMode == null) {
            defaultMode = new Mode(null, translator, stylesheet, "");
            ASTDecorator.setStylesheetDefaultMode(stylesheet, defaultMode);
        } else {
            defaultMode.setTranslator(translator);
        }
        Hashtable<String, Key> keys2 = stylesheet.getKeys();
        boolean isBCMode = stylesheet.isBackwardsCompatibilityMode(translator.getStaticContext().getLanguage());
        int v = 2;
        if (isBCMode) {
            v = 1;
        }
        defaultMode.processPatterns(keys2, v);
        Enumeration modes = ASTDecorator.getStylesheetModes(stylesheet).elements();
        while (modes.hasMoreElements()) {
            Mode mode = (Mode)modes.nextElement();
            mode.setTranslator(translator);
            mode.processPatterns(keys2, v);
        }
    }

    protected static void compileModes(XTQProgram stylesheet, XSLT2Translator translator) {
        Mode defaultMode = ASTDecorator.getStylesheetDefaultMode(stylesheet);
        translator.setCurrentModeName(defaultMode.getModeName());
        defaultMode.compileApplyTemplates();
        Enumeration modes = ASTDecorator.getStylesheetModes(stylesheet).elements();
        while (modes.hasMoreElements()) {
            Mode mode = (Mode)modes.nextElement();
            translator.setCurrentModeName(mode.getModeName());
            mode.compileApplyTemplates();
        }
    }

    protected static void compileTransform(XSLT2Translator translator, XTQProgram stylesheet) {
        if (stylesheet.jjtGetNumChildren() > 0) {
            Stylesheet2Helper.compileTopLevel(translator, stylesheet);
        }
        Stylesheet2Helper.compileBuildKeys(translator, stylesheet);
    }

    protected static void compileConstructor(XSLT2Translator translator, XTQProgram stylesheet, Output output) {
        if (output != null) {
            translator.output(output);
        }
        if (stylesheet.isNumberFormattingUsed()) {
            // empty if block
        }
    }

    private static void compileBuildKeys(XSLT2Translator translator, XTQProgram stylesheet) {
        int count2 = stylesheet.jjtGetNumChildren();
        Hashtable<String, Key> keys2 = stylesheet.getKeys();
        Hashtable<String, LinkedList> newKeys = new Hashtable<String, LinkedList>();
        for (int i = 0; i < count2; ++i) {
            Node element2 = stylesheet.jjtGetChild(i);
            if (!(element2 instanceof Key)) continue;
            Key key2 = (Key)element2;
            String keyName = key2.getQName().toString();
            String collation2 = key2.getCollation();
            if (collation2 == null) {
                key2.setCollation(key2.getDefaultCollationURI(translator.getParser()));
            } else {
                ErrorMsg err;
                try {
                    String absoluteCollation = SystemIDResolver.isAbsoluteURI(collation2) ? collation2 : SystemIDResolver.getAbsoluteURI(collation2, key2.getBaseURI());
                    if (!translator.getStaticContext().collationURIRecognized(absoluteCollation)) {
                        err = new ErrorMsg("KEY_COLLATION_URI_ERR", (Object)collation2, (SimpleNode)key2);
                        translator.getParser().reportError(3, err);
                    }
                }
                catch (Exception e) {
                    err = new ErrorMsg("KEY_COLLATION_URI_ERR", (Object)collation2, (SimpleNode)key2);
                    translator.getParser().reportError(3, err);
                }
            }
            Key oldKey = keys2.get(keyName);
            if (oldKey != null) {
                String oldCollation = oldKey.getCollation();
                if (oldCollation != null && collation2 != null && !oldCollation.equals(collation2)) {
                    ErrorMsg err = new ErrorMsg("KEY_COLLATION_ATTR_REDEF_ERR", key2, true);
                    translator.getParser().reportError(3, err);
                    return;
                }
                Expr e1 = key2.getUse();
                String use = e1 != null ? e1.getXQueryString(false) : key2.getTextKeySpecifier();
                Expr e2 = oldKey.getUse();
                String oldUse = e2 != null ? e2.getXQueryString(false) : oldKey.getTextKeySpecifier();
                String match = key2.getMatch().getXQueryString(false);
                String oldMatch = oldKey.getMatch().getXQueryString(false);
                if (use != null && oldUse != null && use.equals(oldUse) && match.equals(oldMatch)) continue;
            }
            keys2.put(keyName, key2);
            LinkedList list = newKeys.containsKey(keyName) ? (LinkedList)newKeys.get(keyName) : new LinkedList();
            list.add(key2);
            newKeys.put(keyName, list);
        }
        for (String keyName : newKeys.keySet()) {
            LinkedList list = (LinkedList)newKeys.get(keyName);
            translator.key(stylesheet, keyName, list);
        }
    }

    private static void compileTopLevel(XSLT2Translator translator, XTQProgram stylesheet) {
        String defaultName;
        XStaticContext context2 = translator.getParser().getStaticContext();
        Vector whitespaceRules = new Vector();
        int n2 = stylesheet.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            Node element2 = stylesheet.jjtGetChild(i);
            if (element2 instanceof DecimalFormatting) {
                translator.decimalFormat((DecimalFormatting)element2);
                continue;
            }
            if (!(element2 instanceof Whitespace)) continue;
            whitespaceRules.addAll(WhitespaceHelper.getRules((Whitespace)element2));
        }
        String[] names = context2.getCollationElementNames();
        if (names.length > 0) {
            for (int idx = 0; idx < names.length; ++idx) {
                String uri2 = names[idx];
                CollationElement element3 = context2.getCollationElement(uri2);
                translator.collatorDeclaration(element3);
            }
        }
        if ((defaultName = context2.getDefaultCollationName()) != null) {
            // empty if block
        }
        if (whitespaceRules.size() > 0) {
            translator.addWhitespaceRules(whitespaceRules);
        }
        if (!translator.isXQuery()) {
            translator.commitDecimalFormats();
        }
    }

    private static void compileVariable(XSLT2Translator translator, XTQProgram stylesheet, VariableBase var) {
    }

    public static Mode getMode(XTQProgram stylesheet, QName modeName, XSLT2Translator translator) {
        if (modeName == null || modeName.getLocalPart().equals("#default")) {
            Mode defaultMode = ASTDecorator.getStylesheetDefaultMode(stylesheet);
            if (defaultMode == null) {
                defaultMode = new Mode(null, translator, stylesheet, "");
                ASTDecorator.setStylesheetDefaultMode(stylesheet, defaultMode);
            }
            return defaultMode;
        }
        Hashtable modes = ASTDecorator.getStylesheetModes(stylesheet);
        Mode mode = (Mode)modes.get(modeName);
        if (mode == null) {
            int nextModeSerial = ASTDecorator.getStylesheetNextModeSerial(stylesheet);
            String suffix2 = Integer.toString(nextModeSerial);
            ASTDecorator.setStylesheetNextModeSerial(stylesheet, ++nextModeSerial);
            mode = new Mode(modeName, translator, stylesheet, suffix2);
            modes.put(modeName, mode);
        }
        return mode;
    }
}

