/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.typechecker;

import com.ibm.xltxe.rnm1.xtq.Constants;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Param;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VarDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableBase;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.exec.XTQStaticContext;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.VisitorBase;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2.CircularReferenceHandler;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.namespace.QName;

public abstract class TypeCheckerBase
extends VisitorBase
implements Constants {
    protected XPathCompiler _compiler;
    protected XSLTParser _parser;
    protected XTQStaticContext _staticContext;
    protected Hashtable<QName, Object> _variableScope;
    protected CircularReferenceHandler _circRefs;
    private Stack<TypeCheckerContext> _contextStack = new Stack();

    protected TypeCheckerBase(XPathCompiler compiler) {
        this._compiler = compiler;
        this._parser = compiler.getParser();
        this._staticContext = compiler.getStaticContext();
        this._variableScope = new Hashtable();
        this._circRefs = new CircularReferenceHandler();
    }

    public XPathCompiler getCompiler() {
        return this._compiler;
    }

    public XSLTParser getParser() {
        return this._parser;
    }

    public void addVariable(VarDecl var) {
        this.addVariableOrParam(var);
    }

    public void addParameter(Param param) {
        this.addVariableOrParam(param);
    }

    private void addVariableOrParam(VariableBase var) {
        Object existing = this._variableScope.get(var.getQName());
        if (existing != null) {
            if (existing instanceof Stack) {
                Stack stack = (Stack)existing;
                stack.push(var);
            } else if (existing instanceof VariableBase) {
                Stack<Object> stack = new Stack<Object>();
                stack.push(existing);
                stack.push(var);
                this._variableScope.put(var.getQName(), stack);
            }
        } else {
            this._variableScope.put(var.getQName(), var);
        }
    }

    public void removeVariable(QName name2) {
        Object existing = this._variableScope.get(name2);
        if (existing instanceof Stack) {
            Stack stack = (Stack)existing;
            if (!stack.isEmpty()) {
                stack.pop();
            }
            if (!stack.isEmpty()) {
                return;
            }
        }
        this._variableScope.remove(name2);
    }

    public VariableBase lookupVariable(QName name2) {
        Object existing = this._variableScope.get(name2);
        if (existing instanceof VariableBase) {
            return (VariableBase)existing;
        }
        if (existing instanceof Stack) {
            Stack stack = (Stack)existing;
            return (VariableBase)stack.peek();
        }
        return null;
    }

    protected QName updateScope(Expr node2) {
        if (node2 instanceof VarDecl) {
            VarDecl var = (VarDecl)node2;
            this.addVariable(var);
            if (var.getAt() != null) {
                this.updateScope(var.getAt());
            }
            return var.getQName();
        }
        if (node2 instanceof Param) {
            Param param = (Param)node2;
            this.addParameter(param);
            return param.getQName();
        }
        return null;
    }

    public void startContext(Expr expr) {
        this._contextStack.push(new TypeCheckerContext(this._parser, this._staticContext, this._variableScope));
        XTQProgram program = expr.getXTQProgram();
        this._parser = program.getParser();
        this._staticContext = (XTQStaticContext)program.getStaticContext();
        this._variableScope = this._staticContext.getVariableScope();
        if (this._variableScope == null) {
            this._variableScope = new Hashtable();
            this.setupGlobals();
            this._staticContext.saveVariableScope(this._variableScope);
        }
    }

    public void endContext() {
        TypeCheckerContext context2 = this._contextStack.pop();
        this._parser = context2._parser;
        this._staticContext = context2._staticContext;
        this._variableScope = context2._variableScope;
    }

    protected void setupGlobals() {
    }

    private class TypeCheckerContext {
        public XSLTParser _parser;
        public XTQStaticContext _staticContext;
        public Hashtable<QName, Object> _variableScope;

        public TypeCheckerContext(XSLTParser parser, XTQStaticContext staticContext, Hashtable<QName, Object> variableScope) {
            this._parser = parser;
            this._staticContext = staticContext;
            this._variableScope = variableScope;
        }
    }
}

