/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.AttributeSet;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionCall;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.UseAttributeSets;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableBase;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator2;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.TypeCheckError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class CircularReferenceHandler {
    private IdentityHashMap<Expr, Expr> fGlobals = new IdentityHashMap();
    private Expr fCurrent = null;
    private QName fCurrentQName = null;
    private final HashMap<QName, Expr> fExprMap = new HashMap();
    private HashSet<QName> fDeclsThatInvokeApplyTemplates;
    private HashMap<QName, Set<QName>> fDeclsThatInvokeKey;
    private HashMap<QName, HashSet<QName>> fAttrGroupsUsedByVars = null;
    private HashMap<QName, HashSet<QName>> fAttrGroupsUsedByKeys = null;
    private HashSet<Expr> fVarsReferenced = new HashSet();
    private LinkedList<Expr> fVariableStack = new LinkedList();
    private HashMap<QName, HashSet<Expr>> fVarsReferencedMap = null;
    private HashSet<QName> fKeysBeingDefined;
    private boolean fInTemplateMatch;
    private HashSet<VariableBase> fVarsInTemplateMatch;
    private HashSet<QName> fVarsInKeyMatchOrUse;
    private HashMap<QName, HashSet<VariableBase>> fVarsRefferedByAttrs = null;
    private HashSet<VariableBase> fVarsUsedInAttributeSet = null;
    private HashMap<QName, Set<QName>> fKeysRefferedByAttrs = null;
    private HashMap<QName, Set<QName>> fKeysUsedInAttributeUse = null;
    private HashMap<QName, FunctionCall> fKeyMap = null;
    private HashMap<QName, HashSet<QName>> fAttributeSetUsage = null;

    public void addGlobals(Collection<Expr> globals) {
        for (Expr expr : globals) {
            this.fGlobals.put(expr, expr);
        }
    }

    public void setCurrent(Expr n2, QName name2) {
        this.fCurrent = n2;
        this.fCurrentQName = name2;
        if (n2 != null) {
            if (n2 instanceof VariableBase) {
                this.fVarsReferenced.add(n2);
            }
            this.fExprMap.put(this.fCurrentQName, this.fCurrent);
        }
        if (n2 instanceof VariableBase) {
            this.fVariableStack.add(n2);
        }
    }

    public void endCurrent(Expr n2) {
        if (this.fCurrent == n2) {
            if (this.fVarsReferenced != null) {
                if (this.fVarsReferencedMap == null) {
                    this.fVarsReferencedMap = new HashMap();
                }
                if (this.fCurrentQName != null) {
                    this.fVarsReferencedMap.put(this.fCurrentQName, this.fVarsReferenced);
                }
                this.fVarsReferenced = new HashSet();
            }
            this.fVariableStack.clear();
        }
    }

    public void applyTemplates() {
        if (this.fCurrentQName == null) {
            return;
        }
        if (this.fDeclsThatInvokeApplyTemplates == null) {
            this.fDeclsThatInvokeApplyTemplates = new HashSet();
        }
        this.fDeclsThatInvokeApplyTemplates.add(this.fCurrentQName);
    }

    private QName keyName(FunctionCall function2) {
        Expr name2 = function2.getOperand(0);
        if (name2 != null) {
            return ASTDecorator2.getResolvedQNameArgument(name2);
        }
        return null;
    }

    public void keyCall(FunctionCall function2) {
        Set<QName> keys2;
        if (this.fCurrentQName == null) {
            return;
        }
        if (this.fKeyMap == null) {
            this.fKeyMap = new HashMap();
        }
        if (this.fDeclsThatInvokeKey == null) {
            this.fDeclsThatInvokeKey = new HashMap();
        }
        if ((keys2 = this.fDeclsThatInvokeKey.get(this.fCurrentQName)) == null) {
            keys2 = new HashSet<QName>();
            this.fDeclsThatInvokeKey.put(this.fCurrentQName, keys2);
        }
        QName keyName = this.keyName(function2);
        this.fKeyMap.put(keyName, function2);
        keys2.add(keyName);
        if (this.fKeysBeingDefined != null && this.fKeysBeingDefined.contains(keyName)) {
            function2.isCircularlyDefined();
        }
        if (this.inAttributeSet()) {
            Set<QName> keysUsed = this.fKeysUsedInAttributeUse.get(keyName);
            if (keysUsed == null) {
                keysUsed = new HashSet<QName>();
                this.fKeysUsedInAttributeUse.put(keyName, keysUsed);
            }
            keysUsed.add(function2.getQName());
        }
    }

    public void templatePrologue() {
        this.fInTemplateMatch = true;
    }

    public void templateEpilogue() {
        this.fInTemplateMatch = false;
    }

    public boolean startVariableReference(VariableBase var) {
        if (this.fGlobals != null && this.fGlobals.containsKey(var)) {
            if (this.fVariableStack.contains(var)) {
                var.isCircularlyDefined();
                return false;
            }
            this.fVariableStack.add(var);
            this.updateForVariableReference(var);
        }
        return true;
    }

    public void endVariableReference(VariableBase var) {
        if (this.fGlobals != null && this.fGlobals.containsKey(var) && this.fVariableStack.size() > 0 && this.fVariableStack.getLast() == var) {
            this.fVariableStack.removeLast();
        }
    }

    public void updateForVariableReference(VariableBase var) {
        this.fVarsReferenced.add(var);
        if (this.fInTemplateMatch) {
            if (this.fVarsInTemplateMatch == null) {
                this.fVarsInTemplateMatch = new HashSet();
            }
            this.fVarsInTemplateMatch.add(var);
        } else if (this.fKeysBeingDefined != null && !this.fKeysBeingDefined.isEmpty()) {
            if (this.fVarsInKeyMatchOrUse == null) {
                this.fVarsInKeyMatchOrUse = new HashSet();
            }
            this.fVarsInKeyMatchOrUse.add(var.getQName());
        }
        if (this.inAttributeSet()) {
            this.fVarsUsedInAttributeSet.add(var);
        }
    }

    public void useAnalyzedNode(QName qname2) {
        HashSet<Expr> refs;
        if (this.fVarsReferencedMap != null && (refs = this.fVarsReferencedMap.get(qname2)) != null) {
            for (Expr e : refs) {
                this.updateForVariableReference((VariableBase)e);
            }
        }
        if (this.inAttributeSet()) {
            HashSet<VariableBase> vars;
            if (this.fVarsRefferedByAttrs != null && (vars = this.fVarsRefferedByAttrs.get(qname2)) != null) {
                this.fVarsUsedInAttributeSet.addAll(vars);
            }
            if (this.fDeclsThatInvokeKey.containsKey(qname2)) {
                Set<QName> keys2 = this.fKeysUsedInAttributeUse.get(qname2);
                if (keys2 == null) {
                    keys2 = new HashSet<QName>();
                    this.fKeysUsedInAttributeUse.put(qname2, keys2);
                }
                keys2.addAll((Collection<QName>)this.fDeclsThatInvokeKey.get(qname2));
            }
        } else {
            if (this.fDeclsThatInvokeApplyTemplates != null && this.fDeclsThatInvokeApplyTemplates.contains(qname2)) {
                this.fDeclsThatInvokeApplyTemplates.add(this.fCurrentQName);
            }
            if (this.fDeclsThatInvokeKey != null && this.fDeclsThatInvokeKey.containsKey(qname2)) {
                this.fDeclsThatInvokeKey.put(this.fCurrentQName, this.fDeclsThatInvokeKey.get(qname2));
            }
        }
    }

    public void attributeSetPrologue(UseAttributeSets useSets) {
        List<QName> list;
        this.fVarsUsedInAttributeSet = new HashSet();
        this.fKeysUsedInAttributeUse = new HashMap();
        if (useSets != null && (list = useSets.getReferenceSets()) != null && list.size() != 0) {
            HashSet<QName> attrSetsUsed;
            if (this.fAttributeSetUsage == null) {
                this.fAttributeSetUsage = new HashMap();
                attrSetsUsed = new HashSet();
                this.fAttributeSetUsage.put(this.fCurrentQName, attrSetsUsed);
            } else {
                attrSetsUsed = this.fAttributeSetUsage.get(this.fCurrentQName);
                if (attrSetsUsed == null) {
                    attrSetsUsed = new HashSet();
                    this.fAttributeSetUsage.put(this.fCurrentQName, attrSetsUsed);
                }
            }
            attrSetsUsed.addAll(list);
        }
    }

    public void attributeSetEpilogue(AttributeSet attributeSet) {
        if (!this.fVarsUsedInAttributeSet.isEmpty()) {
            if (this.fVarsRefferedByAttrs == null) {
                this.fVarsRefferedByAttrs = new HashMap();
            }
            this.fVarsRefferedByAttrs.put(attributeSet.getQName(), this.fVarsUsedInAttributeSet);
        }
        this.fVarsUsedInAttributeSet = null;
        if (!this.fKeysUsedInAttributeUse.isEmpty()) {
            if (this.fKeysRefferedByAttrs == null) {
                this.fKeysRefferedByAttrs = new HashMap();
            }
            this.fKeysRefferedByAttrs.put(attributeSet.getQName(), this.fKeysUsedInAttributeUse.keySet());
        }
        this.fKeysUsedInAttributeUse = null;
    }

    public void useAttributeSets(UseAttributeSets useSets) {
        if (this.fCurrentQName == null) {
            return;
        }
        List<QName> list = useSets.getReferenceSets();
        if (list != null && list.size() != 0) {
            HashSet<QName> set2;
            if (this.fAttrGroupsUsedByVars == null) {
                this.fAttrGroupsUsedByVars = new HashMap();
            }
            if ((set2 = this.fAttrGroupsUsedByVars.get(this.fCurrentQName)) == null) {
                set2 = new HashSet();
                this.fAttrGroupsUsedByVars.put(this.fCurrentQName, set2);
            }
            set2.addAll(list);
            if (this.fKeysBeingDefined != null && !this.fKeysBeingDefined.isEmpty()) {
                if (this.fAttrGroupsUsedByKeys == null) {
                    this.fAttrGroupsUsedByKeys = new HashMap();
                }
                for (QName key2 : this.fKeysBeingDefined) {
                    set2 = this.fAttrGroupsUsedByKeys.get(key2);
                    if (set2 == null) {
                        set2 = new HashSet();
                        this.fAttrGroupsUsedByKeys.put(key2, set2);
                    }
                    set2.addAll(list);
                }
            }
        }
    }

    public void keyPrologue(QName keyName) {
        if (this.fKeysBeingDefined == null) {
            this.fKeysBeingDefined = new HashSet();
        }
        this.fKeysBeingDefined.add(keyName);
    }

    public void keyEpilogue(QName keyName) {
        this.fKeysBeingDefined.remove(keyName);
    }

    public void errorCheckStyleSheet() throws TypeCheckError {
        if (this.fAttributeSetUsage != null) {
            boolean stop = false;
            while (!stop) {
                stop = true;
                ArrayList<Object[]> changed = null;
                for (Map.Entry<QName, HashSet<QName>> entry : this.fAttributeSetUsage.entrySet()) {
                    HashSet<QName> attrSetsUsed = entry.getValue();
                    int sizeBefore = -1;
                    if (stop) {
                        sizeBefore = attrSetsUsed.size();
                    }
                    HashSet<QName> closure = new HashSet<QName>(attrSetsUsed);
                    for (QName attrSet : attrSetsUsed) {
                        HashSet<QName> s = this.fAttributeSetUsage.get(attrSet);
                        if (s == null) continue;
                        closure.addAll(s);
                    }
                    if (!stop || sizeBefore == closure.size()) continue;
                    if (changed == null) {
                        changed = new ArrayList<Object[]>();
                    }
                    changed.add(new Object[]{entry.getKey(), closure});
                    stop = false;
                }
                if (stop) continue;
                for (Object[] objectArray : changed) {
                    this.fAttributeSetUsage.put((QName)objectArray[0], (HashSet)objectArray[1]);
                }
            }
            for (Map.Entry<QName, HashSet<QName>> e : this.fAttributeSetUsage.entrySet()) {
                QName qName = e.getKey();
                if (!e.getValue().contains(qName)) continue;
                throw new TypeCheckError("CIRCULAR_ATTRIBUTE_SET_ERR", qName);
            }
        }
        if (this.fDeclsThatInvokeApplyTemplates != null && this.fVarsInTemplateMatch != null) {
            for (QName qname3 : this.fDeclsThatInvokeApplyTemplates) {
                Expr d = this.fExprMap.get(qname3);
                if (!this.fVarsInTemplateMatch.contains(d)) continue;
                d.isCircularlyDefined();
            }
        }
        if (this.fDeclsThatInvokeKey != null && this.fVarsInKeyMatchOrUse != null) {
            for (QName n2 : this.fVarsInKeyMatchOrUse) {
                if (!this.fDeclsThatInvokeKey.containsKey(n2)) continue;
                this.fExprMap.get(n2).isCircularlyDefined();
            }
        }
        if (this.fAttrGroupsUsedByVars != null && this.fVarsRefferedByAttrs != null) {
            for (Map.Entry<QName, HashSet<QName>> entry : this.fAttrGroupsUsedByVars.entrySet()) {
                QName qname2 = entry.getKey();
                Expr expr = this.fExprMap.get(qname2);
                if (expr.hasCircularDefinition()) continue;
                for (QName attr2 : entry.getValue()) {
                    HashSet<VariableBase> vars = this.fVarsRefferedByAttrs.get(attr2);
                    if (vars == null || !vars.contains(expr)) continue;
                    expr.isCircularlyDefined();
                }
            }
        }
        if (this.fAttrGroupsUsedByKeys != null && this.fKeysRefferedByAttrs != null) {
            for (Map.Entry<QName, HashSet<QName>> entry : this.fAttrGroupsUsedByKeys.entrySet()) {
                QName qname2 = entry.getKey();
                for (QName attr3 : entry.getValue()) {
                    Set<QName> keys2 = this.fKeysRefferedByAttrs.get(attr3);
                    if (keys2 == null) continue;
                    FunctionCall func = this.fKeyMap.get(qname2);
                    func.isCircularlyDefined();
                }
            }
        }
    }

    private boolean inAttributeSet() {
        return this.fVarsUsedInAttributeSet != null;
    }
}

