/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2;

import com.ibm.xltxe.rnm1.xtq.ast.XPath20Exception;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CaseClause;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ConditionalExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ExtensionExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FLWORExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionCall;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.IdOrKeyFunctionCallPattern;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.KindTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.NameTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.NodeTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OperatorExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OrderedExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.PathExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.QuantifiedExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SequenceTypeOperator;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.StepExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TreatExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TypeExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TypeSwitch;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.UnorderedExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ValidateExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VarDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableBase;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableRef;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.XML11Char;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.xml.types.AggregateType;
import com.ibm.xltxe.rnm1.xtq.xml.types.AnyAtomicType;
import com.ibm.xltxe.rnm1.xtq.xml.types.AttributeType;
import com.ibm.xltxe.rnm1.xtq.xml.types.ChoiceType;
import com.ibm.xltxe.rnm1.xtq.xml.types.CollectionType;
import com.ibm.xltxe.rnm1.xtq.xml.types.DecimalType;
import com.ibm.xltxe.rnm1.xtq.xml.types.DocumentType;
import com.ibm.xltxe.rnm1.xtq.xml.types.DoubleType;
import com.ibm.xltxe.rnm1.xtq.xml.types.ElementType;
import com.ibm.xltxe.rnm1.xtq.xml.types.ExtendedTypes;
import com.ibm.xltxe.rnm1.xtq.xml.types.ItemType;
import com.ibm.xltxe.rnm1.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.TypeConstants;
import com.ibm.xltxe.rnm1.xtq.xml.types.UntypedAtomic;
import com.ibm.xltxe.rnm1.xtq.xml.types.UserDefinedUnionType;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.VisitorBase;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator2;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.FunctionOperatorTable;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.PolymorphicFunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.Translator2Helper;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XSLTC2Helper;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.TypeCheckError;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2.Function2TypeChecker;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.xci.type.SequenceType;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;

public class XPath2TypeChecker
extends Function2TypeChecker {
    static final boolean LOG_REWRITES = HiddenOptions.optionValueIs("logRewrites", "on");
    private static final NodeType NULL_NODE = new NodeType(null, -1);
    private static QName dataFunction = new QName("http://www.w3.org/2005/xpath-functions", "data");

    public XPath2TypeChecker(XPathCompiler compiler) {
        super(compiler);
    }

    @Override
    public Type visitExpression(Expr expr) throws TypeCheckError {
        switch (expr.getId()) {
            case 0: 
            case 1: {
                break;
            }
            case 40: {
                return this.sequenceExpression(expr);
            }
            case 101: {
                return this.emptySequence(expr);
            }
            case 186: {
                return this.pattern(expr);
            }
            case 187: {
                return this.pathPattern(expr);
            }
            case 83: 
            case 84: {
                return this.slashSlashPattern(expr);
            }
            case 41: {
                break;
            }
            case 188: {
                return this.stepPattern(expr);
            }
            case 5: {
                return this.stringLiteral(expr);
            }
            case 100: {
                return this.variableOrParameterReference(expr);
            }
            case 57: {
                return this.orExpression(expr);
            }
            case 58: {
                return this.andExpression(expr);
            }
            case 53: {
                return this.quantifiedExpression(expr);
            }
            case 42: {
                return this.forExpression(expr);
            }
            case 56: {
                return this.ifExpression(expr);
            }
            case 65: {
                return this.instanceofExpression(expr);
            }
            case 67: {
                return this.castableAsExpression(expr);
            }
            case 59: {
                return this.comparisonExpression(expr);
            }
            case 60: {
                return this.rangeExpression(expr);
            }
            case 61: {
                return this.additiveExpression(expr);
            }
            case 62: {
                return this.multiplicativeExpression(expr);
            }
            case 69: {
                return this.unaryExpression(expr);
            }
            case 63: {
                return this.unionExpression(expr);
            }
            case 64: {
                return this.intersectOrExceptExpression(expr);
            }
            case 82: {
                return this.pathExpression(expr);
            }
            case 85: {
                return this.stepExpression(expr);
            }
            case 68: {
                return this.castAsExpression(expr);
            }
            case 66: {
                return this.treatAsExpression(expr);
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 163: 
            case 167: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 178: 
            case 191: {
                break;
            }
            case 97: {
                return this.integerLiteral(expr);
            }
            case 98: {
                return this.decimalLiteral(expr);
            }
            case 99: {
                return this.doubleLiteral(expr);
            }
            case 105: {
                Type type2 = expr.isRootOnSelfNode() ? TypeConstants.NODE : this.visitFunction((FunctionCall)expr);
                return type2;
            }
            case 228: {
                return this.stringLiteral(expr);
            }
            case 102: {
                return this.contextItemExpression(expr);
            }
            case 108: 
            case 157: {
                return this.elementConstructor(expr);
            }
            case 54: {
                return this.typeswitchExpression(expr);
            }
            case 55: {
                break;
            }
            case 103: {
                return this.orderedExpression(expr);
            }
            case 104: {
                return this.unorderedExpression(expr);
            }
            case 74: {
                return this.extensionExpression(expr);
            }
            case 72: {
                return this.validateExpression(expr);
            }
            default: {
                throw new StaticError(expr);
            }
        }
        return null;
    }

    protected Type binaryOperatorExpression(Expr expr) throws TypeCheckError {
        OperatorExpr op2 = (OperatorExpr)expr;
        int operatorIndex = this.getOperatorIndex(op2);
        PolymorphicFunctionDeclaration polyfunc = this._compiler.getOperatorDeclaration(operatorIndex);
        return this.standardPolymorphicFunctionCall(polyfunc, op2, FunctionOperatorTable.getOperatorCategory(operatorIndex), operatorIndex, true);
    }

    private int getOperatorIndex(OperatorExpr op2) {
        switch (op2.getOperatorType()) {
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 30: {
                return 2;
            }
            case 31: {
                return 3;
            }
            case 32: {
                return 4;
            }
            case 33: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 11: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 12: {
                return 10;
            }
            case 10: {
                return 11;
            }
            case 26: {
                return 12;
            }
            case 13: {
                return 14;
            }
            case 14: {
                return 15;
            }
            case 15: {
                return 17;
            }
            case 16: {
                return 19;
            }
            case 17: {
                return 16;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
            case 1: {
                return 23;
            }
            case 2: {
                return 24;
            }
            case 3: {
                return 25;
            }
        }
        return -1;
    }

    protected Type additiveExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    private Type logicalExpression(Expr expr) throws TypeCheckError {
        OperatorExpr op2 = (OperatorExpr)expr;
        int numArgs = op2.getOperandCount();
        if (numArgs != 2) {
            throw new StaticError(expr);
        }
        Type leftOpType = this.visitExpression(op2.getOperand(0));
        Type rightOpType = this.visitExpression(op2.getOperand(1));
        int leftOpEBVCheck = this.checkEffectiveBooleanValue(leftOpType);
        int rightOpEBVCheck = this.checkEffectiveBooleanValue(rightOpType);
        if (leftOpEBVCheck == 0 || rightOpEBVCheck == 0 || this._compiler.isStaticTyping() && (leftOpEBVCheck == 2 || rightOpEBVCheck == 2)) {
            ErrorMsg err = new ErrorMsg("TYPE_ERR_ARGUMENTS_UNMATCH_OP", (Object)op2.getOperatorChar(), (SimpleNode)expr);
            throw new StaticError(err);
        }
        ASTDecorator2.setType(expr, TypeConstants.BOOLEAN);
        return TypeConstants.BOOLEAN;
    }

    protected Type andExpression(Expr expr) throws TypeCheckError {
        return this.logicalExpression(expr);
    }

    protected Type orExpression(Expr expr) throws TypeCheckError {
        return this.logicalExpression(expr);
    }

    protected Type comparisonExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    @Override
    public Type visitFunction(FunctionCall function2) throws TypeCheckError {
        if (function2 instanceof IdOrKeyFunctionCallPattern) {
            return this.idKeyPattern(function2);
        }
        return super.visitFunction(function2);
    }

    protected Type idKeyPattern(Expr expr) throws TypeCheckError {
        FunctionCall idkey = (FunctionCall)expr;
        QName qname2 = idkey.getFunctionQName();
        if (qname2.getLocalPart().equals("id")) {
            this._compiler.setHasIdCall(true);
            int valueId = idkey.getOperand(0).getId();
            if (idkey.getOperandCount() == 1 && (valueId == 5 || valueId == 97 || valueId == 98 || valueId == 99 || valueId == 185 || valueId == 100)) {
                Type valueType = this.visitExpression(idkey.getOperand(0));
                return Type.NODE;
            }
            throw new StaticError(expr);
        }
        int valueId = idkey.getOperand(1).getId();
        if (idkey.getOperandCount() == 2 && idkey.getOperand(0).getId() == 5 && (valueId == 5 || valueId == 97 || valueId == 98 || valueId == 99 || valueId == 185 || valueId == 100)) {
            Type valueType = this.visitExpression(idkey.getOperand(1));
            return this.keyCall(idkey);
        }
        throw new StaticError(expr);
    }

    protected Type multiplicativeExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    protected Type pattern(Expr expr) throws TypeCheckError {
        if (expr instanceof OperatorExpr && ((OperatorExpr)expr).getOperatorType() == 1) {
            return this.unionPattern((OperatorExpr)expr);
        }
        throw new StaticError(expr);
    }

    protected Type unionPattern(OperatorExpr pattern2) throws TypeCheckError {
        int n2 = pattern2.getOperandCount();
        for (int i = 0; i < n2; ++i) {
            this.visitExpression(pattern2.getOperand(i));
        }
        return null;
    }

    protected Type pathPattern(Expr expr) throws TypeCheckError {
        PathExpr pathExpr = (PathExpr)expr;
        int elementCount = pathExpr.getOperandCount();
        if (elementCount == 0 && pathExpr.isAbsolute()) {
            return TypeConstants.DOCUMENT;
        }
        Type type2 = null;
        for (int i = 0; i < elementCount; ++i) {
            Expr child2 = pathExpr.getOperand(i);
            type2 = this.visitExpression(child2);
        }
        return type2;
    }

    protected Type pathExpression(Expr expr) throws TypeCheckError {
        PathExpr pathExpr = (PathExpr)expr;
        int elementCount = pathExpr.getOperandCount();
        int startIndex = pathExpr.isAbsolute() ? 1 : 0;
        Type type2 = null;
        if (elementCount == startIndex + 1) {
            Expr child2 = pathExpr.getOperand(startIndex);
            type2 = this.visitExpression(child2);
        } else {
            Expr firstStep = pathExpr.getOperand(startIndex);
            Type firstType = this.visitExpression(firstStep);
            for (int i = startIndex + 1; i < elementCount; ++i) {
                Expr step2 = pathExpr.getOperand(i);
                type2 = this.visitExpression(step2);
            }
        }
        ASTDecorator2.setType(pathExpr, type2);
        while (this.rewriteSlashSlash(pathExpr)) {
        }
        return type2;
    }

    private boolean rewriteSlashSlash(PathExpr pathExpr) {
        int nChildren = pathExpr.jjtGetNumChildren();
        for (int j = 0; j < nChildren; ++j) {
            Expr child2;
            NodeTest nt;
            Expr child3 = (Expr)pathExpr.jjtGetChild(j);
            if (!this.isStepExpr(child3, 6)) continue;
            boolean doRewrite = false;
            StepExpr descendantOrSelf = (StepExpr)child3;
            boolean simpleNodeTest = false;
            if (descendantOrSelf.getNodeTest() != null && (nt = descendantOrSelf.getNodeTest()) instanceof KindTest && ((KindTest)nt).getKindTestType() == 2) {
                simpleNodeTest = true;
            }
            if (!simpleNodeTest) continue;
            StepExpr childExpr = null;
            int nPredicatesDescendantOrSelf = descendantOrSelf.getPredicateCount();
            if (nPredicatesDescendantOrSelf == 0 && j + 1 < nChildren && this.isStepExpr(child2 = (Expr)pathExpr.jjtGetChild(j + 1), 1)) {
                childExpr = (StepExpr)child2;
                int nPredicatesChildExpr = childExpr.getPredicateCount();
                if (nPredicatesChildExpr == 0) {
                    doRewrite = true;
                } else {
                    for (int k = 0; k < nPredicatesChildExpr; ++k) {
                        Expr predicate2 = childExpr.getPredicateAt(k);
                        Type predType = ASTDecorator2.getType(predicate2);
                        if (this.isNumericType(predType) || this.isFunction(predicate2, dataFunction)) continue;
                        VisitForPositionalQueries visitor = new VisitForPositionalQueries();
                        visitor.visitTree(predicate2);
                        if (visitor.accessesContextPosition) continue;
                        doRewrite = true;
                    }
                }
            }
            if (!doRewrite) continue;
            if (LOG_REWRITES) {
                System.out.print("Rewriting '//' expression: " + pathExpr.getXQueryString(true) + " to ");
            }
            childExpr.copyTestValues(descendantOrSelf);
            descendantOrSelf.setAxisType((short)2);
            pathExpr.jjtRemoveChild(childExpr);
            pathExpr.removeNullChildren();
            if (LOG_REWRITES) {
                System.out.println(pathExpr.getXQueryString(true));
            }
            return true;
        }
        return false;
    }

    private boolean isFunction(Expr expr, QName funcName) {
        return expr.getId() == 105 && ((FunctionCall)expr).getFunctionQName().equals(funcName);
    }

    private boolean isNumericType(Type predType) {
        return predType instanceof DecimalType || predType instanceof DoubleType;
    }

    private boolean isStepExpr(Expr child2, int axis) {
        return child2.getId() == 85 && !((StepExpr)child2).isFilterStep() && ((StepExpr)child2).getAxisType() == axis;
    }

    protected Type sequenceExpression(Expr expr) throws TypeCheckError {
        Type type2;
        OperatorExpr genericExpr = (OperatorExpr)expr;
        int n2 = genericExpr.getOperandCount();
        if (n2 == 0) {
            type2 = TypeConstants.EMPTY;
        } else if (n2 == 1) {
            type2 = this.visitExpression(genericExpr.getOperand(0));
        } else {
            AggregateType types2 = new AggregateType();
            for (int i = 0; i < n2; ++i) {
                Expr child2 = genericExpr.getOperand(i);
                types2.addType(this.visitExpression(child2));
            }
            type2 = types2;
        }
        ASTDecorator2.setType(genericExpr, type2);
        return type2;
    }

    protected Type contextItemExpression(Expr expr) {
        if (this._staticContext.getFeature("http://www.ibm.com/xmlns/prod/xltxe-j/use-when")) {
            String exprString = this._parser.getExprString();
            ErrorMsg err = new ErrorMsg("ERR_CONTEXTUNDEFINED_USEWHEN", (Object)exprString.substring(8, exprString.length() - 1), (SimpleNode)expr);
            throw new StaticError(err);
        }
        XSequenceType type2 = ExtendedTypes.ITEM_ONE;
        ASTDecorator2.setType(expr, type2);
        return type2;
    }

    protected Type stepExpression(Expr expr) throws TypeCheckError {
        StepExpr step2 = (StepExpr)expr;
        if (step2.isFilterStep()) {
            return this.filterStepExpression(step2);
        }
        return this.axisStepExpression(step2);
    }

    private Type filterStepExpression(StepExpr step2) throws TypeCheckError {
        Expr primary = null;
        try {
            primary = step2.getPrimaryExpr();
        }
        catch (XPath20Exception e) {
            throw new StaticError(step2);
        }
        int numPredicates = step2.getPredicateCount();
        Type type2 = null;
        if (XSLTCHelper.isAbbreviatedDot(step2)) {
            if (numPredicates > 0) {
                type2 = new XSequenceType(Type.NODE, OccurrenceIndicator.ZERO_OR_MORE);
            }
        } else {
            type2 = this.visitExpression(primary);
            if (numPredicates > 0) {
                if (type2 instanceof ItemType) {
                    type2 = new XSequenceType((ItemType)type2, OccurrenceIndicator.ZERO_OR_MORE);
                } else if (type2 instanceof CollectionType) {
                    ((CollectionType)type2).setCanBeEmpty(true);
                }
            }
        }
        for (int i = 0; i < numPredicates; ++i) {
            Expr pred = step2.getPredicateAt(i);
            this.predicate(pred);
        }
        ASTDecorator2.setType(step2, type2);
        return type2;
    }

    private Type axisStepExpression(StepExpr step2) throws TypeCheckError {
        NodeType nodeType = this.getTypeForStep(step2, this._compiler);
        int typeId = nodeType.getId();
        step2.setStepNodeType(typeId);
        if (typeId == 7) {
            XSLTCHelper.processingInstructionTestRewrite(step2, this._parser);
        }
        if (typeId == 9) {
            XSLTC2Helper.documentTestRewrite(this._parser, step2, this._parser);
        }
        Type type2 = nodeType.getType();
        int numPredicates = step2.getPredicateCount();
        if (XSLTCHelper.isAbbreviatedDot(step2)) {
            // empty if block
        }
        for (int i = 0; i < numPredicates; ++i) {
            Expr pred = step2.getPredicateAt(i);
            this.predicate(pred);
        }
        ASTDecorator2.setType(step2, type2);
        return type2;
    }

    protected Type stepPattern(Expr expr) throws TypeCheckError {
        StepExpr stepPattern = (StepExpr)expr;
        NodeType nodeType = this.getTypeForStep(stepPattern, this._compiler);
        int typeId = nodeType.getId();
        stepPattern.setStepNodeType(typeId);
        int numPredicates = stepPattern.getPredicateCount();
        if (numPredicates > 0) {
            for (int i = 0; i < numPredicates; ++i) {
                Expr pred = stepPattern.getPredicateAt(i);
                this.predicate(pred);
            }
        }
        return nodeType.getType();
    }

    protected Type emptySequence(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.EMPTY);
        return TypeConstants.EMPTY;
    }

    protected Type stringLiteral(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.STRING);
        return TypeConstants.STRING;
    }

    protected Type integerLiteral(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.INTEGER);
        return TypeConstants.INTEGER;
    }

    protected Type decimalLiteral(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.DECIMAL);
        return TypeConstants.DECIMAL;
    }

    private Type elementConstructor(Expr expr) {
        ElementType resultType = new ElementType(((DirElemConstructor)expr).getQName(), null);
        ASTDecorator2.setType(expr, resultType);
        return resultType;
    }

    protected Type doubleLiteral(Expr expr) {
        ASTDecorator2.setType(expr, Type.DOUBLE);
        return Type.DOUBLE;
    }

    protected Type unaryExpression(Expr expr) throws TypeCheckError {
        OperatorExpr op2 = (OperatorExpr)expr;
        if (op2.getOperatorType() == 26) {
            int operatorIndex = this.getOperatorIndex(op2);
            PolymorphicFunctionDeclaration polyfunc = this._compiler.getOperatorDeclaration(operatorIndex);
            return this.standardPolymorphicFunctionCall(polyfunc, op2, FunctionOperatorTable.getOperatorCategory(operatorIndex), operatorIndex, true);
        }
        Type argType = this.visitExpression(op2.getOperand(0));
        ASTDecorator2.setType(expr, argType);
        return argType;
    }

    protected Type unionExpression(Expr expr) throws TypeCheckError {
        OperatorExpr unionExpr = (OperatorExpr)expr;
        int count2 = unionExpr.getOperandCount();
        if (count2 != 2) {
            throw new StaticError(unionExpr);
        }
        for (int i = 0; i < 2; ++i) {
            Expr child2 = unionExpr.getOperand(i);
            Type type2 = this.visitExpression(child2);
        }
        XSequenceType returnType = new XSequenceType(Type.NODE, OccurrenceIndicator.ZERO_OR_MORE);
        ASTDecorator2.setType(expr, returnType);
        return returnType;
    }

    protected Type predicate(Expr expr) throws TypeCheckError {
        Type texp = this.visitExpression(expr);
        if (texp == Type.INTEGER) {
            Node grandParent;
            Expr parent2 = (Expr)expr.jjtGetParent();
            boolean nthPositionFilter = false;
            if (XSLTCHelper.hasLastCall(expr) || XSLTCHelper.isPattern(parent2) || XSLTCHelper.isFilterStep(parent2)) {
                if (!XSLTCHelper.hasLastCall(expr)) {
                    ASTDecorator.setNthPositionFilter(expr, ASTDecorator.getCanOptimize(expr));
                } else if (XSLTCHelper.isFilterStep(parent2)) {
                    StepExpr step2 = (StepExpr)parent2;
                    Expr primary = null;
                    try {
                        primary = step2.getPrimaryExpr();
                    }
                    catch (XPath20Exception e) {
                        throw new StaticError(expr);
                    }
                    boolean canOptimize = true;
                    if (XSLTCHelper.isKeyCall(primary)) {
                        canOptimize = false;
                    } else if (primary instanceof VariableRef) {
                        canOptimize = false;
                    } else if (primary instanceof PathExpr) {
                        canOptimize = false;
                    } else if (primary.getId() == 63) {
                        canOptimize = false;
                    } else if (XSLTCHelper.hasLastCall(expr)) {
                        canOptimize = false;
                    } else if (step2.jjtGetParent() instanceof PathExpr && ((PathExpr)step2.jjtGetParent()).getOperandCount() > 1) {
                        canOptimize = false;
                    }
                    ASTDecorator.setCanOptimize(expr, canOptimize);
                    if (canOptimize) {
                        nthPositionFilter = true;
                    }
                }
                if (nthPositionFilter) {
                    ASTDecorator.setNthPositionFilter(expr, true);
                    return Type.NODE;
                }
                return Type.INTEGER;
            }
            if (parent2 != null && parent2.getId() == 85 && (grandParent = parent2.jjtGetParent()) != null && grandParent instanceof PathExpr) {
                PathExpr pathExpr = (PathExpr)grandParent;
                Expr firstStep = null;
                try {
                    if (pathExpr.isAbsolute() && (firstStep = pathExpr.getOperand(1)) instanceof StepExpr && ((StepExpr)firstStep).getAxisType() == 13) {
                        ASTDecorator.setNthDescendant(expr, true);
                        return Type.NODE;
                    }
                }
                catch (XPath20Exception e) {
                    throw new StaticError(expr);
                }
            }
            ASTDecorator.setNthPositionFilter(expr, true);
            return Type.NODE;
        }
        if (texp == Type.BOOLEAN && XSLTCHelper.hasPositionCall(expr)) {
            ASTDecorator.setNthPositionFilter(expr, true);
        }
        ASTDecorator.setNthPositionFilter(expr, false);
        Translator2Helper.getCompareValue(expr);
        return Type.BOOLEAN;
    }

    private boolean isFororQuantifiedExpr(Expr expr) {
        for (Expr parent2 = (Expr)expr.jjtGetParent(); parent2 != null; parent2 = (Expr)parent2.jjtGetParent()) {
            if (parent2.getId() != 53 && parent2.getId() != 42) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Type variableOrParameterReference(Expr expr) throws TypeCheckError {
        VariableRef varRef = (VariableRef)expr;
        if (this._staticContext.getFeature("http://www.ibm.com/xmlns/prod/xltxe-j/use-when") && !this.isFororQuantifiedExpr(expr)) {
            String exprString = this._parser.getExprString();
            ErrorMsg err = new ErrorMsg("ERR_VERUNDEFINED_USEWHEN", exprString.substring(8, exprString.length() - 1), varRef.getQName().toString(), expr);
            throw new StaticError(err);
        }
        Type type2 = ASTDecorator2.getType(varRef);
        if (type2 != null) {
            return type2;
        }
        QName varName = varRef.getVariableName();
        String localName2 = varName.getLocalPart();
        String namespace2 = varName.getNamespaceURI();
        String prefix2 = varName.getPrefix();
        QName newVarName = this._parser.getQName(namespace2, prefix2, localName2);
        VariableBase variable2 = this.lookupVariable(newVarName);
        boolean isModuleVariable = false;
        if (variable2 == null && (variable2 = this._staticContext.lookupModuleVariable(newVarName)) != null) {
            isModuleVariable = true;
            ASTDecorator2.setModuleVariableRef(varRef, true);
        }
        if (variable2 == null) {
            int language = this._staticContext.getLanguage();
            if (language != 4 && language != 5) {
                SequenceType aReturnType = this._staticContext.getVariableBindingType(varRef.getVariableName());
                if (aReturnType != null && (type2 = XSLTC2Helper.convertSequenceTypeToXtqType(aReturnType, this._staticContext.getTypeFactory(), this.getCompiler().getStaticContext())) != null) {
                    ASTDecorator2.setType(varRef, type2);
                    return type2;
                }
                ASTDecorator2.setType(varRef, ExtendedTypes.ITEM_ZERO_OR_MORE);
                return ExtendedTypes.ITEM_ZERO_OR_MORE;
            }
            ASTMsg err = new ASTMsg("VARIABLE_UNDEF_ERR", new Object[]{newVarName.toString()}, (SimpleNode)expr);
            throw new StaticError(err.toString());
        }
        ASTDecorator.setVariable(varRef, variable2);
        if (this._staticContext.getLanguage() != 3 && !this.startVariableReference(variable2)) {
            return null;
        }
        try {
            TypeExpr variableType = variable2.getType();
            if (variableType != null) {
                XSequenceType asType = XSLTC2Helper.convertSequenceType(this._staticContext, this._staticContext.getTypeFactory(), variableType, this.getParser(), isModuleVariable);
                ASTDecorator2.setAsType(variable2, asType);
            }
            if (variable2.isLocal()) {
                SimpleNode node2 = varRef;
                do {
                    if (!XSLTCHelper.isClosure(node2)) continue;
                    ASTDecorator.setClosure(varRef, node2);
                    XSLTCHelper.addVariableToClosure(node2, varRef);
                    break;
                } while (!(node2 instanceof TopLevelDecl) && (node2 = (SimpleNode)node2.jjtGetParent()) != null);
            }
            if ((type2 = ASTDecorator2.getVariableType(variable2)) == null) {
                if (isModuleVariable) {
                    this.startContext(variable2);
                    this.visitTree(variable2);
                    this.endContext();
                } else {
                    this.visitTree(variable2);
                }
                type2 = ASTDecorator2.getVariableType(variable2);
            }
        }
        finally {
            if (this._staticContext.getLanguage() != 3) {
                this.endVariableReference(variable2);
            }
        }
        if (type2 == null) {
            type2 = ExtendedTypes.ITEM_ZERO_OR_MORE;
        }
        ASTDecorator2.setType(varRef, type2);
        return type2;
    }

    protected boolean startVariableReference(VariableBase variable2) {
        return true;
    }

    protected void endVariableReference(VariableBase var) {
    }

    protected Type castableAsExpression(Expr expr) throws TypeCheckError {
        SequenceTypeOperator castExpr = (SequenceTypeOperator)expr;
        Expr sourceExpr = castExpr.getLHS();
        TypeExpr targetExpr = castExpr.getSequenceType();
        Type sourceType = this.visitExpression(sourceExpr);
        sourceType = sourceType.getAtomizedType();
        boolean acceptEmpty = false;
        QName typeName = targetExpr.getTypeName();
        Type targetType = (Type)((Object)this._staticContext.getTypeFactory().getTypeFromName(typeName));
        if (typeName != null) {
            String ns = this._staticContext.getNamespaceURI(typeName);
            this._staticContext.isImportedNamespace(ns, this.getParser());
        }
        if (targetType == null) {
            throw new StaticError(castExpr);
        }
        if (!(targetType instanceof AnyAtomicType)) {
            throw new StaticError(castExpr);
        }
        if (targetExpr.getOccurrenceIndicator() == 0 || targetExpr.getOccurrenceIndicator() == 1) {
            throw new StaticError(castExpr);
        }
        if (targetType == Type.NOTATION || targetType == Type.ANYATOMICTYPE) {
            ErrorMsg err = new ErrorMsg("ERR_INVALID_CAST_TARGETTYPE");
            throw new StaticError(err);
        }
        if (targetType == Type.ANYATOMICTYPE) {
            throw new StaticError(castExpr);
        }
        if (targetExpr.getOccurrenceIndicator() == 2) {
            acceptEmpty = true;
        }
        int castable = sourceType.castableAs((AnyAtomicType)targetType, acceptEmpty);
        if (acceptEmpty && sourceType.getQuantifier().canBeEmpty()) {
            targetType = new XSequenceType((AnyAtomicType)targetType, OccurrenceIndicator.ZERO_OR_ONE);
        }
        if (sourceExpr.getId() == 5 && targetType == TypeConstants.QNAME) {
            String pref;
            String value2 = String.valueOf(RuntimeLibrary.normalizeSpace(sourceExpr.getValue().toCharArray()));
            int index2 = value2.indexOf(":");
            castable = index2 == -1 ? 1 : (this._staticContext.getNamespaceURI(pref = value2.substring(0, index2)) != null ? 1 : 0);
        }
        ASTDecorator2.setCastableAsResult(expr, castable);
        ASTDecorator2.setCastableAsTargetType(expr, targetType);
        ASTDecorator2.setType(expr, Type.BOOLEAN);
        return Type.BOOLEAN;
    }

    protected Type castAsExpression(Expr expr) throws TypeCheckError {
        SequenceTypeOperator castExpr = (SequenceTypeOperator)expr;
        Expr sourceExpr = castExpr.getLHS();
        TypeExpr targetExpr = castExpr.getSequenceType();
        Type sourceType = this.visitExpression(sourceExpr);
        sourceType = sourceType.getAtomizedType();
        boolean acceptEmpty = false;
        QName typeName = targetExpr.getTypeName();
        Type targetType = (Type)((Object)this._staticContext.getTypeFactory().getTypeFromName(typeName));
        if (typeName != null) {
            String ns = this._staticContext.getNamespaceURI(typeName);
            this._staticContext.isImportedNamespace(ns, this.getParser());
        }
        if (targetType == null) {
            throw new StaticError(castExpr);
        }
        if (!(targetType instanceof AnyAtomicType)) {
            throw new StaticError(castExpr);
        }
        if (targetExpr.getOccurrenceIndicator() == 0 || targetExpr.getOccurrenceIndicator() == 1) {
            throw new StaticError(castExpr);
        }
        if (targetType == Type.NOTATION || targetType == Type.ANYATOMICTYPE) {
            ErrorMsg err = new ErrorMsg("ERR_INVALID_CAST_TARGETTYPE");
            throw new StaticError(err);
        }
        if (targetType == Type.ANYATOMICTYPE) {
            throw new StaticError(castExpr);
        }
        if (sourceType.getQuantifier() == OccurrenceIndicator.TWO_OR_MORE) {
            throw new StaticError(castExpr);
        }
        if (targetExpr.getOccurrenceIndicator() == 2) {
            acceptEmpty = true;
        }
        if (sourceType == Type.EMPTY && targetExpr.getOccurrenceIndicator() == 3) {
            throw new StaticError(castExpr);
        }
        int castable = sourceType.castableAs((AnyAtomicType)targetType, acceptEmpty);
        if (castable == 0) {
            throw new StaticError(castExpr);
        }
        QName qname2 = null;
        int sId = sourceExpr.getId();
        if (sId == 5 && targetType == TypeConstants.QNAME) {
            String value2 = String.valueOf(RuntimeLibrary.normalizeSpace(sourceExpr.getValue().toCharArray()));
            if (!XML11Char.isXML11ValidQName(value2)) {
                ErrorMsg err = new ErrorMsg("ERR_QNAME_LEXICAL_VALUE", value2);
                throw new StaticError(err);
            }
            int index2 = value2.indexOf(":");
            if (index2 == -1) {
                String uri2 = this._staticContext.getNamespaceURI("");
                qname2 = uri2 == null ? new QName(value2) : new QName(uri2, value2);
            } else {
                String pref = value2.substring(0, index2);
                String uri3 = this._staticContext.getNamespaceURI(pref);
                if (uri3 != null) {
                    qname2 = new QName(uri3, value2.substring(index2 + 1), pref);
                } else {
                    throw new StaticError("ERR_NO_NAMESPACE_FOR_PREFIX", pref);
                }
            }
        }
        if (acceptEmpty && sourceType.getQuantifier().canBeEmpty()) {
            targetType = new XSequenceType((AnyAtomicType)targetType, OccurrenceIndicator.ZERO_OR_ONE);
        }
        ASTDecorator2.setExpressionCastValue(expr, qname2);
        ASTDecorator2.setType(expr, targetType);
        return targetType;
    }

    protected Type everyExpression(Expr expr) {
        return null;
    }

    protected Type forExpression(Expr expr) throws TypeCheckError {
        int i;
        FLWORExpr forExpr = (FLWORExpr)expr;
        int nClauses = forExpr.getClauseCount();
        for (int i2 = 0; i2 < nClauses; ++i2) {
            VarDecl varDecl = forExpr.getVardecl(i2);
            Expr clauseExpr = varDecl.getExpression();
            Type clauseType = this.visitExpression(clauseExpr);
            if (clauseType instanceof CollectionType) {
                clauseType = ((CollectionType)clauseType).getPrimeType();
            }
            ASTDecorator2.setVariableType(varDecl, clauseType);
            TypeExpr variableType = varDecl.getType();
            if (variableType != null) {
                XSequenceType asType = XSLTC2Helper.convertSequenceType(this._staticContext, this._staticContext.getTypeFactory(), variableType, this.getParser(), false);
                ASTDecorator2.setAsType(varDecl, asType);
            }
            this.addVariable(varDecl);
            this.addPositionVariable(varDecl, forExpr);
        }
        Expr whereExpr = forExpr.getWhere();
        if (whereExpr != null) {
            Type type2 = this.visitExpression(whereExpr);
            ASTDecorator2.setType(whereExpr, type2);
        }
        Expr returnExpr = forExpr.getResultingExpr();
        Type type3 = this.visitExpression(returnExpr);
        ASTDecorator2.setType(returnExpr, type3);
        for (i = 0; i < forExpr.orderSpecCount(); ++i) {
            Type oType = this.visitExpression(forExpr.getOrderSpec(i));
            ASTDecorator2.setType(forExpr.getOrderSpec(i), oType);
        }
        for (i = 0; i < nClauses; ++i) {
            QName vname = forExpr.getVariableName(i);
            this.removeVariable(vname);
            this.removePositionVariable(forExpr.getVardecl(i));
        }
        return type3;
    }

    protected Type ifExpression(Expr expr) throws TypeCheckError {
        Type elseType;
        ConditionalExpr ifExpr = (ConditionalExpr)expr;
        Expr thenExpr = ifExpr.getThenExpr();
        Expr elseExpr = ifExpr.getElseExpr();
        Type testType = this.visitExpression(ifExpr.getTestExpr());
        Type thenType = this.visitExpression(thenExpr);
        if (thenType.equals(elseType = this.visitExpression(elseExpr))) {
            return thenType;
        }
        return new ChoiceType(thenType, elseType);
    }

    protected Type instanceofExpression(Expr expr) throws TypeCheckError {
        SequenceTypeOperator instanceOf = (SequenceTypeOperator)expr;
        Type argType = this.visitExpression(instanceOf.getLHS());
        TypeExpr exprType = instanceOf.getSequenceType();
        XSequenceType targetType = XSLTC2Helper.convertSequenceType(this._staticContext, this._staticContext.getTypeFactory(), exprType, this.getParser(), false);
        if (targetType == null) {
            ErrorMsg err = new ErrorMsg("TYPE_ERR_INSTANCE_OF");
            throw new StaticError(err);
        }
        if (targetType instanceof DocumentType) {
            // empty if block
        }
        if (!(argType.getPrimeType() instanceof UntypedAtomic)) {
            int match = argType.typeMatches(targetType);
            if (match == 1) {
                ASTDecorator2.setCompileTimeEvaluationValue(expr, Boolean.TRUE);
            } else {
                ASTDecorator2.setSequenceType(instanceOf, targetType);
            }
        } else {
            ASTDecorator2.setSequenceType(instanceOf, targetType);
        }
        ASTDecorator2.setType(instanceOf, TypeConstants.BOOLEAN);
        return TypeConstants.BOOLEAN;
    }

    protected Type validateExpression(Expr expr) throws TypeCheckError {
        ValidateExpr vExpr = (ValidateExpr)expr;
        Type exprType = this.visitExpression(vExpr.getExpr());
        OccurrenceIndicator expectedQuantifier = exprType.getQuantifier();
        XSequenceType docExpectedType = new XSequenceType(Type.DOCUMENT, expectedQuantifier);
        XSequenceType elemExpectedType = new XSequenceType(Type.ELEMENT, expectedQuantifier);
        int docMatch = exprType.typeMatches(docExpectedType);
        int elemMatch = exprType.typeMatches(elemExpectedType);
        if (docMatch == 1 && elemMatch == 1) {
            return new UserDefinedUnionType(new Type[]{Type.DOCUMENT, Type.ELEMENT});
        }
        if (docMatch == 1) {
            return new XSequenceType(Type.DOCUMENT, OccurrenceIndicator.ONE);
        }
        if (elemMatch == 1) {
            return new XSequenceType(Type.ELEMENT, OccurrenceIndicator.ONE);
        }
        if (docMatch == 2 && elemMatch == 2) {
            return new UserDefinedUnionType(new Type[]{Type.DOCUMENT, Type.ELEMENT});
        }
        if (docMatch == 2) {
            return new XSequenceType(Type.DOCUMENT, OccurrenceIndicator.ONE);
        }
        if (elemMatch == 2) {
            return new XSequenceType(Type.ELEMENT, OccurrenceIndicator.ONE);
        }
        if (docMatch == 0 && elemMatch == 0) {
            throw new StaticError("XQUERY_ERR_VALIDATION_EXACT_ONE_NODE", vExpr);
        }
        return exprType;
    }

    protected Type typeswitchExpression(Expr expr) throws TypeCheckError {
        TypeSwitch tExpr = (TypeSwitch)expr;
        Type operandType = this.visitExpression(tExpr.getOperandExpr());
        Expr defaultReturn = tExpr.getDefaultResultingExpr();
        int nCase = tExpr.getCaseCount();
        int nReturns = nCase + (defaultReturn == null ? 0 : 1);
        for (int i = 0; i < nReturns; ++i) {
            Expr returnExpr;
            QName var;
            CaseClause c;
            if (i < nCase) {
                c = tExpr.getCaseClause(i);
                var = c.getVarName();
                returnExpr = c.getReturnExpr();
            } else {
                c = null;
                var = tExpr.getDefaultVariable();
                returnExpr = tExpr.getDefaultResultingExpr();
            }
            if (var != null) {
                VarDecl vd = new VarDecl(29);
                vd.setQName(var);
                vd.setLocal(true);
                vd.jjtSetParent(tExpr);
                if (c != null) {
                    vd.setType(c.getType());
                } else {
                    ASTDecorator2.setVariableType(vd, operandType);
                }
                this.addVariable(vd);
            }
            this.visitExpression(returnExpr);
            if (c != null) {
                ASTDecorator2.setSequenceType(c, XSLTC2Helper.convertSequenceType(this._staticContext, this._staticContext.getTypeFactory(), c.getType(), this.getParser(), false));
            }
            if (var == null) continue;
            this.removeVariable(var);
        }
        return ExtendedTypes.ITEM_ZERO_OR_MORE;
    }

    protected Type orderedExpression(Expr expr) throws TypeCheckError {
        OrderedExpr oe = (OrderedExpr)expr;
        Expr e = oe.getOrderedExpr();
        return this.visitExpression(e);
    }

    protected Type unorderedExpression(Expr expr) throws TypeCheckError {
        UnorderedExpr oe = (UnorderedExpr)expr;
        Expr e = oe.getUnorderedExpr();
        return this.visitExpression(e);
    }

    protected Type extensionExpression(Expr expr) throws TypeCheckError {
        ExtensionExpr oe = (ExtensionExpr)expr;
        if (!oe.hasExtensionExpr()) {
            ErrorMsg err = new ErrorMsg("ERR_PRAGMA_EXPR_MISSING");
            throw new StaticError(err);
        }
        Expr e = oe.getExtensionExpr();
        return this.visitExpression(e);
    }

    protected Type caseExpression(Expr expr) throws TypeCheckError {
        CaseClause c = (CaseClause)expr;
        Expr ce = c.getReturnExpr();
        ASTDecorator2.setSequenceType(c, XSLTC2Helper.convertSequenceType(this._staticContext, this._staticContext.getTypeFactory(), c.getType(), this.getParser(), false));
        return null;
    }

    protected Type intersectOrExceptExpression(Expr expr) throws TypeCheckError {
        OperatorExpr op2 = (OperatorExpr)expr;
        int count2 = op2.getOperandCount();
        if (count2 != 2) {
            throw new StaticError(op2);
        }
        for (int i = 0; i < 2; ++i) {
            Expr child2 = op2.getOperand(i);
            Type type2 = this.visitExpression(child2);
        }
        XSequenceType returnType = new XSequenceType(Type.NODE, OccurrenceIndicator.ZERO_OR_MORE);
        ASTDecorator2.setType(expr, returnType);
        return returnType;
    }

    protected Type quantifiedExpression(Expr expr) throws TypeCheckError {
        QuantifiedExpr quantifiedExpr = (QuantifiedExpr)expr;
        int nClauses = quantifiedExpr.getClauseCount();
        for (int i = 0; i < nClauses; ++i) {
            VarDecl varDecl = quantifiedExpr.getVardecl(i);
            Expr clauseExpr = varDecl.getExpression();
            Type clauseType = this.visitExpression(clauseExpr);
            if (clauseType instanceof CollectionType) {
                clauseType = ((CollectionType)clauseType).getPrimeType();
            }
            ASTDecorator2.setVariableType(varDecl, clauseType);
            this.addVariable(varDecl);
        }
        Expr returnExpr = quantifiedExpr.getResultingExpr();
        Type type2 = this.visitExpression(returnExpr);
        ASTDecorator2.setType(returnExpr, type2);
        for (int i = 0; i < nClauses; ++i) {
            QName vname = quantifiedExpr.getVariableName(i);
            this.removeVariable(vname);
        }
        return Type.BOOLEAN;
    }

    protected Type rangeExpression(Expr expr) throws TypeCheckError {
        OperatorExpr opExpr = (OperatorExpr)expr;
        int n2 = opExpr.getOperandCount();
        for (int i = 0; i < n2; ++i) {
            Expr operand2 = opExpr.getOperand(i);
            this.visitExpression(operand2);
        }
        XSequenceType type2 = ExtendedTypes.INTEGER_ZERO_OR_MORE;
        ASTDecorator2.setType(expr, type2);
        return type2;
    }

    protected Type someExpression(Expr expr) {
        return null;
    }

    protected Type treatAsExpression(Expr expr) throws TypeCheckError {
        Type resultType;
        TreatExpr treatExpr = (TreatExpr)expr;
        Type argType = this.visitExpression(treatExpr.getExpr());
        TypeExpr sequenceType = treatExpr.getSequenceType();
        XSequenceType targetType = XSLTC2Helper.convertSequenceType(this._staticContext, this._staticContext.getTypeFactory(), sequenceType, this.getParser(), false);
        if (targetType == null) {
            String lexqnameOfSeqType = targetType.toString();
            ErrorMsg err = new ErrorMsg("TYPE_ERR_TREAT_AS_2", (Object)lexqnameOfSeqType, (SimpleNode)expr);
            throw new StaticError(err);
        }
        int matches2 = 2;
        if (!(argType.getPrimeType() instanceof UntypedAtomic)) {
            matches2 = argType.typeMatches(targetType);
            if (matches2 == 0) {
                String aType = argType.toString();
                String tType = targetType.toString();
                ErrorMsg err = new ErrorMsg("TYPE_ERR_TREAT_AS", aType, tType, expr);
                throw new StaticError(err);
            }
            resultType = matches2 == 1 ? argType : targetType;
        } else {
            resultType = targetType;
        }
        ASTDecorator2.setTreatAsResult(treatExpr, matches2);
        ASTDecorator2.setTreatAsSequenceType(treatExpr, targetType);
        return resultType;
    }

    public NodeType getTypeForStep(StepExpr step2, XPathCompiler compiler) {
        NodeTest nodetest = null;
        short axis = 0;
        try {
            nodetest = step2.getNodeTest();
            axis = step2.getAxisType();
        }
        catch (XPath20Exception e) {
            // empty catch block
        }
        XSLTParser parser = compiler.getParser();
        if (nodetest.isNameTest()) {
            NameTest nameTest = (NameTest)nodetest;
            QName qname2 = nameTest.getQName();
            String namespace2 = null;
            String localName2 = null;
            String prefix2 = null;
            if (qname2 != null) {
                localName2 = qname2.getLocalPart();
                prefix2 = qname2.getPrefix();
                namespace2 = axis == 4 && prefix2.equals("") ? "" : qname2.getNamespaceURI();
            } else {
                short type2 = nameTest.getNameTestType();
                if (type2 == 0) {
                    if (axis == 12) {
                        return new NodeType(ExtendedTypes.NODE_ZERO_OR_MORE, -1);
                    }
                    if (axis == 4) {
                        return new NodeType(ExtendedTypes.ATTRIBUTE_ZERO_OR_MORE, 2);
                    }
                    return new NodeType(ExtendedTypes.ELEMENT_ZERO_OR_MORE, 1);
                }
                if (type2 == 1) {
                    prefix2 = nameTest.getNCName();
                    namespace2 = this._staticContext.getNamespaceURI(prefix2);
                    localName2 = "*";
                    if (step2.getId() == 188 && step2.getPredicateCount() == 0) {
                        ASTDecorator.setPatternPriority(step2, new BigDecimal("-0.25"));
                    }
                } else if (type2 == 2) {
                    localName2 = nameTest.getNCName();
                    if (step2.getId() == 188 && step2.getPredicateCount() == 0) {
                        ASTDecorator.setPatternPriority(step2, new BigDecimal("-0.25"));
                    }
                }
                qname2 = prefix2 != null ? new QName(namespace2, localName2, prefix2) : new QName(localName2);
            }
            if (axis == 12) {
                if (qname2 != null) {
                    QName newName = new QName("", localName2, "xmlns");
                    return new NodeType(null, compiler.registerNamespaceDecl(newName));
                }
                return NULL_NODE;
            }
            QName newName = parser.getQName(namespace2, prefix2, localName2);
            if (axis == 4) {
                int id2 = compiler.registerAttribute(newName);
                AttributeType attrType = new AttributeType(qname2, TypeConstants.UNTYPEDATOMIC);
                return new NodeType(new XSequenceType(attrType, OccurrenceIndicator.ZERO_OR_MORE), id2);
            }
            int id3 = compiler.registerElement(newName);
            ElementType elementType = new ElementType(qname2, TypeConstants.UNTYPEDANY);
            return new NodeType(new XSequenceType(elementType, OccurrenceIndicator.ZERO_OR_MORE), id3);
        }
        KindTest kindTest = (KindTest)nodetest;
        short type3 = kindTest.getKindTestType();
        switch (type3) {
            case 0: {
                return new NodeType(ExtendedTypes.PI_ZERO_OR_MORE, 7);
            }
            case 1: {
                return new NodeType(ExtendedTypes.COMMENT_ZERO_OR_MORE, 8);
            }
            case 2: {
                return new NodeType(ExtendedTypes.NODE_ZERO_OR_MORE, -1);
            }
            case 3: {
                return new NodeType(ExtendedTypes.TEXT_ZERO_OR_MORE, 3);
            }
            case 4: {
                return new NodeType(ExtendedTypes.DOCUMENT_ZERO_OR_MORE, 9);
            }
            case 7: {
                this.testInScopeElementDeclarations(kindTest.getTypeName());
            }
            case 5: {
                QName typeName = kindTest.getTypeName();
                if (typeName != null) {
                    this._staticContext.getTypeFactory();
                    String ns = this._staticContext.getNamespaceURI(typeName);
                    this._staticContext.isImportedNamespace(ns, parser);
                }
                return new NodeType(ExtendedTypes.ELEMENT_ZERO_OR_MORE, 1);
            }
            case 8: {
                this.testInScopeAttributeDeclarations(kindTest.getTypeName());
            }
            case 6: {
                QName typeName = kindTest.getTypeName();
                if (typeName != null) {
                    this._staticContext.getTypeFactory();
                    String ns = this._staticContext.getNamespaceURI(typeName);
                    this._staticContext.isImportedNamespace(ns, parser);
                }
                return new NodeType(ExtendedTypes.ATTRIBUTE_ZERO_OR_MORE, 2);
            }
        }
        return NULL_NODE;
    }

    protected Type slashSlashPattern(Expr expr) throws TypeCheckError {
        OperatorExpr pathExpr = (OperatorExpr)expr;
        int elementCount = pathExpr.getOperandCount();
        Type type2 = null;
        for (int i = 0; i < elementCount; ++i) {
            Expr child2 = pathExpr.getOperand(i);
            type2 = this.visitExpression(child2);
        }
        return type2;
    }

    private boolean testInScopeElementDeclarations(QName elementName) {
        if (this._staticContext.getInScopeElementDeclaration(elementName, this.getParser()) == null) {
            throw new StaticError("ERR_NOT_DEFINED_IN_SCOPE_SCHEMA_ELEM", elementName.toString());
        }
        return true;
    }

    private boolean testInScopeAttributeDeclarations(QName attributeName) {
        if (this._staticContext.getInScopeAttributeDeclaration(attributeName, this.getParser()) == null) {
            throw new StaticError("ERR_NOT_DEFINED_IN_SCOPE_SCHEMA_ATT", attributeName.toString());
        }
        return true;
    }

    private void addPositionVariable(VarDecl varDecl, Expr parent2) {
        if (varDecl.getPositionalVar() != null) {
            VarDecl vd = new VarDecl(29);
            vd.setQName(varDecl.getPositionalVar().getQName());
            vd.setLocal(true);
            vd.jjtSetParent(parent2);
            ASTDecorator2.setVariableType(vd, Type.INTEGER);
            this.addVariable(vd);
        }
    }

    private void removePositionVariable(VarDecl varDecl) {
        if (varDecl.getPositionalVar() != null) {
            this.removeVariable(varDecl.getPositionalVar().getQName());
        }
    }

    @Override
    protected void setupGlobals() {
        Hashtable<String, FunctionDecl> functions = this._staticContext.getStylesheetFunctions();
        HashMap<String, Expr> globals = new HashMap<String, Expr>();
        if (functions != null) {
            globals.putAll(functions);
        }
        int language = this._staticContext.getLanguage();
        if (this._staticContext.hasGlobals()) {
            for (Map.Entry<String, VariableBase> entry : this._staticContext.getGlobals().entrySet()) {
                VariableBase var = entry.getValue();
                if (language == 3) {
                    this.reportUndeclaredVariable(var.getExpression(), globals, this._staticContext);
                }
                this.updateScope(var);
                globals.put(entry.getKey(), var);
            }
        }
        this._circRefs.addGlobals(globals.values());
    }

    protected void typecheckGlobalVariables() {
        if (this._staticContext.hasGlobals()) {
            Iterator<VariableBase> globalVars = this._staticContext.getGlobals().values().iterator();
            this.getCompiler().setInGlobal(true);
            while (globalVars.hasNext()) {
                VariableBase var = globalVars.next();
                this._staticContext.setCurrentNode(var);
                this._circRefs.setCurrent(var, var.getQName());
                this.visitTree(var);
                this._circRefs.endCurrent(var);
            }
            this.getCompiler().setInGlobal(false);
        }
    }

    private void reportUndeclaredVariable(Expr e, HashMap<String, Expr> variables, XStaticContext context2) {
        if (e == null) {
            return;
        }
        if (e instanceof VariableRef) {
            QName varQName = ((VariableRef)e).getQName();
            VariableBase vb = (VariableBase)variables.get(varQName.toString());
            if (vb == null) {
                vb = context2.lookupModuleVariable(varQName);
            }
            if (vb == null) {
                ASTMsg error2 = new ASTMsg("VARIABLE_UNDEF_ERR", (Object)((VariableRef)e).getQName().toString(), (SimpleNode)e);
                throw new StaticError(error2.toString());
            }
        }
        for (int i = 0; i < e.jjtGetNumChildren(); ++i) {
            this.reportUndeclaredVariable((Expr)e.jjtGetChild(i), variables, context2);
        }
    }

    public void removeGlobals() {
        if (this._staticContext.hasGlobals()) {
            for (VariableBase var : this._staticContext.getGlobals().values()) {
                this.removeVariable(var.getQName());
            }
        }
    }

    static class VisitForPositionalQueries
    extends VisitorBase {
        private static QName positionFunction = new QName("http://www.w3.org/2005/xpath-functions", "position");
        private static QName lastFunction = new QName("http://www.w3.org/2005/xpath-functions", "last");
        boolean accessesContextPosition = false;

        VisitForPositionalQueries() {
        }

        @Override
        public boolean visitNode(Expr node2, int nodeType) {
            if (!this.accessesContextPosition) {
                this.accessesContextPosition = this.isFunction(node2, positionFunction) || this.isFunction(node2, lastFunction);
            }
            return !this.accessesContextPosition;
        }

        private boolean isFunction(Expr expr, QName funcName) {
            return expr.getId() == 105 && ((FunctionCall)expr).getFunctionQName().equals(funcName);
        }
    }

    static class NodeType {
        private Type _type;
        private int _id;

        public NodeType(Type type2, int id2) {
            this._type = type2;
            this._id = id2;
        }

        public Type getType() {
            return this._type;
        }

        public int getId() {
            return this._id;
        }
    }
}

