/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof;

import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.FunctionComparator;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.FunctionRecord;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.ModuleRecord;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xml.ras.LoggerUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FunctionReader {
    private static final boolean VERIFY = false;
    private static final Logger s_logger = LoggerUtil.getLogger(FunctionReader.class);
    private static final String s_className = FunctionReader.class.getName();
    List m_functionRecords = new LinkedList();
    HashMap m_moduleMap = new HashMap();
    ModuleRecord[] m_moduleRecords;
    private static final int INITIAL_HIGH_WATER = 0x100000;
    private static final int REFILL_STORE_FACTOR = 10;
    private FunctionStore m_store;
    Thread m_readerThread;
    private ArrayList[] m_functionsToRead;

    public void readFunctions(String[] moduleNames, File[] moduleFiles, HashMap functionMap, HashMap moduleMap) throws Exception {
        this.m_moduleMap = moduleMap;
        this.m_moduleRecords = new ModuleRecord[moduleNames.length];
        for (int i = 0; i < moduleFiles.length; ++i) {
            this.readIndividualModule(i, moduleNames[i], moduleFiles[i], functionMap);
        }
        this.m_store = new FunctionStore(0x100000);
        Collections.sort(this.m_functionRecords, FunctionComparator.CMP);
        this.m_readerThread = new Thread(new Reader());
        this.m_readerThread.start();
    }

    public final Function getFunction(FunctionRecord fr) {
        return this.m_store.getStoredFunction(fr);
    }

    private void refillStore() {
        ModuleRecord mr;
        int j;
        Object[] rtn = this.m_store.waitUntilEmptyOrRequired();
        FunctionRecord required = (FunctionRecord)rtn[0];
        int size = (Integer)rtn[1];
        Iterator i = this.m_functionRecords.iterator();
        if (this.m_functionsToRead == null) {
            this.m_functionsToRead = new ArrayList[this.m_moduleRecords.length];
            for (j = 0; j < this.m_functionsToRead.length; ++j) {
                this.m_functionsToRead[j] = new ArrayList();
            }
        }
        while (i.hasNext()) {
            FunctionRecord fr = (FunctionRecord)i.next();
            mr = (ModuleRecord)this.m_moduleMap.get(fr.m_moduleName);
            if ((size -= fr.m_size) < 0 && required == null) break;
            this.m_functionsToRead[mr.m_index].add(fr);
            if (fr == required) {
                required = null;
            }
            i.remove();
        }
        for (j = 0; j < this.m_moduleRecords.length; ++j) {
            mr = this.m_moduleRecords[j];
            for (FunctionRecord fr : this.m_functionsToRead[j]) {
                Function f2 = new Function();
                try {
                    f2.read(mr.m_rofh);
                    FunctionSignature fs = new FunctionSignature(f2);
                    fs.setFunctionName(fr.m_signature.getFunctionName());
                }
                catch (Exception e) {
                    s_logger.logp(Level.SEVERE, s_className, "refillStore", "error encountered reading '" + fr + "' : ", e);
                    throw new RuntimeException();
                }
                this.m_store.saveFunction(fr, f2);
            }
            this.m_functionsToRead[j].clear();
        }
    }

    public void readIndividualModule(int index2, String moduleName, File file, HashMap functionMap) throws Exception {
        InputStream fis = new FileInputStream(file);
        fis = new BufferedInputStream(fis, 0x100000);
        final int[] filePosition = new int[1];
        DataInputStream dis = new DataInputStream(fis);
        ModuleRecord mr = new ModuleRecord();
        mr.m_baseOffset = dis.readInt() + 4;
        ObjectInputStream ois = new ObjectInputStream(dis);
        ReadObjectFileHelper rofh = new ReadObjectFileHelper(new ModuleSignature(), ois, new ModuleSignatureStore(Collections.EMPTY_LIST));
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "readIndividualModule", "reading xdm tables ...");
        }
        mr.m_names = (String[])rofh.readObject();
        mr.m_uris = (String[])rofh.readObject();
        mr.m_types = (int[])rofh.readObject();
        mr.m_functionNames = new HashMap();
        int records = rofh.readInt();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "readIndividualModule", "reading " + records + " function records ");
        }
        for (int i = 0; i < records; ++i) {
            FunctionRecord r = new FunctionRecord();
            r.m_offset = rofh.readInt();
            r.m_size = rofh.readInt();
            r.m_originalName = rofh.readString();
            r.m_exported = rofh.readBoolean();
            r.m_signature = new FunctionSignature();
            r.m_signature.read(rofh);
            r.m_moduleName = moduleName;
            ArrayList<FunctionRecord> list = (ArrayList<FunctionRecord>)functionMap.get(r.m_signature);
            if (list == null) {
                list = new ArrayList<FunctionRecord>();
                functionMap.put(r.m_signature, list);
            }
            list.add(r);
            mr.m_functionNames.put(r.m_originalName, r.m_signature);
            this.m_functionRecords.add(r);
        }
        int c = ois.readInt();
        final HashMap<Integer, Class> instructionNames = new HashMap<Integer, Class>();
        for (int i = 0; i < c; ++i) {
            Integer k = (Integer)ois.readObject();
            Class v = (Class)ois.readObject();
            instructionNames.put(k, v);
        }
        ObjectInputStream ois2 = new ObjectInputStream(fis);
        mr.m_rofh = rofh = new ReadObjectFileHelper(new ModuleSignature(), ois2, new ModuleSignatureStore(Collections.EMPTY_LIST)){

            @Override
            public Instruction readInstruction(BindingEnvironment benv) throws Exception {
                int key2 = this.readInt();
                Class k = (Class)instructionNames.get(new Integer(key2));
                if (k == null) {
                    s_logger.logp(Level.SEVERE, s_className, "readInstruction", "instruction class not found for " + Integer.toHexString(key2) + " at " + Integer.toHexString(filePosition[0]));
                }
                try {
                    Instruction n2 = (Instruction)k.newInstance();
                    n2.setCachedType(this.readType());
                    n2.read(this, benv);
                    return n2;
                }
                catch (Exception e) {
                    s_logger.logp(Level.SEVERE, s_className, "readInstruction", "could not read class " + k, e);
                    throw new Error();
                }
            }
        };
        mr.m_index = index2;
        this.m_moduleRecords[index2] = mr;
        this.m_moduleMap.put(moduleName, mr);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "readIndividualModule", "done.");
        }
    }

    private void cleanUp() {
        if (!this.m_functionRecords.isEmpty()) {
            this.m_functionRecords = null;
            this.m_store = null;
            this.m_functionsToRead = null;
            this.m_moduleMap = null;
        }
        this.m_readerThread = null;
    }

    public void finish() {
        if (this.m_readerThread != null && this.m_readerThread.isAlive()) {
            try {
                this.m_readerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void forceFinish() {
        if (this.m_readerThread != null) {
            this.m_readerThread.interrupt();
        }
        this.m_readerThread = null;
    }

    class Reader
    implements Runnable {
        Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!FunctionReader.this.m_functionRecords.isEmpty()) {
                    FunctionReader.this.refillStore();
                }
            }
            catch (Throwable t) {
                FunctionReader.this.m_readerThread = null;
                FunctionStore functionStore = FunctionReader.this.m_store;
                synchronized (functionStore) {
                    ((FunctionReader)FunctionReader.this).m_store.m_error = true;
                    FunctionReader.this.m_store.notifyAll();
                }
                s_logger.logp(Level.SEVERE, s_className, "run", "exception " + t + " in FunctionReader", t);
                return;
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "run", "All functions read storeHighWater=" + ((FunctionReader)FunctionReader.this).m_store.m_storeHighWater);
            }
            FunctionReader.this.cleanUp();
        }
    }

    private static class FunctionStore {
        int m_storeSize = 0;
        boolean m_error = false;
        int m_storeHighWater = 0x100000;
        HashMap m_functionStore = new HashMap(this.m_storeHighWater);
        private FunctionRecord m_required = null;

        public FunctionStore(int size) {
            this.m_storeHighWater = size;
        }

        public synchronized Function getStoredFunction(FunctionRecord fr) {
            Function f2 = null;
            while (true) {
                if ((f2 = (Function)this.m_functionStore.remove(fr)) != null) {
                    this.m_storeSize -= fr.m_size;
                    return f2;
                }
                this.m_required = fr;
                if (this.m_error) {
                    throw new RuntimeException();
                }
                try {
                    this.notifyAll();
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
            }
        }

        public synchronized void saveFunction(FunctionRecord fr, Function f2) {
            if (this.m_functionStore.put(fr, f2) != null) {
                throw new StaticError("ERR_SYSTEM", "added function " + fr + " twice!");
            }
            this.m_storeSize += fr.m_size;
            if (this.m_storeSize > this.m_storeHighWater) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "saveFunction", "expanded store to " + this.m_storeSize / 1024 + "k to fit " + this.m_functionStore.size() + " functions");
                }
                this.m_storeHighWater = this.m_storeSize;
            }
            if (this.m_required == fr) {
                this.m_required = null;
                this.notifyAll();
            }
        }

        public synchronized Object[] waitUntilEmptyOrRequired() {
            while (this.m_required == null && this.m_storeSize >= this.m_storeHighWater / 10) {
                if (this.m_error) {
                    throw new RuntimeException();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
            }
            return new Object[]{this.m_required, new Integer(this.m_storeHighWater - this.m_storeSize)};
        }
    }
}

