/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.XylemXSLTC;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.OverlapDetectionXSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.OverlapDetector;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OverlapDetectionXSLTC
extends XylemXSLTC {
    private static final Logger s_logger = LoggerUtil.getLogger(OverlapDetectionXSLTC.class);
    private static final String s_className = OverlapDetectionXSLTC.class.getName();

    public static void main(String[] args) {
        SessionContext session = new SessionContext();
        final boolean[] nolink = new boolean[1];
        final boolean[] nocompile = new boolean[1];
        final boolean[] noclean = new boolean[1];
        s_classes = new ArrayList();
        s_resources = new ArrayList();
        XylemXSLTC.XylemXSLTCommandLineParser clp = new XylemXSLTC.XylemXSLTCommandLineParser(){

            @Override
            protected int parseOption(String[] args, int i) {
                if (args[i].equals("-nocompile")) {
                    nocompile[0] = true;
                } else if (args[i].equals("-nolink")) {
                    nolink[0] = true;
                } else if (args[i].equals("-nocleanxo")) {
                    noclean[0] = true;
                } else {
                    if (args[i].equals("-help")) {
                        super.parseOption(args, i);
                        System.out.println("                  [-nocompile]");
                        System.out.println("                  [-noclean]");
                        System.out.println("                  [-nolink]");
                        return -1;
                    }
                    return super.parseOption(args, i);
                }
                return i;
            }
        };
        if (!clp.parseCommandLine(args)) {
            return;
        }
        clp.m_linkerSettings.setOverlapDetection(true);
        clp.m_linkerSettings.setOverlapDetectionArgLast(true);
        if (clp.m_files.size() != clp.m_classNames.size()) {
            String msg = "missing file or classname argument. Got" + clp.m_files.size() + " files, and " + clp.m_classNames.size() + " classnames )";
            s_logger.logp(Level.SEVERE, s_className, "main", msg);
            throw new RuntimeException(msg);
        }
        HashSet<String> s = new HashSet<String>();
        ArrayList<File> tempFiles = new ArrayList<File>(clp.m_files.size());
        for (int i = 0; i < clp.m_classNames.size(); ++i) {
            String cName = (String)clp.m_classNames.get(i);
            File temp = new File(clp.m_linkerSettings.getOutputDir(), cName + ".xo");
            tempFiles.add(temp);
            if (s.add(cName)) continue;
            String msg = "Duplicate classname '" + cName + "' in command line";
            s_logger.logp(Level.SEVERE, s_className, "main", msg);
            throw new RuntimeException(msg);
        }
        try {
            Module rtlib = XSLTCompiler.loadRuntimeLibrary(false);
            if (!nocompile[0]) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "main", "Phase I: Compiling individual stylesheets...");
                }
                for (int i = 0; i < clp.m_files.size(); ++i) {
                    URL url = (URL)clp.m_files.get(i);
                    File temp = (File)tempFiles.get(i);
                    Module m = OverlapDetectionXSLTCompiler.compileIndividualModule(url, rtlib, clp.m_compilerSettings, s_sourceLoader, s_topResolve);
                    m.removeDeadFunctions();
                    String cName = (String)clp.m_classNames.get(i);
                    if (clp.m_linkerSettings.isDumpXylem()) {
                        Program.dumpXylemFile(m, clp.m_linkerSettings.getOutputDir(), cName);
                    }
                    ParamReferenceIdentifier.createParamReferences(m);
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINE, s_className, "main", "Writing temp-file file " + temp);
                    }
                    OverlapDetectionXSLTCompiler.writeIndividualModule(m, temp, session);
                }
            }
            if (!nolink[0]) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "main", "Phase II: Detect Overlap and Link");
                }
                OverlapDetector.detectOverlapAndLink(rtlib, clp.m_classNames.toArray(new String[0]), tempFiles.toArray(new File[0]), clp.m_compilerSettings, clp.m_linkerSettings, session);
            }
            if (clp.m_jarFileName != null) {
                try {
                    OverlapDetectionXSLTC.outputToJar(clp.m_linkerSettings.getOutputDir(), clp.m_jarFileName);
                }
                catch (IOException e) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "IOException outputting jar file", e);
                    System.exit(-1);
                }
            }
        }
        catch (Throwable e) {
            s_logger.logp(Level.SEVERE, s_className, "main", "", e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (!noclean[0]) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "main", "cleaning up temp files ...");
                }
                for (File xo : tempFiles) {
                    try {
                        if (xo.delete()) continue;
                        throw new RuntimeException();
                    }
                    catch (Exception e) {
                        s_logger.logp(Level.SEVERE, s_className, "main", "could not delete " + xo);
                    }
                }
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "Done");
            }
        }
    }
}

