/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.AutoFunctorizingXSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XDMTypeUpdater;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.FunctionComparator;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.FunctionReader;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.FunctionRecord;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.ModuleRecord;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.TailRecursiveOptimizer;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OverlapDetector {
    private static final Logger s_logger = LoggerUtil.getLogger(OverlapDetector.class);
    private static final String s_className = OverlapDetector.class.getName();

    public static void main(String[] args) {
        Module rtlib;
        SessionContext session = new SessionContext();
        XSLTCompilerSettings compilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings linkerSettings = new XSLTLinkerSettings(compilerSettings);
        linkerSettings.setOverlapDetection(true);
        linkerSettings.setOverlapDetectionArgLast(true);
        if (args.length == 0) {
            s_logger.logp(Level.WARNING, s_className, "main", "Usage: OverlapDetectionXSLTLinker\n        [-split n]\n        [-dumpxylem]\n        [-disablejavac]\n        [-generateBCEL]\n        [-suppressComments]\n        filename+ | -command file-with-list-of-filenames");
            return;
        }
        int base2 = 0;
        while (base2 < args.length) {
            ArrayList<String> list;
            String opt = args[base2];
            if (opt.equals("-split")) {
                if (++base2 == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "-split requires parameter");
                    return;
                }
                compilerSettings.setPrereductionSplitLimit(Integer.parseInt(args[base2++]));
                continue;
            }
            if (opt.equals("-newsplit")) {
                if (++base2 == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "-newsplit requires parameter");
                    return;
                }
                linkerSettings.getCodeGenerationSettings().setPostReductionSplitLimit(Integer.parseInt(args[base2++]));
                continue;
            }
            if (opt.equals("-dumpxylem")) {
                linkerSettings.setDumpXylem(true);
                ++base2;
                continue;
            }
            if (opt.equals("-disablejavac")) {
                linkerSettings.getCodeGenerationSettings().getJavaCSettings().setJavaCDisabled(true);
                ++base2;
                continue;
            }
            if (opt.equals("-generateBCEL")) {
                linkerSettings.getCodeGenerationSettings().setTargetLanguage(4);
                ++base2;
                continue;
            }
            if (opt.equals("-suppressComments")) {
                linkerSettings.getCodeGenerationSettings().setSuppressComments(true);
                ++base2;
                continue;
            }
            if (!opt.equals("-command")) break;
            if (++base2 == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "main", "-split requires parameter");
                return;
            }
            try {
                String s;
                list = new ArrayList<String>();
                FileReader fr = new FileReader(args[base2]);
                BufferedReader br = new BufferedReader(fr);
                while ((s = br.readLine()) != null) {
                    if ((s = s.trim()).length() <= 0) continue;
                    list.add(s);
                }
                br.close();
                fr.close();
            }
            catch (IOException e) {
                s_logger.logp(Level.SEVERE, s_className, "main", "Could not read command file " + args[base2], e);
                return;
            }
            args = list.toArray(args);
            base2 = 0;
            break;
        }
        if ((args.length - base2) % 2 != 0) {
            throw new StaticError("ERR_SYSTEM", "Uneven args starting at " + args[base2]);
        }
        String[] moduleNames = new String[(args.length - base2) / 2];
        File[] moduleFiles = new File[moduleNames.length];
        for (int i = 0; i < args.length - base2; i += 2) {
            moduleFiles[i / 2] = new File(args[i + base2]);
            moduleNames[i / 2] = args[i + base2 + 1];
        }
        try {
            rtlib = XSLTCompiler.loadRuntimeLibrary(false);
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "main", "", e);
            throw new RuntimeException();
        }
        OverlapDetector.detectOverlapAndLink(rtlib, moduleNames, moduleFiles, compilerSettings, linkerSettings, session);
    }

    public static void detectOverlapAndLink(Module rtlib, String[] moduleNames, File[] moduleFiles, XSLTCompilerSettings compilerSettings, XSLTLinkerSettings linkerSettings, SessionContext session) {
        HashMap functionMap = new HashMap();
        HashMap moduleMap = new HashMap();
        FunctionReader freader = new FunctionReader();
        try {
            freader.readFunctions(moduleNames, moduleFiles, functionMap, moduleMap);
            Module master = new Module(moduleNames[0], null, new ModuleSignature(""));
            XDMTypeUpdater[] ttuu = OverlapDetector.mergeXDMTables(master, moduleNames, moduleMap);
            AutoFunctorizingXSLTLinker.Statistics stats = new AutoFunctorizingXSLTLinker.Statistics(moduleNames);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "detectOverlapAndLink", "Detecting overlap");
            }
            OverlapDetector.detectOverlap(master, functionMap, moduleMap, ttuu, freader, stats);
            stats.summarize();
            freader.finish();
            master.addModuleImportDirective(new TopLevelModuleImportDirective("xslt1", rtlib.m_signature, "xslt1"));
            AutoFunctorizingXSLTLinker.handleStandardExports(master);
            Iterator i = moduleMap.values().iterator();
            while (i.hasNext()) {
                ((ModuleRecord)i.next()).m_rofh.close();
            }
            moduleMap = null;
            functionMap = null;
            master.clearTypeInformation(true);
            master.removeFunctionDerivativeInformation(false);
            ParamReferenceIdentifier.fixParamReferences(master);
            freader = null;
            XSLTCompiler.postASTProcessing(master, null, compilerSettings.getPrereductionSplitLimit(), compilerSettings.isStreamResultOnly());
            XSLTLinker.s_linker.compileProgram(master, rtlib, moduleNames.length, Arrays.asList(moduleNames), master.getName(), linkerSettings, session);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "detectOverlapAndLink", "Done");
            }
        }
        catch (Throwable e) {
            s_logger.logp(Level.SEVERE, s_className, "detectOverlapAndLink", "", e);
            if (freader != null) {
                freader.forceFinish();
            }
            throw new RuntimeException();
        }
    }

    private static XDMTypeUpdater[] mergeXDMTables(Module master, String[] moduleNames, HashMap moduleMap) {
        XDMTypeUpdater[] ttuu = new XDMTypeUpdater[moduleNames.length];
        ArrayList<String> masterNames = new ArrayList<String>();
        ArrayList<String> masterURIs = new ArrayList<String>();
        ArrayList<Integer> masterTypes = new ArrayList<Integer>();
        for (int i = 0; i < moduleNames.length; ++i) {
            ModuleRecord mr = (ModuleRecord)moduleMap.get(moduleNames[i]);
            String[] names = mr.m_names;
            String[] uris = mr.m_uris;
            int[] types2 = mr.m_types;
            int[] newIndices = new int[names.length];
            for (int j = 0; j < names.length; ++j) {
                newIndices[j] = -1;
                for (int k = 0; k < masterNames.size(); ++k) {
                    if (!XSLTLinker.areStringRefsEqual(masterNames.get(k), names[j]) || !XSLTLinker.areStringRefsEqual(masterURIs.get(k), uris[j]) || !masterTypes.get(k).equals(new Integer(types2[j]))) continue;
                    newIndices[j] = k;
                    break;
                }
                if (newIndices[j] != -1) continue;
                newIndices[j] = masterNames.size();
                masterNames.add(names[j]);
                masterURIs.add(uris[j]);
                masterTypes.add(new Integer(types2[j]));
            }
            ttuu[mr.m_index] = new XDMTypeUpdater();
            ttuu[mr.m_index].m_newIndices = newIndices;
        }
        String[] masterNamesArray = new String[masterNames.size()];
        masterNames.toArray(masterNamesArray);
        String[] masterURIsArray = new String[masterURIs.size()];
        masterURIs.toArray(masterURIsArray);
        Instruction namesBody = XSLTLinker.makeStringArrayBody(masterNamesArray);
        Instruction urisBody = XSLTLinker.makeStringArrayBody(masterURIsArray);
        Instruction typesBody = XSLTLinker.makeIntArrayBody(masterTypes);
        try {
            Function f2 = new Function("xdm-names", new Binding[0], namesBody);
            master.addFunction(f2);
            f2.typeCheck(master, null, new LinkedList<Function>());
            master.forceFunctionGeneration(f2);
            f2 = new Function("xdm-uris", new Binding[0], urisBody);
            master.addFunction(f2);
            f2.typeCheck(master, null, new LinkedList<Function>());
            master.forceFunctionGeneration(f2);
            f2 = new Function("xdm-types", new Binding[0], typesBody);
            master.addFunction(f2);
            f2.typeCheck(master, null, new LinkedList<Function>());
            master.forceFunctionGeneration(f2);
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "mergeXDMTables", "", e);
            throw new Error();
        }
        return ttuu;
    }

    public static void detectOverlap(Module master, HashMap functionMap, HashMap moduleMap, XDMTypeUpdater[] ttuu, FunctionReader freader, AutoFunctorizingXSLTLinker.Statistics stats) throws Exception {
        final HashMap<FunctionSignature, String> unifiedFunctionNameMap = new HashMap<FunctionSignature, String>();
        HashSet<String> usedNames = new HashSet<String>();
        for (FunctionSignature fs : functionMap.keySet()) {
            String name2 = fs.getFunctionName();
            int j = 0;
            while (usedNames.contains(name2)) {
                name2 = name2 + "$" + ++j;
            }
            unifiedFunctionNameMap.put(fs, name2);
            usedNames.add(name2);
        }
        ArrayList signatures = new ArrayList(functionMap.keySet());
        Collections.sort(signatures, FunctionComparator.CMP);
        block2: for (FunctionSignature sig : signatures) {
            ArrayList list = (ArrayList)functionMap.get(sig);
            Iterator j = list.iterator();
            Instruction[] bodies = new Instruction[list.size()];
            Function[] functions = new Function[list.size()];
            int[] xToRealTable = new int[list.size()];
            int k = 0;
            while (j.hasNext()) {
                FunctionRecord fr = (FunctionRecord)j.next();
                Function f2 = null;
                f2 = freader.getFunction(fr);
                if (f2.getName().equals("main")) {
                    f2.setName("main-functor");
                } else if (!(f2.getName().equals("setupOutput") || f2.getName().equals("whitespaceRules") || f2.getName().equals("setupCharacterMaps") || f2.getName().equals("get-ns-prefix-counter"))) {
                    if (fr.m_exported) {
                        if (master.getFunction(f2.getName()) != null) continue block2;
                        master.addFunction(f2);
                        master.forceFunctionGeneration(f2);
                        continue block2;
                    }
                    f2.setName((String)unifiedFunctionNameMap.get(fr.m_signature));
                }
                final ModuleRecord mr = (ModuleRecord)moduleMap.get(fr.m_moduleName);
                xToRealTable[k] = mr.m_index;
                ttuu[mr.m_index].optimizeFunction(f2);
                new TailRecursiveOptimizer(){

                    @Override
                    protected Instruction optimizeStep2(Instruction n2) {
                        if (n2 instanceof FunctionCallInstruction) {
                            FunctionCallInstruction fci = (FunctionCallInstruction)n2;
                            FunctionSignature fs = (FunctionSignature)mr.m_functionNames.get(fci.getFunction());
                            String newName = (String)unifiedFunctionNameMap.get(fs);
                            Instruction[] newParams = new Instruction[n2.getChildInstructionCount() + 1];
                            System.arraycopy(fci.m_parameters, 0, newParams, 0, fci.m_parameters.length);
                            newParams[fci.m_parameters.length] = new IdentifierInstruction("__functorindex__");
                            fci.m_parameters = newParams;
                            fci.setFunction(newName);
                        }
                        return n2;
                    }
                }.optimizeFunction(f2);
                functions[k] = f2;
                bodies[k++] = f2.getBody();
            }
            Function masterFunction = functions[0];
            boolean forceTopLevel = false;
            if (masterFunction.getName().equals("build_key")) {
                forceTopLevel = true;
            }
            Binding[] newParams = new Binding[masterFunction.m_parameters.length + 1];
            System.arraycopy(masterFunction.m_parameters, 0, newParams, 0, masterFunction.m_parameters.length);
            newParams[masterFunction.m_parameters.length] = new Binding((Object)"__functorindex__", IntType.s_intType);
            masterFunction.m_parameters = newParams;
            int[] score = new int[1];
            Instruction combined = AutoFunctorizingXSLTLinker.foldTogetherOrMakeChoice(bodies, true, master, masterFunction, xToRealTable, moduleMap.size(), forceTopLevel, score);
            stats.add(sig, xToRealTable, score[0]);
            masterFunction.setBody(combined);
            master.addFunction(masterFunction);
        }
    }
}

