/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import java.io.IOException;
import java.util.LinkedList;

public class ArithmeticInstruction
extends BinaryPrimopInstruction {
    protected int m_operation;

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_operation = rofh.readInt();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeInt(this.m_operation);
    }

    public ArithmeticInstruction() {
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        this.doDefaultTypeCheck(tenv, benv, functionStack);
        Type t2 = this.m_operand2.typeCheck(tenv, benv, functionStack);
        if (IntType.s_intType.equals(this.m_operand1.typeCheck(tenv, benv, functionStack).resolveType(tenv)) && IntType.s_intType.equals(t2.resolveType(tenv))) {
            return this.setCachedType(IntType.s_intType);
        }
        return this.setCachedType(DoubleType.s_doubleType);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        if (IntType.s_intType.equals(this.m_operand1.getType(tenv, benv).resolveType(tenv)) && IntType.s_intType.equals(this.m_operand2.getType(tenv, benv).resolveType(tenv))) {
            return IntType.s_intType;
        }
        return DoubleType.s_doubleType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        Type t2;
        Type t1 = this.m_operand1.getPreTypecheckType(msig);
        if (t1 == (t2 = this.m_operand1.getPreTypecheckType(msig))) {
            if (t1 == IntType.s_intType) {
                return IntType.s_intType;
            }
            if (t1 != null && t1 instanceof PrimitiveNumericalType) {
                return DoubleType.s_doubleType;
            }
            return super.getPreTypecheckType(msig);
        }
        return super.getPreTypecheckType(msig);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        ArithmeticInstruction i = new ArithmeticInstruction(this.m_operation, this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation());
        ArithmeticInstruction.propagateInfo(this, i);
        return i;
    }

    public ArithmeticInstruction(int operation, Instruction op1, Instruction op2) {
        super(op1, op2);
        this.m_operation = operation;
    }

    public int getOperation() {
        return this.m_operation;
    }

    public String getOperationAsString() {
        String op2;
        switch (this.m_operation) {
            case 4: {
                op2 = "+";
                break;
            }
            case 5: {
                op2 = "-";
                break;
            }
            case 30: {
                op2 = "*";
                break;
            }
            case 31: {
                op2 = "/";
                break;
            }
            case 33: {
                op2 = "%";
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return op2;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        FcgType resultType;
        cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
        cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.DEFAULT);
        switch (this.m_operation) {
            case 4: {
                resultType = il.binaryOperationExpr(FcgBinOp.PLUS);
                break;
            }
            case 5: {
                resultType = il.binaryOperationExpr(FcgBinOp.SUBTRACT);
                break;
            }
            case 30: {
                resultType = il.binaryOperationExpr(FcgBinOp.MULTIPLY);
                break;
            }
            case 31: {
                resultType = il.binaryOperationExpr(FcgBinOp.DIVIDE);
                break;
            }
            case 33: {
                resultType = il.binaryOperationExpr(FcgBinOp.MODULO);
                break;
            }
            default: {
                throw new StaticError("ERR_SYSTEM", "Arithmetic Instruction does not support op " + this.m_operation);
            }
        }
        return resultType;
    }

    public int getOperationAsXylemOpcode() {
        int op2;
        switch (this.m_operation) {
            case 4: {
                op2 = 0;
                break;
            }
            case 5: {
                op2 = 1;
                break;
            }
            case 30: {
                op2 = 2;
                break;
            }
            case 31: {
                op2 = 3;
                break;
            }
            case 33: {
                op2 = 4;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return op2;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        BindingEnvironment benv = this.evaluateBindingEnvironment(f2);
        Type t1 = this.m_operand1.evaluateType(f2);
        Type t2 = this.m_operand2.evaluateType(f2);
        Object x = this.m_operand1.evaluate(e, f2, di, false);
        Object y = this.m_operand2.evaluate(e, f2, di, false);
        if (!(t1 instanceof INumericalType && t2 instanceof INumericalType && t1.equals(t2, f2.getTypeEnvironment()))) {
            x = CoerceInstruction.evaluateCoersion(e, this.m_operand1, DoubleType.s_doubleType, f2, benv, di);
            y = CoerceInstruction.evaluateCoersion(e, this.m_operand2, DoubleType.s_doubleType, f2, benv, di);
            t1 = DoubleType.s_doubleType;
        }
        int op2 = this.getOperationAsXylemOpcode();
        Object ans = ((INumericalType)((Object)t1)).evaluateOperation(e, x, y, op2);
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen("arithmetic", indent);
        pw.printToken(this.getOperationAsString(), indent + 1);
        this.m_operand1.toString(pw, indent + 1);
        this.m_operand2.toString(pw, indent + 1);
        pw.printFormClose(indent);
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        ArithmeticInstruction ai = (ArithmeticInstruction)arg0;
        return ai.m_operation == this.m_operation;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        return new ArithmeticInstruction(this.m_operation, op1, op2);
    }
}

