/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.BasisLibrary;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.Operators;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.codegen.FcgXtqType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.IMinimalFeatureUsage;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xml.xci.Cursor;
import java.io.IOException;
import java.util.LinkedList;

public class ComparisonInstruction
extends BinaryPrimopInstruction
implements IMinimalFeatureUsage {
    protected int m_operation;

    public ComparisonInstruction() {
    }

    public int getOperation() {
        return this.m_operation;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_operation = rofh.readInt();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeInt(this.m_operation);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        this.doDefaultTypeCheck(tenv, benv, functionStack);
        this.m_operand1.typeCheck(tenv, benv, functionStack);
        this.m_operand2.typeCheck(tenv, benv, functionStack);
        return this.setCachedType(BooleanType.s_booleanType);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        ComparisonInstruction i = new ComparisonInstruction(this.m_operation, this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation());
        ComparisonInstruction.propagateInfo(this, i);
        return i;
    }

    public ComparisonInstruction(int operation, Instruction op1, Instruction op2) {
        super(op1, op2);
        this.m_operation = operation;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        FcgBinOp fcgOp;
        int reverseOp2;
        int op2;
        Type t1 = cgt.resolveType(this.m_operand1);
        Type t2 = cgt.resolveType(this.m_operand2);
        if (t1 == null || t2 == null) {
            throw new RuntimeException();
        }
        switch (this.m_operation) {
            case 18: {
                op2 = 4;
                reverseOp2 = 5;
                fcgOp = FcgBinOp.COMPARE_GTE;
                break;
            }
            case 16: {
                reverseOp2 = 4;
                op2 = 5;
                fcgOp = FcgBinOp.COMPARE_LTE;
                break;
            }
            case 17: {
                reverseOp2 = 3;
                op2 = 2;
                fcgOp = FcgBinOp.COMPARE_GT;
                break;
            }
            case 15: {
                reverseOp2 = 2;
                op2 = 3;
                fcgOp = FcgBinOp.COMPARE_LT;
                break;
            }
            default: {
                throw new StaticError("ERR_SYSTEM", "ComparisonInstruction has bad operation: (" + this.m_operation + ")");
            }
        }
        if (t1 instanceof XDMItemType && t2.equals(CharType.s_charType.getStreamType())) {
            XDMItemType.generateWithCloneIfNeeded(this.m_operand1, cg, cgt, il, ValueGenStyle.DEFAULT);
            CharStreamToJavaStringInstruction.generateJavaString(cg, cgt, this.m_operand2, null, il);
            il.loadLiteral(op2);
            il.invokeClassMethod(FcgXtqType.BASIS_LIBRARY, "compare", (FcgType)FcgType.BOOLEAN, 3);
        } else if (t2 instanceof XDMItemType && t1.equals(CharType.s_charType.getStreamType())) {
            XDMItemType.generateWithCloneIfNeeded(this.m_operand2, cg, cgt, il, ValueGenStyle.DEFAULT);
            CharStreamToJavaStringInstruction.generateJavaString(cg, cgt, this.m_operand2, null, il);
            il.loadLiteral(reverseOp2);
            il.invokeClassMethod(FcgXtqType.BASIS_LIBRARY, "compare", (FcgType)FcgType.BOOLEAN, 3);
        } else if (t1 instanceof XDMItemType && t2 instanceof INumericalType) {
            XDMItemType.generateWithCloneIfNeeded(this.m_operand1, cg, cgt, il, ValueGenStyle.DEFAULT);
            CoerceInstruction.generateCoersion(cg, this.m_operand2, DoubleType.s_doubleType, cgt, il);
            il.loadLiteral(op2);
            il.invokeClassMethod(FcgXtqType.BASIS_LIBRARY, "compare", (FcgType)FcgType.BOOLEAN, 3);
        } else if (t2 instanceof XDMItemType && t1 instanceof INumericalType) {
            XDMItemType.generateWithCloneIfNeeded(this.m_operand2, cg, cgt, il, ValueGenStyle.DEFAULT);
            CoerceInstruction.generateCoersion(cg, this.m_operand1, DoubleType.s_doubleType, cgt, il);
            il.loadLiteral(reverseOp2);
            il.invokeClassMethod(FcgXtqType.BASIS_LIBRARY, "compare", (FcgType)FcgType.BOOLEAN, 3);
        } else if (t2 instanceof XDMItemType && t1 instanceof XDMItemType) {
            XDMItemType.generateWithCloneIfNeeded(this.m_operand1, cg, cgt, il, ValueGenStyle.DEFAULT_WITH_PUSH);
            XDMItemType.generateWithCloneIfNeeded(this.m_operand2, cg, cgt, il, ValueGenStyle.DEFAULT_WITH_PUSH);
            il.loadLiteral(op2);
            il.invokeClassMethod(FcgXtqType.BASIS_LIBRARY, "compare", (FcgType)FcgType.BOOLEAN, 3);
        } else if (t1 instanceof INumericalType || t2 instanceof INumericalType) {
            if (t1.equals(t2)) {
                cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
                cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.DEFAULT);
                il.binaryOperationExpr(fcgOp);
            } else {
                CoerceInstruction.generateCoersion(cg, this.m_operand1, DoubleType.s_doubleType, cgt, il);
                CoerceInstruction.generateCoersion(cg, this.m_operand2, DoubleType.s_doubleType, cgt, il);
                il.binaryOperationExpr(fcgOp);
            }
        } else if (t1.equals(CharType.s_charType.getStreamType()) && t2.equals(CharType.s_charType.getStreamType())) {
            CoerceInstruction.generateCoersion(cg, this.m_operand1, DoubleType.s_doubleType, cgt, il);
            CoerceInstruction.generateCoersion(cg, this.m_operand2, DoubleType.s_doubleType, cgt, il);
            il.binaryOperationExpr(fcgOp);
        } else if (t1.equals(BooleanType.s_booleanType) || t2.equals(BooleanType.s_booleanType)) {
            if (t1.equals(t2)) {
                CoerceInstruction.generateCoersion(cg, this.m_operand1, IntType.s_intType, cgt, il);
                CoerceInstruction.generateCoersion(cg, this.m_operand2, IntType.s_intType, cgt, il);
                il.binaryOperationExpr(fcgOp);
            } else {
                CoerceInstruction.generateCoersion(cg, this.m_operand1, BooleanType.s_booleanType, cgt, il);
                il.convertExpr(FcgType.BOOLEAN, FcgType.INT);
                CoerceInstruction.generateCoersion(cg, this.m_operand2, BooleanType.s_booleanType, cgt, il);
                il.convertExpr(FcgType.BOOLEAN, FcgType.INT);
                il.binaryOperationExpr(fcgOp);
            }
        } else {
            CoerceInstruction.generateCoersion(cg, this.m_operand1, DoubleType.s_doubleType, cgt, il);
            CoerceInstruction.generateCoersion(cg, this.m_operand2, DoubleType.s_doubleType, cgt, il);
            il.binaryOperationExpr(fcgOp);
        }
        return FcgType.BOOLEAN;
    }

    @Override
    public String innerToString() {
        return "comparison";
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return Integer.toString(this.m_operation);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Object y;
        Object x;
        int op2;
        if (null != di) {
            di.enter(this, e, f2);
        }
        switch (this.m_operation) {
            case 18: {
                op2 = 4;
                break;
            }
            case 16: {
                op2 = 5;
                break;
            }
            case 17: {
                op2 = 2;
                break;
            }
            case 15: {
                op2 = 3;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        Type t1 = this.m_operand1.evaluateType(f2);
        Type t2 = this.m_operand2.evaluateType(f2);
        if (t1 == null || t2 == null) {
            throw new RuntimeException();
        }
        Cursor xcs = null;
        Cursor ycs = null;
        if (t1 instanceof XDMItemType && t2.equals(CharType.s_charType.getStreamType())) {
            xcs = (Cursor)this.m_operand1.evaluate(e, f2, di, false);
            x = xcs == null ? null : e.pushForkForRelease(xcs.fork(false));
            y = ((Object)((IStream)this.m_operand2.evaluate(e, f2, di, false))).toString();
        } else if (t2 instanceof XDMItemType && t1.equals(CharType.s_charType.getStreamType())) {
            y = ((Object)((IStream)this.m_operand1.evaluate(e, f2, di, false))).toString();
            ycs = (Cursor)this.m_operand2.evaluate(e, f2, di, false);
            x = ycs == null ? null : e.pushForkForRelease(ycs.fork(false));
            op2 = Operators.getReverseOp(op2);
        } else if (t1 instanceof XDMItemType && t2 instanceof INumericalType) {
            xcs = (Cursor)this.m_operand1.evaluate(e, f2, di, false);
            x = xcs == null ? null : e.pushForkForRelease(xcs.fork(false));
            y = CoerceInstruction.evaluateCoersion(e, this.m_operand2, DoubleType.s_doubleType, f2, this.evaluateBindingEnvironment(f2), di);
        } else if (t2 instanceof XDMItemType && t1 instanceof INumericalType) {
            y = CoerceInstruction.evaluateCoersion(e, this.m_operand1, DoubleType.s_doubleType, f2, this.evaluateBindingEnvironment(f2), di);
            ycs = (Cursor)this.m_operand2.evaluate(e, f2, di, false);
            x = ycs == null ? null : e.pushForkForRelease(ycs.fork(false));
            op2 = Operators.getReverseOp(op2);
        } else if (t1 instanceof XDMItemType && t2.equals(BooleanType.s_booleanType)) {
            x = CoerceInstruction.evaluateCoersion(e, this.m_operand1, BooleanType.s_booleanType, f2, this.evaluateBindingEnvironment(f2), di);
            y = this.m_operand2.evaluate(e, f2, di, false);
        } else if (t2 instanceof XDMItemType && t1.equals(BooleanType.s_booleanType)) {
            x = this.m_operand1.evaluate(e, f2, di, false);
            y = CoerceInstruction.evaluateCoersion(e, this.m_operand2, BooleanType.s_booleanType, f2, this.evaluateBindingEnvironment(f2), di);
        } else if (t2 instanceof XDMItemType && t1 instanceof XDMItemType) {
            xcs = (Cursor)this.m_operand1.evaluate(e, f2, di, false);
            x = xcs == null ? null : e.pushForkForRelease(xcs.fork(false));
            ycs = (Cursor)this.m_operand2.evaluate(e, f2, di, false);
            y = ycs == null ? null : e.pushForkForRelease(ycs.fork(false));
        } else {
            x = !(t1 instanceof INumericalType) ? CoerceInstruction.evaluateCoersion(e, this.m_operand1, DoubleType.s_doubleType, f2, this.evaluateBindingEnvironment(f2), di) : this.m_operand1.evaluate(e, f2, di, false);
            y = !(t2 instanceof INumericalType) ? CoerceInstruction.evaluateCoersion(e, this.m_operand2, DoubleType.s_doubleType, f2, this.evaluateBindingEnvironment(f2), di) : this.m_operand2.evaluate(e, f2, di, false);
        }
        Boolean ans = BasisLibrary.compare(x, y, op2) ? Boolean.TRUE : Boolean.FALSE;
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        ComparisonInstruction ci = (ComparisonInstruction)arg0;
        return this.m_operation == ci.m_operation;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        return new ComparisonInstruction(this.m_operation, op1, op2);
    }

    @Override
    public Cursor.Profile getMinimalUsageForEvaluate(int argumentIndex, Function f2) {
        switch (argumentIndex) {
            case 0: {
                return Cursor.Profile.NONE;
            }
            case 1: {
                Type t = this.m_operand1.evaluateType(f2);
                assert (!(t instanceof XDMSequenceType));
                if (t instanceof XDMItemType) {
                    return Cursor.Profile.MAY_USE_WHILE_FORKED;
                }
                return Cursor.Profile.NONE;
            }
            case 2: {
                Type t = this.m_operand2.evaluateType(f2);
                assert (!(t instanceof XDMSequenceType));
                if (t instanceof XDMItemType) {
                    return Cursor.Profile.MAY_USE_WHILE_FORKED;
                }
                return Cursor.Profile.NONE;
            }
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " " + argumentIndex);
    }

    @Override
    public Cursor.Profile getMinimalUsageForEvaluateWithStreamOptimization(int argumentIndex, Function f2) {
        return this.getMinimalUsageForEvaluate(argumentIndex, f2);
    }

    @Override
    public Cursor.Profile getMinimalUsageForGenerateCode(int argumentIndex, Function f2) {
        return this.getMinimalUsageForEvaluate(argumentIndex, f2);
    }

    @Override
    public Cursor.Profile getMinimalUsageForGenerateCodeWithStreamOptimization(int argumentIndex, Function f2) {
        return this.getMinimalUsageForEvaluate(argumentIndex, f2);
    }
}

