/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.BasisLibrary;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xml.xci.Cursor;
import java.io.IOException;
import java.util.LinkedList;

public class EqualityInstruction
extends BinaryPrimopInstruction {
    protected boolean m_testInequality;

    public EqualityInstruction() {
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        this.doDefaultTypeCheck(tenv, benv, functionStack);
        this.m_operand1.typeCheck(tenv, benv, functionStack);
        this.m_operand2.typeCheck(tenv, benv, functionStack);
        return this.setCachedType(BooleanType.s_booleanType);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        EqualityInstruction i = new EqualityInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation(), this.m_testInequality);
        EqualityInstruction.propagateInfo(this, i);
        return i;
    }

    public EqualityInstruction(Instruction op1, Instruction op2, boolean testInequality) {
        super(op1, op2);
        this.m_testInequality = testInequality;
    }

    public boolean isTestingInequality() {
        return this.m_testInequality;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        Type xt1 = cgt.resolveType(this.m_operand1);
        Type xt2 = cgt.resolveType(this.m_operand2);
        FcgType t1 = xt1.getFCGType(cg);
        FcgType t2 = xt2.getFCGType(cg);
        if (t1 == null || t2 == null) {
            throw new StaticError("ERR_SYSTEM", "Cannot compare values of null type");
        }
        if (t1 != t2) {
            if (t1 == FcgType.BIG_DECIMAL) {
                cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
                cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.DEFAULT);
                il.convertExpr(t2, FcgType.BIG_DECIMAL);
            } else if (t2 == FcgType.BIG_DECIMAL) {
                cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
                il.convertExpr(t1, FcgType.BIG_DECIMAL);
                cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.DEFAULT);
            } else if (t1 == FcgType.BIG_INTEGER && (t2 == FcgType.DOUBLE || t2 == FcgType.FLOAT) || t2 == FcgType.BIG_INTEGER && (t1 == FcgType.DOUBLE || t1 == FcgType.FLOAT)) {
                cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
                il.convertExpr(t1, FcgType.BIG_DECIMAL);
                cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.DEFAULT);
                il.convertExpr(t2, FcgType.BIG_DECIMAL);
            } else if (t1 == FcgType.BIG_INTEGER) {
                cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
                cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.DEFAULT);
                il.convertExpr(t2, FcgType.BIG_INTEGER);
            } else if (t2 == FcgType.BIG_INTEGER) {
                cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
                il.convertExpr(t1, FcgType.BIG_INTEGER);
                cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.DEFAULT);
            } else if (xt1 instanceof INumericalType && xt2 instanceof INumericalType) {
                if (xt1 instanceof IntType && xt2 instanceof DoubleType) {
                    CoerceInstruction.generateCoersion(cg, this.m_operand1, DoubleType.s_doubleType, cgt, il);
                    cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.DEFAULT);
                } else {
                    if (!(xt2 instanceof IntType) || !(xt1 instanceof DoubleType)) throw new StaticError("ERR_SYSTEM", "Don't know how to compare '" + t1.getTypeName() + "' to '" + t2.getTypeName() + "'");
                    CoerceInstruction.generateCoersion(cg, this.m_operand2, DoubleType.s_doubleType, cgt, il);
                    cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
                }
            } else {
                il.comment("AZ: Generic equality comparison");
                CoerceInstruction.generateCoersion(cg, this.m_operand1, CharType.s_charType.getStreamType(), cgt, il);
                CoerceInstruction.generateCoersion(cg, this.m_operand2, CharType.s_charType.getStreamType(), cgt, il);
            }
        } else {
            cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
            cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.DEFAULT);
        }
        if (this.m_testInequality) {
            il.binaryOperationExpr(FcgBinOp.COMPARE_NE);
            return FcgType.BOOLEAN;
        } else {
            il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
        }
        return FcgType.BOOLEAN;
    }

    @Override
    public String innerToString() {
        return this.m_testInequality ? "unequal?" : "equal?";
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Object y;
        Object x;
        if (null != di) {
            di.enter(this, e, f2);
        }
        Cursor xcs = null;
        Cursor ycs = null;
        Type t1 = this.m_operand1.evaluateType(f2);
        Type t2 = this.m_operand2.evaluateType(f2);
        if (t1 == null || t2 == null) {
            throw new RuntimeException();
        }
        if (t1 instanceof INumericalType && t2 instanceof INumericalType || t1 instanceof BooleanType && t2 instanceof BooleanType) {
            x = this.m_operand1.evaluate(e, f2, di, false);
            y = this.m_operand2.evaluate(e, f2, di, false);
        } else if (t1 instanceof XDMItemType && t2.equals(CharType.s_charType.getStreamType())) {
            xcs = (Cursor)this.m_operand1.evaluate(e, f2, di, false);
            x = xcs == null ? null : e.pushForkForRelease(xcs.fork(false));
            y = ((Object)((IStream)this.m_operand2.evaluate(e, f2, di, false))).toString();
        } else if (t1.equals(CharType.s_charType.getStreamType()) && t2 instanceof XDMItemType) {
            y = ((Object)((IStream)this.m_operand1.evaluate(e, f2, di, false))).toString();
            ycs = (Cursor)this.m_operand2.evaluate(e, f2, di, false);
            x = ycs == null ? null : e.pushForkForRelease(ycs.fork(false));
        } else if (t1 instanceof XDMItemType && t2 instanceof INumericalType) {
            xcs = (Cursor)this.m_operand1.evaluate(e, f2, di, false);
            x = xcs == null ? null : e.pushForkForRelease(xcs.fork(false));
            y = CoerceInstruction.evaluateCoersion(e, this.m_operand2, DoubleType.s_doubleType, f2, this.evaluateBindingEnvironment(f2), di);
        } else if (t1 instanceof INumericalType && t2 instanceof XDMItemType) {
            y = CoerceInstruction.evaluateCoersion(e, this.m_operand1, DoubleType.s_doubleType, f2, this.evaluateBindingEnvironment(f2), di);
            ycs = (Cursor)this.m_operand2.evaluate(e, f2, di, false);
            x = ycs == null ? null : e.pushForkForRelease(ycs.fork(false));
        } else if (t2.equals(CharType.s_charType.getStreamType()) && t1.equals(CharType.s_charType.getStreamType())) {
            x = ((Object)((IStream)this.m_operand1.evaluate(e, f2, di, false))).toString();
            y = ((Object)((IStream)this.m_operand2.evaluate(e, f2, di, false))).toString();
        } else if (t2 instanceof XDMItemType && t1 instanceof XDMItemType) {
            xcs = (Cursor)this.m_operand1.evaluate(e, f2, di, false);
            x = xcs == null ? null : e.pushForkForRelease(xcs.fork(false));
            ycs = (Cursor)this.m_operand2.evaluate(e, f2, di, false);
            y = ycs == null ? null : e.pushForkForRelease(ycs.fork(false));
        } else if (t2 instanceof XDMSequenceType && t1 instanceof XDMSequenceType) {
            xcs = (Cursor)this.m_operand1.evaluate(e, f2, di, false);
            x = xcs == null ? null : e.pushForkForRelease(xcs.fork(false));
            ycs = (Cursor)this.m_operand2.evaluate(e, f2, di, false);
            y = ycs == null ? null : e.pushForkForRelease(ycs.fork(false));
        } else if (t1.equals(BooleanType.s_booleanType)) {
            x = this.m_operand1.evaluate(e, f2, di, false);
            y = CoerceInstruction.evaluateCoersion(e, this.m_operand2, BooleanType.s_booleanType, f2, this.evaluateBindingEnvironment(f2), di);
        } else if (t2.equals(BooleanType.s_booleanType)) {
            x = CoerceInstruction.evaluateCoersion(e, this.m_operand1, BooleanType.s_booleanType, f2, this.evaluateBindingEnvironment(f2), di);
            y = this.m_operand2.evaluate(e, f2, di, false);
        } else if (t1 instanceof INumericalType) {
            x = this.m_operand1.evaluate(e, f2, di, false);
            y = CoerceInstruction.evaluateCoersion(e, this.m_operand2, DoubleType.s_doubleType, f2, this.evaluateBindingEnvironment(f2), di);
        } else if (t2 instanceof INumericalType) {
            x = CoerceInstruction.evaluateCoersion(e, this.m_operand1, DoubleType.s_doubleType, f2, this.evaluateBindingEnvironment(f2), di);
            y = this.m_operand2.evaluate(e, f2, di, false);
        } else {
            x = CoerceInstruction.evaluateCoersion(e, this.m_operand1, CharType.s_charType.getStreamType(), f2, this.evaluateBindingEnvironment(f2), di);
            x = ((Object)((IStream)x)).toString();
            y = CoerceInstruction.evaluateCoersion(e, this.m_operand2, CharType.s_charType.getStreamType(), f2, this.evaluateBindingEnvironment(f2), di);
            y = ((Object)((IStream)y)).toString();
        }
        boolean b = BasisLibrary.compare(x, y, this.m_testInequality ? 1 : 0);
        Boolean ans = b ? Boolean.TRUE : Boolean.FALSE;
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        return new EqualityInstruction(op1, op2, this.m_testInequality);
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        EqualityInstruction ei = (EqualityInstruction)arg0;
        return this.m_testInequality == ei.m_testInequality;
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeBoolean(this.m_testInequality);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_testInequality = rofh.readBoolean();
    }
}

