/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeProperties;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import java.io.IOException;
import java.util.LinkedList;

public class GetRuntimePropertyInstruction
extends Instruction {
    private String m_key;
    private JavaObjectType m_type;

    public GetRuntimePropertyInstruction() {
    }

    public GetRuntimePropertyInstruction(String key2, JavaObjectType type2) {
        this.m_key = key2;
        this.m_type = type2;
    }

    @Override
    public Instruction cloneShallow() {
        GetRuntimePropertyInstruction i = new GetRuntimePropertyInstruction(this.m_key, this.m_type);
        GetRuntimePropertyInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction i = this.cloneShallow();
        GetRuntimePropertyInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        state[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_type;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        return this.setCachedType(this.m_type);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        FcgClassReferenceType retType = cgh.getClassReferenceType(this.m_type.getClassName());
        cgh.loadThisVar(il);
        il.loadLiteral(this.m_key);
        il.invokeInterfaceMethod(cgh.getInterfaceType(RuntimeProperties.class.getName()), "getProperty", (FcgType)FcgType.OBJECT, 1);
        il.convertExpr(cgh.getClassReferenceType(Object.class.getName()), retType);
        return retType;
    }

    @Override
    public int hashCode() {
        return this.m_key.hashCode();
    }

    @Override
    public int getChildInstructionCount() {
        return 0;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Object ans;
        if (null != di) {
            di.enter(this, e, f2);
        }
        if (this.m_key.equals("__dynamicContext__")) {
            ans = e.getDynamicContext();
        } else {
            RuntimeProperties runtime = (RuntimeProperties)e.m_statics.get("__this__");
            ans = runtime.getProperty(this.m_key);
        }
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public String innerToString() {
        return "get-runtime-property";
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen(this.innerToString() + "@" + this.m_type.prettyPrint(), indent);
        pw.print("\"" + this.m_key + "\"");
        pw.printFormClose(indent);
    }

    @Override
    public boolean equals(Object other2) {
        boolean isEqual;
        if (other2 instanceof GetRuntimePropertyInstruction) {
            GetRuntimePropertyInstruction otherGRPI = (GetRuntimePropertyInstruction)other2;
            isEqual = this.m_key.equals(otherGRPI.m_key) && this.m_type.equals(otherGRPI.m_type) && super.equals(other2);
        } else {
            isEqual = false;
        }
        return isEqual;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_key = rofh.readString();
        this.m_type = (JavaObjectType)rofh.readType();
        this.setCachedType(this.m_type);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_key);
        wofh.writeType(this.m_type);
    }
}

