/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import java.util.LinkedList;

public class NegationInstruction
extends UnaryPrimopInstruction {
    public NegationInstruction() {
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        this.doDefaultTypeCheck(tenv, benv, functionStack);
        if (IntType.s_intType.equals(this.m_operand.typeCheck(tenv, benv, functionStack).resolveType(tenv))) {
            return this.setCachedType(IntType.s_intType);
        }
        return this.setCachedType(DoubleType.s_doubleType);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        if (IntType.s_intType.equals(this.m_operand.getType(tenv, benv).resolveType(tenv))) {
            return IntType.s_intType;
        }
        return DoubleType.s_doubleType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        NegationInstruction i = new NegationInstruction(this.m_operand.cloneWithoutTypeInformation());
        NegationInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        Type t = cgt.resolveType(this.m_operand);
        FcgType exprType = !(t instanceof INumericalType) ? CoerceInstruction.generateCoersion(cg, this.m_operand, DoubleType.s_doubleType, cgt, il) : cgt.generateConventionally(this.m_operand, cg, false, il, ValueGenStyle.DEFAULT);
        il.unaryOperationExpr(FcgUnaryOp.NEGATIVE);
        return exprType;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Type t;
        if (null != di) {
            di.enter(this, e, f2);
        }
        if (!((t = this.m_operand.evaluateType(f2)) instanceof INumericalType)) {
            BindingEnvironment benv = this.evaluateBindingEnvironment(f2);
            Double x = (Double)CoerceInstruction.evaluateCoersion(e, this.m_operand, DoubleType.s_doubleType, f2, benv, di);
            Double ans = new Double(-x.doubleValue());
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        Number n2 = (Number)this.m_operand.evaluate(e, f2, di, false);
        if (n2 instanceof Integer) {
            Integer ans = new Integer(-n2.intValue());
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        Double ans = new Double(-n2.doubleValue());
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    public NegationInstruction(Instruction op2) {
        super(op2);
    }

    @Override
    public String innerToString() {
        return "negation";
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op2) {
        NegationInstruction i = new NegationInstruction(op2);
        NegationInstruction.propagateInfo(this, i);
        return i;
    }
}

