/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.codegen.FcgXtqType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.QNameType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.FcgXmlType;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TernaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import java.util.LinkedList;
import javax.xml.namespace.QName;

public class QNameInstruction
extends TernaryPrimopInstruction {
    private static FcgClassReferenceType s_FcgQNameType;

    public QNameInstruction() {
        this.setCachedType();
    }

    public QNameInstruction(Instruction op1, Instruction op2, Instruction op3) {
        super(op1, op2, op3);
        this.setCachedType();
    }

    private void setCachedType() {
        this.setCachedType(QNameType.s_qnameType);
    }

    public QNameInstruction(String namespaceURI, String prefix2, String localName2) {
        this(StreamInstruction.charStreamLiteral(namespaceURI), StreamInstruction.charStreamLiteral(prefix2), StreamInstruction.charStreamLiteral(localName2));
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return QNameType.s_qnameType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return QNameType.s_qnameType;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        if (s_FcgQNameType == null) {
            s_FcgQNameType = cgh.getClassReferenceType(QName.class.getName());
        }
        if (this.m_operand1 instanceof IdentifierInstruction && this.m_operand2 instanceof IdentifierInstruction && this.m_operand3 instanceof IdentifierInstruction) {
            BindingEnvironment benv = cgt.m_bindingEnvironment;
            IdentifierInstruction namespaceURIIdent = (IdentifierInstruction)this.m_operand1;
            IdentifierInstruction localPartIdent = (IdentifierInstruction)this.m_operand3;
            IdentifierInstruction prefixIdent = (IdentifierInstruction)this.m_operand2;
            String namespaceURI = this.tryToEvalStaticallyToString(benv, namespaceURIIdent);
            String localPart = this.tryToEvalStaticallyToString(benv, localPartIdent);
            String prefix2 = this.tryToEvalStaticallyToString(benv, prefixIdent);
            if (namespaceURI != null && localPart != null && prefix2 != null) {
                FcgType fcgType = this.generateQNameConstant(cgh, cgt, il, namespaceURI, localPart, prefix2, valueStyleRequest);
                return fcgType;
            }
        }
        FcgType resultType = this.genRequestedConstruction(cgh, cgt, il, valueStyleRequest, false, null, null, null);
        return resultType;
    }

    private FcgType genRequestedConstruction(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il, ValueGenStyle valueStyleRequest, boolean isConstant, String namespaceURI, String localPart, String prefix2) {
        FcgType resultType;
        if (valueStyleRequest == ValueGenStyle.VOLATILECDATA || valueStyleRequest == ValueGenStyle.CURSOR) {
            FcgVariable this_var = il.findVar("__this__");
            if (this_var != null) {
                XDMSequenceType.generateSimpleFactoryVar(cgh, cgt, il);
            } else {
                il.invokeClassMethod(FcgXmlType.SESSIONCONTEXT, "getStaticSimpleDataFactory", (FcgType)FcgXmlType.CURSOR_FACTORY, 0);
            }
        }
        if (localPart != null) {
            il.loadLiteral(namespaceURI);
            il.loadLiteral(localPart);
            il.loadLiteral(prefix2);
        } else {
            FcgType t1 = cgt.generateConventionally(this.m_operand1, cgh, false, il, ValueGenStyle.STRING);
            il.convertExpr(t1, FcgType.STRING);
            FcgType t3 = cgt.generateConventionally(this.m_operand3, cgh, false, il, ValueGenStyle.STRING);
            il.convertExpr(t3, FcgType.STRING);
            FcgType t2 = cgt.generateConventionally(this.m_operand2, cgh, false, il, ValueGenStyle.STRING);
            il.convertExpr(t2, FcgType.STRING);
        }
        switch (valueStyleRequest) {
            case CURSOR: 
            case VOLATILECDATA: {
                il.loadClassField(FcgXmlType.TYPEREGISTRY, "XSQNAME", FcgXtqType.XSSIMPLETYPEDEFINITION);
                il.loadLiteral(false);
                FcgType[] argTypes = new FcgType[]{FcgType.CHARSEQUENCE, FcgType.CHARSEQUENCE, FcgType.CHARSEQUENCE, FcgXtqType.XSSIMPLETYPEDEFINITION, FcgType.BOOLEAN};
                resultType = valueStyleRequest == ValueGenStyle.CURSOR ? il.invokeInterfaceMethod(FcgXmlType.CURSOR_FACTORY, "sequence", (FcgType)FcgXmlType.CURSOR_TYPE, argTypes) : il.invokeInterfaceMethod(FcgXmlType.CURSOR_FACTORY, "data", (FcgType)FcgXmlType.CDATA, argTypes);
                if (!isConstant) break;
                il.loadLiteral(false);
                FcgType[] argTypes2 = new FcgType[]{FcgXmlType.VOLATILE_CDATA, FcgType.BOOLEAN};
                il.invokeClassMethod(FcgXtqType.BASIS_LIBRARY2, "constructEncodedCData", (FcgType)FcgXmlType.CDATA, argTypes2);
                break;
            }
            case DEFAULT: 
            case DEFAULT_WITH_PUSH: 
            case DEFAULT_NO_PUSH: 
            case QNAME: {
                resultType = il.createObjectExpr((FcgType)s_FcgQNameType, 3);
                break;
            }
            default: {
                throw new RuntimeException("Can't handle the valueStyleRequest!");
            }
        }
        return resultType;
    }

    public QName getStaticQName(BindingEnvironment benv) {
        QName staticName = null;
        if (this.m_operand1 instanceof IdentifierInstruction && this.m_operand2 instanceof IdentifierInstruction && this.m_operand3 instanceof IdentifierInstruction) {
            IdentifierInstruction namespaceURIIdent = (IdentifierInstruction)this.m_operand1;
            IdentifierInstruction localPartIdent = (IdentifierInstruction)this.m_operand3;
            IdentifierInstruction prefixIdent = (IdentifierInstruction)this.m_operand2;
            String namespaceURI = this.tryToEvalStaticallyToString(benv, namespaceURIIdent);
            String localPart = this.tryToEvalStaticallyToString(benv, localPartIdent);
            String prefix2 = this.tryToEvalStaticallyToString(benv, prefixIdent);
            if (namespaceURI != null && localPart != null && prefix2 != null) {
                staticName = new QName(namespaceURI, localPart, prefix2);
            }
        }
        return staticName;
    }

    private String tryToEvalStaticallyToString(BindingEnvironment benv, IdentifierInstruction ident) {
        StreamInstruction si;
        Instruction val;
        LetInstruction let = ident.getBinding(benv).getLet();
        if (let != null && (val = let.getValue()) instanceof StreamInstruction && (si = (StreamInstruction)val).isString()) {
            return si.getStringContent();
        }
        return null;
    }

    String getJavaIdent(String string2) {
        return Util.toJavaInternalName(string2);
    }

    private FcgType generateQNameConstant(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il, String namespaceURI, String localPart, String prefix2, ValueGenStyle valueStyleRequest) {
        String keyBase;
        FcgType resultType = valueStyleRequest == ValueGenStyle.DEFAULT || valueStyleRequest == ValueGenStyle.DEFAULT_NO_PUSH || valueStyleRequest == ValueGenStyle.DEFAULT_WITH_PUSH ? FcgXmlType.QNAME : valueStyleRequest.getFcgType();
        switch (valueStyleRequest) {
            case CURSOR: {
                keyBase = "CURS_";
                break;
            }
            case VOLATILECDATA: {
                keyBase = "ECD_";
                break;
            }
            case DEFAULT: 
            case DEFAULT_WITH_PUSH: 
            case DEFAULT_NO_PUSH: 
            case QNAME: {
                keyBase = "QN_";
                break;
            }
            default: {
                keyBase = valueStyleRequest.toString();
            }
        }
        String qnameKey = keyBase + "%^" + prefix2 + "_" + localPart + namespaceURI;
        String qnameIdentifier = cgt._executablesTable.get(qnameKey);
        if (!cgh.insertConstant(qnameKey, resultType, il)) {
            FcgInstructionList il2 = cgh.startConstantGeneration();
            resultType = this.genRequestedConstruction(cgh, cgt, il2, valueStyleRequest, true, namespaceURI, localPart, prefix2);
            qnameIdentifier = cgh.generateNewMemberVariableName(keyBase + this.getJavaIdent(prefix2) + "_" + this.getJavaIdent(localPart));
            cgh.finishConstantGeneration(qnameIdentifier, qnameIdentifier, resultType, il);
            cgt._executablesTable.put(qnameKey, qnameIdentifier);
        }
        return resultType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        QNameInstruction i = new QNameInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation(), this.m_operand3.cloneWithoutTypeInformation());
        QNameInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        tenv.unify(this.m_operand1.typeCheck(tenv, benv, functionStack), CharType.s_charType.getStreamType(), this);
        tenv.unify(this.m_operand2.typeCheck(tenv, benv, functionStack), CharType.s_charType.getStreamType(), this);
        tenv.unify(this.m_operand3.typeCheck(tenv, benv, functionStack), CharType.s_charType.getStreamType(), this);
        return this.setCachedType(QNameType.s_qnameType);
    }

    @Override
    public String innerToString() {
        return "qname";
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2, Instruction op3) {
        return new QNameInstruction(op1, op2, op3);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        IStream s1 = (IStream)this.m_operand1.evaluate(e, f2, di, false);
        IStream s2 = (IStream)this.m_operand2.evaluate(e, f2, di, false);
        IStream s3 = (IStream)this.m_operand3.evaluate(e, f2, di, false);
        QName ans = new QName(new String(s1.toCharArray()), new String(s3.toCharArray()), new String(s2.toCharArray()));
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }
}

