/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.debug;

import com.ibm.xltxe.rnm1.xtq.runtime.AbstractStarlet;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.FunctionEventImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TraceManagerImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TraceUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.debug.TraceEventInstruction;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xml.xci.exec.SourceLocation;
import java.io.IOException;
import java.util.HashMap;

public class FunctionEventInstruction
extends TraceEventInstruction {
    private String m_name;
    private HashMap<String, String> m_namespaceMap;
    private com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation m_endTagLocation;

    public FunctionEventInstruction() {
    }

    public FunctionEventInstruction(String name2, HashMap<String, String> namespaceMap, Instruction body) {
        super(body);
        this.m_name = name2;
        this.m_namespaceMap = namespaceMap;
    }

    @Override
    public Instruction cloneShallow() {
        FunctionEventInstruction instr = new FunctionEventInstruction(this.m_name, this.m_namespaceMap, this.m_body);
        instr.setSourceLocation(this.getSourceLocation());
        FunctionEventInstruction.propagateInfo(this, instr);
        return instr;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        FunctionEventInstruction instr = new FunctionEventInstruction(this.m_name, this.m_namespaceMap, this.m_body.cloneWithoutTypeInformation());
        instr.setSourceLocation(this.getSourceLocation());
        FunctionEventInstruction.propagateInfo(this, instr);
        return instr;
    }

    @Override
    public Object evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        AbstractStarlet starlet = (AbstractStarlet)e.m_statics.get("__this__");
        TraceManagerImpl tm = starlet.getTraceManager();
        HashMap<String, String> m_oldNamespaceMap = starlet.addNamespaces(this.m_namespaceMap);
        SourceLocation location = TraceUtils.getSourceLocation(this.getSourceLocation());
        FunctionEventImpl event = new FunctionEventImpl(4, this.m_name, location);
        tm.trace(event);
        Object ans = null;
        if (as != null) {
            this.m_body.evaluate(as, e, f2, di);
        } else {
            ans = this.m_body.evaluate(e, f2, di, tailPosition);
        }
        location = TraceUtils.getSourceLocation(this.getEndTagSourceLocation());
        event = new FunctionEventImpl(5, this.m_name, location);
        tm.trace(event);
        starlet.restoreNamespaces(m_oldNamespaceMap);
        return ans != null ? Debugger.leave(di, this, e, f2, ans) : null;
    }

    public void setName(String name2) {
        this.m_name = name2;
    }

    public String getName() {
        return this.m_name;
    }

    public void setNamespaceMap(HashMap<String, String> map2) {
        this.m_namespaceMap = map2;
    }

    public HashMap<String, String> getNamespaceMap() {
        return this.m_namespaceMap;
    }

    public void setEndTagSourceLocation(com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation location) {
        this.m_endTagLocation = location;
    }

    public com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation getEndTagSourceLocation() {
        return this.m_endTagLocation;
    }

    @Override
    public String innerToString() {
        return "trace-function-event";
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_name);
        if (this.m_namespaceMap == null) {
            wofh.writeBoolean(false);
        } else {
            wofh.writeBoolean(true);
            wofh.writeObject(this.m_namespaceMap);
        }
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_name = rofh.readString();
        if (rofh.readBoolean()) {
            this.m_namespaceMap = (HashMap)rofh.readObject();
        }
    }

    @Override
    public void doPropagateInfo(Instruction from2) {
        super.doPropagateInfo(from2);
        if (from2 instanceof FunctionEventInstruction) {
            this.setEndTagSourceLocation(((FunctionEventInstruction)from2).getEndTagSourceLocation());
        }
    }
}

