/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.debug;

import com.ibm.xltxe.rnm1.xtq.runtime.AbstractStarlet;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.InstructionEventImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TraceManagerImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TraceUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.debug.TraceEventInstruction;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xml.xci.exec.SourceLocation;
import com.ibm.xml.xci.exec.trace.InstructionEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class InstructionEventInstruction
extends TraceEventInstruction {
    private int m_instructionType;
    private HashMap<String, String> m_namespaceMap;
    private Instruction m_otherContextInfo;
    private boolean m_compatibilityMode;
    private com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation m_endLocation;

    public InstructionEventInstruction() {
    }

    public InstructionEventInstruction(int instructionType, HashMap<String, String> namespaceMap, Instruction otherContextInfo, boolean compatibilityMode, Instruction body) {
        super(body);
        this.m_instructionType = instructionType;
        this.m_namespaceMap = namespaceMap;
        this.m_otherContextInfo = otherContextInfo;
        this.m_compatibilityMode = compatibilityMode;
    }

    @Override
    public Instruction cloneShallow() {
        InstructionEventInstruction instr = new InstructionEventInstruction(this.m_instructionType, this.m_namespaceMap, this.m_otherContextInfo, this.m_compatibilityMode, this.m_body);
        instr.setSourceLocation(this.getSourceLocation());
        InstructionEventInstruction.propagateInfo(this, instr);
        return instr;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        InstructionEventInstruction instr = new InstructionEventInstruction(this.m_instructionType, this.m_namespaceMap, this.m_otherContextInfo.cloneWithoutTypeInformation(), this.m_compatibilityMode, this.m_body.cloneWithoutTypeInformation());
        instr.setSourceLocation(this.getSourceLocation());
        InstructionEventInstruction.propagateInfo(this, instr);
        return instr;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        this.m_otherContextInfo.typeCheck(tenv, benv, functionStack);
        return this.setCachedType(this.m_body.typeCheck(tenv, benv, functionStack));
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_otherContextInfo = rh.reduceToBasicInstruction(state, this.m_otherContextInfo, benv);
        state[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public final int getChildInstructionCount() {
        return 2;
    }

    @Override
    public final Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_otherContextInfo;
            }
            case 1: {
                return this.m_body;
            }
        }
        return null;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_otherContextInfo = n2;
            }
            case 1: {
                this.m_body = n2;
            }
        }
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return i == 1;
    }

    @Override
    public Object evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        AbstractStarlet translet = (AbstractStarlet)e.m_statics.get("__this__");
        TraceManagerImpl tm = translet.getTraceManager();
        Object contextInfo = this.m_otherContextInfo.evaluate(e, f2, di, tailPosition);
        HashMap<String, String> m_oldNamespaceMap = translet.addNamespaces(this.m_namespaceMap);
        SourceLocation location = TraceUtils.getSourceLocation(this.getSourceLocation());
        InstructionEventImpl event = new InstructionEventImpl(6, this.m_instructionType, location, translet, contextInfo, this.m_compatibilityMode);
        tm.trace(event);
        Object ans = null;
        if (as != null) {
            this.m_body.evaluate(as, e, f2, di);
        } else {
            ans = this.m_body.evaluate(e, f2, di, tailPosition);
        }
        if (as != null) {
            as.append(ans, this.evaluateType(f2));
        }
        location = TraceUtils.getSourceLocation(this.getEndSourceLocation());
        event = new InstructionEventImpl(7, this.m_instructionType, location, translet, contextInfo, this.m_compatibilityMode);
        tm.trace(event);
        translet.restoreNamespaces(m_oldNamespaceMap);
        return ans != null ? Debugger.leave(di, this, e, f2, ans) : null;
    }

    public void setInstructionType(int type2) {
        this.m_instructionType = type2;
    }

    public int getInstructionType() {
        return this.m_instructionType;
    }

    public void setNamespaceMap(HashMap<String, String> map2) {
        this.m_namespaceMap = map2;
    }

    public HashMap<String, String> getNamespaceMap() {
        return this.m_namespaceMap;
    }

    public void setOtherContextInfo(Instruction otherContextInfo) {
        this.m_otherContextInfo = otherContextInfo;
    }

    public Instruction getOtherContextInfo() {
        return this.m_otherContextInfo;
    }

    public void setCompatibilityMode(boolean setting) {
        this.m_compatibilityMode = setting;
    }

    public boolean getCompatibilityMode() {
        return this.m_compatibilityMode;
    }

    public void setEndSourceLocation(com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation location) {
        this.m_endLocation = location;
    }

    public com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation getEndSourceLocation() {
        return this.m_endLocation;
    }

    @Override
    public String innerToString() {
        return "trace-instruction-event";
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen(this.innerToString(), indent);
        pw.printToken(InstructionEvent.s_elementNames[this.m_instructionType], indent + 1);
        this.m_body.toString(pw, indent + 1);
        pw.printFormClose(indent);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeInt(this.m_instructionType);
        if (this.m_namespaceMap == null) {
            wofh.writeBoolean(false);
        } else {
            wofh.writeBoolean(true);
            wofh.writeObject(this.m_namespaceMap);
        }
        wofh.writeInstruction(this.m_otherContextInfo);
        wofh.writeBoolean(this.m_compatibilityMode);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_instructionType = rofh.readInt();
        if (rofh.readBoolean()) {
            this.m_namespaceMap = (HashMap)rofh.readObject();
        }
        this.m_otherContextInfo = rofh.readInstruction(benv);
        this.m_compatibilityMode = rofh.readBoolean();
    }

    @Override
    public void doPropagateInfo(Instruction from2) {
        super.doPropagateInfo(from2);
        if (from2 instanceof InstructionEventInstruction) {
            this.setEndSourceLocation(((InstructionEventInstruction)from2).getEndSourceLocation());
        }
    }
}

