/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.debug;

import com.ibm.xltxe.rnm1.xtq.exec.AbstractSPIExecutable;
import com.ibm.xltxe.rnm1.xtq.runtime.AbstractStarlet;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.JavaExtensionEventImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TraceManagerImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.v2.BasisLibrary2;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XSLT2Translator;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.debug.TraceEventInstruction;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.exec.BasicMutableDynamicContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class JavaExtensionEventInstruction
extends TraceEventInstruction {
    private static final Logger s_logger = LoggerUtil.getLogger(XSLT2Translator.class);
    private static final String s_className = JavaExtensionEventInstruction.class.getName();
    private QName m_name;
    private int m_arity;
    private String className;

    public JavaExtensionEventInstruction() {
    }

    public JavaExtensionEventInstruction(QName name2, int arity, String clazz, Instruction body) {
        super(body);
        this.m_name = name2;
        this.m_arity = arity;
        this.className = clazz;
    }

    @Override
    public Instruction cloneShallow() {
        JavaExtensionEventInstruction instr = new JavaExtensionEventInstruction(this.m_name, this.m_arity, this.className, this.m_body);
        instr.setSourceLocation(this.getSourceLocation());
        JavaExtensionEventInstruction.propagateInfo(this, instr);
        return instr;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        JavaExtensionEventInstruction instr = new JavaExtensionEventInstruction(this.m_name, this.m_arity, this.className, this.m_body.cloneWithoutTypeInformation());
        instr.setSourceLocation(this.getSourceLocation());
        JavaExtensionEventInstruction.propagateInfo(this, instr);
        return instr;
    }

    @Override
    public Object evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        JavaExtensionEventImpl event;
        if (null != di) {
            di.enter(this, e, f2);
        }
        AbstractStarlet starlet = (AbstractStarlet)e.m_statics.get("__this__");
        TraceManagerImpl tm = starlet.getTraceManager();
        DynamicContext dc = e.getDynamicContext();
        Executable exec = dc.getFunction(this.m_name, this.m_arity);
        Member method = null;
        if (this.className == null) {
            block21: {
                if (exec instanceof BasicMutableDynamicContext.JavaMethodExecutable) {
                    method = ((BasicMutableDynamicContext.JavaMethodExecutable)exec).getMethod();
                } else {
                    try {
                        method = Executable.class.getMethod("execute", Cursor.class, DynamicContext.class, Cursor.Profile.class, Cursor[].class);
                    }
                    catch (Exception ex) {
                        if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINE)) break block21;
                        s_logger.logp(Level.FINE, s_className, "evaluate", ex.getMessage());
                    }
                }
            }
            if (method != null) {
                event = new JavaExtensionEventImpl(13, (Method)method);
                tm.trace(event);
            } else if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "evaluate", "Failed to retrieve method for Java extension call.");
            }
        } else {
            method = BasisLibrary2.resolveJavaExtensionMember(this.m_name, this.className, this.m_arity, (AbstractSPIExecutable)starlet.getExecutable(), null);
            if (method instanceof Method) {
                event = new JavaExtensionEventImpl(13, (Method)method);
                tm.trace(event);
            } else if (method instanceof Constructor) {
                event = new JavaExtensionEventImpl(13, (Constructor)method);
                tm.trace(event);
            }
        }
        Object ans = null;
        if (as != null) {
            this.m_body.evaluate(as, e, f2, di);
        } else {
            ans = this.m_body.evaluate(e, f2, di, tailPosition);
        }
        if (this.className == null) {
            if (method != null) {
                JavaExtensionEventImpl event2 = new JavaExtensionEventImpl(14, (Method)method);
                tm.trace(event2);
            }
        } else if (method instanceof Method) {
            JavaExtensionEventImpl event3 = new JavaExtensionEventImpl(14, (Method)method);
            tm.trace(event3);
        } else if (method instanceof Constructor) {
            JavaExtensionEventImpl event4 = new JavaExtensionEventImpl(14, (Constructor)method);
            tm.trace(event4);
        }
        return ans != null ? Debugger.leave(di, this, e, f2, ans) : null;
    }

    public void setName(QName name2) {
        this.m_name = name2;
    }

    public QName getName() {
        return this.m_name;
    }

    public void setArity(int arity) {
        this.m_arity = arity;
    }

    public int getArity() {
        return this.m_arity;
    }

    @Override
    public String innerToString() {
        return "trace-function-event";
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_name.getLocalPart());
        wofh.writeString(this.m_name.getNamespaceURI());
        wofh.writeInt(this.m_arity);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        String name2 = rofh.readString();
        String namespace2 = rofh.readString();
        this.m_name = new QName(namespace2, name2);
        this.m_arity = rofh.readInt();
    }
}

