/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.debug;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.AbstractTranslet;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TemplateEventImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TraceManagerImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TraceUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.debug.TraceEventInstruction;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xml.xci.exec.SourceLocation;
import java.io.IOException;
import java.util.HashMap;

public class TemplateEventInstruction
extends TraceEventInstruction {
    private String m_name;
    private String m_match;
    private String m_mode;
    private String m_priority;
    private String m_as;
    private HashMap<String, String> m_namespaceMap;
    private com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation m_endTagLocation;

    public TemplateEventInstruction() {
    }

    public TemplateEventInstruction(String name2, String match, String mode, String priority, String as, HashMap<String, String> namespaceMap, Instruction body) {
        super(body);
        this.m_name = name2;
        this.m_match = match;
        this.m_mode = mode;
        this.m_priority = priority;
        this.m_as = as;
        this.m_namespaceMap = namespaceMap;
    }

    @Override
    public Instruction cloneShallow() {
        TemplateEventInstruction instr = new TemplateEventInstruction(this.m_name, this.m_match, this.m_mode, this.m_priority, this.m_as, this.m_namespaceMap, this.m_body);
        instr.setSourceLocation(this.getSourceLocation());
        TemplateEventInstruction.propagateInfo(this, instr);
        return instr;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        TemplateEventInstruction instr = new TemplateEventInstruction(this.m_name, this.m_match, this.m_mode, this.m_priority, this.m_as, this.m_namespaceMap, this.m_body.cloneWithoutTypeInformation());
        instr.setSourceLocation(this.getSourceLocation());
        TemplateEventInstruction.propagateInfo(this, instr);
        return instr;
    }

    @Override
    public Object evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        AbstractTranslet translet = (AbstractTranslet)e.m_statics.get("__this__");
        TraceManagerImpl tm = translet.getTraceManager();
        HashMap<String, String> m_oldNamespaceMap = translet.addNamespaces(this.m_namespaceMap);
        SourceLocation location = TraceUtils.getSourceLocation(this.getSourceLocation());
        TemplateEventImpl event = new TemplateEventImpl(2, this.m_name, this.m_match, this.m_mode, this.m_priority, this.m_as, location);
        tm.trace(event);
        Object ans = null;
        if (as != null) {
            this.m_body.evaluate(as, e, f2, di);
        } else {
            ans = this.m_body.evaluate(e, f2, di, tailPosition);
        }
        location = TraceUtils.getSourceLocation(this.getEndTagSourceLocation());
        event = new TemplateEventImpl(3, this.m_name, this.m_match, this.m_mode, this.m_priority, this.m_as, location);
        tm.trace(event);
        translet.restoreNamespaces(m_oldNamespaceMap);
        return ans != null ? Debugger.leave(di, this, e, f2, ans) : null;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name2) {
        this.m_name = name2;
    }

    public String getMatch() {
        return this.m_match;
    }

    public void setMatch(String match) {
        this.m_match = match;
    }

    public String getMode() {
        return this.m_mode;
    }

    public void setMode(String mode) {
        this.m_mode = mode;
    }

    public String getPriority() {
        return this.m_priority;
    }

    public void setPriority(String priority) {
        this.m_priority = priority;
    }

    public String getAs() {
        return this.m_as;
    }

    public void setAs(String as) {
        this.m_as = as;
    }

    public void setNamespaceMap(HashMap<String, String> map2) {
        this.m_namespaceMap = map2;
    }

    public HashMap<String, String> getNamespaceMap() {
        return this.m_namespaceMap;
    }

    public void setEndTagSourceLocation(com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation location) {
        this.m_endTagLocation = location;
    }

    public com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation getEndTagSourceLocation() {
        return this.m_endTagLocation;
    }

    @Override
    public String innerToString() {
        return "trace-template-event";
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_name);
        wofh.writeString(this.m_match);
        wofh.writeString(this.m_mode);
        wofh.writeString(this.m_priority);
        wofh.writeString(this.m_as);
        if (this.m_namespaceMap == null) {
            wofh.writeBoolean(false);
        } else {
            wofh.writeBoolean(true);
            wofh.writeObject(this.m_namespaceMap);
        }
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_name = rofh.readString();
        this.m_match = rofh.readString();
        this.m_mode = rofh.readString();
        this.m_priority = rofh.readString();
        this.m_as = rofh.readString();
        if (rofh.readBoolean()) {
            this.m_namespaceMap = (HashMap)rofh.readObject();
        }
    }

    @Override
    public void doPropagateInfo(Instruction from2) {
        super.doPropagateInfo(from2);
        if (from2 instanceof TemplateEventInstruction) {
            this.setEndTagSourceLocation(((TemplateEventInstruction)from2).getEndTagSourceLocation());
        }
    }
}

