/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.debug;

import com.ibm.xltxe.rnm1.xtq.runtime.AbstractStarlet;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TraceManagerImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TraceUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.VariableEventImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.debug.TraceEventInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.exec.SourceLocation;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class VariableEventInstruction
extends TraceEventInstruction {
    private String m_name;
    private boolean m_isParam;
    private boolean m_isGlobal;
    private Instruction m_value;

    public VariableEventInstruction() {
    }

    public VariableEventInstruction(String name2, boolean isParam, boolean isGlobal, Instruction value2, Instruction body) {
        super(body);
        this.m_name = name2;
        this.m_isParam = isParam;
        this.m_isGlobal = isGlobal;
        this.m_value = value2;
    }

    @Override
    public Instruction cloneShallow() {
        VariableEventInstruction instr = new VariableEventInstruction(this.m_name, this.m_isParam, this.m_isGlobal, this.m_value, this.m_body);
        instr.setSourceLocation(this.getSourceLocation());
        VariableEventInstruction.propagateInfo(this, instr);
        return instr;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        VariableEventInstruction instr = new VariableEventInstruction(this.m_name, this.m_isParam, this.m_isGlobal, this.m_value.cloneWithoutTypeInformation(), this.m_body.cloneWithoutTypeInformation());
        instr.setSourceLocation(this.getSourceLocation());
        VariableEventInstruction.propagateInfo(this, instr);
        return instr;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        this.m_value.typeCheck(tenv, benv, functionStack);
        return this.setCachedType(this.m_body.typeCheck(tenv, benv, functionStack));
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_value = rh.reduceToBasicInstruction(state, this.m_value, benv);
        state[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public final int getChildInstructionCount() {
        return 2;
    }

    @Override
    public final Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_value;
            }
            case 1: {
                return this.m_body;
            }
        }
        return null;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_value = n2;
            }
            case 1: {
                this.m_body = n2;
            }
        }
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return i == 1;
    }

    @Override
    public Object evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Cursor cursor2;
        if (null != di) {
            di.enter(this, e, f2);
        }
        AbstractStarlet starlet = (AbstractStarlet)e.m_statics.get("__this__");
        TraceManagerImpl tm = starlet.getTraceManager();
        Object valueObj = this.m_value.evaluate(e, f2, di, tailPosition);
        Cursor value2 = null;
        boolean releaseValue = false;
        if (valueObj != null) {
            value2 = (Cursor)valueObj;
            Type type2 = this.m_value.evaluateType(f2);
            if (type2.equals(XDMItemType.s_itemType)) {
                value2 = value2.fork(false);
                value2.toSelf();
                releaseValue = true;
            }
        }
        HashMap<String, Cursor> variableValues = starlet.getVariableValues();
        boolean restore = variableValues.containsKey(this.m_name);
        Cursor oldValue = variableValues.put(this.m_name, value2 == null ? value2 : value2.fork(false));
        SourceLocation location = TraceUtils.getSourceLocation(this.getSourceLocation());
        VariableEventImpl event = new VariableEventImpl(8, this.m_name, this.m_isParam, this.m_isGlobal, value2, location);
        tm.trace(event);
        Object ans = null;
        if (as != null) {
            this.m_body.evaluate(as, e, f2, di);
        } else {
            ans = this.m_body.evaluate(e, f2, di, tailPosition);
        }
        event = new VariableEventImpl(9, this.m_name, this.m_isParam, this.m_isGlobal, null, location);
        tm.trace(event);
        if (releaseValue) {
            value2.release();
        }
        if ((cursor2 = restore ? variableValues.put(this.m_name, oldValue) : variableValues.remove(this.m_name)) != null) {
            cursor2.release();
        }
        return ans != null ? Debugger.leave(di, this, e, f2, ans) : null;
    }

    public void setName(String name2) {
        this.m_name = name2;
    }

    public String getName() {
        return this.m_name;
    }

    public void setIsParam(boolean isParam) {
        this.m_isParam = isParam;
    }

    public boolean getIsParam() {
        return this.m_isParam;
    }

    public void setIsGlobal(boolean isGlobal) {
        this.m_isGlobal = isGlobal;
    }

    public boolean getIsGlobal() {
        return this.m_isGlobal;
    }

    public void setValue(Instruction value2) {
        this.m_value = value2;
    }

    public Instruction getValue() {
        return this.m_value;
    }

    @Override
    public String innerToString() {
        return "trace-variable-event";
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen(this.innerToString(), indent);
        this.m_value.toString(pw, indent + 1);
        this.m_body.toString(pw, indent + 1);
        pw.printFormClose(indent);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_name);
        wofh.writeBoolean(this.m_isParam);
        wofh.writeBoolean(this.m_isGlobal);
        wofh.writeInstruction(this.m_value);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_name = rofh.readString();
        this.m_isParam = rofh.readBoolean();
        this.m_isGlobal = rofh.readBoolean();
        this.m_value = rofh.readInstruction(benv);
    }
}

