/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.IMinimalFeatureUsage;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ItemKind;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.MatchXDMItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;

public class DeconstructMatchXDMItemInstruction
extends Instruction
implements ISpecialForm,
IMinimalFeatureUsage {
    ItemKind m_itemKind;
    protected Binding[] m_bindings;
    protected String m_moduleName;
    Instruction m_handler;

    protected DeconstructMatchXDMItemInstruction() {
    }

    public DeconstructMatchXDMItemInstruction(String moduleName, ItemKind itemKind, int fields, int fieldToExtract) {
        this(moduleName, itemKind, DeconstructMatchXDMItemInstruction.makeFields(OptimizerUtilities.generateIntermediateIdentifier(), fields, fieldToExtract), null, true);
        this.m_handler = new IdentifierInstruction(this.m_bindings[fieldToExtract].getName());
    }

    public DeconstructMatchXDMItemInstruction(String moduleName, ItemKind itemKind, Binding[] bindings, Instruction handler) {
        this.m_itemKind = itemKind;
        this.m_moduleName = moduleName;
        this.m_handler = handler;
        assert (bindings instanceof Binding[]);
        this.m_bindings = bindings;
    }

    public DeconstructMatchXDMItemInstruction(String moduleName, ItemKind itemKind, Object[] varNames, Instruction handler, boolean isVarList) {
        this.m_itemKind = itemKind;
        this.m_moduleName = moduleName;
        this.m_handler = handler;
        assert (!(varNames instanceof Binding[]));
        assert (isVarList);
        this.m_bindings = Binding.getBindings(varNames);
    }

    @Override
    public Instruction cloneShallow() {
        Object[] newBindingNames = new Object[this.m_bindings.length];
        for (int i = 0; i < this.m_bindings.length; ++i) {
            newBindingNames[i] = this.m_bindings[i].getName();
        }
        return new DeconstructMatchXDMItemInstruction(this.m_moduleName, this.m_itemKind, newBindingNames, this.m_handler, true);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Object[] newBindingNames = new Object[this.m_bindings.length];
        for (int i = 0; i < this.m_bindings.length; ++i) {
            newBindingNames[i] = this.m_bindings[i].getName();
        }
        return new DeconstructMatchXDMItemInstruction(this.m_moduleName, this.m_itemKind, newBindingNames, this.m_handler.cloneWithoutTypeInformation(), true);
    }

    static Object[] makeFields(String prefix2, int fields, int fieldToExtract) {
        Object[] x = new Object[fields];
        for (int i = 0; i < fields; ++i) {
            x[i] = i == fieldToExtract ? prefix2 + i : "_";
        }
        return x;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        if (this.m_itemKind.lengthParams() != this.m_bindings.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Expected " + this.m_itemKind.lengthParams() + " but got " + this.m_bindings.length + " in Deconstruction match " + this), this.m_handler);
        }
        BindingEnvironment benv2 = new BindingEnvironment(benv);
        for (int i = 0; i < this.m_itemKind.lengthParams(); ++i) {
            this.m_bindings[i].setType(this.m_itemKind.getParamType(i));
            benv2.setVariableBinding(this.m_bindings[i]);
        }
        Type resultType = this.m_handler.typeCheck(tenv, benv2, functionStack);
        assert (resultType != null);
        return this.setCachedType(resultType);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        if (this.m_itemKind.lengthParams() != this.m_bindings.length) {
            throw new XylemError("ERR_SYSTEM", "Expected " + this.m_itemKind.lengthParams() + " but got " + this.m_bindings.length + " in Deconstruction match " + this);
        }
        for (int i = 0; i < this.m_itemKind.lengthParams(); ++i) {
            if (this.m_bindings[i].getName().equals("_")) continue;
            this.m_bindings[i].setType(this.m_itemKind.getParamType(i));
            benv.setVariableBinding(this.m_bindings[i]);
        }
        this.m_handler.typeCheckReduced(tenv, benv, functionStack);
    }

    public Binding[] getBindings() {
        return this.m_bindings;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_moduleName = rofh.readString();
        this.m_itemKind = ItemKind.stringToItemKind(rofh.readString());
        this.m_bindings = Binding.getBindings(rofh.readBindingNames());
        this.m_handler = rofh.readInstruction(benv);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(" + this.m_itemKind.getName());
        for (int i = 0; i < this.m_bindings.length; ++i) {
            sb.append(" ");
            sb.append(this.m_bindings[i].getName());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        String com = this.m_handler.getLocationComment();
        if (com != null) {
            pw.comment(com, indent);
        }
        pw.printFormOpen("case", indent);
        pw.printFormOpen(this.m_itemKind.getName(), indent + 1);
        for (int i = 0; i < this.m_bindings.length; ++i) {
            pw.printIdentifier(this.m_bindings[i], indent + 2);
        }
        pw.printFormClose(indent + 1);
        this.m_handler.toString(pw, indent + 1);
        pw.printFormClose(indent);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeString(this.m_moduleName);
        wofh.writeString(this.m_itemKind.getName());
        wofh.writeBindingNames(this.m_bindings);
        wofh.writeInstruction(this.m_handler);
    }

    public ItemKind getItemKind() {
        return this.m_itemKind;
    }

    public XType getXTypeFromMatch() {
        ItemKind ik = this.getItemKind();
        XType matchXType = ik.getXType();
        return matchXType;
    }

    public Instruction getHandler() {
        return this.m_handler;
    }

    public void setHandler(Instruction h) {
        this.m_handler = h;
    }

    @Override
    public void generateReducedForm(ReductionHelper rh0, Instruction[] state, BindingEnvironment benv) {
        ReductionHelper rh = (ReductionHelper)rh0.clone();
        int c2 = this.m_bindings.length;
        for (int i2 = 0; i2 < c2; ++i2) {
            if (this.m_bindings[i2].getName().equals("_")) continue;
            rh.upgradeBinding(this.m_bindings[i2]);
            benv.setVariableBinding(this.m_bindings[i2]);
        }
        this.m_handler = rh.reduce(this.m_handler, benv);
    }

    @Override
    protected Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        if (this.m_handler != null) {
            return this.m_handler.getType(tenv, benv);
        }
        return this.m_bindings[0].getBindingType();
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        return this.m_bindings;
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return i == 0;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return false;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        if (this.isChildInstructionBody(i)) {
            return this.m_handler;
        }
        return null;
    }

    @Override
    public int getChildInstructionCount() {
        return 1;
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        DeconstructMatchXDMItemInstruction dm = this;
        for (int j = 0; j < dm.m_bindings.length; ++j) {
            set2.remove(dm.m_bindings[j]);
        }
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        DeconstructMatchXDMItemInstruction dm = this;
        for (int j = 0; j < dm.m_bindings.length; ++j) {
            set2.remove(dm.m_bindings[j]);
        }
    }

    @Override
    public boolean equals(Object arg0) {
        if (!(arg0 instanceof MatchXDMItemInstruction)) {
            return false;
        }
        DeconstructMatchXDMItemInstruction dm = this;
        DeconstructMatchXDMItemInstruction dm2 = (DeconstructMatchXDMItemInstruction)arg0;
        if (dm.m_bindings.length != dm2.m_bindings.length) {
            return false;
        }
        if (!dm.m_itemKind.equals((Object)dm2.m_itemKind)) {
            return false;
        }
        if (dm.m_handler instanceof IdentifierInstruction && dm2.m_handler instanceof IdentifierInstruction) {
            IdentifierInstruction x = (IdentifierInstruction)dm.m_handler;
            IdentifierInstruction y = (IdentifierInstruction)dm2.m_handler;
            for (int j = 0; j < dm.m_bindings.length; ++j) {
                if (!dm.m_bindings[j].equals(x.getVariable()) || !dm2.m_bindings[j].equals(y.getVariable())) continue;
                return true;
            }
            return false;
        }
        return super.equals(arg0);
    }
}

