/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.IteratorXDMSequenceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.CharArrayWriterStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.ListStream;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xml.xci.Cursor;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ForEachXDMSequenceStreamInstruction
extends IteratorXDMSequenceInstruction
implements IStreamOptimizationInstruction {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Instruction m_source;
    protected Instruction m_body;
    protected Binding m_binding;
    protected Binding m_indexBinding = null;

    public ForEachXDMSequenceStreamInstruction() {
    }

    public ForEachXDMSequenceStreamInstruction(Instruction source, Object var, Instruction body) {
        this(source, var, null, body);
    }

    public ForEachXDMSequenceStreamInstruction(Instruction source, Object var, Object indexVar, Instruction body) {
        this.m_source = source;
        this.m_binding = new Binding(var, (Type)XDMItemType.s_itemType, this);
        if (indexVar != null) {
            this.m_indexBinding = new Binding(indexVar, (Type)IntType.s_intType, this);
        }
        this.m_body = body;
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        set2.remove(this.m_binding);
        if (this.m_indexBinding != null) {
            set2.remove(this.m_indexBinding);
        }
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        set2.remove(this.m_binding);
        if (this.m_indexBinding != null) {
            set2.remove(this.m_indexBinding);
        }
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Object var = ing.getNewName();
        names.put(this.m_binding.getName(), new IdentifierInstruction(var));
        Object indexVar = null;
        if (this.m_indexBinding != null) {
            indexVar = ing.getNewName();
            names.put(this.m_indexBinding.getName(), new IdentifierInstruction(indexVar));
        }
        return new ForEachXDMSequenceStreamInstruction(this.m_source.assignNewNames(names, ing), var, indexVar, this.m_body.assignNewNames(names, ing));
    }

    @Override
    public Instruction cloneShallow() {
        if (this.m_binding.getBindingType() instanceof TypeVariable) {
            ForEachXDMSequenceStreamInstruction i = new ForEachXDMSequenceStreamInstruction(this.m_source, this.m_binding.getName(), this.m_indexBinding == null ? null : this.m_indexBinding.getName(), this.m_body);
            ForEachXDMSequenceStreamInstruction.propagateInfo(this, i);
            return i;
        }
        ForEachXDMSequenceStreamInstruction i = new ForEachXDMSequenceStreamInstruction(this.m_source, this.m_binding.getName(), this.m_indexBinding == null ? null : this.m_indexBinding.getName(), this.m_body);
        ForEachXDMSequenceStreamInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        if (this.m_binding.getBindingType() instanceof TypeVariable) {
            ForEachXDMSequenceStreamInstruction i = new ForEachXDMSequenceStreamInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_binding.getName(), this.m_indexBinding == null ? null : this.m_indexBinding.getName(), this.m_body.cloneWithoutTypeInformation());
            ForEachXDMSequenceStreamInstruction.propagateInfo(this, i);
            return i;
        }
        ForEachXDMSequenceStreamInstruction i = new ForEachXDMSequenceStreamInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_binding.getName(), this.m_indexBinding == null ? null : this.m_indexBinding.getName(), this.m_body.cloneWithoutTypeInformation());
        ForEachXDMSequenceStreamInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        CharArrayWriterStream as = CharType.s_charType.getStreamType().equals(this.getCachedType()) ? new CharArrayWriterStream() : (IAppendableStream)((Object)e.pushIForkReleaseManagedForRelease(new ListStream()));
        this.evaluate(as, e, f2, di);
        return as;
    }

    @Override
    public void evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di) {
        Cursor source;
        if (null != di) {
            di.enter(this, e, f2);
        }
        if ((source = (Cursor)this.m_source.evaluate(e, f2, di, false)) == null) {
            return;
        }
        source = e.pushForkForRelease(source.fork(false, Cursor.STREAMING_READ, Cursor.RANDOM_ACCESS));
        int index2 = 0;
        assert (this.m_binding.getBindingType() instanceof XDMItemType);
        e.bindInCurrentFrame(this.m_binding, source);
        do {
            if (this.m_indexBinding != null) {
                e.bindInCurrentFrame(this.m_indexBinding, new Integer(index2));
                ++index2;
            }
            this.m_body.evaluate(as, e, f2, di);
        } while (source.toNext());
        Debugger.leave(di, this, e, f2, (Object)"(void)");
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        Instruction source = rh.reduceToBasicInstruction(state, this.m_source, benv);
        ForEachXDMSequenceStreamInstruction ai = this;
        ai.m_source = source;
        ReductionHelper rh2 = (ReductionHelper)rh.clone();
        rh2.upgradeBinding(this.m_binding);
        benv.setVariableBinding(ai.m_binding);
        if (this.m_indexBinding != null) {
            rh2.upgradeBinding(this.m_indexBinding);
            benv.setVariableBinding(ai.m_indexBinding);
        }
        ai.m_body = rh2.reduce(this.m_body, benv);
        state[0] = ai;
        this.m_bindingEnvironment = null;
    }

    @Override
    public Instruction getBody() {
        return this.m_body;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_source;
            }
            case 1: {
                return this.m_body;
            }
        }
        return null;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        if (i != 1) {
            return null;
        }
        if (this.m_indexBinding == null) {
            return new IBinding[]{this.m_binding};
        }
        return new IBinding[]{this.m_binding, this.m_indexBinding};
    }

    @Override
    public int getChildInstructionCount() {
        return 2;
    }

    public IBinding getIndexBinding() {
        return this.m_indexBinding;
    }

    @Override
    public Object getIndexVar() {
        return this.m_indexBinding == null ? null : this.m_indexBinding.getName();
    }

    public Instruction getSource() {
        return this.m_source;
    }

    @Override
    public Instruction[] getSources() {
        return new Instruction[]{this.m_source};
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_body.getType(tenv, benv);
    }

    public Binding getVarBinding() {
        return this.m_binding;
    }

    public Object getVarName() {
        return this.m_binding.getName();
    }

    Type getVarType() {
        return XDMItemType.s_itemType;
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return i == 1;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return false;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_source = rofh.readInstruction(benv);
        this.m_binding = new Binding(rofh.readBindingName(), (Type)new TypeVariable(), this);
        if (rofh.readBoolean()) {
            this.m_indexBinding = new Binding(rofh.readBindingName(), (Type)IntType.s_intType, this);
        }
        this.m_body = rofh.readInstruction(benv);
        this.m_binding.setType(XDMItemType.s_itemType);
    }

    public void setBody(Instruction n2) {
        this.m_body = n2;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_source = n2;
                break;
            }
            case 1: {
                this.m_body = n2;
            }
        }
    }

    public void setIndexVar(Object indexVar) {
        this.m_indexBinding = indexVar == null ? null : new Binding(indexVar, (Type)IntType.s_intType, this);
    }

    public void setSource(Instruction source2) {
        this.m_source = source2;
    }

    @Override
    public String innerToString() {
        String x = this.m_indexBinding == null ? "foreach-XDMSequence-stream" : "foreach-c-XDMSequence-stream";
        return x;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.newline();
        pw.printFormOpen(this.innerToString(), indent, this.getTypeForTypeAnnotationPrettyPrint());
        pw.printIdentifier(this.m_binding, indent + 1);
        this.m_source.toString(pw, indent + 1);
        if (this.m_indexBinding != null) {
            pw.printIdentifier(this.m_indexBinding, indent + 1);
        }
        this.m_body.toString(pw, indent + 1);
        pw.print(")");
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        if (this.m_indexBinding != null) {
            this.m_indexBinding.setTypeEnvironment(tenv);
            benv = new BindingEnvironment(benv, this.m_indexBinding);
        }
        Type sourcetype = this.m_source.typeCheck(tenv, benv, functionStack);
        tenv.unify(sourcetype, XDMSequenceType.s_sequenceType, this);
        BindingEnvironment benv2 = new BindingEnvironment(benv);
        this.typeCheckLoopVariableBinding(tenv, benv2, sourcetype, this.m_binding);
        Type t = this.m_body.typeCheck(tenv, benv2, functionStack);
        tenv.unify(t, new TypeVariable().getStreamType(), this);
        return this.setCachedType(t);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        benv.setVariableBinding(this.m_binding);
        if (this.m_indexBinding != null) {
            benv.setVariableBinding(this.m_indexBinding);
        }
        this.m_body.typeCheckReduced(tenv, benv, functionStack);
        this.clearLocalForTypecheckReduced();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_source);
        wofh.writeBindingName(this.m_binding.getName());
        wofh.writeBoolean(this.m_indexBinding != null);
        if (this.m_indexBinding != null) {
            wofh.writeBindingName(this.m_indexBinding.getName());
        }
        wofh.writeInstruction(this.m_body);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        IBinding toSkip = ((IdentifierInstruction)this.m_source).getBinding(cgt.m_bindingEnvironment);
        cgt.generateFreeBindings(this, cgh, il, toSkip, false, false, ValueGenStyle.DEFAULT);
        Type streamType = cgt.resolveType(this);
        String varName2 = cgh.generateNewLocalVariableName(varNameSuggestion);
        FcgVariable var2 = il.defineVar(streamType.getFCGType(cgh), varName2, false);
        ((StreamType)streamType).generateCreateStream(varName2, 128, cgh, il);
        boolean usesIndex = this.m_indexBinding != null && cgt.isBindingUsed(this.m_indexBinding);
        FcgVariable index2 = null;
        if (usesIndex) {
            il.loadLiteral(0);
            index2 = il.defineVar(FcgType.INT, cgh.generateNewLocalVariableName(), true);
        }
        Type seqTypeMaybe = this.m_source.getCachedType();
        XDMSequenceType sequenceType = XDMSequenceType.getXDMSequenceType(seqTypeMaybe);
        FcgType fcgItemType = XDMItemType.s_itemType.getFCGType(cgh);
        FcgVariable currentElement = sequenceType.generateLoopStart(cgh, il, this.m_source, fcgItemType, cgt);
        CodeGenerationTracker cgt2 = cgt.cloneBranch();
        if (usesIndex) {
            cgt2.registerExtantBinding(this.m_indexBinding, index2.getName());
        }
        cgt2.registerExtantBinding(this.m_binding, currentElement.getName());
        cgt2.generateAddToStream(this.m_body, varName2, (StreamType)streamType, cgh, il, false, valueStyleRequest);
        if (usesIndex) {
            il.incrementVarStmt(index2);
        }
        sequenceType.generateLoopEnd(cgh, il, currentElement, cgt);
        ((StreamType)streamType).generateCompactStream(varName2, cgh, il);
        return il.loadVar(var2);
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        IBinding toSkip = ((IdentifierInstruction)this.m_source).getBinding(cgt.m_bindingEnvironment);
        cgt.generateFreeBindings(this, cgh, il, toSkip, tailPosition, false, ValueGenStyle.DEFAULT);
        boolean usesIndex = this.m_indexBinding != null && cgt.isBindingUsed(this.m_indexBinding);
        FcgVariable indexVar = null;
        String index2 = null;
        if (usesIndex) {
            index2 = cgh.generateNewLocalVariableName();
            il.loadLiteral(0);
            indexVar = il.defineVar(FcgType.INT, index2, true);
        }
        Type seqTypeMaybe = this.m_source.getCachedType();
        XDMSequenceType sequenceType = XDMSequenceType.getXDMSequenceType(seqTypeMaybe);
        FcgType fcgItemType = XDMItemType.s_itemType.getFCGType(cgh);
        FcgVariable current2 = sequenceType.generateLoopStart(cgh, il, this.m_source, fcgItemType, cgt);
        CodeGenerationTracker cgt2 = cgt.cloneBranch();
        if (usesIndex) {
            cgt2.registerExtantBinding(this.m_indexBinding, index2);
        }
        cgt2.registerExtantBinding(this.m_binding, current2.getName());
        cgt2.generateAddToStream(this.m_body, streamName, (StreamType)cgt.resolveType(this), cgh, il, tailPosition, valueStyleRequest);
        if (usesIndex) {
            il.incrementVarStmt(indexVar);
        }
        sequenceType.generateLoopEnd(cgh, il, current2, cgt);
    }
}

