/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgInterfaceType;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.codegen.FcgXtqType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.IMinimalFeatureUsage;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import java.text.ParseException;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;

public class ItemValueEqualsInstruction
extends BinaryPrimopInstruction
implements IMinimalFeatureUsage {
    public ItemValueEqualsInstruction() {
    }

    public ItemValueEqualsInstruction(Instruction parameter1, Instruction parameter2) {
        super(parameter1, parameter2);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        ItemValueEqualsInstruction i = new ItemValueEqualsInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation());
        ItemValueEqualsInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        tenv.unify(this.m_operand1.typeCheck(tenv, benv, functionStack), XDMItemType.s_itemType, this);
        tenv.unify(this.m_operand2.typeCheck(tenv, benv, functionStack), XDMItemType.s_itemType, this);
        return this.setCachedType(BooleanType.s_booleanType);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return BooleanType.s_booleanType;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        il.loadLiteral(false);
        FcgVariable isEqualsVar = il.defineVar(FcgType.BOOLEAN, cgh.generateNewLocalVariableName("ret"), true);
        FcgInterfaceType cursorType = cgh.getInterfaceType(Cursor.class.getName());
        FcgType type2 = cgt.generateConventionally(this.getChildInstruction(0), cgh, tailPosition, il, ValueGenStyle.DEFAULT);
        FcgVariable xVar = il.defineVar(cursorType, cgh.generateNewLocalVariableName("x"), true);
        il.loadVar(xVar);
        il.loadNull();
        il.binaryOperationExpr(FcgBinOp.COMPARE_NE);
        il.beginIf();
        type2 = cgt.generateConventionally(this.getChildInstruction(1), cgh, tailPosition, il, ValueGenStyle.DEFAULT);
        FcgVariable yVar = il.defineVar(cursorType, cgh.generateNewLocalVariableName("x"), true);
        il.loadVar(yVar);
        il.loadNull();
        il.binaryOperationExpr(FcgBinOp.COMPARE_NE);
        il.beginIf();
        il.loadVar(xVar);
        il.invokeInterfaceMethod(cursorType, "itemTypedValue", (FcgType)FcgXtqType.VOLATILE_CDATA, 0);
        il.loadVar(yVar);
        il.invokeInterfaceMethod(cursorType, "itemTypedValue", (FcgType)FcgXtqType.VOLATILE_CDATA, 0);
        il.invokeInterfaceMethod(FcgXtqType.VOLATILE_CDATA, "typedEquals", (FcgType)FcgType.BOOLEAN, 1);
        il.storeVar(isEqualsVar);
        il.endIf();
        il.endIf();
        il.loadVar(isEqualsVar);
        return FcgType.BOOLEAN;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Boolean ans;
        Cursor xcs;
        if (null != di) {
            di.enter(this, e, f2);
        }
        if ((xcs = (Cursor)this.m_operand1.evaluate(e, f2, di, false)) != null) {
            Cursor ycs = (Cursor)this.m_operand2.evaluate(e, f2, di, false);
            if (ycs != null) {
                VolatileCData xcsVCdata = xcs.itemTypedValue();
                VolatileCData ycsVCdata = ycs.itemTypedValue();
                if (xcsVCdata != null && ycs != null) {
                    boolean isEquals;
                    switch (xcsVCdata.getXSTypeDefinition().getBuiltInKind()) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            try {
                                XMLGregorianCalendar c1 = xcsVCdata.getXMLGregorianCalendar(1);
                                c1 = this.adjustImplicitTimeZone(c1);
                                XMLGregorianCalendar c2 = ycsVCdata.getXMLGregorianCalendar(1);
                                c2 = this.adjustImplicitTimeZone(c2);
                                int result2 = c1.compare(c2);
                                isEquals = result2 == 0;
                                break;
                            }
                            catch (ParseException e2) {
                                throw new RuntimeException("XX0000", e2);
                            }
                        }
                        default: {
                            isEquals = xcsVCdata.typedEquals(ycsVCdata);
                        }
                    }
                    ans = new Boolean(isEquals);
                } else {
                    ans = new Boolean(xcsVCdata == ycs);
                }
            } else {
                ans = new Boolean(false);
            }
        } else {
            ans = new Boolean(false);
        }
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    private XMLGregorianCalendar adjustImplicitTimeZone(XMLGregorianCalendar c1) {
        if (c1.getTimezone() == Integer.MIN_VALUE) {
            TimeZone tz = TimeZone.getDefault();
            GregorianCalendar calendar = new GregorianCalendar(tz);
            int minutes2 = calendar.get(15) / 1000 / 60;
            c1.setTimezone(minutes2);
            return c1;
        }
        return c1;
    }

    @Override
    public String innerToString() {
        return "item-value-equals";
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        return new ItemValueEqualsInstruction(op1, op2);
    }

    @Override
    public Cursor.Profile getMinimalUsageForEvaluate(int argumentIndex, Function f2) {
        if (argumentIndex == 0) {
            return Cursor.Profile.MINIMAL_STREAMING_NAVIGATION;
        }
        if (argumentIndex == 1) {
            return Cursor.Profile.MINIMAL_STREAMING_NAVIGATION;
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " " + argumentIndex);
    }
}

