/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.IMinimalFeatureUsage;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IteratorInstruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xml.xci.Cursor;
import java.util.HashSet;

public abstract class IteratorXDMSequenceInstruction
extends IteratorInstruction
implements IMinimalFeatureUsage {
    @Override
    public Cursor.Profile getMinimalUsageForEvaluate(int argumentIndex, Function f2) {
        if (argumentIndex == 0) {
            return Cursor.Profile.TO_NEXT;
        }
        return Cursor.Profile.NONE;
    }

    protected int typeCheckLoopVariableBinding(TypeEnvironment tenv, BindingEnvironment benv2, Type sourcetype, Binding binding) {
        XType sxtype = (sourcetype = sourcetype.resolveTypeAsMuchAsPossible(tenv, new HashSet())) instanceof XDMSequenceType ? ((XDMSequenceType)sourcetype).getXType() : ((XDMItemType)sourcetype).getXType();
        XType fsxtype = sxtype.factor();
        XType bxtype = fsxtype.prime().buildUnstable();
        assert (!bxtype.isStableType());
        binding.setTypeEnvironment(tenv);
        binding.setType(new XDMItemType(bxtype));
        benv2.setVariableBinding(binding);
        int socc = sxtype.quantifier();
        return socc;
    }

    public static boolean typeCheckXDMItemOrSequence(Type t, TypeEnvironment tenv, Instruction errorBase) throws TypeCheckException {
        boolean isItem;
        if ((t = t.resolveTypeAsMuchAsPossible(tenv, new HashSet())) instanceof XDMItemType) {
            tenv.unify(t, XDMItemType.s_itemType, errorBase);
            isItem = true;
        } else if (t instanceof XDMSequenceType) {
            tenv.unify(t, XDMSequenceType.s_sequenceType, errorBase);
            isItem = false;
        } else if (!tenv.unifyQuietly(t, XDMSequenceType.s_sequenceType, errorBase)) {
            if (!tenv.unifyQuietly(t, XDMItemType.s_itemType, errorBase)) {
                boolean isItem2 = false;
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Expected value of type XDMSequence or XDMItem but found type " + t.prettyPrint() + " instead"), errorBase);
            }
            isItem = true;
        } else {
            isItem = false;
        }
        return isItem;
    }

    public static XType typeCheckXDMItemOrSequenceToXType(TypeEnvironment tenv, Type t0, Instruction errorBase) throws TypeCheckException {
        XType xtype;
        Type t = t0.resolveTypeAsMuchAsPossible(tenv, new HashSet());
        if (t instanceof XDMItemType) {
            tenv.unify(t, XDMItemType.s_itemType, errorBase);
            xtype = ((XDMItemType)t).getXType();
        } else if (t instanceof XDMSequenceType) {
            tenv.unify(t, XDMSequenceType.s_sequenceType, errorBase);
            xtype = ((XDMSequenceType)t).getXType();
        } else if (!tenv.unifyQuietly(t, XDMSequenceType.s_sequenceType, errorBase)) {
            if (!tenv.unifyQuietly(t, XDMItemType.s_itemType, errorBase)) {
                Object xtype2 = null;
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Expected value of type XDMSequence or XDMItem but found type " + t.prettyPrint() + " instead"), errorBase);
            }
            xtype = t instanceof XDMItemType ? ((XDMItemType)t).getXType() : XDMItemType.s_itemType.getXType();
        } else {
            xtype = t instanceof XDMSequenceType ? ((XDMSequenceType)t).getXType() : XDMSequenceType.s_sequenceType.getXType();
        }
        return xtype;
    }
}

