/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm;

import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.exec.BasicDynamicContext;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;

public class MakeInstructionReport {
    static CursorUsageInfo[] cursorUsageInfo = new CursorUsageInfo[]{new CursorUsageInfo("addAttribute", Cursor.Profile.MINIMAL_STREAMING_MUTATION), new CursorUsageInfo("addComment", Cursor.Profile.MINIMAL_STREAMING_MUTATION), new CursorUsageInfo("addCopy", Cursor.Profile.ADD_COPY), new CursorUsageInfo("addElement", Cursor.Profile.MINIMAL_STREAMING_MUTATION), new CursorUsageInfo("addNamespaceNode", Cursor.Profile.MINIMAL_STREAMING_MUTATION), new CursorUsageInfo("addProcessingInstruction", Cursor.Profile.MINIMAL_STREAMING_MUTATION), new CursorUsageInfo("addText", Cursor.Profile.MINIMAL_STREAMING_MUTATION), new CursorUsageInfo("canBeSpecialized", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("closeMutation", Cursor.Profile.MINIMAL_STREAMING_MUTATION), new CursorUsageInfo("contextIsAtomsOnly", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("contextIsLive", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("contextIsNodesOnly", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("contextIsOrdered", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("contextIsSingleton", Cursor.Profile.SIZE), new CursorUsageInfo("contextPosition", Cursor.Profile.POSITION), new CursorUsageInfo("contextSize", Cursor.Profile.SIZE), new CursorUsageInfo("copyToResult", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("dataProviderSubID", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("documentOrder", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("exportAs", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("exportAsClass", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("factory", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("fork", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("futureProfile", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("isWrapped", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemBaseUri", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemCopy", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemDocumentIdentity", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemDocumentInfo", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemIsAtomic", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemIsBeforeNode", Cursor.Profile.IS_BEFORE_NODE), new CursorUsageInfo("itemIsDeepEqualTo", Cursor.Profile.IS_DEEP_EQUAL_TO), new CursorUsageInfo("itemIsID", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemIsIDREFS", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemIsSameDocument", Cursor.Profile.IS_SAME_DOCUMENT), new CursorUsageInfo("itemIsSameNode", Cursor.Profile.IS_SAME_NODE), new CursorUsageInfo("itemKind", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemName", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemNamespaceContext", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemNilled", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemNodeIdentity", Cursor.Profile.NODE_IDENTITY), new CursorUsageInfo("itemStringValue", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemTypedValue", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemTypeName", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemXSAttributeDeclaration", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemXSElementDeclaration", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("itemXSPSVInfo", Cursor.Profile.XSPSVINFO), new CursorUsageInfo("itemXSType", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("move", Cursor.Profile.MOVE), new CursorUsageInfo("openMutation", Cursor.Profile.MINIMAL_STREAMING_MUTATION), new CursorUsageInfo("profile", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("profileLimit", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("release", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("removeAttribute", Cursor.Profile.REMOVE_ATTRIBUTE), new CursorUsageInfo("removeSubtree", Cursor.Profile.REMOVE_SUBTREE), new CursorUsageInfo("sequenceConcat", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("serialize", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("setItemBaseURI", Cursor.Profile.SET_BASE_URI), new CursorUsageInfo("setItemName", Cursor.Profile.SET_NAME), new CursorUsageInfo("setItemPSVI", Cursor.Profile.SET_PSVI), new CursorUsageInfo("setItemValue", Cursor.Profile.SET_VALUE), new CursorUsageInfo("setItemXSType", Cursor.Profile.SET_TYPE), new CursorUsageInfo("toAttributes", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.TO_NODE_TEST), new CursorUsageInfo("toChildren", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.TO_NODE_TEST), new CursorUsageInfo("toFollowingSiblings", Cursor.Profile.TO_FOLLOWING_SIBLINGS, Cursor.Profile.TO_NODE_TEST), new CursorUsageInfo("toIdrefs", Cursor.Profile.TO_IDREFS), new CursorUsageInfo("toIds", Cursor.Profile.TO_IDS), new CursorUsageInfo("toLast", Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION), new CursorUsageInfo("toNamespaceDecls", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("toNext", Cursor.Profile.TO_NEXT), new CursorUsageInfo("toParent", Cursor.Profile.TO_PARENT), new CursorUsageInfo("toPosition", Cursor.Profile.TO_POSITION), new CursorUsageInfo("toPrecedingSiblings", Cursor.Profile.TO_PRECEDING_SIBLINGS, Cursor.Profile.TO_NODE_TEST), new CursorUsageInfo("toPrevious", Cursor.Profile.TO_PREVIOUS), new CursorUsageInfo("toRoot", Cursor.Profile.TO_ROOT), new CursorUsageInfo("toSelf", Cursor.Profile.TO_SELF), new CursorUsageInfo("unwrap", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), new CursorUsageInfo("validate", Cursor.Profile.MINIMAL_STREAMING_NAVIGATION)};
    public static int MAXPARAMSTORECORD = 30;
    public static ArrayList<InstructionInfo> _instructionTable = null;

    private static void generateReport(ArrayList<InstructionInfo> instructionTable) throws IOException {
        File reportFile = new File("C:\\proj\\xtqhp_head\\xylem\\doc\\InstructionAnalysis.csv");
        System.out.println("Preparing report: " + reportFile.getAbsolutePath());
        PrintWriter pw = new PrintWriter(new FileWriter(reportFile));
        pw.print("Category");
        pw.print(", ");
        pw.print("FIL Keyword");
        pw.print(", ");
        pw.print("Instruction");
        pw.print(", ");
        pw.print("from getType()");
        pw.print(", ");
        pw.print("Runtime Types");
        pw.print(", ");
        pw.print("body");
        pw.print(", ");
        pw.print("SF?");
        pw.print(", ");
        pw.print("#P");
        pw.print(", ");
        pw.print("evaluate");
        pw.print(", ");
        pw.print("evaluateToIAppendableStream");
        pw.print(", ");
        pw.print("generateCode");
        pw.print(", ");
        pw.print("generateCodeWithStreamOptimization");
        pw.print(", ");
        InstructionInfo dummy = new InstructionInfo();
        for (int i = 0; i < dummy.params.length; ++i) {
            pw.print("P" + i);
            pw.print(", ");
        }
        pw.print("Full Class Name");
        pw.print(", ");
        pw.println("Source File Class");
        for (InstructionInfo instructionInfo : instructionTable) {
            pw.print(instructionInfo.category);
            pw.print(", ");
            pw.print(instructionInfo.xylemInstructionString);
            pw.print(", ");
            pw.print(instructionInfo.clazz.getSimpleName());
            pw.print(", ");
            pw.print(instructionInfo.typeString);
            pw.print(", ");
            pw.print(instructionInfo.runtimeTypes);
            pw.print(", ");
            pw.print(instructionInfo.hasBody);
            pw.print(", ");
            pw.print(instructionInfo.isSpecialForm);
            pw.print(", ");
            if (instructionInfo.numberOfParams == -100) {
                pw.print("VAR");
            } else {
                pw.print(instructionInfo.numberOfParams);
            }
            pw.print(", ");
            pw.print(instructionInfo.evaluateUsage);
            pw.print(", ");
            pw.print(instructionInfo.evaluateToIAppendableStreamUsage);
            pw.print(", ");
            pw.print(instructionInfo.generateCodeUsage);
            pw.print(", ");
            pw.print(instructionInfo.generateCodeWithStreamOptimizationUsage);
            pw.print(", ");
            for (int i = 0; i < instructionInfo.params.length; ++i) {
                if (instructionInfo.params[i] != null) {
                    pw.print(instructionInfo.params[i]);
                } else {
                    pw.print(" ");
                }
                pw.print(", ");
            }
            pw.print(instructionInfo.clazz.getName());
            pw.print(", ");
            pw.print(instructionInfo.file.getAbsolutePath());
            pw.println("");
        }
        pw.flush();
        pw.close();
    }

    public static InstructionInfo findInstructionInfo(ArrayList<InstructionInfo> instructionTable, Instruction instr) {
        InstructionInfo maybe = null;
        String maybeSyntaxString = MakeInstructionReport.tryToGetFILKeyword(instr);
        if (maybeSyntaxString != null && maybeSyntaxString.contains("$fixup$")) {
            return null;
        }
        for (InstructionInfo instructionInfo : instructionTable) {
            if (instructionInfo.clazz != instr.getClass()) continue;
            if (maybeSyntaxString == null) {
                return instructionInfo;
            }
            String filSyntax = instructionInfo.xylemInstructionString;
            if (filSyntax != null) {
                if (filSyntax.equals(maybeSyntaxString) || instructionInfo.clazz == FunctionCallInstruction.class) {
                    return instructionInfo;
                }
                maybe = instructionInfo;
                continue;
            }
            maybe = instructionInfo;
        }
        if (maybe != null) {
            if (maybe.xylemInstructionString == null && maybeSyntaxString != null) {
                maybe.xylemInstructionString = maybeSyntaxString;
            } else if (maybeSyntaxString != null) {
                InstructionInfo newInfo = maybe.dup();
                newInfo.xylemInstructionString = maybeSyntaxString;
                newInfo.params = new String[MAXPARAMSTORECORD];
                instructionTable.add(newInfo);
                maybe = newInfo;
            }
        }
        return maybe;
    }

    public static String tryToGetFILKeyword(Instruction instr) {
        String maybeSyntaxString = null;
        if (!(instr instanceof IdentifierInstruction || instr instanceof LiteralInstruction || instr instanceof StreamInstruction && ((StreamInstruction)instr).isString())) {
            String initialString = instr.toString().trim().split(" ")[0];
            initialString = initialString.trim().split("@")[0];
            maybeSyntaxString = (initialString = initialString.trim()).startsWith("(") ? initialString.substring(1) : initialString;
            maybeSyntaxString = maybeSyntaxString.endsWith(")") ? maybeSyntaxString.substring(0, maybeSyntaxString.length() - 1) : maybeSyntaxString;
            maybeSyntaxString = maybeSyntaxString.trim();
        }
        return maybeSyntaxString;
    }

    public static void recordOperationInInstructionTable(String operation) {
        if (_instructionTable != null) {
            StackTraceElement[] whereWeAre = Thread.currentThread().getStackTrace();
            for (int i = 0; i < whereWeAre.length; ++i) {
                StackTraceElement stackTraceElement = whereWeAre[i];
                ArrayList<InstructionInfo> instructionTable = _instructionTable;
                for (InstructionInfo instructionInfo : instructionTable) {
                    if (!instructionInfo.clazz.getName().equals(stackTraceElement.getClassName())) continue;
                    String methodName = stackTraceElement.getMethodName();
                    if (methodName.equals("generateCodeWithStreamOptimization")) {
                        String usage = instructionInfo.generateCodeWithStreamOptimizationUsage;
                        if (usage != null) {
                            if (!usage.contains(operation)) {
                                instructionInfo.generateCodeWithStreamOptimizationUsage = instructionInfo.generateCodeWithStreamOptimizationUsage + "|" + operation;
                            }
                        } else {
                            instructionInfo.generateCodeWithStreamOptimizationUsage = operation;
                        }
                        return;
                    }
                    if (!methodName.equals("generateCode")) continue;
                    String usage = instructionInfo.generateCodeUsage;
                    if (usage != null) {
                        if (!usage.contains(operation)) {
                            instructionInfo.generateCodeUsage = instructionInfo.generateCodeUsage + "|" + operation;
                        }
                    } else {
                        instructionInfo.generateCodeUsage = operation;
                    }
                    return;
                }
            }
        }
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, SecurityException, NegativeArraySizeException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        System.setProperty("com.ibm.xltxe.rnm1.xylem.debugopt", "mixedmode(off)");
        ArrayList<InstructionInfo> instructionTable = MakeInstructionReport.buildInitialTable();
        _instructionTable = instructionTable;
        SessionContext session = new SessionContext();
        BasicStaticContext scontext = new BasicStaticContext();
        scontext.setFeature("http://www.ibm.com/xmlns/prod/xltxe-j/compile", true);
        Preparer preparer = session.getPreparer(RequestInfo.XSLT2);
        StreamSource xslsrc = new StreamSource("C:\\proj\\xtqhp_head\\xtqhp-test\\tests\\input\\perf_ver10\\exm\\inventory.xsl");
        Executable xslt = preparer.prepare(xslsrc, (StaticContext)scontext, -1);
        StreamSource docsrc = new StreamSource("C:\\proj\\xtqhp_head\\xtqhp-test\\tests\\input\\perf_ver10\\exm\\inventory.xml");
        Cursor doc2 = session.document(docsrc, RequestInfo.RANDOM_UPDATE);
        BasicDynamicContext dynamicContext = new BasicDynamicContext(session);
        Cursor result2 = xslt.execute(doc2, dynamicContext, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, null);
        VolatileCData serializer = result2.serialize(null);
        serializer.writeEncodedBytesTo(System.out, "UTF-8", (short)0, true);
        Class<?> clazz = Class.forName("com.ibm.xltxe.rnm1.xtqhp.qetest.xsl.XTPTestletDriver");
        Object instance2 = clazz.newInstance();
        Method method = clazz.getMethod("doMain", String[].class);
        String[] args2 = new String[]{"-load", "Regression_XSLT10_DTM_MixedMode_SPI.properties"};
        method.invoke(instance2, new Object[]{args2});
        System.out.println();
        MakeInstructionReport.generateReport(instructionTable);
        System.out.print("All Done!");
    }

    public static ArrayList<InstructionInfo> buildInitialTable() throws IOException {
        ArrayList<InstructionInfo> instructionTable = new ArrayList<InstructionInfo>();
        System.out.println("Finding Instruction classes...");
        for (String classpathEntry : System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
            if (classpathEntry.endsWith(".jar") || classpathEntry.endsWith(".zip")) continue;
            File dir = new File(classpathEntry);
            String[] path2 = new String[100];
            MakeInstructionReport.processFile(dir, 0, path2, instructionTable);
        }
        System.out.println("Trying to get basic return type info...");
        for (InstructionInfo instructionInfo : instructionTable) {
            MakeInstructionReport.tryToGleanWhatInfoWeCanFromSourceFile(instructionInfo);
        }
        System.out.println("Trying to fix up return types based on super classes...");
        MakeInstructionReport.tryToFixupNullTypesBasedOnSuperTypes(instructionTable);
        File formHandlerFile = new File("C:\\proj\\xtqhp_head\\xtqhp\\java\\src\\com\\ibm\\xtq\\xslt\\xylem\\parser\\FormHandler.java");
        System.out.println("Trying to get more info from " + formHandlerFile.getAbsolutePath());
        MakeInstructionReport.tryToGetInfoFromFormHandler(instructionTable, formHandlerFile);
        File coreFormHandlerFile = new File("C:\\proj\\xtqhp_head\\xylem\\src\\com\\ibm\\xylem\\parser\\CoreFormHandler.java");
        System.out.println("Trying to get more info from " + coreFormHandlerFile.getAbsolutePath());
        MakeInstructionReport.tryToGetInfoFromFormHandler(instructionTable, coreFormHandlerFile);
        System.out.println("Done with buildInitialTable");
        return instructionTable;
    }

    /*
     * Unable to fully structure code
     */
    private static void tryToGetInfoFromFormHandler(ArrayList<InstructionInfo> instructionTable, File formHandlerFile) throws FileNotFoundException, IOException {
        lnr = new LineNumberReader(new FileReader(formHandlerFile));
        formNameEqualsMatches = new HashSet<String>();
        extras = new ArrayList<InstructionInfo>();
        paramCount = 0;
        hasBody = false;
        line = lnr.readLine();
        while (line != null) {
            block14: {
                block15: {
                    if ((line = line.trim()).length() == 0 || line.startsWith("import ") || line.startsWith("package ") || line.startsWith("//") || line.startsWith("/*") || line.startsWith("*")) break block14;
                    if (!line.contains("formName.equals(")) break block15;
                    stuff = line.split("\\\"");
                    if (stuff.length >= 2) {
                        formNameEqualsMatches.add(stuff[1]);
                    }
                    if (stuff.length >= 4) {
                        formNameEqualsMatches.add(stuff[3]);
                    }
                    if (stuff.length < 6) break block14;
                    formNameEqualsMatches.add(stuff[5]);
                    break block14;
                }
                if (formNameEqualsMatches.size() <= 0) ** GOTO lbl-1000
                if (line.contains("Instruction body =")) {
                    hasBody = true;
                } else if (line.contains("parser.parse")) {
                    ++paramCount;
                } else lbl-1000:
                // 4 sources

                {
                    for (InstructionInfo instructionInfo : instructionTable) {
                        simpleClassName = instructionInfo.clazz.getSimpleName();
                        if (simpleClassName.equals("Instruction") || !line.contains(simpleClassName)) continue;
                        stuff = line.split(",");
                        if (stuff.length >= 3 && stuff[0].startsWith("new BasicForm(\"")) {
                            instructionInfo.xylemInstructionString = xylemName = stuff[0].substring("new BasicForm(\"".length(), stuff[0].length() - 1);
                            try {
                                instructionInfo.numberOfParams = Integer.valueOf(stuff[1].trim());
                            }
                            catch (Exception e) {
                                instructionInfo.numberOfParams = -100;
                            }
                            instructionInfo.hasBody = false;
                            break;
                        }
                        if (formNameEqualsMatches.size() <= 0 || !line.contains("new " + simpleClassName)) continue;
                        count = 0;
                        for (String string : formNameEqualsMatches) {
                            if (count == 0) {
                                instructionInfo.xylemInstructionString = string;
                                instructionInfo.hasBody = hasBody;
                                paramCount = 0;
                                hasBody = false;
                            } else {
                                dup = instructionInfo.dup();
                                dup.xylemInstructionString = string;
                                extras.add(dup);
                            }
                            ++count;
                        }
                        formNameEqualsMatches.clear();
                        break;
                    }
                }
            }
            line = lnr.readLine();
        }
        instructionTable.addAll(extras);
        extras.clear();
    }

    private static void tryToFixupNullTypesBasedOnSuperTypes(ArrayList<InstructionInfo> instructionTable) {
        block0: for (InstructionInfo instructionInfo : instructionTable) {
            if (instructionInfo.typeString != null) continue;
            Class<?> superClass = instructionInfo.clazz;
            while ((superClass = superClass.getSuperclass()) != null) {
                for (InstructionInfo info2 : instructionTable) {
                    if (info2.clazz != superClass || info2.typeString == null) continue;
                    instructionInfo.typeString = info2.typeString;
                    break;
                }
                if (instructionInfo.typeString == null) continue;
                continue block0;
            }
        }
    }

    static int count(String s, char c) {
        char[] sChars = s.toCharArray();
        int count2 = 0;
        for (int i = 0; i < sChars.length; ++i) {
            char sC = sChars[i];
            if (sC != c) continue;
            ++count2;
        }
        return count2;
    }

    static String normalize(String s) {
        String tail;
        char[] sChars = s.toCharArray();
        StringBuilder builder = new StringBuilder();
        boolean inComment = false;
        for (int i = 0; i < sChars.length && !(tail = s.substring(i)).startsWith("//"); ++i) {
            if (tail.startsWith("/*")) {
                inComment = true;
            }
            if (tail.startsWith("*/")) {
                inComment = false;
            }
            if (tail.startsWith("  ") || inComment) continue;
            builder.append(sChars[i]);
        }
        return builder.toString();
    }

    private static void tryToGleanWhatInfoWeCanFromSourceFile(InstructionInfo instructionInfo) throws FileNotFoundException, IOException {
        LineNumberReader lnr = new LineNumberReader(new FileReader(instructionInfo.file));
        MethodState methodState = MethodState.notInterested;
        int curlyLeftBracketCount = 0;
        int curlyRightBracketCount = 0;
        HashSet<String> localCursorUsages = new HashSet<String>();
        String line = lnr.readLine();
        while (line != null) {
            line = line.trim();
            if (!((line = MakeInstructionReport.normalize(line)).startsWith("package ") || line.startsWith("//") || line.startsWith("/*") || line.startsWith("*"))) {
                if (line.contains("import com.ibm.xml.xci.Cursor") || line.contains("import com.ibm.xltxe.rnm1.xtq.xslt.xylem.interpreter.XDMSequenceWriterStream;") || line.contains("import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType") || line.contains("import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType")) {
                    instructionInfo.category = "XDM";
                    if (Modifier.isAbstract(instructionInfo.clazz.getModifiers())) {
                        instructionInfo.category = instructionInfo.category + "|ABSTRACT";
                    }
                }
                if (!line.startsWith("import ")) {
                    if (line.startsWith("public Object evaluate(Environment")) {
                        assert (methodState == MethodState.notInterested);
                        methodState = MethodState.evaluate;
                    } else if (line.startsWith("public void evaluate(IAppendableStream as")) {
                        assert (methodState == MethodState.notInterested);
                        methodState = MethodState.evaluateToIAppendableStream;
                    } else if (line.startsWith("public FcgType generateCode(")) {
                        assert (methodState == MethodState.notInterested);
                        methodState = MethodState.generateCode;
                        if (instructionInfo.clazz.getSimpleName().equals("ContextIsNodeOnlyInstruction")) {
                            System.out.println("Found generateCode for ContextIsNodeOnlyInstruction");
                        }
                    } else if (line.startsWith("public void generateCodeWithStreamOptimization(")) {
                        assert (methodState == MethodState.notInterested);
                        methodState = MethodState.generateCodeWithStreamOptimization;
                    }
                    if (methodState != MethodState.notInterested) {
                        curlyLeftBracketCount += MakeInstructionReport.count(line, '{');
                        curlyRightBracketCount += MakeInstructionReport.count(line, '}');
                    }
                    if (methodState != MethodState.notInterested && curlyLeftBracketCount > 0 && curlyLeftBracketCount - curlyRightBracketCount == 0) {
                        switch (methodState) {
                            case evaluate: {
                                instructionInfo.evaluateUsage = "";
                                break;
                            }
                            case evaluateToIAppendableStream: {
                                instructionInfo.evaluateToIAppendableStreamUsage = "";
                                break;
                            }
                            case generateCode: {
                                instructionInfo.generateCodeUsage = "";
                                break;
                            }
                            case generateCodeWithStreamOptimization: {
                                instructionInfo.generateCodeWithStreamOptimizationUsage = "";
                                break;
                            }
                        }
                        HashSet<String> usages = localCursorUsages;
                        for (String string2 : usages) {
                            switch (methodState) {
                                case evaluate: {
                                    instructionInfo.evaluateUsage = instructionInfo.evaluateUsage + string2 + "|";
                                    break;
                                }
                                case evaluateToIAppendableStream: {
                                    instructionInfo.evaluateToIAppendableStreamUsage = instructionInfo.evaluateToIAppendableStreamUsage + string2 + "|";
                                    break;
                                }
                                case generateCode: {
                                    instructionInfo.generateCodeUsage = instructionInfo.generateCodeUsage + string2 + "|";
                                    break;
                                }
                                case generateCodeWithStreamOptimization: {
                                    instructionInfo.generateCodeWithStreamOptimizationUsage = instructionInfo.generateCodeWithStreamOptimizationUsage + string2 + "|";
                                    break;
                                }
                            }
                        }
                        methodState = MethodState.notInterested;
                        localCursorUsages.clear();
                        curlyLeftBracketCount = 0;
                        curlyRightBracketCount = 0;
                    } else if (methodState != MethodState.notInterested && curlyLeftBracketCount > 0) {
                        CursorUsageInfo[] usageTable = cursorUsageInfo;
                        block18: for (int i = 0; i < usageTable.length; ++i) {
                            CursorUsageInfo usage = usageTable[i];
                            switch (methodState) {
                                case evaluate: 
                                case evaluateToIAppendableStream: {
                                    if (!line.contains("." + usage.method)) continue block18;
                                    localCursorUsages.add(usage.method);
                                    continue block18;
                                }
                                case generateCode: 
                                case generateCodeWithStreamOptimization: {
                                    String methodString = "\"" + usage.method.trim() + "\"";
                                    if (!line.contains(methodString)) continue block18;
                                    localCursorUsages.add(usage.method);
                                    continue block18;
                                }
                            }
                        }
                    }
                    if (methodState == MethodState.notInterested && line.startsWith("public Type getType(") && line.contains("TypeEnvironment") && line.contains("BindingEnvironment")) {
                        line = lnr.readLine();
                        if (line != null) {
                            String[] stuff = line.trim().split("[ \\.]");
                            if (stuff.length >= 2) {
                                if (stuff[0].equals("return")) {
                                    if (stuff[1].equals("new")) {
                                        instructionInfo.typeString = stuff[2];
                                    }
                                    if (!stuff[1].contains("Type")) {
                                        instructionInfo.typeString = line.trim();
                                        if (instructionInfo.typeString.startsWith("return ")) {
                                            instructionInfo.typeString = instructionInfo.typeString.substring("return ".length());
                                        }
                                        instructionInfo.typeString = instructionInfo.typeString.replace(",", ".");
                                    } else {
                                        instructionInfo.typeString = stuff[1];
                                    }
                                } else {
                                    instructionInfo.typeString = line;
                                    instructionInfo.typeString = instructionInfo.typeString.replace(",", ".");
                                }
                            } else {
                                instructionInfo.typeString = "UNKNOWN1";
                            }
                        } else {
                            instructionInfo.typeString = "UNKNOWN0";
                        }
                    }
                }
            }
            line = lnr.readLine();
        }
        lnr.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void processFile(File dirOrFile, int depth, String[] path2, ArrayList<InstructionInfo> instructionTable) {
        String name2 = dirOrFile.getName();
        if (dirOrFile.isDirectory()) {
            File[] files = dirOrFile.listFiles();
            for (int i = 0; i < files.length; ++i) {
                path2[depth] = dirOrFile.getName();
                MakeInstructionReport.processFile(files[i], depth + 1, path2, instructionTable);
            }
            return;
        } else {
            if (!name2.endsWith(".class")) return;
            StringBuilder sbuilder = new StringBuilder();
            for (int i = 1; i < depth; ++i) {
                sbuilder.append(path2[i]);
                sbuilder.append('.');
            }
            sbuilder.append(name2.split("\\.")[0]);
            String qualifiedName = sbuilder.toString();
            if (qualifiedName.startsWith("com.ibm.xltxe.rnm1.xtq.runtime.")) return;
            try {
                Class<?> clazz = Class.forName(qualifiedName);
                if (!Instruction.class.isAssignableFrom(clazz) || dirOrFile.getName().contains("$")) return;
                InstructionInfo info = new InstructionInfo();
                info.clazz = clazz;
                String classFileName = dirOrFile.getAbsolutePath();
                String sourceFileName = classFileName.replace("eclipse-build", "src");
                File sourceFile = new File(sourceFileName = sourceFileName.replace(".class", ".java"));
                if (!sourceFile.exists()) {
                    System.err.println(sourceFileName + " does not exist!");
                }
                info.file = sourceFile;
                System.out.println(info.file.getAbsolutePath());
                info.isSpecialForm = ISpecialForm.class.isAssignableFrom(clazz);
                info.category = info.file.getAbsolutePath().contains("xylem\\src\\com") ? "TXE" : "CORE";
                if (Modifier.isAbstract(clazz.getModifiers())) {
                    info.category = info.category + "|ABSTRACT";
                }
                instructionTable.add(info);
                return;
            }
            catch (ClassNotFoundException e) {
                return;
            }
            catch (NoClassDefFoundError e) {
                return;
            }
            catch (TransformerFactoryConfigurationError e) {
                // empty catch block
            }
        }
    }

    static enum MethodState {
        notInterested,
        evaluate,
        evaluateToIAppendableStream,
        generateCode,
        generateCodeWithStreamOptimization;

    }

    public static class InstructionInfo {
        public Class<?> clazz;
        public File file;
        public String runtimeTypes;
        public String typeString;
        public String xylemInstructionString = null;
        public int numberOfParams = -1;
        public boolean hasBody;
        public boolean isSpecialForm;
        public String[] params = new String[MAXPARAMSTORECORD];
        public String category;
        public String evaluateUsage = null;
        public String evaluateToIAppendableStreamUsage = null;
        public String generateCodeUsage = null;
        public String generateCodeWithStreamOptimizationUsage = null;

        public InstructionInfo dup() {
            InstructionInfo dup2 = new InstructionInfo();
            dup2.clazz = this.clazz;
            dup2.file = this.file;
            dup2.typeString = this.typeString;
            dup2.runtimeTypes = this.runtimeTypes;
            dup2.xylemInstructionString = this.xylemInstructionString;
            dup2.numberOfParams = this.numberOfParams;
            dup2.hasBody = this.hasBody;
            dup2.isSpecialForm = this.isSpecialForm;
            dup2.params = new String[MAXPARAMSTORECORD];
            for (int i = 0; i < dup2.params.length; ++i) {
                dup2.params[i] = this.params[i];
            }
            dup2.category = this.category;
            dup2.evaluateUsage = this.evaluateUsage;
            dup2.evaluateToIAppendableStreamUsage = this.evaluateToIAppendableStreamUsage;
            dup2.generateCodeUsage = this.generateCodeUsage;
            dup2.generateCodeWithStreamOptimizationUsage = this.generateCodeWithStreamOptimizationUsage;
            return dup2;
        }
    }

    public static class CursorUsageInfo {
        String method;
        Cursor.Profile profile;
        Cursor.Profile extraIfNodeTestNonNull;

        public CursorUsageInfo(String method, Cursor.Profile profile) {
            this.method = method;
            this.profile = profile;
        }

        public CursorUsageInfo(String method, Cursor.Profile profile, Cursor.Profile extraIfNodeTestNonNull) {
            this.method = method;
            this.profile = profile;
            this.extraIfNodeTestNonNull = extraIfNodeTestNonNull;
        }
    }
}

