/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgField;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.codegen.FcgXtqType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.IReturnsNewXDMSequence;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.interpreter.XDMSequenceWriterStream;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.interpreter.Closure;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.xci.Cursor;
import java.io.IOException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public class SortXDMSequenceInstruction
extends Instruction
implements IReturnsNewXDMSequence {
    protected Instruction[] m_keyGenerators;
    protected Instruction[] m_comparators;
    protected Instruction m_source;
    private ForkInformation _forkInformation = null;

    public SortXDMSequenceInstruction() {
    }

    public SortXDMSequenceInstruction(Instruction source, Instruction[] keyGenerators, Instruction[] comparators) {
        this.m_source = source;
        this.m_keyGenerators = keyGenerators;
        this.m_comparators = comparators;
        if (this.m_keyGenerators.length != this.m_comparators.length) {
            throw new IllegalArgumentException("");
        }
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        int i;
        wofh.writeInt(this.m_keyGenerators.length);
        for (i = 0; i < this.m_keyGenerators.length; ++i) {
            wofh.writeInstruction(this.m_keyGenerators[i]);
        }
        wofh.writeInt(this.m_comparators.length);
        for (i = 0; i < this.m_comparators.length; ++i) {
            wofh.writeInstruction(this.m_comparators[i]);
        }
        wofh.writeInstruction(this.m_source);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        int i;
        int c = rofh.readInt();
        this.m_keyGenerators = new Instruction[c];
        for (i = 0; i < c; ++i) {
            this.m_keyGenerators[i] = rofh.readInstruction(benv);
        }
        c = rofh.readInt();
        this.m_comparators = new Instruction[c];
        for (i = 0; i < c; ++i) {
            this.m_comparators[i] = rofh.readInstruction(benv);
        }
        this.m_source = rofh.readInstruction(benv);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        this.doDefaultTypeCheck(tenv, benv, functionStack);
        tenv.unify(this.m_source.typeCheck(tenv, benv, functionStack), XDMSequenceType.s_sequenceType, this);
        for (int i = 0; i < this.m_comparators.length; ++i) {
            TypeVariable b = new TypeVariable();
            tenv.unify(this.m_keyGenerators[i].typeCheck(tenv, benv, functionStack), new LambdaType(new Type[]{XDMItemType.s_itemType, IntType.s_intType}, b, true), this);
            tenv.unify(this.m_comparators[i].typeCheck(tenv, benv, functionStack), new LambdaType(new Type[]{b, b}, IntType.s_intType, true), this);
        }
        return this.setCachedType(XDMSequenceType.s_sequenceType);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return XDMSequenceType.s_sequenceType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return XDMSequenceType.s_sequenceType;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        il.comment("Starting SortXDMSequenceInstruction:");
        String sortName = cgh.generateNewLocalVariableName();
        String sourceName = sortName + "_sourceToSort";
        FcgType sourceType = cgt.generateConventionally(this.m_source, cgh, false, il, ValueGenStyle.DEFAULT);
        FcgType sourceElemType = ((XDMSequenceType)cgt.resolveType(this.m_source)).getElementType().getFCGType(cgh);
        XDMSequenceType.generateClone(cgh, il, ValueGenStyle.DEFAULT_WITH_PUSH);
        FcgVariable source = il.defineConstVar(sourceType, sourceName);
        FcgVariable result2 = il.defineVar(sourceType, sortName + "_result", false);
        il.loadVar(source);
        il.loadNull();
        il.binaryOperationExpr(FcgBinOp.COMPARE_NE);
        il.beginIf();
        CodeGenerationTracker cgtBranch = cgt.cloneBranch();
        il.loadVar(source);
        il.invokeInterfaceMethod(FcgXtqType.CURSOR_TYPE, "contextSize", (FcgType)FcgType.LONG, 0);
        il.convertExpr(FcgType.LONG, FcgType.INT);
        FcgVariable sourceSize = il.defineVar(FcgType.INT, sortName + "_size", true);
        il.loadVar(sourceSize);
        il.createArrayExpr(sourceElemType, false);
        FcgVariable sourceArray = il.defineVar(FcgXtqType.CURSOR_ARRAY, sortName + "_sourceArray", true);
        FcgType rawKeygen0Type = cgtBranch.generateConventionally(this.m_keyGenerators[0], cgh, false, il, ValueGenStyle.DEFAULT);
        FcgClassReferenceType keygen0Type = (FcgClassReferenceType)rawKeygen0Type;
        FcgVariable keygen0 = il.defineConstVar(keygen0Type, sortName + "_keygen0");
        FcgClassReferenceType comparator0Type = (FcgClassReferenceType)cgtBranch.generateConventionally(this.m_comparators[0], cgh, false, il, ValueGenStyle.DEFAULT);
        FcgVariable comparator0 = il.defineConstVar(comparator0Type, sortName + "_cmp0");
        FcgType keyType = ((LambdaType)this.m_keyGenerators[0].getType(tenv, benv).resolveType(tenv)).getReturnType().getFCGType(cgh);
        il.loadVar(sourceSize);
        FcgType keyArrayType = il.createArrayExpr(keyType, false);
        FcgVariable keyArray = il.defineConstVar(keyArrayType, sortName + "_keyArray");
        il.loadVar(sourceSize);
        FcgClassReferenceType JavaIntClassRef = cgh.getClassReferenceType(Integer.class.getName());
        FcgType IntegerArrayFcgType = il.createArrayExpr(JavaIntClassRef, false);
        FcgVariable indexArray = il.defineVar(IntegerArrayFcgType, sortName + "_indexArray", true);
        il.loadLiteral(0);
        FcgVariable sortIter = il.defineVar(FcgType.INT, sortName + "_iter", true);
        il.loadVar(sortIter);
        il.loadVar(sourceSize);
        il.binaryOperationExpr(FcgBinOp.COMPARE_LT);
        il.preIncrementAndLoadLocalVariable(sortIter);
        il.beginConditionalLoop(sortName + "_initLoop", 2);
        il.loadVar(keyArray);
        il.loadVar(sortIter);
        il.loadVar(keygen0);
        il.loadVar(source);
        il.loadVar(sortIter);
        il.invokeInstanceMethod(keygen0Type, "invoke", keyType, 2);
        il.storeArrayElemStmt();
        il.loadVar(indexArray);
        il.loadVar(sortIter);
        il.loadVar(sortIter);
        il.createObjectExpr((FcgType)JavaIntClassRef, 1);
        il.storeArrayElemStmt();
        il.loadVar(source);
        il.loadLiteral(true);
        il.invokeInterfaceMethod(FcgXtqType.CURSOR_TYPE, "fork", (FcgType)FcgXtqType.CURSOR_TYPE, 1);
        FcgVariable item2 = il.defineConstVar(FcgXtqType.CURSOR_TYPE, sortName + "_item");
        il.loadVar(item2);
        il.invokeInterfaceMethodStmt(FcgXtqType.CURSOR_TYPE, "toSelf", (FcgType)FcgType.BOOLEAN, 0);
        il.loadVar(sourceArray);
        il.loadVar(sortIter);
        il.loadVar(item2);
        il.storeArrayElemStmt();
        il.loadVar(source);
        il.invokeInterfaceMethodStmt(FcgXtqType.CURSOR_TYPE, "toNext", (FcgType)FcgType.BOOLEAN, 0);
        il.endConditionalLoop();
        String className = cgh.generateNewClassName();
        FcgClassReferenceType baseCollatorType = cgh.getClassReferenceType(Collator.class.getName());
        FcgClassReferenceType collatorClassType = cgh.getClassReferenceType(className);
        FcgClassGen collatorCG = cgh.newClassGen(collatorClassType, baseCollatorType, FcgAttrs.PUBLIC_FINAL);
        FcgField cmp0Field = collatorCG.newInstanceField(FcgAttrs.PRIVATE, comparator0Type, "m_cmp0");
        FcgField keyArrayField = collatorCG.newInstanceField(FcgAttrs.PRIVATE, keyArrayType, "m_keyArray");
        FcgField sourceField = collatorCG.newInstanceField(FcgAttrs.PRIVATE, sourceType, "m_sourceToSort");
        FcgField[] comparatorFields = new FcgField[this.m_keyGenerators.length - 1];
        FcgField[] keygenFields = new FcgField[this.m_keyGenerators.length - 1];
        for (int i = 1; i < this.m_keyGenerators.length; ++i) {
            LambdaType comparatorType = (LambdaType)cgt.resolveType(this.m_comparators[i]);
            FcgType comparatorFcgType = comparatorType.getFCGType(cgh);
            LambdaType keygenType = (LambdaType)cgt.resolveType(this.m_keyGenerators[i]);
            FcgType keygenFcgType = keygenType.getFCGType(cgh);
            comparatorFields[i - 1] = collatorCG.newInstanceField(FcgAttrs.PRIVATE, comparatorFcgType, "m_comparator" + i);
            keygenFields[i - 1] = collatorCG.newInstanceField(FcgAttrs.PRIVATE, keygenFcgType, "m_keygen" + i);
        }
        FcgMethodGen mg = collatorCG.newConstructorGen(FcgAttrs.PUBLIC);
        FcgVariable cmp0Param = mg.addParameter(comparator0Type, "cmp0");
        FcgVariable keyArrayParam = mg.addParameter(keyArrayType, "keyArray");
        FcgVariable sourceParam = mg.addParameter(sourceType, "sourceToSort");
        for (int i = 0; i < comparatorFields.length; ++i) {
            mg.addParameter(comparatorFields[i].getType(), "comparator" + (i + 1));
            mg.addParameter(keygenFields[i].getType(), "keygen" + (i + 1));
        }
        FcgInstructionList il2 = mg.getInstructionList();
        il2.beginMethod();
        il2.loadThis();
        il2.invokeSuperConstructor(baseCollatorType, 0);
        il2.loadThis();
        il2.loadVar(cmp0Param);
        il2.storeInstanceFieldStmt(cmp0Field);
        il2.loadThis();
        il2.loadVar(keyArrayParam);
        il2.storeInstanceFieldStmt(keyArrayField);
        il2.loadThis();
        il2.loadVar(sourceParam);
        il2.storeInstanceFieldStmt(sourceField);
        for (int i = 0; i < comparatorFields.length; ++i) {
            il2.loadThis();
            il2.loadVar(il2.findVar("comparator" + (i + 1)));
            il2.storeInstanceFieldStmt(comparatorFields[i]);
            il2.loadThis();
            il2.loadVar(il2.findVar("keygen" + (i + 1)));
            il2.storeInstanceFieldStmt(keygenFields[i]);
        }
        il2.endMethod();
        mg = collatorCG.newMethodGen(FcgAttrs.PUBLIC, FcgType.INT, "hashCode");
        FcgInstructionList il22 = mg.getInstructionList();
        il22.beginMethod();
        il22.loadLiteral(1);
        il22.returnInstruction(FcgType.INT);
        il22.endMethod();
        FcgClassReferenceType CollKeyClassRef = cgh.getClassReferenceType(CollationKey.class.getName());
        FcgMethodGen mg2 = collatorCG.newMethodGen(FcgAttrs.PUBLIC, CollKeyClassRef, "getCollationKey");
        FcgInstructionList il23 = mg2.getInstructionList();
        mg2.addParameter(FcgType.STRING, "s");
        il23.beginMethod();
        il23.loadNull();
        il23.returnInstruction(CollKeyClassRef);
        il23.endMethod();
        mg = collatorCG.newMethodGen(FcgAttrs.PUBLIC, FcgType.INT, "compare");
        il22 = mg.getInstructionList();
        mg.addParameter(FcgType.STRING, "x");
        mg.addParameter(FcgType.STRING, "y");
        il22.beginMethod();
        il22.loadLiteral(0);
        il22.returnInstruction(FcgType.INT);
        il22.endMethod();
        mg = collatorCG.newMethodGen(FcgAttrs.PUBLIC, FcgType.INT, "compare");
        il22 = mg.getInstructionList();
        FcgVariable x = mg.addParameter(FcgType.OBJECT, "x");
        FcgVariable y = mg.addParameter(FcgType.OBJECT, "y");
        il22.beginMethod();
        il22.loadThis();
        il22.loadInstanceField(cmp0Field);
        il22.loadVar(x);
        il22.convertExpr(FcgType.OBJECT, JavaIntClassRef);
        il22.invokeInstanceMethod(JavaIntClassRef, "intValue", (FcgType)FcgType.INT, 0);
        FcgVariable xi = il22.defineVar(FcgType.INT, "xi", true);
        il22.loadVar(y);
        il22.convertExpr(FcgType.OBJECT, JavaIntClassRef);
        il22.invokeInstanceMethod(JavaIntClassRef, "intValue", (FcgType)FcgType.INT, 0);
        FcgVariable yi = il22.defineVar(FcgType.INT, "yi", true);
        il22.loadThis();
        il22.loadInstanceField(keyArrayField);
        il22.loadVar(xi);
        il22.loadArrayElement(keyType);
        il22.loadThis();
        il22.loadInstanceField(keyArrayField);
        il22.loadVar(yi);
        il22.loadArrayElement(keyType);
        il22.invokeInstanceMethod(comparator0Type, "invoke", (FcgType)FcgType.INT, 2);
        FcgVariable cmp1 = il22.defineVar(FcgType.INT, "cmp1", true);
        il22.loadVar(cmp1);
        il22.loadLiteral(0);
        il22.binaryOperationExpr(FcgBinOp.COMPARE_NE);
        il22.beginIf();
        il22.loadVar(cmp1);
        il22.returnInstruction(FcgType.INT);
        if (this.m_keyGenerators.length > 1) {
            il22.beginElse();
            FcgVariable cmpi = il22.defineVar(FcgType.INT, "cmpi", false);
            for (int i = 1; i < this.m_keyGenerators.length; ++i) {
                LambdaType keygenType = (LambdaType)cgt.resolveType(this.m_keyGenerators[i]);
                FcgType keygenReturnType = keygenType.getReturnType().getFCGType(cgh);
                il22.loadThis();
                il22.loadInstanceField(comparatorFields[i - 1]);
                il22.loadThis();
                il22.loadInstanceField(keygenFields[i - 1]);
                il22.loadThis();
                il22.loadInstanceField(sourceField);
                il22.loadVar(xi);
                il22.invokeInstanceMethod((FcgClassReferenceType)keygenFields[i - 1].getType(), "invoke", keygenReturnType, 2);
                il22.loadThis();
                il22.loadInstanceField(keygenFields[i - 1]);
                il22.loadThis();
                il22.loadInstanceField(sourceField);
                il22.loadVar(yi);
                il22.invokeInstanceMethod((FcgClassReferenceType)keygenFields[i - 1].getType(), "invoke", keygenReturnType, 2);
                il22.invokeInstanceMethod((FcgClassReferenceType)comparatorFields[i - 1].getType(), "invoke", (FcgType)FcgType.INT, 2);
                il22.storeVar(cmpi);
                il22.loadVar(cmpi);
                il22.loadLiteral(0);
                il22.binaryOperationExpr(FcgBinOp.COMPARE_NE);
                il22.beginIf();
                il22.loadVar(cmpi);
                il22.returnInstruction(FcgType.INT);
                il22.endIf();
            }
        }
        il22.endIf();
        il22.loadLiteral(0);
        il22.returnInstruction(FcgType.INT);
        il22.endMethod();
        cgh.completeClassGeneration(collatorCG);
        il.loadVar(indexArray);
        FcgType[] paramTypes = new FcgType[3 + 2 * (this.m_keyGenerators.length - 1)];
        il.loadVar(comparator0);
        paramTypes[0] = comparator0Type;
        il.loadVar(keyArray);
        paramTypes[1] = keyArrayType;
        il.loadVar(source);
        paramTypes[2] = sourceType;
        int i = 1;
        int j = 3;
        while (i < this.m_keyGenerators.length) {
            cgtBranch.generateConventionally(this.m_comparators[i], cgh, false, il, ValueGenStyle.DEFAULT);
            paramTypes[j] = comparatorFields[i - 1].getType();
            cgtBranch.generateConventionally(this.m_keyGenerators[i], cgh, false, il, ValueGenStyle.DEFAULT);
            paramTypes[j + 1] = keygenFields[i - 1].getType();
            ++i;
            j += 2;
        }
        il.createObjectExpr((FcgType)collatorCG.getClassType(), paramTypes);
        paramTypes = new FcgType[]{FcgType.OBJECT_ARRAY, cgh.getInterfaceType(Comparator.class.getName())};
        il.invokeClassMethod(cgh.getClassReferenceType(Arrays.class.getName()), "sort", (FcgType)FcgType.VOID, paramTypes);
        il.comment("Paste together sorted source items");
        il.loadVar(sourceArray);
        il.loadVar(indexArray);
        il.loadLiteral(0);
        il.loadArrayElement(JavaIntClassRef);
        il.invokeInstanceMethod(JavaIntClassRef, "intValue", (FcgType)FcgType.INT, 0);
        il.loadArrayElement(FcgXtqType.CURSOR_TYPE);
        il.storeVar(result2);
        il.loadLiteral(1);
        il.storeVar(sortIter);
        il.loadVar(sortIter);
        il.loadVar(sourceSize);
        il.binaryOperationExpr(FcgBinOp.COMPARE_LT);
        il.preIncrementAndLoadLocalVariable(sortIter);
        il.beginConditionalLoop(sortName + "_resultIndexLoop", 2);
        il.loadVar(result2);
        il.loadVar(sourceArray);
        il.loadVar(indexArray);
        il.loadVar(sortIter);
        il.loadArrayElement(JavaIntClassRef);
        il.invokeInstanceMethod(JavaIntClassRef, "intValue", (FcgType)FcgType.INT, 0);
        il.loadArrayElement(sourceElemType);
        FcgClassReferenceType fcgProfileType = cgh.getInnerClassReferenceType(Cursor.class.getName(), "Profile");
        il.loadClassField(fcgProfileType, "RANDOM_ACCESS", fcgProfileType);
        FcgClassReferenceType fcgProfileType2 = cgh.getInnerClassReferenceType(Cursor.class.getName(), "Profile");
        il.loadClassField(fcgProfileType2, "RANDOM_ACCESS", fcgProfileType2);
        il.loadLiteral(true);
        il.loadLiteral(true);
        il.invokeInterfaceMethod(FcgXtqType.CURSOR_TYPE, "sequenceConcat", (FcgType)FcgXtqType.CURSOR_TYPE, 5);
        il.storeVar(result2);
        il.endConditionalLoop();
        il.beginElse();
        il.loadNull();
        il.storeVar(result2);
        il.endIf();
        il.comment("Finished SortStreamInstruction");
        return il.loadVar(result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Environment e, Function f2, final IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        e.pushForkScope();
        Cursor ans = null;
        try {
            Cursor source = (Cursor)this.m_source.evaluate(e, f2, di, false);
            if (null != source) {
                source = e.pushForkForRelease(source.fork(false, Cursor.STREAMING_READ, Cursor.RANDOM_ACCESS));
                ArrayList<Object[]> toBeSorted = new ArrayList<Object[]>();
                int j = 0;
                if (source != null) {
                    do {
                        Cursor item2 = source.fork(true, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_LIMIT_FOR_PROTOTYPE);
                        item2.toSelf();
                        toBeSorted.add(new Object[]{item2, new Integer(j++)});
                    } while (source.toNext());
                }
                Comparator c = null;
                for (int index2 = this.m_comparators.length - 1; index2 >= 0; --index2) {
                    Closure keyGenerator = (Closure)this.m_keyGenerators[index2].evaluate(e, f2, di, false);
                    Closure comparator2 = (Closure)this.m_comparators[index2].evaluate(e, f2, di, false);
                    c = new Comparator(){
                        Environment env;
                        Closure keyGenerator;
                        Closure comparator;
                        Comparator fallback;

                        public Comparator setup(Environment e, Closure keyGenerator, Closure comparator2, Comparator fallbackComparator) {
                            this.env = e;
                            this.keyGenerator = keyGenerator;
                            this.comparator = comparator2;
                            this.fallback = fallbackComparator;
                            return this;
                        }

                        public int compare(Object x1, Object x2) {
                            Object y;
                            Object[] y1 = (Object[])x1;
                            Object[] y2 = (Object[])x2;
                            Object x = this.keyGenerator.evaluate(this.env, y1, di);
                            int cmp = (Integer)this.comparator.evaluate(this.env, new Object[]{x, y = this.keyGenerator.evaluate(this.env, y2, di)}, di);
                            if (cmp == 0 && this.fallback != null) {
                                cmp = this.fallback.compare(x1, x2);
                            }
                            return cmp;
                        }
                    }.setup(e, keyGenerator, comparator2, c);
                }
                Collections.sort(toBeSorted, c);
                Iterator i = toBeSorted.iterator();
                XDMSequenceWriterStream output = new XDMSequenceWriterStream();
                while (i.hasNext()) {
                    output.append(((Object[])i.next())[0], XDMSequenceType.s_sequenceType);
                }
                ans = e.pushForkForRelease(output.getBuiltSequence());
            }
        }
        finally {
            e.popForkScope((Object)ans);
        }
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] x = new Instruction[this.m_keyGenerators.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = this.m_keyGenerators[i].cloneWithoutTypeInformation();
        }
        Instruction[] y = new Instruction[this.m_comparators.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = this.m_comparators[i].cloneWithoutTypeInformation();
        }
        SortXDMSequenceInstruction i = new SortXDMSequenceInstruction(this.m_source.cloneWithoutTypeInformation(), x, y);
        SortXDMSequenceInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        SortXDMSequenceInstruction i = new SortXDMSequenceInstruction(this.m_source, (Instruction[])this.m_keyGenerators.clone(), (Instruction[])this.m_comparators.clone());
        SortXDMSequenceInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        int i;
        this.m_source = rh.reduceToBasicInstruction(state, this.m_source, benv);
        for (i = 0; i < this.m_keyGenerators.length; ++i) {
            this.m_keyGenerators[i] = rh.reduceToBasicInstruction(state, this.m_keyGenerators[i], benv);
        }
        for (i = 0; i < this.m_comparators.length; ++i) {
            this.m_comparators[i] = rh.reduceToBasicInstruction(state, this.m_comparators[i], benv);
        }
        state[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public int getChildInstructionCount() {
        return 1 + 2 * (this.m_comparators == null ? 1 : this.m_comparators.length);
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_source;
            }
        }
        if (--i % 2 == 0) {
            return this.m_keyGenerators[i / 2];
        }
        return this.m_comparators[(i - 1) / 2];
    }

    public Instruction[] getKeyGenerators() {
        return this.m_keyGenerators;
    }

    public Instruction[] getComparators() {
        return this.m_comparators;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_source = n2;
                break;
            }
            default: {
                --i;
                if (this.m_keyGenerators == null) {
                    int size = (this.getChildInstructionCount() - 1) / 2;
                    this.m_keyGenerators = new Instruction[size];
                    this.m_comparators = new Instruction[size];
                }
                if (i % 2 == 0) {
                    this.m_keyGenerators[i / 2] = n2;
                    break;
                }
                this.m_comparators[(i - 1) / 2] = n2;
            }
        }
    }

    @Override
    public String innerToString() {
        return "sort-XDMSequence";
    }

    @Override
    public ForkInformation getReturnForkInformation() {
        if (this._forkInformation == null) {
            this._forkInformation = new ForkInformation();
        }
        return this._forkInformation;
    }
}

