/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.IteratorXDMSequenceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.FcgXmlType;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.ICollectionType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.xci.Cursor;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class TestXDMSequenceInstruction
extends IteratorXDMSequenceInstruction
implements ISpecialForm {
    protected Instruction m_source;
    protected Instruction m_body;
    protected Instruction m_hint;
    protected Binding m_hintBinding;
    protected Binding m_elementBinding;

    public TestXDMSequenceInstruction(Instruction source, Instruction hint, Object elementVar, Object hintVar, Instruction body) {
        this.m_source = source;
        this.m_hint = hint;
        this.m_hintBinding = new Binding(hintVar, this);
        this.m_body = body;
        this.m_elementBinding = new Binding(elementVar, this);
        this.m_elementBinding.setType(XDMItemType.s_itemType);
    }

    public TestXDMSequenceInstruction() {
    }

    @Override
    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction x) {
        this.m_body = x;
    }

    public Binding getElementBinding() {
        return this.m_elementBinding;
    }

    public Instruction getHint() {
        return this.m_hint;
    }

    public void setHint(Instruction x) {
        this.m_hint = x;
    }

    public Binding getHintBinding() {
        return this.m_hintBinding;
    }

    public Instruction getSource() {
        return this.m_source;
    }

    @Override
    public Instruction[] getSources() {
        return new Instruction[]{this.m_source};
    }

    public void setSource(Instruction x) {
        this.m_source = x;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_source;
            }
            case 1: {
                return this.m_hint;
            }
            case 2: {
                return this.m_body;
            }
        }
        return null;
    }

    @Override
    public int getChildInstructionCount() {
        return 3;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_source = n2;
                break;
            }
            case 1: {
                this.m_hint = n2;
                break;
            }
            case 2: {
                this.m_body = n2;
            }
        }
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        IBinding toSkip = ((IdentifierInstruction)this.m_source).getBinding(cgt.m_bindingEnvironment);
        cgt.generateFreeBindings(this, cgh, il, toSkip, false, false, ValueGenStyle.DEFAULT);
        String hint = cgh.generateNewLocalVariableName(varNameSuggestion);
        FcgType initialHint = cgt.generateConventionally(this.m_hint, cgh, false, il, ValueGenStyle.DEFAULT_WITH_PUSH);
        FcgVariable hintVar = il.defineVar(cgt.resolveType(this).getFCGType(cgh), hint, true);
        boolean onceFalseAlwaysFalseIdiom = false;
        boolean onceTrueAlwaysTrueIdiom = false;
        if (this.m_body instanceof ChooseInstruction) {
            Instruction test2;
            ChooseInstruction ci = (ChooseInstruction)this.m_body;
            if (LiteralInstruction.booleanFalseLiteral().equals(ci.getDefaultHandler()) && ci.m_cases.length == 1) {
                IdentifierInstruction ii;
                test2 = ci.m_cases[0].getTest();
                if (test2 instanceof IdentifierInstruction && (ii = (IdentifierInstruction)test2).getBinding(benv) == this.m_hintBinding) {
                    onceFalseAlwaysFalseIdiom = true;
                    il.loadVar(hintVar);
                    il.beginIf();
                }
            } else if (ci.m_cases.length == 1 && (test2 = ci.m_cases[0].getTest()) instanceof IdentifierInstruction && ((IdentifierInstruction)test2).getBinding(benv) == this.m_hintBinding) {
                Instruction handler = ci.m_cases[0].getHandler();
                if (LiteralInstruction.booleanTrueLiteral().equals(handler) || handler instanceof IdentifierInstruction && ((IdentifierInstruction)handler).getBinding(benv) == this.m_hintBinding) {
                    onceTrueAlwaysTrueIdiom = true;
                    il.loadVar(hintVar);
                    il.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
                    il.beginIf();
                }
            }
        }
        FcgVariable currentElement = XDMSequenceType.s_sequenceType.generateLoopStart(cgh, il, this.m_source, FcgXmlType.CURSOR_TYPE, cgt);
        CodeGenerationTracker cgt2 = cgt.cloneBranch();
        cgt2.registerExtantBinding(this.m_hintBinding, hint);
        cgt2.registerExtantBinding(this.m_elementBinding, currentElement.getName());
        if (onceFalseAlwaysFalseIdiom) {
            il.loadVar(hintVar);
            il.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
            il.beginIf();
            il.breakFromLoop();
            il.endIf();
        } else if (onceTrueAlwaysTrueIdiom) {
            il.loadVar(hintVar);
            il.beginIf();
            il.breakFromLoop();
            il.endIf();
        }
        this.generateBodyWithFirstCaseShortcut(cgh, cgt2, varNameSuggestion, false, this.m_body, hintVar, il);
        XDMSequenceType.s_sequenceType.generateLoopEnd(cgh, il, currentElement, cgt);
        if (onceFalseAlwaysFalseIdiom || onceTrueAlwaysTrueIdiom) {
            il.endIf();
        }
        return il.loadVar(hintVar);
    }

    public void generateBodyWithFirstCaseShortcut(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, Instruction originalBody, FcgVariable hint, FcgInstructionList il) {
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        Instruction body = originalBody;
        if (body instanceof LetInstruction) {
            body = ((LetInstruction)body).skipLetCodegen(cgt, null);
        }
        if (body instanceof ChooseInstruction) {
            ChooseInstruction choose = (ChooseInstruction)body;
            if (choose.m_cases.length >= 1) {
                Instruction test2;
                Set bindings;
                if (choose.m_cases.length > 1) {
                    throw new XylemError("ERR_SYSTEM", "reduced choose should only have one case");
                }
                Instruction handler = choose.m_cases[0].getHandler();
                if (handler instanceof IdentifierInstruction && ((IdentifierInstruction)handler).getBinding(benv) == this.m_hintBinding && !(bindings = NavigationUtilities.resolveFreeBindingsForReducedExpression(test2 = choose.m_cases[0].getTest(), originalBody, benv)).contains(this.m_elementBinding)) {
                    cgt.generateConventionally(test2, cgh, false, il, ValueGenStyle.DEFAULT);
                    il.beginIf();
                    il.breakFromLoop();
                    il.beginElse();
                    if (choose.getDefaultHandler() != null) {
                        this.generateBodyWithFirstCaseShortcut(cgh, cgt, varNameSuggestion, tailPosition, choose.getDefaultHandler(), hint, il);
                    }
                    il.endIf();
                    return;
                }
            }
        }
        body.generateCode(cgh, cgt.cloneBranch(), null, tailPosition, il, ValueGenStyle.DEFAULT);
        Type hintType = this.m_hint.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment);
        hintType.generateObjectFork(cgh, il, cgt, ValueGenStyle.DEFAULT_WITH_PUSH);
        il.storeVar(hint);
    }

    @Override
    public Instruction cloneShallow() {
        TestXDMSequenceInstruction i = new TestXDMSequenceInstruction(this.m_source, this.m_hint, this.m_elementBinding.getName(), this.m_hintBinding.getName(), this.m_body);
        TestXDMSequenceInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        TestXDMSequenceInstruction i = new TestXDMSequenceInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_hint.cloneWithoutTypeInformation(), this.m_elementBinding.getName(), this.m_hintBinding.getName(), this.m_body.cloneWithoutTypeInformation());
        TestXDMSequenceInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_source = rh.reduceToBasicInstruction(state, this.m_source, benv);
        this.m_hint = rh.reduceToBasicInstruction(state, this.m_hint, benv);
        ReductionHelper rh2 = (ReductionHelper)rh.clone();
        rh2.upgradeBinding(this.m_elementBinding);
        rh2.upgradeBinding(this.m_hintBinding);
        benv.setVariableBinding(this.m_elementBinding);
        benv.setVariableBinding(this.m_hintBinding);
        this.m_body = rh2.reduce(this.m_body, benv);
        this.m_elementBinding.setType(XDMItemType.s_itemType);
        this.m_bindingEnvironment = null;
        state[0] = this;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        BindingEnvironment benv2 = new BindingEnvironment(benv);
        Type sourcetype = this.m_source.typeCheck(tenv, benv, functionStack);
        tenv.unify(sourcetype, XDMSequenceType.s_sequenceType, this);
        this.typeCheckLoopVariableBinding(tenv, benv2, sourcetype, this.m_elementBinding);
        this.m_hintBinding.setType(this.m_hint.typeCheck(tenv, benv, functionStack));
        this.m_hintBinding.setTypeEnvironment(tenv);
        benv2.setVariableBinding(this.m_hintBinding);
        Type t = this.m_body.typeCheck(tenv, benv2, functionStack);
        tenv.unify(t, this.m_hintBinding.getBindingType(), this);
        return this.setCachedType(t);
    }

    @Override
    public boolean constructsCursor() {
        return true;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_body.getType(tenv, benv);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object ans = null;
        Cursor seq = (Cursor)this.m_source.evaluate(e, f2, di, false);
        if (seq != null) {
            seq = e.pushForkForRelease(seq.fork(false, Cursor.STREAMING_READ, Cursor.RANDOM_ACCESS));
        }
        Object hint = this.m_hint.evaluate(e, f2, di, false);
        if (seq != null) {
            assert (this.m_elementBinding.getBindingType() instanceof XDMItemType);
            e.bindInCurrentFrame(this.m_elementBinding, seq);
            do {
                e.bindInCurrentFrame(this.m_hintBinding, hint);
                hint = this.m_body.evaluate(e, f2, di, false);
                hint = XCIConstruction.evalForkIfNeeded(hint, e);
            } while (seq.toNext());
        }
        ans = hint;
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public String innerToString() {
        return "test-XDMSequence";
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.newline();
        pw.printFormOpen(this.innerToString(), indent, this.getTypeForTypeAnnotationPrettyPrint());
        this.m_source.toString(pw, indent + 1);
        this.m_hint.toString(pw, indent + 1);
        pw.printIdentifier(this.m_elementBinding, indent + 1);
        pw.printIdentifier(this.m_hintBinding, indent + 1);
        this.m_body.toString(pw, indent + 1);
        pw.print(")");
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        set2.remove(this.m_elementBinding);
        set2.remove(this.m_hintBinding);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        benv.setVariableBinding(this.m_elementBinding);
        benv.setVariableBinding(this.m_hintBinding);
        this.m_hintBinding.setType(this.m_hint.getType(tenv, benv));
        this.m_elementBinding.setType(XDMItemType.s_itemType);
        super.typeCheckReduced(tenv, benv, functionStack);
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        set2.remove(this.m_elementBinding);
        set2.remove(this.m_hintBinding);
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Object s = ing.getNewName();
        names.put(this.m_elementBinding.getName(), new IdentifierInstruction(s));
        Object elementVar = s;
        s = ing.getNewName();
        names.put(this.m_hintBinding.getName(), new IdentifierInstruction(s));
        Object hintVar = s;
        return new TestXDMSequenceInstruction(this.m_source.assignNewNames(names, ing), this.m_hint.assignNewNames(names, ing), elementVar, hintVar, this.m_body.assignNewNames(names, ing));
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_source = rofh.readInstruction(benv);
        this.m_hint = rofh.readInstruction(benv);
        this.m_elementBinding = new Binding(rofh.readBindingName(), this);
        this.m_hintBinding = new Binding(rofh.readBindingName(), this);
        this.m_body = rofh.readInstruction(benv);
        this.m_elementBinding.setType(XDMItemType.s_itemType);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_source);
        wofh.writeInstruction(this.m_hint);
        wofh.writeBindingName(this.m_elementBinding.getName());
        wofh.writeBindingName(this.m_hintBinding.getName());
        wofh.writeInstruction(this.m_body);
    }

    public ICollectionType getCollectionType() {
        return XDMSequenceType.s_sequenceType;
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return i == 2;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        Binding[] bindingArray;
        Binding hb = this.m_hintBinding;
        if (i == 2) {
            Binding[] bindingArray2 = new Binding[2];
            bindingArray2[0] = this.m_hintBinding;
            bindingArray = bindingArray2;
            bindingArray2[1] = this.m_elementBinding;
        } else {
            bindingArray = null;
        }
        return bindingArray;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return false;
    }

    @Override
    public Object getIndexVar() {
        return null;
    }
}

